#ifndef TERASIC_GPIO_H
#define TERASIC_GPIO_H

#include <linux/gpio.h>
#include <stdbool.h>

typedef struct{
	int fd;
	struct gpiohandle_request req;
}GPIO_HANDLE;

GPIO_HANDLE* gpio_open_line(const char *dev_name, int line, int direction);
void gpio_close_line(GPIO_HANDLE *pHandle);
bool gpio_get_line_value(GPIO_HANDLE *pHandle, unsigned int *pValue);
bool gpio_set_line_value(GPIO_HANDLE *pHandle, unsigned int nValue);

#endif // TERASIC_GPIO_H

