// ============================================================================
// Copyright (c) 2024 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================




#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <stdarg.h> 
#include <sys/ioctl.h>
#include <linux/spi/spidev.h> // spi driver
#include "LCD_Hw.h"
#include "gpio_lib.h"



 // internal fucniton
//#define MY_DEBUG(msg, arg...) printf("%s:%s(%d): " msg, __FILE__, __FUNCTION__, __LINE__, ##arg)
#define MY_DEBUG(msg, arg...) 
void PIO_DC_Set(bool bIsData);
bool SPIM_IsTxFifoEmpty(void);
void SPIM_WriteTxData(uint8_t Data);


/////////////////////////////////////////////
/////	LCD Fucntion //////////////////////////
/////////////////////////////////////////////

// io
static GPIO_HANDLE *gResetIO=NULL;
static GPIO_HANDLE *gBacklightIO=NULL;
static GPIO_HANDLE *gAddrIO=NULL;

// spi
static int lcd_spi_file = 0;
struct spi_ioc_transfer spi_xfer;

void LCDHW_Init(void){

	// use gpio driver to control IO
	gResetIO = gpio_open_line("/dev/gpiochip0", 10/*line 10 for HPS_LCM_RST_n*/, 1 /*output*/);
	gBacklightIO = gpio_open_line("/dev/gpiochip0", 18/*line 18 for HPS_LCM_BK*/, 1 /*output*/);
	gAddrIO = gpio_open_line("/dev/gpiochip0", 11/*line 11 for HPS_LCM_D_C*/, 1 /*output*/);
	
	// reset
	gpio_set_line_value(gResetIO, 0); // output high for RST_n
	usleep( 1000000 / 16 );	
	gpio_set_line_value(gResetIO, 1); // output high for RST_n
	usleep( 1000000 / 16 );	
	
	gpio_set_line_value(gBacklightIO, 0); // output low for HPS_LCM_BK to trun off backlight
	gpio_set_line_value(gAddrIO, 0); // output low for HPS_LCM_D_C (LCD-A0 addr);

	

	////////////////////////////////////////////////////
	////////////////////////////////////////////////////
	////////////////////////////////////////////////////
	// SPIM0 Init

	char *filename = "/dev/spidev0.0";
	
	MY_DEBUG("use spi driver = %s\r\n", filename);
	
	lcd_spi_file = open(filename,O_RDWR);
	if (lcd_spi_file > 0){
		uint8_t    mode, lsb, bits;
		uint32_t speed=2500000, max_speed;
		
            if (ioctl(lcd_spi_file, SPI_IOC_RD_MODE, &mode) < 0)
                {
                MY_DEBUG("SPI rd_mode");
                return;
                }
            if (ioctl(lcd_spi_file, SPI_IOC_RD_LSB_FIRST, &lsb) < 0)
                {
                MY_DEBUG("SPI rd_lsb_fist");
                return;
                }		
            if (ioctl(lcd_spi_file, SPI_IOC_RD_BITS_PER_WORD, &bits) < 0) 
                {
                MY_DEBUG("SPI bits_per_word");
                return;
                }        
            if (ioctl(lcd_spi_file, SPI_IOC_RD_MAX_SPEED_HZ, &max_speed) < 0) 
                {
                MY_DEBUG("SPI max_speed_hz");
                return;
                }      
            MY_DEBUG("%s: spi mode %d, %d bits %sper word, %d Hz max\n",filename, mode, bits, lsb ? "(lsb first) " : "", max_speed);   
            	
    spi_xfer.len = 3; /* Length of  command to write*/
    spi_xfer.cs_change = 0; /* Keep CS activated */
    spi_xfer.delay_usecs = 0; //delay in us
    spi_xfer.speed_hz = (speed > max_speed)?max_speed: speed;//2500000, //speed
    spi_xfer.bits_per_word = bits;//8, // bites per word 8                
	}else{
		MY_DEBUG("failed to open file = %s(lcd_spi_file=%d)\r\n", filename, lcd_spi_file);
	}

	
	MY_DEBUG("[SPIM0]LCD_Init done\r\n");
	
}



void LCDHW_BackLight(bool bON){
	gpio_set_line_value(gBacklightIO, bON?1:0); // output low for HPS_LCM_BK to trun off backlight
}



void LCDHW_Write8(uint8_t bIsData, uint8_t Data){

    static uint8_t bPreIsData=0xFF;
 
    // set A0
    if (bPreIsData != bIsData){
        // Note. cannot change D_C until all tx dara(or command) are sent. i.e. fifo is empty
        //  while(!SPIM_IsTxEmpty()); // wait if buffer is not empty

        PIO_DC_Set(bIsData);
        bPreIsData = bIsData;
    }else{
        // wait buffer is not full
        //  while(SPIM_IsTxFull()); // wait if buffer is full 
    }


    SPIM_WriteTxData(Data);
}



//////////////////////////////////////////////////////////////
// internal funciton
//////////////////////////////////////////////////////////////

void PIO_DC_Set(bool bIsData){
	// D_C = "H": Data
	// D_C = "L": CMD

	gpio_set_line_value(gAddrIO, bIsData?1:0); // output low for HPS_LCM_D_C (LCD-A0 addr);
}




//////////
// Write n bytes int the 2 bytes address add1 add2
//////////
void spi_write8(int file, uint8_t Data){
		int status;

    spi_xfer.tx_buf = (unsigned long)&Data;
    spi_xfer.len = 1; /* Length of  command to write*/
    status = ioctl(file, SPI_IOC_MESSAGE(1), &spi_xfer);
    if (status < 0)
        {
        MY_DEBUG("SPI_IOC_MESSAGE");
        return;
        }
    //printf("env: %02x %02x %02x\n", buf[0], buf[1], buf[2]);
    //printf("ret: %02x %02x %02x %02x\n", buf2[0], buf2[1], buf2[2], buf2[3]);
 
    //com_serial=1;
    //failcount=0;
}



void SPIM_WriteTxData(uint8_t Data){

	if (lcd_spi_file > 0)
		spi_write8(lcd_spi_file, Data);
}


