/*
 * VPP_TPG.cpp
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#include <stdio.h>
#include <stdlib.h> // malloc, free
#include <unistd.h>  // usleep (unix standard?)
#include "VVP_TPG.h"


VVP_TPG::VVP_TPG(uint32_t BaseAddr):
	VVP_CORE(BaseAddr){
	// TODO Auto-generated destructor stub
	int result;
	result =  intel_vvp_tpg_init(&m_instance, (intel_vvp_core_base )BaseAddr);
	if (result != 0){
		printf("intel_vvp_tpg_init failed\r\n");
	}else{
		m_bValidInstance = true;
	}
}

VVP_TPG::~VVP_TPG() {
	// TODO Auto-generated destructor stub
}

bool VVP_TPG::IsLiteMode(){
	bool bYes;

	if (!m_bValidInstance){
		printf("TPG invalid instance\r\n");
		return false;
	}
	bYes = intel_vvp_tpg_get_lite_mode(&m_instance);
	return bYes;
}

void VVP_TPG::ShowStatus() {
	// TODO Auto-generated destructor stub


	REG_INFO szRegList[] = {
			{TPG_IMG_INFO_WIDTH, 0xFFFF, "TPG image width"},
			{TPG_IMG_INFO_HEIGHT, 0xFFFF, "TPG image height"},
			{TPG_IMG_INFO_INTERLACE, 0x000F, "TPG image interlace"},
			{TPG_STATUS, 0x0003, "TPG status"},
			{TPG_FIELD_COUNT, 0xFFFF, "TPG field count"},
			{TPG_CONTROL, 0x0001, "TPG control"},
			{TPG_COMMIT, 0xFFFFFFFF, "TPG commit"},
			{TPG_PATTERN_SELECT, 0x0007, "TPG pattern select"},
	};

/*

#define TPG_C0						0x015c
#define TPG_C1						0x0160
#define TPG_C2						0x0164
#define TPG_BARS_SELECT				0x0168
#define TPG_ZONE_X_ORIGIN			0x016c
#define TPG_ZONE_Y_ORIGIN			0x0170
#define TPG_ZONE_COARSE_FACTOR		0x0174 //Intel suggests a value of 14 for 1920x1080, or 20 for a 4k display.
#define TPG_ZONE_FINE_FACTOR		0x0178
#define TPG_CLOCK_B_BACKGROUND		0x017C
#define TPG_CLOCK_G_BACKGROUND		0x0180
#define TPG_CLOCK_R_BACKGROUND		0x0184
#define TPG_CLOCK_B_FONT			0x0188
#define TPG_CLOCK_G_FONT			0x018C
#define TPG_CLOCK_R_FONT			0x0190
#define TPG_CLOCK_LOCATION_X		0x0194
#define TPG_CLOCK_LOCATION_Y		0x0198
#define TPG_CLOCK_SCALE_FACTOR		0x019C
#define TPG_CLOCK_FPS				0x01A0
*/
//	int result;
	bool bYes;
//	uint32_t   value32;
	uint8_t value8;

	if (!m_bValidInstance){
		printf("TPG invalid instance\r\n");
		return;
	}
	printf("=========== TPG Status =============\r\n");

		bYes = intel_vvp_tpg_get_lite_mode(&m_instance);
		printf("TPG lite mode: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_tpg_get_debug_enabled(&m_instance);
		printf("TPG debug mode: %s\r\n", bYes?"Yes":"No");

		value8 =  intel_vvp_tpg_get_num_patterns(&m_instance);
		printf("TPG num patterns: %d\r\n", value8);

		value8 =  intel_vvp_tpg_get_bits_per_sample(&m_instance);
		printf("TPG bits per sample: %d\r\n", value8);

		value8 =  intel_vvp_tpg_get_pixels_in_parallel(&m_instance);
		printf("TPG pixel in parallel: %d\r\n", value8);

//	??	value32 =  intel_vvp_tpg_get_pattern_data(&m_instance);
	//	printf("DEMOSAIC number of pixel in parallel: %d\r\n", value8);

		bYes = intel_vvp_tpg_is_running(&m_instance);
		printf("TPG running: %s\r\n", bYes?"Yes":"No");

		bYes =  intel_vvp_tpg_get_commit_status(&m_instance);
		printf("TPG commit status: %s\r\n", bYes?"in full mode":"contains uncommitted writes");

		value8 =  intel_vvp_tpg_get_status(&m_instance);
		printf("TPG status: %d\r\n", value8);

		// via register access
		// https://www.intel.com/content/www/us/en/docs/programmable/683329/24-2/test-pattern-generator-ip-registers.html
		printf("TPG query via register\r\n");

		DumpRegister(szRegList, sizeof(szRegList)/sizeof(szRegList[0]));

/*

		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_WIDTH);
		printf("DEMOSAIC image width: %d (%xh)\r\n", (value32 & 0xFF) , value32);

		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_HEIGHT);
		printf("DEMOSAIC image height: %d (%xh)\r\n", (value32 & 0xFF) , value32);


		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_STATUS);
		printf("DEMOSAIC Status: %d (%xh)\r\n", value32, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_CONTROL);
		printf("DEMOSAIC Status: %d (%xh)\r\n", value32 & 0x07, value32);
*/

		printf("\r\n");

}

bool VVP_TPG::Run(bool Start){
	if (!m_bValidInstance){
		printf("DEMOSAIC invalid instance\r\n");
		return false;
	}

	IOWR_32DIRECT(m_BaseAddr, TPG_CONTROL, Start?0x01:0x00); //1 = go, 0 = stop.

	return true;
}

bool VVP_TPG::Config(int nWidth, int nHeight){
	int nIntlaceNibble = 0; //Progressive frame
	int nPatternIndex = 0;

	if (!m_bValidInstance){
		printf("FB invalid instance\r\n");
		return false;
	}

	IOWR_32DIRECT(m_BaseAddr, TPG_IMG_INFO_WIDTH, nWidth);
	IOWR_32DIRECT(m_BaseAddr, TPG_IMG_INFO_HEIGHT, nHeight);
	IOWR_32DIRECT(m_BaseAddr, TPG_IMG_INFO_INTERLACE, nIntlaceNibble);
	IOWR_32DIRECT(m_BaseAddr, TPG_PATTERN_SELECT, nPatternIndex);

	return true;

}


