/*
 * VVP_Demosaic.cpp
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#include <stdio.h>
#include <stdlib.h> // malloc, free
#include <unistd.h>  // usleep (unix standard?)
#include "system.h"
#include "VVP_Demosaic.h"



VVP_Demosaic::VVP_Demosaic(uint32_t BaseAddr):
VVP_CORE(BaseAddr){
	// TODO Auto-generated destructor stub
	int result;
	result =  intel_vvp_demosaic_init(&m_instance, (intel_vvp_core_base)BaseAddr);
	if (result != 0){
		printf("intel_vvp_demosaic_init failed\r\n");
	}else{
		m_bValidInstance = true;
	}
}

VVP_Demosaic::~VVP_Demosaic() {
	// TODO Auto-generated destructor stub
}

bool VVP_Demosaic::IsLiteMode(){
	bool bYes;

	if (!m_bValidInstance){
		printf("Demosaic invalid instance\r\n");
		return false;
	}
	bYes = intel_vvp_demosaic_get_lite_mode(&m_instance);
	return bYes;
}

void VVP_Demosaic::ShowStatus() {
	// TODO Auto-generated destructor stub

//	int result;
	bool bYes;
	uint32_t   value32;
	uint8_t value8;

	if (!m_bValidInstance){
		printf("DEMOSAIC invalid instance\r\n");
		return;
	}
	printf("=========== DEMOSAIC Status =============\r\n");

		bYes = intel_vvp_demosaic_get_lite_mode(&m_instance);
		printf("DEMOSAIC lite mode: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_demosaic_get_debug_enabled(&m_instance);
		printf("DEMOSAIC debug mode: %s\r\n", bYes?"Yes":"No");

		value8 =  intel_vvp_demosaic_get_bits_per_sample_in(&m_instance);
		printf("DEMOSAIC bit per sample in: %d\r\n", value8);

		value8 =  intel_vvp_demosaic_get_bits_per_sample_out(&m_instance);
		printf("DEMOSAIC bit per sample out: %d\r\n", value8);

		value8 =  intel_vvp_demosaic_get_num_color_planes_in(&m_instance);
		printf("DEMOSAIC number of color plane in: %d\r\n", value8);

		value8 =  intel_vvp_demosaic_get_num_color_planes_out(&m_instance);
		printf("DEMOSAIC number of color plane out: %d\r\n", value8);

		value8 =  intel_vvp_demosaic_get_pixels_in_parallel(&m_instance);
		printf("DEMOSAIC number of pixel in parallel: %d\r\n", value8);

		value32 =  intel_vvp_demosaic_get_max_width(&m_instance);
		printf("DEMOSAIC max width: %d\r\n", value32);

		value32 =  intel_vvp_demosaic_get_max_height(&m_instance);
		printf("DEMOSAIC max height: %d\r\n", value32);

		value32 =  intel_vvp_demosaic_get_status(&m_instance);
		printf("DEMOSAIC status: %d\r\n", value32);


		bYes = intel_vvp_demosaic_get_bypass(&m_instance);
		printf("DEMOSAIC bypass: %s\r\n", bYes?"Yes":"No");

		value8 =  intel_vvp_demosaic_get_cfa_phase(&m_instance);
		printf("DEMOSAIC CFA: %d\r\n", value8);


		// via register access
		// https://www.intel.com/content/www/us/en/docs/programmable/683329/24-2/demosaic-ip-registers.html
		printf("query via register\r\n");



		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_WIDTH);
		printf("DEMOSAIC image width: %d (%xh)\r\n", (value32 & 0xFFFF) , value32);

		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_HEIGHT);
		printf("DEMOSAIC image height: %d (%xh)\r\n", (value32 & 0xFFFF) , value32);


		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_STATUS);
		printf("DEMOSAIC Status: %d (%xh). When 1, the IP is processing data.\r\n", value32 & 0x01, value32);

		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_FRAME_STAT);
		printf("DEMOSAIC Frame Statistics: %d (%xh). A simple checksum of the frame\r\n", value32 & 0xFF, value32);


		value32 = IORD_32DIRECT(m_BaseAddr, DEMOSAIC_CONTROL);
		printf("DEMOSAIC Control: %d (%xh). bit0: set to bypass the Demosaic IP.\r\n", value32 & 0x07, value32);


		printf("\r\n");

}

bool VVP_Demosaic::Run(bool Start, int color_filter_index){

	if (!m_bValidInstance){
		printf("DEMOSAIC invalid instance\r\n");
		return false;
	}

//	IOWR_32DIRECT(m_BaseAddr, DEMOSAIC_CONTROL, Start?(0x01 | (color_filter_index << 1)) & 0x07:0x00);
	IOWR_32DIRECT(m_BaseAddr, DEMOSAIC_CONTROL, Start?((color_filter_index << 1)) & 0x07:0x01/* bypass */ );

	return true;
}


bool VVP_Demosaic::Config(int nWidth, int nHeight){

	if (!m_bValidInstance){
		printf("Demosaic invalid instance\r\n");
		return false;
	}else{
		//printf("Demosaic config width=%d, height=%d\r\n", nWidth, nHeight);
	}

	IOWR_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_WIDTH, nWidth);
	IOWR_32DIRECT(m_BaseAddr, DEMOSAIC_IMG_INFO_HEIGHT, nHeight);

	return true;

}


