/*
 * AK7375.h
 *
 *  Created on: Jun 27, 2024
 *      Author: User
 */

#ifndef AK7375_H_
#define AK7375_H_

#include "I2C.h"

#define AK7375_I2C_ADDRESS 0x0C // DW9817-VCM 7-bit i2c address (8-bit is 0x18)


#define AK7375_MAX_FOCUS_POS	4095  // 2^12
/*
 * This sets the minimum granularity for the focus positions.
 * A value of 1 gives maximum accuracy for a desired focus position
 */
#define AK7375_FOCUS_STEPS	1
/*
 * This acts as the minimum granularity of lens movement.
 * Keep this value power of 2, so the control steps can be
 * uniformly adjusted for gradual lens movement, with desired
 * number of control steps.
 */
#define AK7375_CTRL_STEPS	64
#define AK7375_CTRL_DELAY_US	1000

#define AK7375_REG_POSITION	0x0
#define AK7375_REG_CONT		0x2
#define AK7375_MODE_ACTIVE	0x0
#define AK7375_MODE_STANDBY	0x40

#define AK7375_PW_MIN_DELAY_US		12000
#define AK7375_PW_DELAY_RANGE_US	1000

class AK7375 : public I2C{
protected:
	int m_focus_vol;
	//char m_szDevName[64];
	//alt_u32 m_nDeviceAddr;

	bool i2c_write16(alt_u8 addr8, alt_u16 data16);
	bool i2c_write8(alt_u8 addr8, alt_u8 data8);
public:
	AK7375(const char *pDevName, alt_u32 nDeviceAddr);
	virtual ~AK7375();

	bool active();
	bool standby();
	bool set_pos(int nPos);
	bool scan();
};

#endif /* AK7375_H_ */
