# (C) 2001-2025 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


#**************************************************************
# SDC Entity File: intel_vvp_vtiming_core
#**************************************************************

# CDC Helper procedures

proc apply_cdc {from_list to_list {delay 100} {multiplier 0.8}} {
  set from_keepers [get_keepers $from_list -nowarn]
  set to_keepers [get_keepers $to_list -nowarn]

  if {[get_collection_size $from_keepers] > 0} {
    if {[get_collection_size $from_keepers] > 1} {
        set_max_skew -from $from_keepers -to $to_keepers -get_skew_value_from_clock_period min_clock_period -skew_value_multiplier $multiplier
    }
    set_min_delay -from $from_keepers -to $to_keepers -$delay
    set_max_delay -from $from_keepers -to $to_keepers $delay
    set_net_delay -from $from_keepers -to $to_keepers -max -get_value_from_clock_period min_clock_period -value_multiplier $multiplier
  }
}

proc apply_cdc_flop_primitive {instance} {
  apply_cdc "${instance}|data\[*\]" "${instance}|g_synchronizer_flop\[*\].u_synchronizer_flop|gen_flop_primitive\[*\].u_flop_primitive|out_data"
}

# Core specific

foreach i {0 1 2 3 4 5 6 7} {
  apply_cdc_flop_primitive "i_cpu_regs|i_cdc_rd_${i}"
}
apply_cdc_flop_primitive {i_cpu_regs|i_cdc_timing_request}
apply_cdc_flop_primitive {i_cpu_regs|i_cdc_timing_toggle}
apply_cdc_flop_primitive {i_cpu_regs|i_cdc_1_second_return}
apply_cdc_flop_primitive {i_cpu_regs|i_cdc_1_second_vid2cpu}
apply_cdc_flop_primitive {i_cpu_regs|i_cdc_1_second}

apply_cdc {i_cpu_regs|cpu_regs_cdc_in[*]} {i_cpu_regs|i_cpu_reg_cdc|r1_out_data[*]}
apply_cdc {i_cpu_regs|r_vid_1_second_ltchd_shadow[*]} {i_cpu_regs|i_cpu_1second_cdc|r1_out_data[*]}
