// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module altera_avalon_i2c_spksupp (
    input       clk,
    input       rst_n,
    input [7:0] spike_len,
    input       sda_in,
    input       scl_in,
    output      sda_int,
    output      scl_int
);

// Status Register bit definition


// wires & registers declaration
reg [7:0]   scl_spike_cnt;
reg         scl_int_reg;
reg         scl_doublesync_a;
reg [7:0]   sda_spike_cnt;
reg         sda_int_reg;
reg         sda_doublesync_a;
reg         scl_in_synced;
reg         sda_in_synced;

wire        scl_clear_cnt;
wire        scl_cnt_limit;
wire        scl_int_next;
wire        sda_clear_cnt;
wire        sda_cnt_limit;
wire        sda_int_next; 
 
 
// double sync flops for scl  
always @(posedge clk or negedge rst_n) begin
    if (!rst_n) begin
        scl_doublesync_a    <= 1'b1;
        scl_in_synced       <= 1'b1;
    end
    else begin
        scl_doublesync_a    <= scl_in;
        scl_in_synced       <= scl_doublesync_a;
    end
end
  
  
//assign scl_in_synced = scl_doublesync_b;
// XOR: return 1 to increase counter ; return 0 to reset counter
assign scl_clear_cnt = ~(scl_in_synced ^ scl_int_next) ;

// scl counter
always @(posedge clk or negedge rst_n) begin
    if(!rst_n)
        scl_spike_cnt <= 8'h0;
    else if(scl_clear_cnt)
        scl_spike_cnt <= 8'h0;
    else 
        scl_spike_cnt <= scl_spike_cnt + 8'h1;
end

// to allow scl_in pass through to scl_int when the comparator returns 1
// if disallow to pass through, scl_int returns the prev value
// to make the scl_in pass through at the same clock as the counter reaching the limit value of suppression length
assign scl_cnt_limit = (scl_spike_cnt >= spike_len);

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        scl_int_reg <= 1'b1;
    else 
        scl_int_reg <= scl_int_next;
end

assign scl_int_next = scl_cnt_limit ? scl_in_synced : scl_int_reg; 
//assign scl_int = scl_cnt_limit ? scl_in_synced : scl_int_reg ;
assign scl_int = scl_int_reg; // Using the registered version to improve timing



// double sync flops for sda
always @(posedge clk or negedge rst_n) begin
    if (!rst_n) begin
        sda_doublesync_a <= 1'b1;
        sda_in_synced <= 1'b1;
    end
    else begin
        sda_doublesync_a <= sda_in;
        sda_in_synced <=sda_doublesync_a;
    end
end


//  assign sda_in_synced = sda_doublesync_b;
// XOR: return 1 to increase counter ; return 0 to reset counter
assign sda_clear_cnt = ~(sda_in_synced ^ sda_int_next) ;

// sda counter
always @(posedge clk or negedge rst_n) begin
    if(!rst_n)
        sda_spike_cnt <= 8'h0;
    else if(sda_clear_cnt)
        sda_spike_cnt <= 8'h0;
    else
        sda_spike_cnt <= sda_spike_cnt + 8'h1;
end

// to allow scl_in pass through to scl_int when the comparator returns 1
// if disallow to pass through, scl_int returns the prev value
// to make the scl_in pass through at the same clock as the counter reaching the limit value of suppression length
assign sda_cnt_limit = (sda_spike_cnt >= spike_len);

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        sda_int_reg <= 1'b1;
    else
        sda_int_reg <= sda_int_next;
end

assign sda_int_next = sda_cnt_limit ? sda_in_synced : sda_int_reg;
//assign sda_int = sda_cnt_limit ? sda_in_synced : sda_int_reg ;
assign sda_int = sda_int_reg;  // Using the registered version to improve timing


endmodule


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "SdgU9W/I3Un6mG6zxE4tpLSApCrsI97qN+aYYN4ywNrs4nnUSll4ckaRTU3FRIiEd9MllZ6mJdvi990RtsSB8FE2yrbcspPnDCWzh6v+WDKIcw2hM9759RKXg2QdHGMdjMF1upE6hGueC5zC1QyfItkC8S+1BIbhfbj5mNjROFu7aSecOjFmwUX8iIcYJFHDN4xQKpcAAy8AIHvTqsu/RqI9WBL/1cAlK7jqy9ZpuNXD+x96mJL3ILaYTNPu1AMvb1pszTgOWig3TwxxxaZkskPECsXjx0OQoQVinHXmZhmr5/l104hLH3NawA/WZAAUoFbTCQJstBbZnKThBGwbUTGy8zpscsJ/58VuTck5B7gfwEtxFYYpJvQka0SRTfbiKfh3VxxNxZeEWZRBEizmfbAtpmP8kEWPkYXSklVFGt+Hg8farw3mIiryEiA7NMe7/+fyoKKKK+CFDTpWO6fGZmeyUd/AiTEfa1+GMO3iVCyZgFOQqnAga49nvCswYkd65ppO9ckDvk8n9xY4gihlPmiMg85g37100tLTTWPJr1uezt6BPiYhQJV9y3j7SvcUf3/Uk6AtYR5EMtVO9ZpzR/24+vkMyCLjO+SHDrbeSZ051x2ZdTLutc+S9Ua/YSj9YF5t9NO13lw8kvhu3w+Cm6cvmnf7TNBOFohGvWww54w3ErAoDyXeGnD3Huy1fxHOQTSdi7Py+3zPr+TdMgtoWTFRg+IW7LWqm7su4T3qdrklD1Kc6UpgavQ16rjfjbxJ/ReK6BfbHnnjCtuxvRj1AQsv9v038udNxjSNrk9oCQaCsR+k9mej6d+KVRQr+i1KYmafUtTjYPj97tf2EE8voql/UOuo0UXYo8fzu7kR9BJ4lbF3XhLjnMU1mPF1GMGW69C+fxdNc+c2OqlTT8tKxHVoXn63ISkP7T5Xvz4qGtq/by2270/P4NWz3zeJHJEf8cWdZ7dfzyJ9c5JKEbJLvivwwfMDCysO2IHpJKgNJpKwDJcHUsJVuoRF6PN4uNSq"
`endif