	component system_SEG7_IF_0 is
		generic (
			SEG7_NUM       : integer := 6;
			ADDR_WIDTH     : integer := 3;
			DEFAULT_ACTIVE : integer := 1;
			LOW_ACTIVE     : integer := 1
		);
		port (
			s_address   : in  std_logic_vector(ADDR_WIDTH-1 downto 0)   := (others => 'X'); -- address
			s_read      : in  std_logic                                 := 'X';             -- read
			s_readdata  : out std_logic_vector(7 downto 0);                                 -- readdata
			s_write     : in  std_logic                                 := 'X';             -- write
			s_writedata : in  std_logic_vector(7 downto 0)              := (others => 'X'); -- writedata
			SEG7        : out std_logic_vector((SEG7_NUM*8)-1 downto 0);                    -- export
			s_clk       : in  std_logic                                 := 'X';             -- clk
			s_reset     : in  std_logic                                 := 'X'              -- reset
		);
	end component system_SEG7_IF_0;

	u0 : component system_SEG7_IF_0
		generic map (
			SEG7_NUM       => INTEGER_VALUE_FOR_SEG7_NUM,
			ADDR_WIDTH     => INTEGER_VALUE_FOR_ADDR_WIDTH,
			DEFAULT_ACTIVE => INTEGER_VALUE_FOR_DEFAULT_ACTIVE,
			LOW_ACTIVE     => INTEGER_VALUE_FOR_LOW_ACTIVE
		)
		port map (
			s_address   => CONNECTED_TO_s_address,   --     avalon_slave.address
			s_read      => CONNECTED_TO_s_read,      --                 .read
			s_readdata  => CONNECTED_TO_s_readdata,  --                 .readdata
			s_write     => CONNECTED_TO_s_write,     --                 .write
			s_writedata => CONNECTED_TO_s_writedata, --                 .writedata
			SEG7        => CONNECTED_TO_SEG7,        --      conduit_end.export
			s_clk       => CONNECTED_TO_s_clk,       --       clock_sink.clk
			s_reset     => CONNECTED_TO_s_reset      -- clock_sink_reset.reset
		);

