// system_SEG7_IF_0.v

// Generated using ACDS version 25.1.1 125

`timescale 1 ps / 1 ps
module system_SEG7_IF_0 #(
		parameter SEG7_NUM       = 6,
		parameter ADDR_WIDTH     = 3,
		parameter DEFAULT_ACTIVE = 1,
		parameter LOW_ACTIVE     = 1
	) (
		input  wire [ADDR_WIDTH-1:0]   s_address,   //     avalon_slave.address
		input  wire                    s_read,      //                 .read
		output wire [7:0]              s_readdata,  //                 .readdata
		input  wire                    s_write,     //                 .write
		input  wire [7:0]              s_writedata, //                 .writedata
		output wire [(SEG7_NUM*8)-1:0] SEG7,        //      conduit_end.export
		input  wire                    s_clk,       //       clock_sink.clk
		input  wire                    s_reset      // clock_sink_reset.reset
	);

	SEG7_IF #(
		.SEG7_NUM       (SEG7_NUM),
		.ADDR_WIDTH     (ADDR_WIDTH),
		.DEFAULT_ACTIVE (DEFAULT_ACTIVE),
		.LOW_ACTIVE     (LOW_ACTIVE)
	) seg7_if_0 (
		.s_address   (s_address),   //   input,    width = ADDR_WIDTH,     avalon_slave.address
		.s_read      (s_read),      //   input,             width = 1,                 .read
		.s_readdata  (s_readdata),  //  output,             width = 8,                 .readdata
		.s_write     (s_write),     //   input,             width = 1,                 .write
		.s_writedata (s_writedata), //   input,             width = 8,                 .writedata
		.SEG7        (SEG7),        //  output,  width = (SEG7_NUM*8),      conduit_end.export
		.s_clk       (s_clk),       //   input,             width = 1,       clock_sink.clk
		.s_reset     (s_reset)      //   input,             width = 1, clock_sink_reset.reset
	);

endmodule
