// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer (
    clk_src,
    clk_dst,
    reset_n,    
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n;    
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n)
        if(reset_n == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61QVpXs1y+HeDpJaA5gAfFn0NDdfEiYrzs4y7WqepEmtAca5y5nenS6QZJiVCT0DSNPMRXotNP4LvmVLj5ED+nb4eI3exYkgRmvE4IQTu+fE602v1leXeYr5t8JcG6XvyXrSvCHtEpUhbvOu5CxKbRgSfebYQWIRO9ic6aO/OWKDJTSFMrH8Tz3qI7AIOaZrTRKlqQ0OJVxWcRbx7AUcMxLc9I2t6AgH170hh5kjfNci2ziIzS6VCEJfnYTE/GHtTiYBYGh+K8lIcU/pst59+2trxU171SGVdctvh74t/dT6PCniAphGaidhbLoCF8zU60cvUR2dkKpZ9WRGRUjVJzah6BpoaAi6xsAg+OlkV/K7MeLFB0lJlBStihNaBAlwuncyPNanq804NL4QpVax1pwkaMJbyfotGIiJvv/TGKPQV++rIAp47UBjZAxf6YO/aeGguvG9XAn1csBCNTney22RgmosaaQNR+xKotuf/bgGrgaTNBTwrB2ah0eTuPFK6LFi6k0Sacwk0chfzeIam079whW04GJiX8LERUPXJp6SqD58YB4xD/AsWqy2k3x9SMaFoOAYZdVYLg0ibkZMoTYtbD0oK/pkX6s0Eimhzy8pmSITRWhDK49Qfql5rXbxHL29QJpBojAORr24ryWoX5c0+hwCjRbd7HGKf5NJELHErFHEnpuC3cR942kVm5WGyM/DoEGlkzMTPzPTCflyI/0zbsUQ1WlxaaP9BKsU+BLhsRhprPaHE4OlYtEIcXPPqJshb5eJMF4twMoGEIeeMBae"
`endif