// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



module dphy_timer #(
        parameter WIDTH = 8
   ) 
   (
        input  wire                     clk,     
        input  wire                     srst_n,     
        
        input                           timer_en, 
        input                           ld_timer,   
        input [WIDTH-1:0]               ld_val, 
        output logic                    timer_out           

    );
    
    logic [WIDTH-1:0] cntr;
    logic [WIDTH-1:0] e_cntr;
    logic e_timeout;

    always @(posedge clk)
    begin
        if(srst_n == 1'b0)
            cntr <= {WIDTH{1'b1}};
        else if(ld_timer)
            cntr <= ld_val;
        else if(~&cntr)
            cntr <= e_cntr;
    end
    assign e_cntr = cntr - timer_en;
    assign timer_out = ~|cntr & ~ld_timer & timer_en;



endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61QB32lNDUlOeF3N4M3AoY9MRlNTgtAYM31uc89olS4uODRXjg7SrZOy3HM6FDqx0hQzUxvV1ct/E9+JUbCmJy+6ZiiZ503uvSM+bYCGg8gqeAwWJi+W2Q7uK55fcm++ZE9Hu0KussXImn/inORX5YvscLnf0NXziBMbEH7Yz0H+HLnP7eiL9PmEhPqNTzXi/0vEgWkF18k4c0ms8Rgms4qQffEoNTfjLup0XNPZ71d/1kZqeLIZ6lrhH6YBNQHTZUbKXDpxe+q2737wYMWFtFJm0BSsTfOOZWbe8IvfITN2wpQuLTWgi++BtRP69jOO/vp2OvXFbTHaQz4jv6S53q+EBLi0Y3ziCS8QuI9lzBrTEUHFoDTspO8e5G86iN4froYtS2RNw0Cm6FcxpTYfnJGKSXLXwPjMJ6MGbBoMop+vLL2T4UW6sgm2nxg8R9OO2rdjZ0WpXdwWvDkl9NqNAkveZH19c5tAEEpEyL9+zKNawtFGDbtxo0zMakEmSw4cWMJPk/Rc1EjP+Mcjt70NgMzBxvFdXDY3RfJ1sjfcE6VWcEh5qq2pbTqBKrqmTxVdX6udpqLcP/obACYATfz8JdNhZbbn3kjPpQqat+RELJazDIpHzNpQRnE9gsnItrkE5Iy62GG2gY8UORi0IuLYZsIlSG/kA+t7tPa/E1uYj2oRfIiu/0TjEf5vMjHd8R3jhuoBq2+D4bAEBMJO12RodoYzGZ+sozvRubY3C1oRZ4B7ovs37hYux9Ez1wv7eU3fUIH/PfWZsUS3ow2r3fsEnALq"
`endif