// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

interface dphy_io_if #(
    parameter NUM_LANES = 8,
    parameter IO_CONVERT_RATIO = 16,
    parameter BYTE_CNT = NUM_LANES > 4 ? 2 : 1
    ) ;
   
    logic [BYTE_CNT-1:0]                         rx_clk;         
    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       rx_rd_data; 
    logic [3:0]                                  rx_rd_valid;   
    logic                                        rx_clk_lp_p;
    logic                                        rx_clk_lp_n;
    logic [NUM_LANES-1:0]                        rx_data_lp_p;
    logic [NUM_LANES-1:0]                        rx_data_lp_n;
    logic [3:0]                                  rx_data_read_en;    
    logic                                        rx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        rx_data_lp_hs_b;
    logic [16*NUM_LANES-1:0]                     rx_data_deskew_cntrl;
    logic                                        core_clk;
    logic                                        srst_n;

    logic [NUM_LANES*IO_CONVERT_RATIO-1:0]       tx_wr_data; 
    logic [IO_CONVERT_RATIO-1:0]                 tx_clk_data; 
    logic                                        tx_clk_lp_p;
    logic                                        tx_clk_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_p;
    logic [NUM_LANES-1:0]                        tx_data_lp_n;
    logic [NUM_LANES-1:0]                        tx_data_lp_hs_b;
    logic                                        tx_clk_lp_hs_b;

    logic                                        mnl_tx_en;
    logic                                        mnl_tx_clk_lp_hs_b;
    logic [NUM_LANES-1:0]                        mnl_tx_data_lp_hs_b;
    logic                                        mnl_tx_data_lp_p;
    logic                                        mnl_tx_data_lp_n;
    logic [1:0]                                  mnl_tx_data_hs;
    logic [1:0]                                  mnl_tx_clk_hs;


endinterface : dphy_io_if
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8GkZ/oj/qvsrGlgtAUv/jM7NZ40W5wyCRC9zWEide+n4YVyoBwJ+g/ZCHkzp9HvKhfIZG744DeU4N6Hj8kMwzvfIUklkHD2NJAxQ8jRaAUezlAgi5Q4DClf/uXizTayPHSGAdP/RpL0GCcDa5+SayNutygAEHcsfBY8remhg6OxmbRGAUJ45FL5gK8f8vgfPaUsWGUcRVM9j6F2CVCajmap/9GTKWsx4CQQb0D8dFGhHbXbEItepiB3yo5shyhq5sAWQGKee4sLHwdHuezSjRx+bDmMGiMxhJJqoMnEt2eFCP5VjH+muF2SLi058pFgOrXuSMHdDje24cbhFKqFO+mdjwoi0VXCj2jYgrHeg9cUez7jYZlfuuE7gdaqVC1usZvpKhJLrMvO+FwucigSByO3xoHDNvHjC494RN43kr9HmWHMeDoubrMtt5459/bLVpr62hK/Y9RlSHs2rM1KC9wrOi7+22uyi6BOxpgse7xr3jla0Rf4zoNbB8CT/oLSSDlhe7QfxugsmtQUJKMB8+qW+tmNAYh3V5EVysnLTedkiRx89/Tq0B3dO5T3p7CDHQxbRvHsWXsgwaegT/rWisiNeqxsWlL5MASy/M3a5MNCyEBR/5GJ2T28tx1d3mwIETO+kzWeXg08+jBM3ynBOoOeG0H5c7/JXCzB2XC3bOIeWYlieTBKjdm8tsltj1VAezRMqAwkf6CEJE79wR1eXRBSscUN0Vd9fN4CVPYsS1guiSZugjEpmdBlSxOPfydPHV2akQrJxJj74ESEiFSwM5y6y"
`endif