// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Apr 23 19:05:55 2025
// ============================================================================

`define ENABLE_DDR4
//`define ENABLE_HPS
`define ENABLE_HDMI
//`define ENABLE_HSMC
`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input              CPU_RESET_n,
      input    [ 3: 0]   KEY,

      ///////// SW /////////
      input    [ 9: 0]   SW,

      ///////// LED /////////
`ifdef ENABLE_CAM
		output   [ 8: 0]   LEDR, // LED[9] cannot be used when MIPI CAM enable
`else
      output   [ 9: 0]   LEDR,
`endif //ENABLE_CAM		

      ///////// Seg7 /////////
      output   [ 6: 0]   HEX0,
      output   [ 6: 0]   HEX1,
      output   [ 6: 0]   HEX2,
      output   [ 6: 0]   HEX3,
      output   [ 6: 0]   HEX4,
      output   [ 6: 0]   HEX5,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_DDR4
      ///////// DDR4 /////////
      input              DDR4_REFCLK_p,
      output   [16: 0]   DDR4_A,
      output   [ 1: 0]   DDR4_BA,
      output   [ 0: 0]   DDR4_BG,
      output             DDR4_CK,
      output             DDR4_CK_n,
      output             DDR4_CKE,
      inout    [ 3: 0]   DDR4_DQS,
      inout    [ 3: 0]   DDR4_DQS_n,
      inout    [31: 0]   DDR4_DQ,
      inout    [ 3: 0]   DDR4_DBI_n,
      output             DDR4_CS_n,
      output             DDR4_RESET_n,
      output             DDR4_ODT,
      output             DDR4_PAR,
      input              DDR4_ALERT_n,
      output             DDR4_ACT_n,
      input              DDR4_RZQ,
`endif /*ENABLE_DDR4*/

      ///////// Video-In /////////
      input              TD_CLK27,
      input              TD_HS,
      input              TD_VS,
      input    [ 7: 0]   TD_DATA,
      output             TD_RESET_n,

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,
`endif /*ENABLE_HDMI*/

      ///////// Audio /////////
      inout              AUD_BCLK,
      output             AUD_XCK,
      inout              AUD_ADCLRCK,
      input              AUD_ADCDAT,
      inout              AUD_DACLRCK,
      output             AUD_DACDAT,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// I2C for Camera, Audio, Video-In, Temerature Sensor and Fan Control /////////
      inout              FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,


      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_HSMC
      ///////// HSMC /////////
      output   [ 3: 0]   HSMC_GTS_TX_p,
      output   [ 3: 0]   HSMC_GTS_TX_n,
      input    [ 3: 0]   HSMC_GTS_RX_p,
      input    [ 3: 0]   HSMC_GTS_RX_n,
      input              HSMC_GTS_RX_REFCLK_p,
      output             HSMC_I2C_SCL,
      inout              HSMC_I2C_SDA,
      input    [ 2: 0]   HSMC_CLK_IN,
      input              HSMC_GTS_REFCLK_p,
      inout    [ 1: 0]   HSMC_B5B_D,
      inout    [76: 0]   HSMC_D,
`endif /*ENABLE_HSMC*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LCM_BK,
      inout              HPS_LCM_D_C,
      inout              HPS_LCM_RST_n,
      output             HPS_LCM_SPIM_CLK,
      output             HPS_LCM_SPIM_MOSI,
      output             HPS_LCM_SPIM_SS,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IR /////////
      output             IRDA_TXD,
      input              IRDA_RXD,
		
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
//		output wire [63:0] csi2_rx_video_streaming_interface_0_tdata,         //           csi2_rx_video_streaming_interface_0.tdata
//		output wire        csi2_rx_video_streaming_interface_0_tvalid,        //                                              .tvalid
//		input  wire        csi2_rx_video_streaming_interface_0_tready,        //                                              .tready
//		output wire        csi2_rx_video_streaming_interface_0_tlast,         //                                              .tlast
//		output wire [7:0]  csi2_rx_video_streaming_interface_0_tuser,         //                                              .tuser
		input  wire        csi2_rx_avalon_mm_control_interface_write,         //           csi2_rx_avalon_mm_control_interface.write
		input  wire        csi2_rx_avalon_mm_control_interface_read,          //                                              .read
		input  wire [9:0]  csi2_rx_avalon_mm_control_interface_address,       //                                              .address
		input  wire [31:0] csi2_rx_avalon_mm_control_interface_writedata,     //                                              .writedata
		output wire [31:0] csi2_rx_avalon_mm_control_interface_readdata,      //                                              .readdata
		output wire        csi2_rx_avalon_mm_control_interface_readdatavalid, //                                              .readdatavalid
		output wire        csi2_rx_avalon_mm_control_interface_waitrequest,   //                                              .waitrequest
		input  wire [3:0]  csi2_rx_avalon_mm_control_interface_byteenable,    //                                              .byteenable
		output wire        csi2_rx_avalon_mm_control_interface_interrupt_irq, // csi2_rx_avalon_mm_control_interface_interrupt.irq
//		input  wire        mipi_dphy_rzq_rzq,                                 //                                 mipi_dphy_rzq.rzq
//		input  wire        mipi_dphy_ref_clk_0_clk,                           //                           mipi_dphy_ref_clk_0.clk
		output wire        mipi_dphy_LINK0_link_core_srst_reset_n,            //                mipi_dphy_LINK0_link_core_srst.reset_n
		output wire        mipi_dphy_LINK0_link_core_arst_reset_n,            //                mipi_dphy_LINK0_link_core_arst.reset_n
		input  wire [11:0] mipi_dphy_axi_lite_awaddr,                         //                            mipi_dphy_axi_lite.awaddr
		input  wire        mipi_dphy_axi_lite_awvalid,                        //                                              .awvalid
		output wire        mipi_dphy_axi_lite_awready,                        //                                              .awready
		input  wire [31:0] mipi_dphy_axi_lite_wdata,                          //                                              .wdata
		input  wire [3:0]  mipi_dphy_axi_lite_wstrb,                          //                                              .wstrb
		input  wire        mipi_dphy_axi_lite_wvalid,                         //                                              .wvalid
		output wire        mipi_dphy_axi_lite_wready,                         //                                              .wready
		output wire [1:0]  mipi_dphy_axi_lite_bresp,                          //                                              .bresp
		output wire        mipi_dphy_axi_lite_bvalid,                         //                                              .bvalid
		input  wire        mipi_dphy_axi_lite_bready,                         //                                              .bready
		input  wire [11:0] mipi_dphy_axi_lite_araddr,                         //                                              .araddr
		input  wire        mipi_dphy_axi_lite_arvalid,                        //                                              .arvalid
		output wire        mipi_dphy_axi_lite_arready,                        //                                              .arready
		output wire [31:0] mipi_dphy_axi_lite_rdata,                          //                                              .rdata
		output wire [1:0]  mipi_dphy_axi_lite_rresp,                          //                                              .rresp
		output wire        mipi_dphy_axi_lite_rvalid,                         //                                              .rvalid
		input  wire        mipi_dphy_axi_lite_rready,                         //                                              .rready
		input  wire [2:0]  mipi_dphy_axi_lite_arprot,                         //                                              .arprot
		input  wire [2:0]  mipi_dphy_axi_lite_awprot,                         //                                              .awprot
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dp,              //                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dn,              //                                              .dphy_link_dn
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cp,              //                                              .dphy_link_cp
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cn,              //                                              .dphy_link_cn
		output wire        mipi_dphy_reg_bus_reg_wr_en_o,                     //                             mipi_dphy_reg_bus.reg_wr_en_o
		output wire        mipi_dphy_reg_bus_reg_rd_en_o,                     //                                              .reg_rd_en_o
		output wire [10:0] mipi_dphy_reg_bus_reg_raddr_o,                     //                                              .reg_raddr_o
		output wire [10:0] mipi_dphy_reg_bus_reg_waddr_o,                     //                                              .reg_waddr_o
		output wire [3:0]  mipi_dphy_reg_bus_reg_be_o,                        //                                              .reg_be_o
		output wire [31:0] mipi_dphy_reg_bus_reg_din_o,                       //                                              .reg_din_o
		input  wire [31:0] mipi_dphy_reg_bus_reg_dout_i                      //                                              .reg_dout_i
//		input  wire        rx_axi4s_clk_bridge_in_clk_clk                     //                    rx_axi4s_clk_bridge_in_clk.clk
		

);		



//=======================================================
//  REG/WIRE declarations
//=======================================================
//



wire [63:0] csi2_rx_video_streaming_interface_0_tdata /*synthesis keep*/;         //           csi2_rx_video_streaming_interface_0.tdata
wire        csi2_rx_video_streaming_interface_0_tvalid /*synthesis keep*/;        //                                              .tvalid
wire        csi2_rx_video_streaming_interface_0_tready /*synthesis keep*/;        //                                              .tready
wire        csi2_rx_video_streaming_interface_0_tlast /*synthesis keep*/;         //                                              .tlast
wire [7:0]  csi2_rx_video_streaming_interface_0_tuser /*synthesis keep*/;         //                                              .tuser
	

	
	
//=======================================================
//  Structural coding
//=======================================================

wire vvp_reset_n;
wire not_use_vvp;
assign not_use_vvp = ~KEY[0]; // press KEY0 is disable VVP (high active)
assign vvp_reset_n = KEY[1]; // press KEY1 to trigger reset (low active)


// for debug
//wire        vvp_streamming_ready;
//assign csi2_rx_video_streaming_interface_0_tready = not_use_vvp? 1'b1 : vvp_streamming_ready;




wire ninit_done;
	ResetRelease ResetRelease_inst (
		.ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
	);
	
	
wire reset_n;

assign reset_n = ~ninit_done;	


// camera i2c bus

wire camera_i2c_serial_sda_in;
wire camera_i2c_serial_scl_in;
wire camera_i2c_serial_sda_oe;
wire camera_i2c_serial_scl_oe;
		
assign camera_i2c_serial_scl_in = FPGA_I2C_SCLK;
assign camera_i2c_serial_sda_in = FPGA_I2C_SDAT;
assign FPGA_I2C_SCLK = camera_i2c_serial_scl_oe ? 1'b0 : 1'bz;
assign FPGA_I2C_SDAT = camera_i2c_serial_sda_oe ? 1'b0 : 1'bz;


// power on Camera
assign CAM_GPIO = nios_cam_pio ;//1;

wire [9:0] nios_led;
wire clk_1080p;


wire [23: 0] disp_data;
wire disp_clk;
wire disp_hs;
wire disp_vs;
wire disp_de;	


wire csi2_axi4_clock;
wire dphy_clock;
//wire mipi_dphy_ref_clk;


		  
wire [63:0] csi2_rx_video_streaming_interface_0_tdata /*synthesis keep*/;         //           csi2_rx_video_streaming_interface_0.tdata
wire        csi2_rx_video_streaming_interface_0_tvalid /*synthesis keep*/;        //                                              .tvalid
wire        csi2_rx_video_streaming_interface_0_tready /*synthesis keep*/;        //                                              .tready
wire        csi2_rx_video_streaming_interface_0_tlast /*synthesis keep*/;         //                                              .tlast
wire [7:0]  csi2_rx_video_streaming_interface_0_tuser /*synthesis keep*/;         //                                              .tuser



assign TD_RESET_n = reset_n; // to avoid video-in i2c to effect shared i2c bus

wire hdmi_config_done;
wire pio_mem_ready;
wire nios_reset_n_vvp; // reset vvp when lpddr4 is ready. otherwise, vvp frame buffer could malfunction
wire nios_cam_pio;


wire hdmi_pll_locked;
	hdmi_pll hdmi_pll_inst (
		.refclk   (CLOCK1_50),   //   input,  width = 1,  refclk.clk
		.locked   (hdmi_pll_locked),   //  output,  width = 1,  locked.export
		.rst      (~reset_n),      //   input,  width = 1,   reset.reset
		.outclk_0 (clk_1080p)  //  output,  width = 1, outclk0.clk
	);

 system u0 (
        .clk_clk                            (CLOCK0_50),       
        .reset_n_reset_n                    (reset_n & hdmi_pll_locked), 
        .reset_in_vvp_in_reset_reset_n      (vvp_reset_n & nios_reset_n_vvp & pio_mem_ready),                          //   input,   width = 1,                      reset_in_vvp_in_reset.reset_n
        .pio_hdmi_config_done_external_connection_export   (hdmi_config_done),        //   input,   width = 1,   pio_hdmi_config_done_external_connection.export
        .pio_mem_ready_external_connection_export          (pio_mem_ready),                  //   input,   width = 1,                pio_mem_ready_external_connection.export
        .pio_vvp_reset_n_external_connection_export        (nios_reset_n_vvp),               //  output,   width = 1,              pio_vvp_reset_n_external_connection.export
	     .pio_cam_gpio_external_connection_export           (nios_cam_pio),                    //  output,   width = 1,                  pio_cam_gpio_external_connection.export
		  
		  
		  // PLL clock output
        .csi2_axi4_clk_clk                                     (csi2_axi4_clock),                                     //  output,   width = 1,                         csi2_axi4_clk.clk
        .dphy_clk_clk                                          (dphy_clock),                                          //  output,   width = 1,                              dphy_clk.clk
       // .hdmi_clk_clk                                          (clk_1080p),                                          //  output,   width = 1,                              hdmi_clk.clk

		  
		  // User IO
        .seg7_conduit_end_export               ({
                                              HEX5P, HEX5, HEX4P, HEX4, 
                                              HEX3P, HEX3, HEX2P, HEX2,
                                              HEX1P, HEX1, HEX0P, HEX0}),               //  output,  width = 48,               seg7_conduit_end.export
        .pio_switch_external_connection_export (SW), //   input,  width = 10, pio_switch_external_connection.export
        .pio_key_external_connection_export    (KEY),     //   input,   width = 4,    pio_key_external_connection.export
        .pio_led_external_connection_export (nios_led),  //  output,  width = 10, pio_led_external_connection.export
		  
		  // CAMERA I2C
        .i2c_i2c_serial_sda_in (camera_i2c_serial_sda_in), //   input,  width = 1, i2c_camera_i2c_serial.sda_in
        .i2c_i2c_serial_scl_in (camera_i2c_serial_scl_in), //   input,  width = 1,                      .scl_in
        .i2c_i2c_serial_sda_oe (camera_i2c_serial_sda_oe), //  output,  width = 1,                      .sda_oe
        .i2c_i2c_serial_scl_oe (camera_i2c_serial_scl_oe),  //  output,  width = 1,                      .scl_oe
		  
		  ////////////////////////////
		  // VVP interface
        .vvp_system_clock_in_csi2_in_clk_clk                   (csi2_axi4_clock),                   //   input,   width = 1,       vvp_system_clock_in_csi2_in_clk.clk
        .vvp_system_clock_in_hdmi_in_clk_clk                   (clk_1080p),                   //   input,   width = 1,       vvp_system_clock_in_hdmi_in_clk.clk
		
		  
				// DDR4
        .vvp_system_emif_ph2_ddr4_ref_clk_0_clk                 (DDR4_REFCLK_p),                //   input,   width = 1,    vvp_system_emif_ph2_ddr4_ref_clk_0.clk
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_cke           (DDR4_CKE),           //  output,   width = 1,       vvp_system_emif_io96b_ddr4comp_mem_0.mem_cke
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_odt           (DDR4_ODT),           //  output,   width = 1,                                           .mem_odt
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_cs_n          (DDR4_CS_n),          //  output,   width = 1,                                           .mem_cs_n
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_a             (DDR4_A),             //  output,  width = 17,                                           .mem_a
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_ba            (DDR4_BA),            //  output,   width = 2,                                           .mem_ba
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_bg            (DDR4_BG),            //  output,   width = 1,                                           .mem_bg
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_act_n         (DDR4_ACT_n),         //  output,   width = 1,                                           .mem_act_n
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_par           (DDR4_PAR),           //  output,   width = 1,                                           .mem_par
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_dq            (DDR4_DQ),            //   inout,  width = 32,                                           .mem_dq
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_dqs_t         (DDR4_DQS),         //   inout,   width = 4,                                           .mem_dqs_t
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_dqs_c         (DDR4_DQS_n),         //   inout,   width = 4,                                           .mem_dqs_c
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_alert_n       (DDR4_ALERT_n),       //   input,   width = 1,                                           .mem_alert_n
        .vvp_system_emif_io96b_ddr4comp_mem_0_mem_dbi_n         (DDR4_DBI_n),         //   inout,   width = 4,                                           .mem_dbi_n
        .vvp_system_emif_io96b_ddr4comp_mem_ck_0_mem_ck_t       (DDR4_CK),       //  output,   width = 1,    vvp_system_emif_io96b_ddr4comp_mem_ck_0.mem_ck_t
        .vvp_system_emif_io96b_ddr4comp_mem_ck_0_mem_ck_c       (DDR4_CK_n),       //  output,   width = 1,                                           .mem_ck_c
        .vvp_system_emif_io96b_ddr4comp_mem_reset_n_mem_reset_n (DDR4_RESET_n), //  output,   width = 1, vvp_system_emif_io96b_ddr4comp_mem_reset_n.mem_reset_n
        .vvp_system_emif_io96b_ddr4comp_oct_0_oct_rzqin         (DDR4_RZQ),         //   input,   width = 1,       vvp_system_emif_io96b_ddr4comp_oct_0.oct_rzqin
        .vvp_system_emif_io96b_ddr4comp_s0_axi4_ctrl_ready_reset_n (pio_mem_ready), //  output,   width = 1, vvp_system_emif_io96b_ddr4comp_s0_axi4_ctrl_ready.reset_n
		  
		  
		  
		  
		  // video input (Camera RGB input, 4 pixel paralle, 10 bit per sample, RGB)
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tdata      (csi2_rx_video_streaming_interface_0_tdata),      //   input,  width = 64, vvp_system_intel_vvp_demosaic_axi4s_vid_in.tdata
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tvalid     (csi2_rx_video_streaming_interface_0_tvalid),     //   input,   width = 1,                                           .tvalid
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tready     (csi2_rx_video_streaming_interface_0_tready),     //  output,   width = 1,                                           .tready
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tlast      (csi2_rx_video_streaming_interface_0_tlast),      //   input,   width = 1,                                           .tlast
        .vvp_system_intel_vvp_demosaic_axi4s_vid_in_tuser      (csi2_rx_video_streaming_interface_0_tuser),      //   input,   width = 8,                                           .tuser


		  
				// video output
        .vvp_system_intel_vvp_cvo_vid_status_vid_locked        (),        //  output,   width = 1,   vvp_system_intel_vvp_cvo_vid_status.vid_locked
        .vvp_system_intel_vvp_cvo_vid_status_vid_is_full       (),       //  output,   width = 1,                                      .vid_is_full
        .vvp_system_intel_vvp_cvo_vid_status_vid_stall_error   (),   //  output,   width = 1,                                      .vid_stall_error
        .vvp_system_intel_vvp_cvo_vid_status_vid_size_mismatch (), //  output,   width = 1,                                      .vid_size_mismatch
        .vvp_system_intel_vvp_cvo_frame_start_conduit          (1'b1),          //   input,   width = 1,  vvp_system_intel_vvp_cvo_frame_start.conduit
        .vvp_system_intel_vvp_fr2cv_cv_clk_out_clk             (),             //  output,   width = 1, vvp_system_intel_vvp_fr2cv_cv_clk_out.clk
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_data        (disp_data),        //  output,  width = 24, vvp_system_intel_vvp_fr2cv_cv_vid_out.vid_data
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_underflow       (),       //  output,   width = 1,                                      .underflow
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_datavalid   (disp_de),   //  output,   width = 1,                                      .vid_datavalid
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v_sync      (disp_vs),      //  output,   width = 1,                                      .vid_v_sync
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h_sync      (disp_hs),      //  output,   width = 1,                                      .vid_h_sync
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_f           (),           //  output,   width = 1,                                      .vid_f
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_h           (),           //  output,   width = 1,                                      .vid_h
        .vvp_system_intel_vvp_fr2cv_cv_vid_out_vid_v           ()           //  output,   width = 1,                                      .vid_v
		  
		  
    );
 
/////////////////////////	 
// VVP to HDMI OUTPUT	 

assign disp_clk = clk_1080p; 

assign HDMI_TX_D = disp_data;	 
assign HDMI_TX_CLK = disp_clk;
assign HDMI_TX_HS = disp_hs;
assign HDMI_TX_VS = disp_vs;
assign HDMI_TX_DE = disp_de;		 

	 
/////////////////////////
// Camera System: DPHY + CSI-2
//assign mipi_dphy_ref_clk = CLOCK3_50  ;


	csi2_dphy_sys csi2_dphy_sys_cam (
		.reset_n_bridge_in_reset_reset_n                   (reset_n),                   //   input,   width = 1,                       reset_n_bridge_in_reset.reset_n
		.rx_axi4s_clk_bridge_in_clk_clk                    (csi2_axi4_clock),                     //   input,   width = 1,                    rx_axi4s_clk_bridge_in_clk.clk
	
		// cSI2
		.csi2_rx_o_d0_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d0_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
		.csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_d0_ppi_rx_err_ErrEsc                    (csi2_rx_o_d0_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_d0_ppi_rx_err_ErrControl                (csi2_rx_o_d0_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_o_d1_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d1_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
		.csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_d1_ppi_rx_err_ErrEsc                    (csi2_rx_o_d1_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_d1_ppi_rx_err_ErrControl                (csi2_rx_o_d1_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_o_ck_ppi_rx_err_ErrSotHS                  (csi2_rx_o_ck_ppi_rx_err_ErrSotHS),                  //  output,   width = 1,                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
		.csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS),              //  output,   width = 1,                                              .ErrSotSyncHS
		.csi2_rx_o_ck_ppi_rx_err_ErrEsc                    (csi2_rx_o_ck_ppi_rx_err_ErrEsc),                    //  output,   width = 1,                                              .ErrEsc
		.csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc),                //  output,   width = 1,                                              .ErrSyncEsc
		.csi2_rx_o_ck_ppi_rx_err_ErrControl                (csi2_rx_o_ck_ppi_rx_err_ErrControl),                //  output,   width = 1,                                              .ErrControl
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0),          //  output,   width = 1,                                              .ErrContentionLP0
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1),          //  output,   width = 1,                                              .ErrContentionLP1
		.csi2_rx_video_streaming_interface_0_tdata         (csi2_rx_video_streaming_interface_0_tdata),         //  output,  width = 64,           csi2_rx_video_streaming_interface_0.tdata
		.csi2_rx_video_streaming_interface_0_tvalid        (csi2_rx_video_streaming_interface_0_tvalid),        //  output,   width = 1,                                              .tvalid
		.csi2_rx_video_streaming_interface_0_tready        (csi2_rx_video_streaming_interface_0_tready),        //   input,   width = 1,                                              .tready
		.csi2_rx_video_streaming_interface_0_tlast         (csi2_rx_video_streaming_interface_0_tlast),         //  output,   width = 1,                                              .tlast
		.csi2_rx_video_streaming_interface_0_tuser         (csi2_rx_video_streaming_interface_0_tuser),         //  output,   width = 8,                                              .tuser
		.csi2_rx_avalon_mm_control_interface_write         (csi2_rx_avalon_mm_control_interface_write),         //   input,   width = 1,           csi2_rx_avalon_mm_control_interface.write
		.csi2_rx_avalon_mm_control_interface_read          (csi2_rx_avalon_mm_control_interface_read),          //   input,   width = 1,                                              .read
		.csi2_rx_avalon_mm_control_interface_address       (csi2_rx_avalon_mm_control_interface_address),       //   input,  width = 10,                                              .address
		.csi2_rx_avalon_mm_control_interface_writedata     (csi2_rx_avalon_mm_control_interface_writedata),     //   input,  width = 32,                                              .writedata
		.csi2_rx_avalon_mm_control_interface_readdata      (csi2_rx_avalon_mm_control_interface_readdata),      //  output,  width = 32,                                              .readdata
		.csi2_rx_avalon_mm_control_interface_readdatavalid (csi2_rx_avalon_mm_control_interface_readdatavalid), //  output,   width = 1,                                              .readdatavalid
		.csi2_rx_avalon_mm_control_interface_waitrequest   (csi2_rx_avalon_mm_control_interface_waitrequest),   //  output,   width = 1,                                              .waitrequest
		.csi2_rx_avalon_mm_control_interface_byteenable    (csi2_rx_avalon_mm_control_interface_byteenable),    //   input,   width = 4,                                              .byteenable
		.csi2_rx_avalon_mm_control_interface_interrupt_irq (csi2_rx_avalon_mm_control_interface_interrupt_irq), //  output,   width = 1, csi2_rx_avalon_mm_control_interface_interrupt.irq
		
		// MIPI PHY
		.mipi_dphy_rzq_rzq                                 (CAM_RZQ1),                                 //   input,   width = 1,                                 mipi_dphy_rzq.rzq
		.mipi_dphy_ref_clk_0_clk                           (CLOCK2_50),                           //   input,   width = 1,                           mipi_dphy_ref_clk_0.clk
		.mipi_dphy_LINK0_link_core_srst_reset_n            (mipi_dphy_LINK0_link_core_srst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_srst.reset_n
		.mipi_dphy_LINK0_link_core_arst_reset_n            (mipi_dphy_LINK0_link_core_arst_reset_n),            //  output,   width = 1,                mipi_dphy_LINK0_link_core_arst.reset_n
		.mipi_dphy_axi_lite_awaddr                         (mipi_dphy_axi_lite_awaddr),                         //   input,  width = 12,                            mipi_dphy_axi_lite.awaddr
		.mipi_dphy_axi_lite_awvalid                        (mipi_dphy_axi_lite_awvalid),                        //   input,   width = 1,                                              .awvalid
		.mipi_dphy_axi_lite_awready                        (mipi_dphy_axi_lite_awready),                        //  output,   width = 1,                                              .awready
		.mipi_dphy_axi_lite_wdata                          (mipi_dphy_axi_lite_wdata),                          //   input,  width = 32,                                              .wdata
		.mipi_dphy_axi_lite_wstrb                          (mipi_dphy_axi_lite_wstrb),                          //   input,   width = 4,                                              .wstrb
		.mipi_dphy_axi_lite_wvalid                         (mipi_dphy_axi_lite_wvalid),                         //   input,   width = 1,                                              .wvalid
		.mipi_dphy_axi_lite_wready                         (mipi_dphy_axi_lite_wready),                         //  output,   width = 1,                                              .wready
		.mipi_dphy_axi_lite_bresp                          (mipi_dphy_axi_lite_bresp),                          //  output,   width = 2,                                              .bresp
		.mipi_dphy_axi_lite_bvalid                         (mipi_dphy_axi_lite_bvalid),                         //  output,   width = 1,                                              .bvalid
		.mipi_dphy_axi_lite_bready                         (mipi_dphy_axi_lite_bready),                         //   input,   width = 1,                                              .bready
		.mipi_dphy_axi_lite_araddr                         (mipi_dphy_axi_lite_araddr),                         //   input,  width = 12,                                              .araddr
		.mipi_dphy_axi_lite_arvalid                        (mipi_dphy_axi_lite_arvalid),                        //   input,   width = 1,                                              .arvalid
		.mipi_dphy_axi_lite_arready                        (mipi_dphy_axi_lite_arready),                        //  output,   width = 1,                                              .arready
		.mipi_dphy_axi_lite_rdata                          (mipi_dphy_axi_lite_rdata),                          //  output,  width = 32,                                              .rdata
		.mipi_dphy_axi_lite_rresp                          (mipi_dphy_axi_lite_rresp),                          //  output,   width = 2,                                              .rresp
		.mipi_dphy_axi_lite_rvalid                         (mipi_dphy_axi_lite_rvalid),                         //  output,   width = 1,                                              .rvalid
		.mipi_dphy_axi_lite_rready                         (mipi_dphy_axi_lite_rready),                         //   input,   width = 1,                                              .rready
		.mipi_dphy_axi_lite_arprot                         (mipi_dphy_axi_lite_arprot),                         //   input,   width = 3,                                              .arprot
		.mipi_dphy_axi_lite_awprot                         (mipi_dphy_axi_lite_awprot),                         //   input,   width = 3,                                              .awprot
		.mipi_dphy_LINK0_dphy_io_dphy_link_dp              (CAM_D_p),              //   input,   width = 2,                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
		.mipi_dphy_LINK0_dphy_io_dphy_link_dn              (CAM_D_n),              //   input,   width = 2,                                              .dphy_link_dn
		.mipi_dphy_LINK0_dphy_io_dphy_link_cp              (CAM_CLK_p),              //   input,   width = 1,                                              .dphy_link_cp
		.mipi_dphy_LINK0_dphy_io_dphy_link_cn              (CAM_CLK_n),              //   input,   width = 1,                                              .dphy_link_cn
		.mipi_dphy_reg_bus_reg_wr_en_o                     (mipi_dphy_reg_bus_reg_wr_en_o),                     //  output,   width = 1,                             mipi_dphy_reg_bus.reg_wr_en_o
		.mipi_dphy_reg_bus_reg_rd_en_o                     (mipi_dphy_reg_bus_reg_rd_en_o),                     //  output,   width = 1,                                              .reg_rd_en_o
		.mipi_dphy_reg_bus_reg_raddr_o                     (mipi_dphy_reg_bus_reg_raddr_o),                     //  output,  width = 11,                                              .reg_raddr_o
		.mipi_dphy_reg_bus_reg_waddr_o                     (mipi_dphy_reg_bus_reg_waddr_o),                     //  output,  width = 11,                                              .reg_waddr_o
		.mipi_dphy_reg_bus_reg_be_o                        (mipi_dphy_reg_bus_reg_be_o),                        //  output,   width = 4,                                              .reg_be_o
		.mipi_dphy_reg_bus_reg_din_o                       (mipi_dphy_reg_bus_reg_din_o),                       //  output,  width = 32,                                              .reg_din_o
		.mipi_dphy_reg_bus_reg_dout_i                      (mipi_dphy_reg_bus_reg_dout_i)                      //   input,  width = 32,                                              .reg_dout_i
	);




/////////////////////////////////////
// Optional, Analysis CSI-2 AXI4 video stream 

AXI_Stream_Analyze AXI_Stream_Analyze_inst(
	.reset_n    (reset_n),
	.axi_clock  (csi2_axi4_clock),
	.axi_tdata  (csi2_rx_video_streaming_interface_0_tdata),
	.axi_tvalid (csi2_rx_video_streaming_interface_0_tvalid),
	.axi_tready (csi2_rx_video_streaming_interface_0_tready),
	.axi_tlast  (csi2_rx_video_streaming_interface_0_tlast),
	.axi_tuser  (csi2_rx_video_streaming_interface_0_tuser)
	
);

// override default value
defparam AXI_Stream_Analyze_inst.TICK_PER_SEC = 60000000;


				
			
							
//=======================================================


/////////////////////////////////
//-----HDMI TX chip I2C Setting 

wire	REST_N;
wire  HDMI_READY ;

assign REST_N        = KEY [3] ;
assign hdmi_config_done = HDMI_READY;

I2C_HDMI_Config u_I2C_HDMI_Config (
	.iCLK    ( CLOCK2_50),
	.iRST_N  ( REST_N        ),
	.I2C_SCLK( FPGA_I2C_SCLK ),
	.I2C_SDAT( FPGA_I2C_SDAT ),
	.READY   ( HDMI_READY    ),
	.HDMI_TX_INT(HDMI_TX_INT )
	);
//assign LEDR[8:1]       = 8'hFF;	
assign LEDR[8:1]       = nios_led[8:1];	
assign LEDR [0]        = ~HDMI_READY ; 
	


endmodule

