module I2C_AV_Config (	//	Host Side
						iCLK,
						iRST_N,
						//	I2C Side
						I2C_SCLK,
						I2C_SDAT	,
						READY
						);
//	Host Side
input		iCLK;
input		iRST_N;
//	I2C Side
output		I2C_SCLK;
inout		   I2C_SDAT;
//--
output      READY;
//	Internal Registers/Wires
reg            READY;
reg	[15:0]	mI2C_CLK_DIV;
reg	[23:0]	mI2C_DATA;
reg			mI2C_CTRL_CLK;
reg			mI2C_GO;
wire		mI2C_END;
wire		mI2C_ACK;
reg	[15:0]	LUT_DATA;
reg	[5:0]	LUT_INDEX;
reg	[3:0]	mSetup_ST;

//	Clock Setting
parameter	CLK_Freq	=	50000000;	//	50	MHz
parameter	I2C_Freq	=	20000;		//	20	KHz
//	LUT Data Number
parameter	LUT_SIZE	=	22 + 21;//audio +video
//	Audio Data Index
parameter	Dummy_DATA	=	0  ;
parameter	POWER_ON	   =	1  ;
parameter   AUDIO0      =  2  ;
parameter   AUDIO1      =  3  ;
parameter   AUDIO2      =  4  ;
parameter   AUDIO3      =  5  ;
parameter   AUDIO4      =  6  ;
parameter   AUDIO5      =  7  ;
parameter   AUDIO6      =  8  ;
parameter   AUDIO7      =  9  ;
parameter   AUDIO8      =  10 ;
parameter   AUDIO9      =  11 ;
parameter   AUDIO10     =  12 ;
parameter	SET_LIN_R	=	13 ;
parameter	SET_HEAD_L	=	14 ;
parameter	SET_HEAD_R	=	15 ;
parameter	A_PATH_CTRL	=	16 ;
parameter	D_PATH_CTRL	=	17 ;
parameter	SET_LIN_L	=	18 ;
parameter	SET_FORMAT	=	19;
parameter	SAMPLE_CTRL	=	20;
parameter	SET_ACTIVE	=	21;
//	Video Data Index        
parameter	SET_VIDEO	=	22;

/////////////////////	I2C Control Clock	////////////////////////
always@(posedge iCLK or negedge iRST_N)
begin
	if(!iRST_N)
	begin
		mI2C_CTRL_CLK	<=	0;
		mI2C_CLK_DIV	<=	0;
	end
	else
	begin
		if( mI2C_CLK_DIV	< (CLK_Freq/I2C_Freq) )
		mI2C_CLK_DIV	<=	mI2C_CLK_DIV+1;
		else
		begin
			mI2C_CLK_DIV	<=	0;
			mI2C_CTRL_CLK	<=	~mI2C_CTRL_CLK;
		end
	end
end
////////////////////////////////////////////////////////////////////
I2C_Controller 	u0	(	.CLOCK(mI2C_CTRL_CLK),		//	Controller Work Clock
						.I2C_SCLK(I2C_SCLK),		//	I2C CLOCK
 	 	 	 	 	 	.I2C_SDAT(I2C_SDAT),		//	I2C DATA
						.I2C_DATA(mI2C_DATA),		//	DATA:[SLAVE_ADDR,SUB_ADDR,DATA]
						.GO(mI2C_GO),      			//	GO transfor
						.END(mI2C_END),				//	END transfor 
						.ACK(mI2C_ACK),				//	ACK
						.RESET(iRST_N)	);
////////////////////////////////////////////////////////////////////
//////////////////////	Config Control	////////////////////////////
//When activating the digital core of the SSM2603, 
//it is important for the user to follow this sequence: 
//After activating the desired power-on blocks from Register R6, 
//some delay time should be inserted prior to activating 
//the active bit (Register R9, Bit D0), which enables the digital core.
//The delay time is approximated by the following equation:
//t = C × 25,000/3.5
//where C is the decoupling capacitor on the VMID pin. 
//For example, if C = 10 μF, t = 71 ms.

reg [15:0]delay ; 
parameter ms100 = 4000;  //200ms*20K 
always@(posedge mI2C_CTRL_CLK or negedge iRST_N) //20k
begin
	if(!iRST_N) 
	begin
		READY       <= 0;
		LUT_INDEX	<=	0;
		mSetup_ST	<=	0;
		mI2C_GO		<=	0;
	end
	else
	begin
		if(LUT_INDEX<LUT_SIZE)
		begin
			READY<=0;
			case(mSetup_ST)
			0:	begin
					if(LUT_INDEX<SET_VIDEO)
					mI2C_DATA	<=	{8'h36,LUT_DATA};//audio
					else
					mI2C_DATA	<=	{8'h40,LUT_DATA};//tv-decoder
					mI2C_GO		<=	1;
					mSetup_ST	<=	1;
				end
			1:	begin
					if(mI2C_END)
					begin
						if(!mI2C_ACK)
						   if ((LUT_INDEX == POWER_ON) || (LUT_INDEX == AUDIO8)) mSetup_ST	<=	10;// to delay 
							else mSetup_ST	<=	2;
						else
						mSetup_ST	<=	0;							
						mI2C_GO		<=	0;
					end
				end
			2:	begin
					LUT_INDEX	<=	LUT_INDEX+1;
					mSetup_ST	<=	0;
				end
//    -------	
      	10:	begin
					delay       <= 0;
					mSetup_ST	<=	11;
				end		
      	11:	begin
					if ( delay == ms100) mSetup_ST	<=	2; 
					else delay<= delay+1 ;
					
				end		
				
				
			endcase
		end
		else 		READY<=1;
	end
end
////////////////////////////////////////////////////////////////////

/////////////////////	Config Data LUT	  //////////////////////////
always
begin
	case(LUT_INDEX)
	POWER_ON	   : LUT_DATA <= 16'h0C00;
	//	Audio Config Data0
	
   AUDIO0      : LUT_DATA <= 16'h1E00;
   AUDIO1      : LUT_DATA <= 16'h1200;
   AUDIO2      : LUT_DATA <= 16'h0017;
   AUDIO3      : LUT_DATA <= 16'h0217;
   AUDIO4      : LUT_DATA <= 16'h045B;
   AUDIO5      : LUT_DATA <= 16'h065B;
   AUDIO6      : LUT_DATA <= 16'h0815;
   AUDIO7      : LUT_DATA <= 16'h0A00;
   AUDIO8      : LUT_DATA <= 16'h0C00;
   AUDIO9      : LUT_DATA <= 16'h0E42;
   AUDIO10     : LUT_DATA <= 16'h1002;
//   AUDIO10     : LUT_DATA <= 16'h1201;
	

	//	Audio Config Data1
	SET_LIN_L	:	LUT_DATA	<=	16'h001A;
	SET_LIN_R	:	LUT_DATA	<=	16'h021A;
	SET_HEAD_L	:	LUT_DATA	<=	16'h047B;
	SET_HEAD_R	:	LUT_DATA	<=	16'h067B;
	A_PATH_CTRL	:	LUT_DATA	<=	16'h0832 ; //0x32 //sidetone enable
                                               //select DAC
                                               //bypass disable 
                                               //line input select to ADC
                                                   
	D_PATH_CTRL	:	LUT_DATA	<=	16'h0A06;//48K sample-rate
	SET_FORMAT	:	LUT_DATA	<=	16'h0E02;//bit7:1 = BCLK none  inverted,bit6:0= enable slave mode (default) ,bit [3:2]:00=16bit ,bit[1:0]:10 = standard I2S
	SAMPLE_CTRL	:	LUT_DATA	<=	16'h1000;//0 = support for 256 fS based clock (default)
	SET_ACTIVE	:	LUT_DATA	<=	16'h1201;//
	//	Video Config Data
	SET_VIDEO+0	:	LUT_DATA	<=	16'h0000;//04
	SET_VIDEO+1	:	LUT_DATA	<=	16'hc301;	
   SET_VIDEO+2	:	LUT_DATA	<=	16'hc480;	
   SET_VIDEO+3	:	LUT_DATA	<=	16'h0457;
	SET_VIDEO+4	:	LUT_DATA	<=	16'h1741;
	SET_VIDEO+5	:	LUT_DATA	<=	16'h5801;
	SET_VIDEO+6	:	LUT_DATA	<=	16'h3da2;
	SET_VIDEO+7	:	LUT_DATA	<=	16'h37a0;
	SET_VIDEO+8	:	LUT_DATA	<=	16'h3e6a;
	SET_VIDEO+9	:	LUT_DATA	<=	16'h3fa0;
	SET_VIDEO+10:	LUT_DATA	<=	16'h0e80;
	SET_VIDEO+11:	LUT_DATA	<=	16'h5581;
	SET_VIDEO+12:	LUT_DATA	<=	16'h3720;   // hs/vs negitive Polarity , pixel clock normal 
	SET_VIDEO+13:	LUT_DATA	<=	16'h0880;	// Contrast Register 
	SET_VIDEO+14:	LUT_DATA	<=	16'h0a18;	// Brightness Register 
	SET_VIDEO+15:	LUT_DATA	<=	16'h2c8e;	// AGC Mode control
	SET_VIDEO+16:	LUT_DATA	<=	16'h2df8;   // Chroma Gain Control 1 
	SET_VIDEO+17:	LUT_DATA	<=	16'h2ece;	// Chroma Gain Control 2 
	SET_VIDEO+18:	LUT_DATA	<=	16'h2ff4;	// Luma Gain Control 1
	SET_VIDEO+19:	LUT_DATA	<=	16'h30b2;	// Luma Gain Control 2	
	SET_VIDEO+20:	LUT_DATA	<=	16'h0e00;
	//21
	//SET_VIDEO+13	:	LUT_DATA	   <=	16'h37A0;   // Polarity regiser
	
//45
	default:		LUT_DATA	<=	16'd0 ;
	endcase
end
////////////////////////////////////////////////////////////////////
endmodule