// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Apr 23 19:05:55 2025
// ============================================================================

//`define ENABLE_DDR4
//`define ENABLE_HPS
`define ENABLE_HDMI
//`define ENABLE_HSMC
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input              CPU_RESET_n,
      input    [ 3: 0]   KEY,

      ///////// SW /////////
      input    [ 9: 0]   SW,

      ///////// LED /////////
      output   [ 9: 0]   LEDR,

      ///////// Seg7 /////////
      output   [ 6: 0]   HEX0,
      output   [ 6: 0]   HEX1,
      output   [ 6: 0]   HEX2,
      output   [ 6: 0]   HEX3,
      output   [ 6: 0]   HEX4,
      output   [ 6: 0]   HEX5,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_DDR4
      ///////// DDR4 /////////
      input              DDR4_REFCLK_p,
      output   [16: 0]   DDR4_A,
      output   [ 1: 0]   DDR4_BA,
      output   [ 0: 0]   DDR4_BG,
      output             DDR4_CK,
      output             DDR4_CK_n,
      output             DDR4_CKE,
      inout    [ 3: 0]   DDR4_DQS,
      inout    [ 3: 0]   DDR4_DQS_n,
      inout    [31: 0]   DDR4_DQ,
      inout    [ 3: 0]   DDR4_DBI_n,
      output             DDR4_CS_n,
      output             DDR4_RESET_n,
      output             DDR4_ODT,
      output             DDR4_PAR,
      input              DDR4_ALERT_n,
      output             DDR4_ACT_n,
      input              DDR4_RZQ,
`endif /*ENABLE_DDR4*/

      ///////// Video-In /////////
      input              TD_CLK27,
      input              TD_HS,
      input              TD_VS,
      input    [ 7: 0]   TD_DATA,
      output             TD_RESET_n,

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,
`endif /*ENABLE_HDMI*/

      ///////// Audio /////////
      inout              AUD_BCLK,
      output             AUD_XCK,
      inout              AUD_ADCLRCK,
      input              AUD_ADCDAT,
      inout              AUD_DACLRCK,
      output             AUD_DACDAT,

      ///////// ADC /////////
      output             ADC_SCK,
      output             ADC_SDO,
      input              ADC_SDI,
      output             ADC_CS_n,

      ///////// I2C for Camera, Audio and Video-In /////////
      output             FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_HSMC
      ///////// HSMC /////////
      output   [ 3: 0]   HSMC_GTS_TX_p,
      output   [ 3: 0]   HSMC_GTS_TX_n,
      input    [ 3: 0]   HSMC_GTS_RX_p,
      input    [ 3: 0]   HSMC_GTS_RX_n,
      input              HSMC_GTS_RX_REFCLK_p,
      output             HSMC_I2C_SCL,
      inout              HSMC_I2C_SDA,
      input    [ 2: 0]   HSMC_CLK_IN,
      input              HSMC_GTS_REFCLK_p,
      inout    [ 1: 0]   HSMC_B5B_D,
      inout    [76: 0]   HSMC_D,
`endif /*ENABLE_HSMC*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LCM_BK,
      inout              HPS_LCM_D_C,
      inout              HPS_LCM_RST_n,
      output             HPS_LCM_SPIM_CLK,
      output             HPS_LCM_SPIM_MOSI,
      output             HPS_LCM_SPIM_SS,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IR /////////
      output             IRDA_TXD,
      input              IRDA_RXD

);

//=======================================================
//  REG/WIRE declarations
//=======================================================
//	For Audio CODEC
wire		AUD_CTRL_CLK;	//	For Audio Controller

//	For ITU-R 656 Decoder
wire	[15:0]	YCbCr;
wire	[9:0]	TV_X;
wire			TV_DVAL;

//	For VGA Controller
wire	[9:0]	mRed;
wire	[9:0]	mGreen;
wire	[9:0]	mBlue;
wire	[10:0]	VGA_X;
wire	[10:0]	VGA_Y;
wire			VGA_Read;	//	VGA data request
wire			m1VGA_Read;	//	Read odd field
wire			m2VGA_Read;	//	Read even field

//	For YUV 4:2:2 to YUV 4:4:4
wire	[7:0]	mY;
wire	[7:0]	mCb;
wire	[7:0]	mCr;

//	For field select
wire	[15:0]	mYCbCr;
wire	[15:0]	mYCbCr_d;
wire	[15:0]	m1YCbCr;
wire	[15:0]	m2YCbCr;
wire	[15:0]	m3YCbCr;

//	For Delay Timer
wire			TD_Stable;
wire			DLY0;
wire			DLY1;
wire			DLY2;

//	For Down Sample
wire	[3:0]	Remain;
wire	[9:0]	Quotient;

wire			mDVAL;
wire	[15:0]	m4YCbCr;
wire	[15:0]	m5YCbCr;
wire	[8:0]	Tmp1,Tmp2;
wire	[7:0]	Tmp3,Tmp4;

// NTSC/PAL Status
wire            NTSC;
wire            PAL;

// OUT Clock 
wire            OUT_CLK ; 		

// AV PLL 
wire            AV_PLL_locked ; 
wire            VGA_25MHZ ;

//HDMI I2C	
wire           HDMI_READY ; 
wire           HDMI_I2C_SCLK ;

//	Audio CODEC and video decoder I2C
wire           AV_I2C_SCLK ; 
wire           AV_READY ;

// DAC gen data output 
wire           DAC_DACDAT; 
//=============================================================================
// Structural coding
//=============================================================================

//	All inout port turn to tri-state 
assign	GPIO	=	36'hzzzzzzzzz;

//	Turn On TV Decoder
assign	TD_RESET_n	=	1'b1;

// Audio Codec wire 
assign	AUD_ADCLRCK	=	AUD_DACLRCK;
assign	AUD_XCK	   =	AUD_CTRL_CLK;

// HDMI  SOUND MCLK
assign	HDMI_MCLK   =	AUD_CTRL_CLK;


// LED  display for main point
assign	LEDR[5:0]	=	{~PAL ,~NTSC,~AV_PLL_locked , ~TD_Stable,~HDMI_READY,~AV_READY};

// TO heart main frequence
heart_beat  heart_TD_CLK27     (.CLK  (TD_CLK27),     .CLK_FREQ (27_000_000), .CK_1HZ (LEDR[9]) ) ;
heart_beat  heart_TD_CLK50     (.CLK  (CLOCK0_50),     .CLK_FREQ (50_000_000), .CK_1HZ (LEDR[8]) ) ;
heart_beat  heart_VGA_CLK      (.CLK  (HDMI_TX_CLK),  .CLK_FREQ (25_000_000), .CK_1HZ (LEDR[7]) ) ;
heart_beat  heart_AUD_CTRL_CLK (.CLK  (AUD_CTRL_CLK), .CLK_FREQ (12_288_000), .CK_1HZ (LEDR[6]) ) ;



// read odd/even  Field
assign	m1VGA_Read	=	VGA_Y[0]		?	1'b0		:	(SW[2]?0:VGA_Read)	;
assign	m2VGA_Read	=	VGA_Y[0]		?	(SW[1]?0:VGA_Read)	:	1'b0		;
assign	mYCbCr_d	   =	VGA_Y[0]		?	( SW[1]? 16'h0a80: m2YCbCr )	:  ( SW[2]? 16'h0a80: m1YCbCr )	;
assign	mYCbCr		=	m5YCbCr;

assign	Tmp1	=	m4YCbCr[7:0]+mYCbCr_d[7:0];
assign	Tmp2	=	m4YCbCr[15:8]+mYCbCr_d[15:8];
assign	Tmp3	=	Tmp1[8:2]+m3YCbCr[7:1];
assign	Tmp4	=	Tmp2[8:2]+m3YCbCr[15:9];
assign	m5YCbCr	=	{Tmp4,Tmp3};


//	7 segment LUT
SEG7_LUT_6 			u0	(	.oSEG0(HEX0),
							.oSEG1(HEX1),
							.oSEG2(HEX2),
							.oSEG3(HEX3),
							.oSEG4(HEX4),
							.oSEG5(HEX5),
							.iDIG(SW) );
							
//	TV Decoder Stable Check
TD_Detect			u2	(	.oTD_Stable(TD_Stable),
							.oNTSC (NTSC),
							.oPAL  (PAL ),
							.iTD_VS(TD_VS),
							.iTD_HS(TD_HS),
							.iRST_N(KEY[0] & AV_READY	 & HDMI_READY	));

//	Reset Delay Timer
wire DLY0_1 ; 
Reset_Delay			u3	(
                     .iCLK (TD_CLK27 ),//important 
							.iRST (TD_Stable),
							.oRST_0  (DLY0),
							.oRST_0_1(DLY0_1),
							.oRST_1  (DLY1),
							.oRST_2  (DLY2)							
							);
	
//==========RESET sync============
//---DLY0_CLK_SDRAM sync
wire DLY0_CLK_SDRAM;
altera_std_synchronizer #(
    .depth      (3)
) DLY0_CLK_SDRAM_sync (
    .clk        (CLK_SDRAM  ), 
    .reset_n    (1'b1),
    .din        (DLY0), 
    .dout       (DLY0_CLK_SDRAM)
);

//---DLY0_1_CLK_SDRAM sync
wire DLY0_1_TD_CLK27;
altera_std_synchronizer #(
    .depth      (3)
) DLY0_1_TD_CLK27_sync (
    .clk        (TD_CLK27  ), 
    .reset_n    (1'b1),
    .din        (DLY0_1), 
    .dout       (DLY0_1_TD_CLK27)
);

//---DLY0_OUT_CLK sync
wire DLY0_OUT_CLK;
altera_std_synchronizer #(
    .depth      (3)
) DLY0_OUT_CLK_sync (
    .clk        (OUT_CLK ), 
    .reset_n    (1'b1),
    .din        (DLY0), 
    .dout       (DLY0_OUT_CLK)
);

//---DLY1_AUD_CTRL_CLK sync
wire DLY1_AUD_CTRL_CLK;
altera_std_synchronizer #(
    .depth      (3)
) DLY1_AUD_CTRL_CLK_sync (
    .clk        (AUD_CTRL_CLK ), 
    .reset_n    (1'b1),
    .din        (DLY1), 
    .dout       (DLY1_AUD_CTRL_CLK)
);

//---DLY2_OUT_CLK sync
wire DLY2_OUT_CLK;
altera_std_synchronizer #(
    .depth      (3)
) DLY2_OUT_CLK_sync (
    .clk        (OUT_CLK ), 
    .reset_n    (1'b1),
    .din        (DLY2), 
    .dout       (DLY2_OUT_CLK)
);



//	ITU-R 656 to YUV 4:2:2
ITU_656_Decoder		u4	(	//	TV Decoder Input
							.iTD_DATA(TD_DATA),
							//	Position Output
							.oTV_X (TV_X),
							//	YUV 4:2:2 Output
							.oYCbCr(YCbCr),
							.oDVAL (TV_DVAL),
							//	Control Signals
							.iSwap_CbCr(Quotient[0]),
							.iSkip(Remain==4'h0),
							.iRST_N (DLY1     ),
							.iCLK_27(~TD_CLK27)	);

//	For Down Sample 720 to 640
DIV    u5	(	.aclr    (!DLY0),	
							.clock   (TD_CLK27),
							.denom   (4'h9),
							.numer   (TV_X),
							.quotient(Quotient),
							.remain(Remain));
							
//--- VGA out clock assign 
assign OUT_CLK  = VGA_25MHZ ; //25MHz

//---VGA pixel clock and Audio Clock generater  
VGA_Audio u6(
		                .refclk (CLOCK1_50),   
		                .rst    (!CPU_RESET_n),
		                .outclk_0(VGA_25MHZ), 
		                .outclk_1(AUD_CTRL_CLK), 
		                .locked  (AV_PLL_locked)    
);	
		

//	SDRAM frame buffer
wire CLK_SDRAM ; 
wire WR1_CLR  ;

reset_release u_reset_release( .ninit_done(WR1_CLR) );

Sdram_Control_4Port	u7	(	//	HOST Side
                     .CLK     (CLK_SDRAM), 
						   .REF_CLK (CLOCK2_50   ),
						   .RESET_N (DLY0_CLK_SDRAM),
							//	FIFO Write Side 1
						   .WR1_DATA(YCbCr),
							.WR1     (TV_DVAL   ),
							.WR1_FULL(),
							.WR1_ADDR(0),
							.WR1_MAX_ADDR(NTSC ? 640*507 : 640*576),		//	525-18
							.WR1_LENGTH(9'h80),
							.WR1_CLR (!DLY0_1_TD_CLK27),//WR1_CLR
							.WR1_LOAD(!DLY0_CLK_SDRAM),
							.WR1_CLK (TD_CLK27),
							
							//	FIFO Read Side 1
						   .RD1_DATA(m1YCbCr),
				        	.RD1(m1VGA_Read),
							.RD1_ADDR(NTSC ?     640*13 :640*22 ),			//	Read odd field and bypess blanking
							.RD1_MAX_ADDR(NTSC ? 640*253:640*262),   // 21 ~END 262
							.RD1_LENGTH(9'h80),
				        	.RD1_LOAD(!DLY0_CLK_SDRAM),
							.RD1_CLK ( OUT_CLK),
							//	FIFO Read Side 2
						    .RD2_DATA(m2YCbCr),
				        	.RD2(m2VGA_Read),
				        	.RD2_ADDR(NTSC ?     640*267: 640*310),			//	Read even field and bypess blanking
							.RD2_MAX_ADDR(NTSC ? 640*507: 640*550),     //284 ~END 525
							.RD2_LENGTH(9'h80),
				        	.RD2_LOAD(!DLY0_CLK_SDRAM),
							.RD2_CLK(OUT_CLK),
							//	SDRAM Side
						   .SA(DRAM_ADDR),
						   .BA(DRAM_BA),
						   .CS_N(DRAM_CS_n),
						   .CKE(DRAM_CKE),
						   .RAS_N(DRAM_RAS_n),
				         .CAS_N(DRAM_CAS_n),
				         .WE_N(DRAM_WE_n),
						   .DQ(DRAM_DQ),
				         .DQM({DRAM_UDQM,DRAM_LDQM}),
							.SDR_CLK(DRAM_CLK)	);

//---->  OUT SIDE -----> 
//	Line buffer, delay one line
Line_Buffer u8	(	.aclr(!DLY0_OUT_CLK),
					.clken(VGA_Read),
					.clock(OUT_CLK),
					.shiftin(mYCbCr_d),
					.shiftout(m3YCbCr));

Line_Buffer u9	(	.aclr(!DLY0_OUT_CLK),
					.clken(VGA_Read),
					.clock(OUT_CLK),
					.shiftin(m3YCbCr),
					.shiftout(m4YCbCr));


//	YUV 4:2:2 to YUV 4:4:4
YUV422_to_444	u10	(	//	YUV 4:2:2 Input
							.iYCbCr(mYCbCr),
							//	YUV	4:4:4 Output
							.oY(mY),
							.oCb(mCb),
							.oCr(mCr),
							//	Control Signals
							.iX(VGA_X-160),
							.iCLK  (OUT_CLK),
							.iRST_N(DLY0_OUT_CLK));

//	YCbCr 8-bit to RGB-10 bit 
YCbCr2RGB 			u11	(	//	Output Side
							.Red(mRed),
							.Green(mGreen),
							.Blue(mBlue),
							.oDVAL(mDVAL),
							//	Input Side
							.iY(mY),
							.iCb(mCb),
							.iCr(mCr),
							.iDVAL(VGA_Read),
							//	Control Signal
							.iRESET(!DLY2_OUT_CLK),
							.iCLK(OUT_CLK));

																

//----VGA Controller
VGA_Ctrl		u12	(	//	Host Side
						.iRed      (mRed  [9:2]),
						.iGreen    (mGreen[9:2]),
						.iBlue     (mBlue [9:2]),
						.oCurrent_X(VGA_X),
						.oCurrent_Y(VGA_Y),
						.oRequest  (VGA_Read),
						//	VGA Side
						.oVGA_R    (HDMI_TX_D[23:16] ),
						.oVGA_G    (HDMI_TX_D[15:8]  ),
						.oVGA_B    (HDMI_TX_D[7:0]  ),
						.oVGA_HS   (HDMI_TX_HS ),
						.oVGA_VS   (HDMI_TX_VS ),
						.oVGA_DE   (HDMI_TX_DE ),
						.oVGA_CLOCK(HDMI_TX_CLK),//25MHz
						//	Control Signal
						.iCLK      (OUT_CLK  ),//25MHz
						.iRST_N    (DLY2_OUT_CLK)	
						);

										
//---Audio Master L/RCLK , BCK ,DATA  generater 

AUDIO_DAC 	u13	(	//	Audio Side
					.oAUD_BCK       (AUD_BCLK        ),
					.oAUD_DATA      (DAC_DACDAT      ),
					.oAUD_LRCK      (AUD_DACLRCK     ),
					//	Control Signals
					.iSrc_Select    (2'b00       ),
			      .iCLK_18_4      (AUD_CTRL_CLK),//12.288000MHz
					.iRST_N         (DLY1_AUD_CTRL_CLK    )
					);
										
							
// AV sound passthrough out : SW0=0,CODEC ADC passthrough to CODEC DAC; SW0=1 ,1Khz sine-tone output to Codec DAC
assign AUD_DACDAT = (!SW[0])?AUD_ADCDAT:DAC_DACDAT;					

// HDMI sound passthrough out : SW0=0,CODEC ADC passthrough to HDMI; SW0=1 ,1Khz sine-tone output to HDMI
assign HDMI_I2S   = (!SW[0])?AUD_ADCDAT:DAC_DACDAT;					
assign HDMI_SCLK  = AUD_BCLK     ;
assign HDMI_LRCLK = AUD_DACLRCK  ;	

//	I2C bus for Audio CODEC and video decoder Setting
I2C_AV_Config 	u14	(	//	Host Side
						.iCLK    (CLOCK0_50     ),
						.iRST_N  (KEY[0]        ),
						//	I2C Side
						.I2C_SCLK(AV_I2C_SCLK   ),
						.I2C_SDAT(FPGA_I2C_SDAT ),
						.READY   (AV_READY      )											
						);	 
						


//--HDMI/AV I2C SCLK sel 
assign FPGA_I2C_SCLK	= ( AV_READY==0)? AV_I2C_SCLK	:  HDMI_I2C_SCLK;
								
//HDMI I2C BUS  Setting	
I2C_HDMI_Config u15(
	.iCLK       (CLOCK0_50      ),
	.iRST_N     (AV_READY      ),//when I2C_AV_Config ready ---> Start to I2C_HDMI_Config work
	.I2C_SCLK   (HDMI_I2C_SCLK ),
	.I2C_SDAT   (FPGA_I2C_SDAT ),
	.HDMI_TX_INT(HDMI_TX_INT   ),
	.READY      (HDMI_READY    ) 	
	);						



endmodule
