
namespace eval csi2_dphy_sys_mipi_dphy {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries dphy_arch_fp_600        1
    dict set libraries mipi_dphy_600           1
    dict set libraries csi2_dphy_sys_mipi_dphy 1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pkg.sv"]\"  -work dphy_arch_fp_600"                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_regpkg.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_io_if.sv"]\"  -work dphy_arch_fp_600"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_reg_if.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/ppi_if.sv"]\"  -work dphy_arch_fp_600"                                          
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/altera_std_synchronizer_nocut.v"]\"  -work dphy_arch_fp_600"               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_axil_target.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_clk_rst_blk_modified.sv"]\"  -work dphy_arch_fp_600"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_core_modified.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_cp_map.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_full_byte_hipi_intf.sv"]\"  -work dphy_arch_fp_600"                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_full_byte_wrap_modified.sv"]\"  -work dphy_arch_fp_600"                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs.sv"]\"  -work dphy_arch_fp_600"                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_cal_rx.sv"]\"  -work dphy_arch_fp_600"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_cal_skew_rx.sv"]\"  -work dphy_arch_fp_600"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_clk_rx.sv"]\"  -work dphy_arch_fp_600"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_clk_timing_rx.sv"]\"  -work dphy_arch_fp_600"                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_clk_tx.sv"]\"  -work dphy_arch_fp_600"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_data_mux_tx.sv"]\"  -work dphy_arch_fp_600"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_data_rx.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_data_timing_rx.sv"]\"  -work dphy_arch_fp_600"                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_data_tx.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_esc_rx.sv"]\"  -work dphy_arch_fp_600"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_esc_tx.sv"]\"  -work dphy_arch_fp_600"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_rx.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_timing_tx.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_pcs_tx.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_prbs9.sv"]\"  -work dphy_arch_fp_600"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_regfile.sv"]\"  -work dphy_arch_fp_600"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_regfile_top.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_syncpat.sv"]\"  -work dphy_arch_fp_600"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_timer.sv"]\"  -work dphy_arch_fp_600"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dphy_top_modified.sv"]\"  -work dphy_arch_fp_600"                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/hyperpipe.sv"]\"  -work dphy_arch_fp_600"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/toggle_synchronizer.sv"]\"  -work dphy_arch_fp_600"                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/toggle_synchronizer_2.sv"]\"  -work dphy_arch_fp_600"                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/byte_control_wrap_modified.sv"]\"  -work dphy_arch_fp_600"                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/byte_wrap_modified.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/cpa_wrap.sv"]\"  -work dphy_arch_fp_600"                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/fa_c2p_lane_wrap.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/fa_p2c_lane_wrap.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/ibuf_diff_wrap.sv"]\"  -work dphy_arch_fp_600"                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/ibuf_wrap.sv"]\"  -work dphy_arch_fp_600"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/iopll_wrap.sv"]\"  -work dphy_arch_fp_600"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/obuf_wrap.sv"]\"  -work dphy_arch_fp_600"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/phy_adaptor_wrap.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/csi2_dphy_sys_mipi_dphy_dphy_arch_fp_600_ibwjvsq.sv"]\"  -work dphy_arch_fp_600"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/byte_control_std_fn.sv"]\"  -work dphy_arch_fp_600"                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/byte_rxfifo.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/byte_std_fn.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/cpa_std_fn.sv"]\"  -work dphy_arch_fp_600"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/dll_bhv.sv"]\"  -work dphy_arch_fp_600"                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/fa_c2p_lane_std_fn.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/fa_p2c_lane_std_fn.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/ibuf_diff_std_fn.sv"]\"  -work dphy_arch_fp_600"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/ibuf_std_fn.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/iopll_std_fn.sv"]\"  -work dphy_arch_fp_600"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/obuf_std_fn.sv"]\"  -work dphy_arch_fp_600"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../dphy_arch_fp_600/sim/phy_adaptor_std_fn.sv"]\"  -work dphy_arch_fp_600"                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../mipi_dphy_600/sim/csi2_dphy_sys_mipi_dphy_mipi_dphy_600_iuqoxja.v"]\"  -work mipi_dphy_600"                                                                           
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/csi2_dphy_sys_mipi_dphy.v"]\"  -work csi2_dphy_sys_mipi_dphy"                                                                                                            
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
