// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module toggle_synchronizer_2 (
    clk_src,
    clk_dst,
    reset_n_src,
    reset_n_dst,
    in_pulse,
    out_pulse
    
    );

    parameter depth = 3;        
    parameter rst_value = 0;    
        
    input   clk_src;
    input   clk_dst;
    input   reset_n_src;
    input   reset_n_dst;        
    input   in_pulse;
    output  out_pulse;

    logic in_level;
    logic in_level_ack;
    logic out_level;
    logic out_level_q;
    logic out_pulse;
    
    always @(posedge clk_src or negedge reset_n_src)
        if(reset_n_src == 1'b0)
            in_level <= 1'b0;
        else
            in_level <= ( ~(in_level ^ in_level_ack) & in_pulse ) ^ in_level;

    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync_ack (.clk(clk_src), .reset_n(reset_n_src), .din(out_level), .dout(in_level_ack));   
    altera_std_synchronizer_nocut#(.depth(3), .rst_value(rst_value)) cdc_sync (.clk(clk_dst), .reset_n(reset_n_dst), .din(in_level), .dout(out_level));
    
    always @(posedge clk_dst)
        out_level_q <= out_level;

    assign out_pulse = out_level_q ^ out_level;
   
 endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61R4ZVb1VuLHJnQFv1kCNSM9x5pTgu1zInV6mvIKHoxaUZQU+5ck3ehuxKcu1YFRL5UVFyZMipuPFj562utZE6iCTpre5W4/2Dxf1Qm4d7K9E1GoB4HjnPFMBN30Shydy/wA+ebdIRBbYj00dpuu5nAUlYoqFXWhh1g6j8wuEcJAMvKD4lP4Fu5wKSCJD9HdrvP/4oQvnPHyHghnoqy+pihtOmmddzGeuj7imkGUi+9G1IvpL4ZNzg7bA+uhBNqSXANJBfZvOwpQChY3JLWO9qab7onSq2jtiq0Gt6ONfPwVNP8wZQCwT5xeSK02d2U+CCZn4iLiJSrYKU51RlG2XuEOm5E+QpQQ/+I+JFSeM3/sAuuqurGRAj7wWllapElE4LFjwuejcRO9ms86WQgHJWw3jHSnTLNOBZr1ujcOA86qbQNUPWbCVg45pJi/rsOGZNdncZ6JhwgDgCmkK2aDfS+9Fg0ZVpKLn5lvnlzuLGz667gPfNqtnxCQTwPkwGLtTsW2XII0zMgdBwXXCsUw2Ed5iI64JIlUurdE8WVLRt/n6atMYg4Yi0pxi4j4OBQklYcdLEMtm1MsDK4xaMitbqTNC5AuAuYoBdB5jeJ/8ywrRszaksipsp6UhgIRI3YU2gauoFKqzDfCUbh/hRpcViuWmcfF4pWmnRq0iKwRQKIAq1i1BADJH2JoYx+a7d7yerV+g9bvEmLk28dpPsibpR3uf1a9PHhl2VhaJJkF7tdUIoa6BmK//H4upAlwQiOQ9gbP6TYyfgW1q8f2alPz02VK"
`endif