// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




import dphy_pkg::*;

module dphy_phy_adaptor_bhv #(
    parameter base_address = 9'h0,
    parameter controller = "CONTROLLER_SOFT",
    parameter ddr_lane_mode = "DDR_LANE_MODE_DQ",
    parameter pin0_swizzle = "PIN0_SWIZZLE_DQ0", 
    parameter pin1_swizzle = "PIN1_SWIZZLE_DQ1", 
    parameter pin2_swizzle = "PIN2_SWIZZLE_DQ2", 
    parameter pin3_swizzle = "PIN3_SWIZZLE_DQ3", 
    parameter pin8_swizzle = "PIN8_SWIZZLE_DQ4", 
    parameter pin9_swizzle = "PIN9_SWIZZLE_DQ5", 
    parameter pin10_swizzle = "PIN10_SWIZZLE_DQ6",
    parameter pin11_swizzle = "PIN11_SWIZZLE_DQ7",

    parameter mipi_func = "MIPI_FUNC_OFF",
    parameter rate_conv = "RATE_CONV_OFF"
) ( 
    input  wire  [11:0]    i_alert_gpio_din,               
    input  wire  [4:0]     i_fa2pa_gpio_dout_sel,          
    input  wire  [3:0]     i_fa2pa_rd_rank,                
    input  wire  [3:0]     i_fa2pa_rddata_en,              
    input  wire  [3:0]     i_fa2pa_wr_dqs_en,              
    input  wire  [3:0]     i_fa2pa_wr_rank,                
    input  wire  [95:0]    i_fa2pa_wrdata,                 
    input  wire  [3:0]     i_fa2pa_wrdata_en,              
    input  wire  [7:0]     i_hmc2pa_rd_rank,               
    input  wire  [3:0]     i_hmc2pa_rddata_en,             
    input  wire  [3:0]     i_hmc2pa_wr_dqs0_en,             
    input  wire  [3:0]     i_hmc2pa_wr_dqs1_en,             
    input  wire  [7:0]     i_hmc2pa_wr_rank,               
    input  wire  [95:0]    i_hmc2pa_wrdata,                
    input  wire  [3:0]     i_hmc2pa_wrdata_en,             
    input  wire            i_phy_clk_hr,                   
    input  wire  [47:0]    i_phy2pa_rddata,                
    input  wire  [1:0]     i_phy2pa_rddata_valid,          
    input  wire            i_phyclk_sync,                  
    input  wire            i_rxfwd_clk,                    
    input  wire  [7:0]     i_seq2pa_rd_rank,               
    input  wire  [3:0]     i_seq2pa_rddata_en,             
    input  wire            i_seq2pa_seq_en,                
    input  wire  [11:0]    i_seq2pa_suppression,           
    input  wire  [3:0]     i_seq2pa_wr_dqs_en,             
    input  wire  [7:0]     i_seq2pa_wr_rank,               
    input  wire  [95:0]    i_seq2pa_wrdata,                
    input  wire  [3:0]     i_seq2pa_wrdata_en,             
    output logic [95:0]    o_pa2fa_rddata,                 
    output logic [3:0]     o_pa2fa_rddata_valid,           
    output logic [95:0]    o_pa2hmc_rddata,                
    output logic [3:0]     o_pa2hmc_rddata_valid,          
    output logic [11:0]    o_pa2phy_gpio_dout_sel,         
    output logic [3:0]     o_pa2phy_rd_rank,               
    output logic [1:0]     o_pa2phy_rddata_en,             
    output logic [11:0]    o_pa2phy_suppression,           
    output logic [1:0]     o_pa2phy_wr_dqs0_en,             
    output logic [1:0]     o_pa2phy_wr_dqs1_en,             
    output logic           o_pa2phy_dram_clock_disable,
    input  logic           i_ctr2pa_dram_clock_disable,

    output logic [3:0]     o_pa2phy_wr_rank,               
    output logic [47:0]    o_pa2phy_wrdata,                
    output logic [1:0]     o_pa2phy_wrdata_en,             
    output logic           o_rxfwd_clk,                    
    output logic           o_rb_pa2seq_ddr_lane_mode,      
    output logic           o_rb_pa2seq_if_sel,             
    output logic           o_rb_pa2seq_phy_clk_en,         
    output logic           o_rb_pa2seq_rate_conv_en,       
    output logic [10:0]    o_rb_pa2seq_seq_base_addr,      
    input  wire  [9:0]     i_fa2pa_mipi_lp_dout,           
    output logic [9:0]     o_mipi_lp_dout,                 
    output logic           o_pa2phy_rxanalogen,
    output logic           o_pa2phy_txanalogen,
    input  wire            i_hmc2pa_rxanalogen,
    input  wire            i_hmc2pa_txanalogen
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif




    localparam NUM_LANES =  mipi_func == "MIPI_FUNC_OFF" ? 0 : 
                            mipi_func == "MIPI_FUNC_D1" ? 1 :
                            mipi_func == "MIPI_FUNC_D2" ? 2 :
                            4;
    localparam CLK_LANE_ON = mipi_func == "MIPI_FUNC_D1" || mipi_func == "MIPI_FUNC_D2" || mipi_func == "MIPI_FUNC_D4CK";
    logic phy_clk_div;
    logic phy_clk_div_mux;
    logic phy_clk_div_n;
    logic fwd_clk_div;
    logic clk;
    int i;
    int j;
    
    logic phy_clk_sync;
    logic [2:0] sync_q;

    always @(negedge i_phy_clk_hr)
    begin
        sync_q <= { sync_q [1:0] , i_phyclk_sync };
        phy_clk_sync <= ~sync_q[2] & sync_q[1];
    end


    
    logic  [95:0]  pa2fa_rddata;   
    logic  [47:0]  pa2phy_wrdata;

    buf #(0.1) buf_rddata[95:0] (o_pa2fa_rddata, pa2fa_rddata);
    buf #(0.1) buf_wrdata[47:0] (o_pa2phy_wrdata, pa2phy_wrdata);
    
    assign o_mipi_lp_dout[1:0] = NUM_LANES > 0 ? i_fa2pa_mipi_lp_dout[1:0] : 'h0;
    assign o_mipi_lp_dout[3:2] = NUM_LANES > 1 ? i_fa2pa_mipi_lp_dout[3:2] : 'h0;
    assign o_mipi_lp_dout[5:4] = CLK_LANE_ON ? i_fa2pa_mipi_lp_dout[5:4] : 'h0;
    assign o_mipi_lp_dout[9:6] = NUM_LANES > 2 ? i_fa2pa_mipi_lp_dout[9:6] : 'h0;

    assign o_pa2phy_gpio_dout_sel[1:0] = NUM_LANES > 0 ? { 2 { i_fa2pa_gpio_dout_sel[0] } } : 2'h0;
    assign o_pa2phy_gpio_dout_sel[3:2] = NUM_LANES > 1 ? { 2 { i_fa2pa_gpio_dout_sel[1] } } : 2'h0;
    assign o_pa2phy_gpio_dout_sel[5:4] = CLK_LANE_ON ? { 2 { i_fa2pa_gpio_dout_sel[2] } } : 2'h0;
    assign o_pa2phy_gpio_dout_sel[7:6] = NUM_LANES > 2 ? { 2 { i_fa2pa_gpio_dout_sel[3] } } : 2'h0;
    assign o_pa2phy_gpio_dout_sel[9:8] = NUM_LANES > 2 ? { 2 { i_fa2pa_gpio_dout_sel[4] } } : 2'h0;
    assign o_pa2phy_gpio_dout_sel[11:10] = 2'b00;


    
    logic phy_clk_hr_d;
    logic rxfwd_clk_d;
    assign phy_clk_hr_d = i_phy_clk_hr;
    assign rxfwd_clk_d = i_rxfwd_clk;

    assign clk_1x = mipi_func == "MIPI_FUNC_OFF" ? phy_clk_hr_d : rxfwd_clk_d;
    assign clk_hr = mipi_func == "MIPI_FUNC_OFF" ? ~phy_clk_div : fwd_clk_div;
    assign clk = rate_conv == "RATE_CONV_OFF" ? clk_1x : clk_hr;
    
    initial
    begin
        fwd_clk_div <= 1'b0;
    end
    always @(posedge i_rxfwd_clk)
        fwd_clk_div <= ~fwd_clk_div;

    always @(posedge i_phy_clk_hr)
    begin 
        if(phy_clk_sync)
            phy_clk_div <= 'h0;
        else
            phy_clk_div <= phy_clk_div + 1'b1;
    end    
    assign phy_clk_div_mux = phy_clk_div;
        
    assign o_rxfwd_clk = mipi_func == "MIPI_FUNC_OFF" ? 1'b0 : clk;

    if(rate_conv == "RATE_CONV_QR_HR_CONV_EN")
    begin :  pa_rate_conv

        always @(posedge clk)
        begin
            o_pa2fa_rddata_valid[1:0] <=  i_phy2pa_rddata_valid[1:0];
            for(i=0; i<4; i++)
            begin
                j = i>1 ? i+1 : i;
                if(i==0 || (i==1 && NUM_LANES>1) || (i>1 && NUM_LANES>2))
                begin
                    pa2fa_rddata[j*16 +: 4]   <= i_phy2pa_rddata[j*8 +: 4] ;
                    pa2fa_rddata[j*16+8 +: 4]  <= i_phy2pa_rddata[j*8+4 +: 4];
                end
                else
                begin
                    pa2fa_rddata[j*16 +: 4]   <= 'h0 ;
                    pa2fa_rddata[j*16+8 +: 4]  <= 'h0;
                end
            end
        end

        always @(negedge clk)
        begin
            o_pa2fa_rddata_valid[3:2] <=  i_phy2pa_rddata_valid[1:0];
            for(i=0; i<4; i++)
            begin
                j = i>1 ? i+1 : i;
                if(i==0 || (i==1 && NUM_LANES>1) || (i>1 && NUM_LANES>2))
                begin
                    pa2fa_rddata[j*16+4 +: 4] <= i_phy2pa_rddata[j*8 +: 4];
                    pa2fa_rddata[j*16+12 +: 4]  <= i_phy2pa_rddata[j*8+4 +: 4];
                end
                else
                begin
                    pa2fa_rddata[j*16+4 +: 4]   <= 'h0 ;
                    pa2fa_rddata[j*16+12 +: 4]  <= 'h0;
                end
            end
        end
    end
    else
    begin : pa_no_rate_conv
        always @(posedge clk)
        begin
            o_pa2fa_rddata_valid[1:0] <=  i_phy2pa_rddata_valid[1:0];
            o_pa2fa_rddata_valid[3:2] <=  'h0;
            for(i=0; i<4; i++)
            begin
                j = i>1 ? i+1 : i;
                pa2fa_rddata[j*16+4 +: 4] <= 'h0;
                pa2fa_rddata[j*16+12 +: 4] <= 'h0;
                if(i==0 || (i==1 && NUM_LANES>1) || (i>1 && NUM_LANES>2))
                begin
                    pa2fa_rddata[j*16 +: 4]   <= i_phy2pa_rddata[j*8 +: 4];
                    pa2fa_rddata[j*16+8 +: 4]  <= i_phy2pa_rddata[j*8+4 +: 4];
                end
                else
                begin
                    pa2fa_rddata[j*16 +: 4]   <= 'h0;
                    pa2fa_rddata[j*16+8 +: 4]  <= 'h0;             
                end
            end
        end
    end
        
    always @(posedge phy_clk_hr_d)
    begin
        o_pa2phy_rddata_en[1:0] = rate_conv == "RATE_CONV_OFF" || phy_clk_div_mux == 1'b0 ? i_fa2pa_rddata_en[1:0] : i_fa2pa_rddata_en[3:2];
        o_pa2phy_wrdata_en[1:0] = 2'b11;
    end

    always @(posedge phy_clk_hr_d)
    begin
        for(i=0; i<4; i++)
        begin
            j = i>1 ? i+1 : i;
            if(i==0 || (i==1 && NUM_LANES>1) || (i>1 && NUM_LANES>2))
            begin
                if(rate_conv == "RATE_CONV_QR_HR_CONV_EN")
                begin
                    pa2phy_wrdata[j*8 +: 4] <= phy_clk_div_mux == 1'b0 ? i_fa2pa_wrdata [j*16 +: 4] : i_fa2pa_wrdata [j*16+4 +: 4];
                    pa2phy_wrdata[j*8+4 +: 4] <= phy_clk_div_mux == 1'b0 ? i_fa2pa_wrdata [j*16+8 +: 4] : i_fa2pa_wrdata [j*16+12 +: 4];
                end
                else
                begin
                    pa2phy_wrdata[j*8 +: 4] <= i_fa2pa_wrdata [j*16 +: 4];
                    pa2phy_wrdata[j*8+4 +: 4] <= i_fa2pa_wrdata [j*16+8 +: 4];
                end
            end
            else
            begin
                pa2phy_wrdata[j*8 +: 8] <= 'h0;
            end
        end
    end

    always @(posedge phy_clk_hr_d)
    begin
        j = 2;
        if(rate_conv == "RATE_CONV_QR_HR_CONV_EN")
        begin
            pa2phy_wrdata[j*8 +: 4] <= phy_clk_div_mux == 1'b0 ? i_fa2pa_wrdata [j*16 +: 4] : i_fa2pa_wrdata [j*16+4 +: 4];
            pa2phy_wrdata[j*8+4 +: 4] <= phy_clk_div_mux == 1'b0 ? i_fa2pa_wrdata [j*16+8 +: 4] : i_fa2pa_wrdata [j*16+12 +: 4];
        end
        else
        begin
            pa2phy_wrdata[j*8 +: 4] <= i_fa2pa_wrdata [j*16 +: 4];
            pa2phy_wrdata[j*8+4 +: 4] <= i_fa2pa_wrdata [j*16+8 +: 4];
        end
    end

    
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61S8nFoAkEA5mmw5ZBIHNt84GkZljG/7oZ7TzOOUsjFQzHJtQljMaW8LQ6vBsMv5Osz70hYPsZrapW3Bxn9KQnnBQB5W7DH8Z1KzUDfO7q0A4epJKAoL8QpU4sUvSch/0699sCQ5J5MCQif1hzWqYYUDek96+OSN6uxCPpfjcvQGQ7GmT3zg7hQ211tWcW9E/fetADSs1oFw1t9iobLj97DMa6FXqBVpXojh0GIBJ6XHgx9TmM+WgRYM2QDwGN3Rr4Y5YLhb4QJkBUORbHQ/4YBX9MKBtpyE7i8PHvulrGNbB2TxrLHURlAoSEc6VIsbFXXL7uSQt+iciP2W143CaPphaMcHiIM4FqmLbYxouiDHFCsN/RHW9VT/ypam4E1Itn0uuklImLSp6lLIjzDUFjexGp8TslW+TbMtyEzn+CZflDp5l7tkAbvOQfLhYvurJdSLPLAD+XtoxBZMTW5ml2z7rjOFjyHjUkjDYyJ0dvpDZCIik+zOHz4XURVJBdy1xq5/uraGrGrUNoaY1zkWe3i5lx4q/z2ff2rUXVlfmhcv/DoN2cBcTjSeQryOZ89CRCh6Bv6YHgNBRQpHBkHFhcEaEUc6Ytp4KY4eRitkSUOvNxaX6HSIs/3E1xiZWGZUKE0UShFeqzVtyvTjnbp07fdaid3Vcl7cJP0nesbf1ScJdv3Uil0pvmdT2QIROJXRR1+Hxt5gb9qu05C6ORhf6+lA1yQnamG0XRMdiLST1jBqBNRlIbAXFGbW+pBx+AemAINqSbdg3xUoctz6osMxzh2x"
`endif