// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




import dphy_pkg::*;
module dphy_iopll_bhv #(
    parameter bandwidth_mode = "AUTO",
    parameter base_address = 16'd0,
    parameter cascade_mode = "STANDALONE",
    parameter clk_switch_auto_en = "False",
    parameter clk_switch_manual_en = "False",
    parameter compensation_clk_source = "UNUSED",
    parameter compensation_mode = "DIRECT",
    parameter family = "FP",
    parameter fb_clk_delay = 32'd00,
    parameter fb_clk_fractional_div_den = 32'd0,
    parameter fb_clk_fractional_div_num = 32'd0,
    parameter fb_clk_fractional_div_value = 32'd0,
    parameter fb_clk_m_div = 9'd4,
    parameter internal_base_address = 16'd0,
    parameter out_clk_0_c_div = 8'd2,
    parameter out_clk_0_core_en = "False",
    parameter out_clk_0_delay = 32'd00,
    parameter out_clk_0_dutycycle_den = 32'd02,
    parameter out_clk_0_dutycycle_num = 32'd01,
    parameter out_clk_0_dutycycle_percent = 32'd50,
    parameter out_clk_0_freq = 36'd1000000000,
    parameter out_clk_0_phase_ps = 32'd0,
    parameter out_clk_0_phase_shifts = 32'd0,
    parameter out_clk_1_c_div = 8'd2,
    parameter out_clk_1_core_en = "False",
    parameter out_clk_1_delay = 32'd00,
    parameter out_clk_1_dutycycle_den = 32'd02,
    parameter out_clk_1_dutycycle_num = 32'd01,
    parameter out_clk_1_dutycycle_percent = 32'd50,
    parameter out_clk_1_freq = 36'd1000000000,
    parameter out_clk_1_phase_ps = 32'd0,
    parameter out_clk_1_phase_shifts = 32'd0,
    parameter out_clk_2_c_div = 8'd2,
    parameter out_clk_2_core_en = "False",
    parameter out_clk_2_delay = 32'd00,
    parameter out_clk_2_dutycycle_den = 32'd02,
    parameter out_clk_2_dutycycle_num = 32'd01,
    parameter out_clk_2_dutycycle_percent = 32'd50,
    parameter out_clk_2_freq = 36'd1000000000,
    parameter out_clk_2_phase_ps = 32'd0,
    parameter out_clk_2_phase_shifts = 32'd0,
    parameter out_clk_3_c_div = 8'd2,
    parameter out_clk_3_core_en = "False",
    parameter out_clk_3_delay = 32'd00,
    parameter out_clk_3_dutycycle_den = 32'd02,
    parameter out_clk_3_dutycycle_num = 32'd01,
    parameter out_clk_3_dutycycle_percent = 32'd50,
    parameter out_clk_3_freq = 36'd1000000000,
    parameter out_clk_3_phase_ps = 32'd0,
    parameter out_clk_3_phase_shifts = 32'd0,
    parameter out_clk_4_c_div = 8'd2,
    parameter out_clk_4_core_en = "False",
    parameter out_clk_4_delay = 32'd00,
    parameter out_clk_4_dutycycle_den = 32'd02,
    parameter out_clk_4_dutycycle_num = 32'd01,
    parameter out_clk_4_dutycycle_percent = 32'd50,
    parameter out_clk_4_freq = 36'd1000000000,
    parameter out_clk_4_phase_ps = 32'd0,
    parameter out_clk_4_phase_shifts = 32'd0,
    parameter out_clk_5_c_div = 8'd2,
    parameter out_clk_5_core_en = "False",
    parameter out_clk_5_delay = 32'd00,
    parameter out_clk_5_dutycycle_den = 32'd02,
    parameter out_clk_5_dutycycle_num = 32'd01,
    parameter out_clk_5_dutycycle_percent = 32'd50,
    parameter out_clk_5_freq = 36'd1000000000,
    parameter out_clk_5_phase_ps = 32'd0,
    parameter out_clk_5_phase_shifts = 32'd0,
    parameter out_clk_6_c_div = 8'd2,
    parameter out_clk_6_core_en = "False",
    parameter out_clk_6_delay = 32'd00,
    parameter out_clk_6_dutycycle_den = 32'd02,
    parameter out_clk_6_dutycycle_num = 32'd01,
    parameter out_clk_6_dutycycle_percent = 32'd50,
    parameter out_clk_6_freq = 36'd1000000000,
    parameter out_clk_6_phase_ps = 32'd0,
    parameter out_clk_6_phase_shifts = 32'd0,
    parameter out_clk_cascading_source = "UNUSED",
    parameter out_clk_external_0_source = "UNUSED",
    parameter out_clk_external_1_source = "UNUSED",
    parameter out_clk_periph_0_delay = 32'd00,
    parameter out_clk_periph_0_en = "False",
    parameter out_clk_periph_1_delay = 32'd00,
    parameter out_clk_periph_1_en = "False",
    parameter pfd_clk_freq = 32'd100000000,
    parameter protocol_mode = "BASIC",
    parameter ref_clk_0_freq = 32'd100000000,
    parameter ref_clk_1_freq = 32'd100000000,
    parameter ref_clk_delay = 32'd00,
    parameter ref_clk_n_div = 8'd1,
    parameter self_reset_en = "False",
    parameter set_dutycycle = "FRACTION",
    parameter set_fractional = "FRACTION",
    parameter set_freq = "DIVISION",
    parameter set_phase = "NUM_SHIFTS",
    parameter speed_grade = "SPEEDGRADE2",
    parameter vco_clk_freq = 36'd1000000000
) ( 
    input  wire            reset,                          
    input  wire            permit_cal,                     
    output logic           lock,                           
    input  wire            ref_clk0,                       
    input  wire            ref_clk1,                       
    input  wire            ref_clk_switch_n,               
    output logic [1:0]     ref_clk_bad,                    
    output logic           ref_clk_active,                 
    input  wire            fb_clk_in,                      
    input  wire            fb_clk_in_lvds,                 
    output logic [6:0]     out_clk,                        
    output logic           out_clk_external0,              
    output logic           out_clk_external1,              
    output logic           out_clk_periph0,                
    output logic           out_clk_periph1,                
    output logic           out_clk_cascade,                
    output logic           fb_clk_out,                     
    output logic [7:0]     vco_clk,                        
    output logic           vco_clk_periph,                 
    input  wire            core_avl_clk,                   
    input  wire            core_avl_write,                 
    input  wire            core_avl_read,                  
    input  wire  [8:0]     core_avl_address,               
    input  wire  [7:0]     core_avl_writedata,             
    output logic [7:0]     core_avl_readdata,              
    input  wire            cal_bus_rst_n,                  
    input  wire            cal_bus_clk,                    
    input  wire            cal_bus_write,                  
    input  wire            cal_bus_read,                   
    input  wire  [21:0]    cal_bus_address,                
    input  wire  [31:0]    cal_bus_writedata,              
    output logic [31:0]    cal_bus_readdata,               
    input  wire  [2:0]     dps_num_phase_shifts,           
    input  wire  [3:0]     dps_cnt_sel,                    
    input  wire            dps_phase_en,                   
    input  wire            dps_up_dn,                      
    output logic           dps_phase_done                  
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif






    `ifdef def_PLL_PPM
        localparam PLL_PPM = `def_PLL_PPM ;
    `else
        localparam PLL_PPM = 0 ;
    `endif
    
    `ifdef def_LOCKTIME
        localparam LOCKTIME = `def_LOCKTIME ;
    `else
        localparam LOCKTIME = 250;
    `endif


    logic phy_clk_int;
    logic [8:0] sync_cnt;
    logic por;
    logic reset_int;
    logic sync_clk_int;
    
    logic vco_clk_int;
    shortreal vco_hper;
    shortreal vco_hper_exp = 1000000000.0 / (2*vco_clk_freq);
    localparam VCO_MUL = vco_clk_freq / ref_clk_0_freq;
    int i;
    logic [2:0] lock_q;
    logic lock_int;
    genvar x;
    
    initial
    begin
        por <= 1'b1;
        #10 por <= 1'b0;
    end
    
    assign reset_int = por | reset;
    
    dll_bhv #(
        .num_phases(2*VCO_MUL),
        .mdll(1),
        .gen_clk(0),
        .dll_lock(0)
    ) ref_clk_hper_meas (
        .lock_in(1'b1),                                 
        .clk_in(ref_clk0),                              
        .lock_out(),                                    
        .clk_out(),                                     
        .ph_step_in(),                                  
        .ph_step(vco_hper)                              
    );
    
    assign vco_clk_periph = (lock & ~reset_int) == 1'b1 ?  vco_clk_int : 1'b0;
    assign out_clk_periph0 = phy_clk_int;
    assign out_clk_periph1 = sync_clk_int;
    assign vco_clk[0] = vco_clk_periph;
    for(x=1; x<8; x++)
        assign #(vco_hper/4) vco_clk[x] = vco_clk[x-1];
    
    initial
    begin
        vco_clk_int <= 1'b0;
        lock_q <= 3'h0;
        lock_int <= 1'b0;
    end

    always @(posedge ref_clk0)
    begin
        for(i=0; i<2*VCO_MUL; i++)
            vco_clk_int <= #(i*vco_hper) ~i[0];
    end
    
    assign lock = lock_q[2];

    always @(posedge reset_int or posedge vco_clk_int)
    begin
        if(reset_int == 1'b1)         lock_q <= 3'h0;
        else                          lock_q <= {lock_q[1:0], lock_int};
    end

    always @(posedge reset_int or posedge ref_clk0)
    begin
        if(reset_int == 1'b1)         lock_int <= 1'b0;
        else                          lock_int <= #LOCKTIME 1'b1;
    end
    
    always @(posedge reset_int or posedge vco_clk_periph)
    begin
        if((~lock | reset_int) == 1'b1)       sync_cnt <= 1'b0;
        else                        sync_cnt <= sync_cnt + 1'b1;
    end
    assign phy_clk_int = ~sync_cnt[0];
    assign sync_clk_int =   out_clk_1_c_div == 2    ? ~sync_cnt[0] :
                            out_clk_1_c_div == 4    ? ~sync_cnt[1] :
                            out_clk_1_c_div == 8    ? ~sync_cnt[2] :
                            out_clk_1_c_div == 16   ? ~sync_cnt[3] :
                            out_clk_1_c_div == 32   ? ~sync_cnt[4] :
                            out_clk_1_c_div == 64   ? ~sync_cnt[5] :
                            out_clk_1_c_div == 128  ? ~sync_cnt[6] :
                            out_clk_1_c_div == 256  ? ~sync_cnt[7] :
                            out_clk_1_c_div == 512  ? ~sync_cnt[8] : 1'bx;
    
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61S+Lknm36VE2oCQOARARMl8+ZoHVAknUhUbU0aCxCvhqbk/B867zDVPkG1MgKLKDPwn8TofrxuAHFQEUgEwgd8C7UgIZhkIE+OpFJNwWd6Tr+p78HYMWlseCNWMrnifegwljx93ta2oeZg+ziynZyEqM90SYYIPbDxsCd8SdHjJp9uKOw/i3wZYFubk0x3EWq9YN50wOmx0NfdShv51z+kaR/LqREVTIcWqielUmPNshhsVKe6oMHMe04TTXrV2nAtpwI83gqEHrg8PwLDH6RB+NtwhDd5DXh00zHi1T7hrEJPClrUUGQuLDuZz3mELMQgd9nsx7gUjdvbrj4HXPeSZ4V3WQ5ci+Z9x5O/Fjt9TV3jc3C2sHQrTxy9t8bVIpY9N3ez/UVK3J5JBlbwasokOMreEr8Tz47HgyyXzQDwtWmgEgoHfkxh5kaJgT8IixSsSy9ybqdBfkWC4cptii2Bp1IcdLL8cnPpZs6q05MHIAnSwPC2JPlxz/D7Vy66DUfMiRUFYH9X9yZ6w8vZNHb5o/iqZOENRK8Mnr0g24ewymHuLAfJsBzowwbOPq61E4d+Y8uqosRzbhDxhlJCJrPD/jy1BIagI+TOO4NBQIgJaZrySBjlK1fijVThkPhldkSy4tfcF5YIrR5bSE1uCT+fwWzozr8j87cHew0kq3LjUvNv1+c9Gs1cBhwv3x7f2gTp5WLQvpPTJ1GzqmGQiQhhrwgBsNwu++Ab9hB7Rw3tJf2VSaCHaQIkbYj8kO+ApszWwh9skHcXlDRApRrjga81T"
`endif