// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




(* altera_attribute = "-name AUTO_SHIFT_REGISTER_RECOGNITION off" *) module hyperpipe # ( 
  parameter WIDTH = 1,
  parameter CYCLES = 3
) (
  input clk,
  input [WIDTH-1:0] din,
  output [WIDTH-1:0] dout
);

generate
  if (CYCLES==0) begin : GEN_COMB_INPUT
    assign dout = din;
  end 
  else begin : GEN_REG_INPUT  
    integer i;
    reg [WIDTH-1:0] R_data_preserve [CYCLES-1:0];
    
    always @(posedge clk) begin   
      R_data_preserve[0] <= din;      
      for(i=1;i<CYCLES;i=i+1) R_data_preserve[i] <= R_data_preserve[i-1];
    end
    assign dout = R_data_preserve[CYCLES-1];
  end
endgenerate  
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61SwXeXkHD5MQ97PEHeoft6qRiN+SFqL31DaEx53uJCWbs9CeZgos1oqLFPKErduLKEEKlIHCwUJ9pB+rIH+WbyxootnOz0y7EV6qFBDaeFIETkBnL2cDx5ctyusqKH0A5dMW08O5t/Ddd5NQZDxiJXEyNs24b4lOMOqpLk1xwOdzcSxjG9KRzlaXqN5QaK6Le5NXDrlcFv/KCu3g6OER3dKZVx/YsxFtCeJdjZ2SGT0BgTu4jwmrttLBBTY/7n54kgLT1G9/G8HqdENs+2o5pt+G3TqPcgtjbopkC0qabV8faOsV7ChYYEahH0bgClq6/PFAZJf9nLl/ihCC8Iq0fIVGMyQ1WbPw/SeFzb0INI3YwuE0p7Xy251fbxyoO945WlXoS9Lp1rHAyqc67AG2F5v+jHEZWrgzDD2JzBqzQ15luxD6sZkCKCK1odAAEsspNFXR+JfLzulRUdGBeRLpkmefLXqiHs/ka1/HCF8JXnnMeHouBo1JxueQjcp+2LZTfYFPLc9WRdVjgnFoJp/NMDlhECFpI8fbl5h2mkzXED+5Emoddk4iUvb1GTO3m9vzq1WYt7kIGzRLioeMhGlaD3n5V+x4Zo+TwXhKkeGhfvcYWKwuMEbSZ/GJEjAFwwu4Jb1cM2sJUo6T3JcZyjczXzxADBxU2BkqCOYInjkJjCtIa41jgiRlvSfImEmxKStZ1gOKaWe8RqFqr2YBxwDUuVOXjL9Ad9OpPasNmuCh84wq2omDXdcbFcu3cf0PcI98Vj7fwlTRZWcJRF+nIxLr1ge"
`endif