// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;
module dphy_fa_p2c_lane_bhv #(
    parameter fa_core_periph_clk_sel_data_mode = "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_UNUSED",
    parameter fwd_clock_divide_data_mode = "FWD_CLOCK_DIVIDE_DATA_MODE_UNUSED",
    parameter io12lane_p2c_data_mode = "IO12LANE_P2C_DATA_MODE_REG"
) ( 
    input  wire  [95:0]    i_hmc,                          
    input  wire  [95:0]    i_phy,                          
    output logic [95:0]    o_p2c,                          
    input  wire  [3:0]     i_p2c_phylite_ctrl,             
    input  wire  [3:0]     i_p2c_hmc_ctrl,                 
    output logic [3:0]     o_p2c_ctrl,                     
    input  wire            i_phy_clk_fr,                   
    input  wire            i_phy_clk_sync,                 
    input  wire            i_core_clk,                     
    input  wire            i_mipi_fwd_clk,                 
    output logic           o_mipi_fwd_clk                  
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif




logic clk;
logic fwd_clk_div;
logic [1:0] phy_clk_div;
logic [95:0] i_phy_q;
logic [95:0] i_phy_q_n;
logic [95:0] phy_q;
logic [95:0] phy_q_n;
logic [95:0] i_phy_q_tdm;
logic [95:0] p2c;
logic [3:0] p2c_ctrl;
int i;

logic phy_clk_sync;
logic [2:0] sync_q;

always @(negedge i_phy_clk_fr)
begin
    sync_q <= { sync_q [1:0] , i_phy_clk_sync };
    phy_clk_sync <= ~sync_q[2] & sync_q[1];
end
            

logic phy_clk_fr_d;
logic mipi_fwd_clk_d;    
logic clk_mux_src;
logic clk_phy;


assign phy_clk_fr_d = i_phy_clk_fr;
assign mipi_fwd_clk_d = i_mipi_fwd_clk;


assign clk_mux_src = fwd_clock_divide_data_mode == "FWD_CLOCK_DIVIDE_DATA_MODE_UNUSED" ? phy_clk_fr_d : mipi_fwd_clk_d;
assign clk_mux_dst_phy = fwd_clock_divide_data_mode == "FWD_CLOCK_DIVIDE_DATA_MODE_UNUSED" ? clk_phy :
                         fwd_clock_divide_data_mode == "FWD_CLOCK_DIVIDE_DATA_MODE_DIV2" ? fwd_clk_div :
                         mipi_fwd_clk_d;
assign o_mipi_fwd_clk =  fwd_clock_divide_data_mode == "FWD_CLOCK_DIVIDE_DATA_MODE_UNUSED" ? 'b0 :
                         fwd_clock_divide_data_mode == "FWD_CLOCK_DIVIDE_DATA_MODE_DIV2" ? fwd_clk_div 
                         : mipi_fwd_clk_d;
assign clk = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_CORECLK" ? i_core_clk : clk_mux_dst_phy;
assign p2c =   io12lane_p2c_data_mode == "IO12LANE_P2C_DATA_MODE_BYPASS" ? i_phy : 
               io12lane_p2c_data_mode == "IO12LANE_P2C_DATA_MODE_REG" ? i_phy_q :
               io12lane_p2c_data_mode == "IO12LANE_P2C_DATA_MODE_TDM" ? i_phy_q_tdm : 'h0;

buf #(0.1) buf_p2c_d[95:0] (o_p2c, p2c);
buf #(0.1) buf_p2c_c[3:0]  (o_p2c_ctrl, p2c_ctrl);

initial
    fwd_clk_div <= 1'b0;
    
always @(posedge i_mipi_fwd_clk)
    fwd_clk_div <= ~fwd_clk_div;

always @(posedge i_phy_clk_fr)
begin 
    if(phy_clk_sync)
        phy_clk_div <= 'h0;
    else
        phy_clk_div <= phy_clk_div + 1'b1;
end    

assign clk_phy = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV4" ? ~phy_clk_div[1] :
                 fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV2" ? ~phy_clk_div[0] : 'b0;


always @(posedge clk_mux_src)
    i_phy_q <= i_phy;

buf #(0.1) buf_q[95:0] (phy_q, i_phy_q);
buf #(0.1) buf_qn[95:0] (phy_q_n, i_phy_q_n);
    
always @(negedge clk)
    i_phy_q_n <= phy_q;


always @(posedge clk)
begin
    for(i=0; i<6; i++)
    begin
        i_phy_q_tdm[i*16 +: 8]      <= i_phy_q_n[i*16 +: 8];
        i_phy_q_tdm[i*16+8 +: 8]    <= phy_q[i*16 +: 8];
    end
    p2c_ctrl <= i_p2c_phylite_ctrl;
end

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61S+88I9KykVnCNAqKfn/foXLiztn4FbYSzR/MewlfVzrn9Y0NfWq87KQIISGohBCSAdW0qKiyn7rhGbsIfVSlUdEhtEYGBKAU2VwlWp1NLs5WS8cIjRmeuSBN9WDcf4DXlBYAhk5fKRXTRI/Qownogkhgs0/k1+OtkL/O3dnTfqvWjucLFWHgcA3pwP6ozWdsF8ZXJ6oJNtzUSq/xWM9GDy55hl2kfpKqzvWUX9KwxHz9Bmi+ItwFz0rlpSssfsaMeys5YuvmNvHaxm8XZKzKHdsbx64g2Ld8tFJyvjXSKUVzisWuSza54KBhl4VoHRcUxi/bAMdgjl8E8clbqQTtNRWu4c8Mr5BFaXJDsy/kVce4jP3pT9I2vyDyiGLvH9xrkMJmaasb7IVZG+6be+pPGbZ3uq8x59OHoO5CTvwYUtCe/mAN7XAuU+sjnyW8TXgJOuC6RgnYXrRp0zy3LqkKciDKzlWTIJ9xkLn8gvaAtCJmraLYDQ4S1H9SE7hchTSqkREgRxauMMt/i9ANocKLiPBnkBOIEp7U0GOnx7X34jh094LUA5B6eBZ0DVKG016i9ushMIYwSYpH5u+u1SEeLYrToH3kX070s7FS+eMa1BqJwB++Dq8Jiw/KXyoiElk5uQhqcacbeUY4bTSmRLAe3+GMQlXUmVukNbe+HN7iKgtDXf8DHQ7JMd19xy1BuVV+iq2oOKUQBsrP9BPzgKYpAggA4QiI2EvEiu4j7/ETRJHQjSQSiHvIrbLFd4XBq5NZADwgKrKrd6RdslkY7+UZ13"
`endif