// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;
module dphy_fa_c2p_lane_bhv #(
    parameter IO_CONVERT_RATIO_C2P = 16,
    parameter fa_core_periph_clk_sel_data_mode = "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_UNUSED",
    parameter io12lane_c2p_data_mode = "IO12LANE_C2P_DATA_MODE_REG"
) ( 
    output logic [95:0]    o_c2p_hmc,                      
    output logic [95:0]    o_c2p_phylite,                  
    input  wire  [95:0]    i_c2p,                          
    input  wire  [19:0]    i_c2p_ctrl,                     
    output logic [19:0]    o_c2p_phylite_ctrl,             
    output logic [19:0]    o_c2p_hmc_ctrl,                 
    input  wire            i_phy_clk_fr,                   
    input  wire            i_phy_clk_sync,                 
    input  wire            i_core_clk                      
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif

    localparam IO_TX_PIPE_DEPTH = (IO_CONVERT_RATIO_C2P == 16) ? 3 : 5;

    logic clk_phy;
    logic clk_phy_div_2;
    logic [3:0] phy_clk_div;
    logic [95:0] i_c2p_d;
    logic [95:0] i_c2p_q;
    logic [95:0] c2p_mux;
    logic [19:0] i_c2p_ctrl_d;
    logic [19:0] i_c2p_ctrl_q;
    logic [19:0] c2p_ctrl_mux;
    logic core_clk_div_2;
    logic mux2_ctrl;
    logic mux1_ctrl;
    int i;
    logic i_phy_clk_sync_q;
    logic phy_clk_sync;
    logic din_clk;
    logic [95:0] i_c2p_pre_d;

    logic [2:0] sync_q;

    always @(negedge i_phy_clk_fr)
    begin
        sync_q <= { sync_q [1:0] , i_phy_clk_sync };
        phy_clk_sync <= ~sync_q[2] & sync_q[1];
    end

    
    initial 
        core_clk_div_2 <= 1'b0;
    
    always @(posedge i_core_clk)
        core_clk_div_2 <= ~core_clk_div_2;
    
    always @(posedge i_phy_clk_fr)
    begin 
        if(phy_clk_sync)
            phy_clk_div <= 4'h0;
        else
            phy_clk_div <= phy_clk_div + 1'b1;
    end    
   
   /* 
    assign clk_phy = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV8" ? ~phy_clk_div[1] :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV4" ? ~phy_clk_div[0] :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV2" ? i_phy_clk_fr :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV1" ? i_phy_clk_fr : 
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_CORECLK" ? i_core_clk : 1'b0;
    assign clk_phy_div_2 = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV8" ? ~phy_clk_div[2] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV4" ? ~phy_clk_div[1] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV2" ? ~phy_clk_div[0] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV1" ? i_phy_clk_fr : 
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_CORECLK" ? core_clk_div_2 : 1'b0;
   */ 
    assign clk_phy = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV8" ? ~phy_clk_div[2] :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV4" ? ~phy_clk_div[1] :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV2" ? ~phy_clk_div[0] :
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV1" ? i_phy_clk_fr : 
                    fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_CORECLK" ? i_core_clk : 1'b0;
    assign clk_phy_div_2 = fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV8" ? ~phy_clk_div[3] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV4" ? ~phy_clk_div[2] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV2" ? ~phy_clk_div[1] :
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_PHYCLK_DIV1" ? ~phy_clk_div[0] : 
                        fa_core_periph_clk_sel_data_mode == "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_CORECLK" ? core_clk_div_2 : 1'b0;
    
    buf #(0.1) buf_d[95:0] (i_c2p_pre_d, i_c2p);
    buf #(0.1) buf_c[19:0] (i_c2p_ctrl_d, i_c2p_ctrl);
    

    hyperpipe #(.WIDTH(96), .CYCLES(IO_TX_PIPE_DEPTH-1)) io_tx_pipe_depth_inst (.clk(din_clk), .din(i_c2p_pre_d), .dout(i_c2p_d));
    
    assign din_clk = io12lane_c2p_data_mode == "IO12LANE_C2P_DATA_MODE_TDM_SDR" ||  io12lane_c2p_data_mode == "IO12LANE_C2P_DATA_MODE_TDM_MIPI" ? clk_phy_div_2 : clk_phy;
    always @(posedge din_clk)
    begin
        i_c2p_q <= i_c2p_d ;
        i_c2p_ctrl_q <= i_c2p_ctrl_d ;
    end
    
    assign mux2_ctrl = io12lane_c2p_data_mode == "IO12LANE_C2P_DATA_MODE_TDM_SDR" ||  io12lane_c2p_data_mode == "IO12LANE_C2P_DATA_MODE_TDM_MIPI" ? clk_phy_div_2 : 'b1;
    assign mux1_ctrl =  io12lane_c2p_data_mode == "IO12LANE_C2P_DATA_MODE_TDM_MIPI" ? 'b1 : 'b0;
    
    always @(*)
        for(i=0; i<6; i++)
        begin
            case ( {mux2_ctrl, mux1_ctrl} )
                2'b10 :     
                        c2p_mux[i*16 +: 16] <=  i_c2p_d[i*16 +: 16];
                2'b01 :     
                        c2p_mux[i*16 +: 16] <=  { i_c2p_d[i*16+8 +: 8], i_c2p_d[i*16+8 +: 8] };
                2'b11 :     
                        c2p_mux[i*16 +: 16] <=  { i_c2p_d[i*16 +: 8], i_c2p_d[i*16 +: 8] };
                default :   
                        c2p_mux[i*16 +: 16] <= 'h0;
            endcase
        end
    
    always @(*)
        begin
            case ( {mux2_ctrl, mux1_ctrl} )
                2'b10 :     
                        c2p_ctrl_mux <= i_c2p_ctrl_d;
                2'b01 :     
                        c2p_ctrl_mux <= i_c2p_ctrl_d;
                2'b11 :     
                        c2p_ctrl_mux <= i_c2p_ctrl_d;
                default :   
                        c2p_ctrl_mux <= 'h0;
            endcase
        end
    
    
    buf #(0.1) buf_c2p_d[95:0] (o_c2p_phylite, c2p_mux);
    buf #(0.1) buf_c2p_c[19:0] (o_c2p_phylite_ctrl, c2p_ctrl_mux);
    
    
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61TqF+5R8JUUKQzdgleF9ilJRqAJ2FdaMHiIVWb0DzcRoUleW/DwzQbnFoQfNtavfgqEC+wY2gmATE+pUc8smETCc4cKBcsP/qJXdC8W8QLzn8Xos1sIG2PVAU8E24yojBjy1J+up202XFYoR8tdKhojrsWuYqjfTB1dKhvkqW3L22j8QpL7HALx6u1VlQTDWsDZJx+lYbgENYz95LC0E9KCNmZwTFD14xtAFa4a05Ud1KvMiOiqtkNLXQ7py6PT4Xv4zskXqhsM+rZnK6H54aCJzwzME2SmqVDRGOJ/4DEtFm3+BPNHaN5AzxqCyG2Q8wq9sA25o6nfJsuP8WJ1+5Dd00zH4T+bKZWUVG0pFjcGZp/qAGJzfQCkmWh1OZRmVMSqLN5bzTDB2eNG5kdLkC3v991pUQj6rm0/90T7oxhb1ksF/37YFPi7KXvI3ze8TYerPeKy/SGd2ruhstwucoTj0WikIT84LgUW4J2vh8fxQ6m/JzCOi3YTfrlDlVNVCSizPvVr9zjJm76uOYASa6uFraqEWt1IZFKAh+4m6CfKKxkTNU3OJ8ipgDai4H0UQJEw2Fnt/v0YvxFQL9/O+9xrAEhXW0fvzFpd4rzkUe30HyRiomwUiQRN6xXb7psYTxM6TdIxclkRfm1hg1yXkJNEVF0Mscbgb2o4JEWQSohAfy7PeERGEd/hh6FdXK2u+GS4CMIPvLyNzzfIdSBt3Lv8j2K6+12vS2pnxQWswoPayJDQ3hUikiMCecSO8HOPXkauvkwF3ZyOBhq6ZQs5O6v6"
`endif