// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

module dphy_pcs_timing_tx 
   (
        input  wire                     fr_clk,
        input  wire                     fr_clk_1024,
        input  wire                     srst_fr_n,     
        input  wire                     enable,
        
        input wire                      in_prepare,            
        input wire                      in_zero,  
        input wire                      in_pre,
        input wire                      in_trail,
        input wire                      in_post,
        input wire                      in_wake,
        input wire                      in_hs_exit,
        input wire                      in_lp_exit,
        input wire [7:0]                t_init,   
        input wire [7:0]                t_prepare,
        input wire [7:0]                t_zero,
        input wire [7:0]                t_pre,
        input wire [7:0]                t_trail,
        input wire [7:0]                t_post,
        input wire [7:0]                t_wake,
        input wire [7:0]                t_hs_exit,   
        input wire [7:0]                t_lp_exit,   
        output logic                    init_done,
        output logic                    timer_out

    );
    
    localparam FR_TIMER_WIDTH = 16;
    logic [6:0] in_trig;
    logic [6:0] in_trig_q;
    logic fr_ld_timer;
    logic fr_timer_en;
    logic [FR_TIMER_WIDTH-1:0] fr_ld_val;
    logic init_start;
    logic in_wake_q;
    logic fr_timer_out;

    assign in_trig = { in_prepare, in_zero, in_pre, in_trail, in_post, in_hs_exit, in_lp_exit };
    always @(posedge fr_clk)
    begin
        in_trig_q <= in_trig;
        in_wake_q <= in_wake;
    end
    
    
    assign fr_ld_timer = init_start | |(in_trig & ~in_trig_q) | (in_wake & ~in_wake_q);
    assign fr_timer_en = ( init_done & ~in_wake ) ? |in_trig : fr_clk_1024;
    assign fr_ld_val = { 8'h0,  ({ 8{init_start} } & t_init ) |
                                ({ 8{in_prepare} } & t_prepare ) |
                                ({ 8{in_zero} } & t_zero ) |
                                ({ 8{in_pre} } & t_pre ) |
                                ({ 8{in_trail} } & t_trail ) |
                                ({ 8{in_post} } & t_post ) |
                                ({ 8{in_wake} } & t_wake ) |
                                ({ 8{in_hs_exit} } & t_hs_exit ) |
                                ({ 8{in_lp_exit} } & t_lp_exit ) };
    
    always @(posedge fr_clk)
        if( (srst_fr_n & enable) == 1'b0)
        begin
            init_start <= 1;
            init_done <= 1'b0;
        end
        else
        begin
            init_start <= 1'b0;
            init_done <= init_done | fr_timer_out;
        end

    dphy_timer #(
        .WIDTH(FR_TIMER_WIDTH)
   ) tx_timer_fr
   (
        .clk(fr_clk),     
        .srst_n(srst_fr_n),     
        .timer_en(fr_timer_en), 
        .ld_timer(fr_ld_timer),   
        .ld_val(fr_ld_val), 
        .timer_out(fr_timer_out)   
    );
    
    assign timer_out = fr_timer_out;

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8GnXs2Ok3JgtLqR5OUKFTwYQ4K+2yK0EpibkY9AN2WisvfXJeTpNaY0uY/CCuAz4dU7Xv0C1Ql+K+sQFU5vaJBewqUjgDZYtqKW36Gx0c1qgaqszJXDFgWteTVK/DRgSmDVSOj1bxSiadMvB/iOU2cP/B3rqer3oHZ057WnvIUNOKFsSxyXMVbfwVfpPPI4gLu7xEt1UdWKmHBifqsEeiIz8O4os91XMvFAH2i569bYFc8eOLMsNIhfcyprM7Nn0MVfOKeYgAnVR1WT1xYJ0WYNrwVO9v2RHVwQVYdCXUfh32rWOG/sxT6BAVQPwf2gpx+JtybSJXdXTdFds82DtaQcjsN11N0EwA+MGzj3iS29hQbAPp/oSgSJEJukPI4E/Najxi5L/8ede6EV8UtmC2fuQk+pKfq+gVRivo/e4dbuwp4Plm3qjh5W8KAAQilh5QxIVvco195oS+PenAShOpxZhyhPVN+d882wpJSqH/Uke9zlwjt0idvBCjg9GUn+MeF4rrODfjUmMTUxfE1ahJz+h2mOS4EO8WXMR+2q8EtuZdGNSAqVSial86avezZJ0IANwcha/XiKICEZ+gjvF7mdBnzovdaYfp+nlqbsyirLv6OOI/Bkl3II13L7PcVhkowAbWT4TfNXv6w1eMV8yEMmugnYO4731nMcWF9GVF2NSGyB83H2FFPMApV4Izh4pduSC1KsUMNfoBPVHl0k4rJ2TRhTUej8JyVlZpdfRajatEEosQGnxgUXxD0Jw032u4AnFwInViDUwDPWEbY68MC9Q"
`endif