// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`define C2P_HIPI \
      (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 225"} *)
`define C2P_CTRL_HIPI \
      (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 225"} *) (* preserve *)
`define RX_C2P_HIPI \
      (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 225"} *) (* preserve *)
`define P2C_HIPI \
      (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_PERIPHERY_CORE_TRANSFER ON"} *)

`define P2C_HIPI_1DOMAIN_RESTRICTION

`ifndef dphy_mipi_ff_name
`define dphy_mipi_ff_name tennm_ff
`endif

import dphy_pkg::*;
		   
module dphy_full_byte_hipi_intf
  #(
    parameter DPHY_RX_EN = 0,
    parameter DPHY_TX_EN = 0,
    parameter NUM_LANES = 1,
    parameter BYTE_CNT = 1
    )
   (

    input logic 		   link_core_clk, 
    input logic [BYTE_CNT-1:0] 	   rx_fwd_clk, 

    input logic [BYTE_CNT*96-1:0]  p2c, 
    input logic [BYTE_CNT*4-1:0]   p2c_ctrl, 
    input logic [BYTE_CNT*12-1:0]  phy_gpio_din, 
    
    input logic [BYTE_CNT*96-1:0]  c2p, 
    input logic [BYTE_CNT*20-1:0]  c2p_ctrl, 
    output logic [BYTE_CNT*96-1:0] c2p_hipi, 
    output logic [BYTE_CNT*96-1:0] p2c_hipi, 
    output logic [BYTE_CNT*20-1:0] c2p_ctrl_hipi, 
    output logic [BYTE_CNT*4-1:0]  p2c_ctrl_hipi, 
    output logic [BYTE_CNT*12-1:0] phy_gpio_din_hipi 
    );

   genvar 			   BYTE_N;
   genvar 			   i;
   integer 			   LANENUM;
   
   
   logic [BYTE_CNT-1:0] 	   core_clk;
   logic [BYTE_CNT-1:0] 	   srst_n;
  
   for(BYTE_N = 0; BYTE_N < BYTE_CNT; BYTE_N++)
     begin : byte_in_link
	
	assign core_clk[BYTE_N] = link_core_clk;
	
	if (DPHY_TX_EN == 1)
	  begin:drv0
	     assign p2c_hipi[BYTE_N*96 +: 96] = 96'd0;	     
	     assign p2c_ctrl_hipi[BYTE_N*4 +: 4] = 4'd0;
	     assign phy_gpio_din_hipi[BYTE_N*12 +: 12] = 12'd0;	     
	  end
	
`ifdef DPHY_BHV_SIM
	
// synthesis translate_off
	//power-up state on c2p_ctrl_hipi
	initial begin
	   c2p_ctrl_hipi[BYTE_N*20 +: 20] = $urandom();		   
	end
// synthesis translate_on
   
   always @(posedge core_clk[BYTE_N]) begin
      c2p_hipi[BYTE_N*96 +: 96] <= c2p[BYTE_N*96 +: 96];		   
   end
   
   always @(posedge core_clk[BYTE_N]) begin
      c2p_ctrl_hipi[BYTE_N*20 +: 20] <= c2p_ctrl[BYTE_N*20 +: 20];
   end
   
   if (DPHY_RX_EN == 1) begin : dphy_rx_hipi_intf
      
      always @(posedge rx_fwd_clk[BYTE_N]) begin
	 p2c_hipi[BYTE_N*96 +: 96] <= p2c[BYTE_N*96 +: 96];
	 p2c_ctrl_hipi[BYTE_N*4 +: 4] <= p2c_ctrl[BYTE_N*4 +: 4];
      end

      `ifndef P2C_HIPI_1DOMAIN_RESTRICTION
      always @(posedge core_clk[BYTE_N]) begin
         phy_gpio_din_hipi[BYTE_N*12 +: 12] <= phy_gpio_din[BYTE_N*12 +: 12];
      end
      `else
      assign phy_gpio_din_hipi[BYTE_N*12 +: 12] = phy_gpio_din[BYTE_N*12 +: 12];
      `endif   
   end 
   
`else 

   /*
   for (i = (0+BYTE_N*96); i < (96+BYTE_N*96); i++)
     begin : c2p_hipi_inst
	`C2P_HIPI `dphy_mipi_ff_name
	    c2p_hipi_ff
	    (
	     .clk (core_clk[BYTE_N]),
	     .d   (c2p[i]),
	     .q   (c2p_hipi[i])
	     );
     end
    */
   
   for (i = (0+BYTE_N*20); i < (20+BYTE_N*20); i++)
     begin : c2p_ctrl_hipi_inst
	`C2P_CTRL_HIPI `dphy_mipi_ff_name
	    // synthesis translate_off
	    #(
	      .power_up ("high")
	      )
	    // synthesis translate_on
	c2p_ctrl_hipi_ff (
			  .clk (core_clk[BYTE_N]),
			  .d   (c2p_ctrl[i]),
			  .q   (c2p_ctrl_hipi[i])
			  );
     end 

   if (DPHY_TX_EN == 1) begin : dphy_tx_hipi_intf
      for (i = (0+BYTE_N*96); i < (96+BYTE_N*96); i++)
	begin : c2p_hipi_inst
	   `C2P_HIPI `dphy_mipi_ff_name
	       c2p_hipi_ff
	       (
		.clk (core_clk[BYTE_N]),
		.d   (c2p[i]),
		.q   (c2p_hipi[i])
		);
	end
   end
   else begin
   if (DPHY_RX_EN == 1) begin : dphy_rx_hipi_intf

      for (i = (0+BYTE_N*96); i < (96+BYTE_N*96); i++)
	begin : rx_data_deskew
	   if (((i-BYTE_N*96) < 80) && (((i-BYTE_N*96)<32)||((i-BYTE_N*96)>47)) && 
	       ((((i-BYTE_N*96)/16) > 1 ? (((i-BYTE_N*96)/16) - 1) + BYTE_N*4 :  ((i-BYTE_N*96)/16) + BYTE_N*4) < NUM_LANES))
	     begin : c2p_hipi_inst
		`RX_C2P_HIPI `dphy_mipi_ff_name
		  c2p_hipi_ff
		    (
		     .clk (core_clk[BYTE_N]),
		     .d   (c2p[i]),
		     .q   (c2p_hipi[i])
		     );		 
	     end
	   else
	     begin : c2p_hipi_inst_drv0
		assign c2p_hipi[i] = 1'b0;		
	     end
	end
      
      for (i = (0+BYTE_N*96); i < (96+BYTE_N*96); i++)
	begin : p2c_hipi_inst	   
	   `P2C_HIPI `dphy_mipi_ff_name
	       p2c_hipi_ff
	       (
		.clk (rx_fwd_clk[BYTE_N]),
		.d   (p2c[i]),
		.q   (p2c_hipi[i])
		);
	end
      
      for (i = (0+BYTE_N*4); i < (4+BYTE_N*4); i++)
	begin : p2c_ctrl_hipi_inst
	   `dphy_mipi_ff_name
	       p2c_ctrl_hipi_ff
	       (
		.clk (rx_fwd_clk[BYTE_N]),
		.d   (p2c_ctrl[i]),
		.q   (p2c_ctrl_hipi[i])
		);	
	end
      
      for (i = (0+BYTE_N*12); i < (12+BYTE_N*12); i++)
	begin : phy_gpio_din_hipi_inst
	   `ifndef P2C_HIPI_1DOMAIN_RESTRICTION
	   `P2C_HIPI `dphy_mipi_ff_name
	       phy_gpio_din_hipi_ff
	       (
		.clk (core_clk[BYTE_N]),
		.d   (phy_gpio_din[i]),
		.q   (phy_gpio_din_hipi[i])
		);
	   `else
	       assign phy_gpio_din_hipi[i] = phy_gpio_din[i];
	   `endif
	end 
      
   end 
      
   end 
   
`endif
   
end 

endmodule 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "k1LH1RcWqBqQ76v8cfULmmlV9sW1nnbJaS2wcLgqGwqBhLWK73DmouWbV7pbibS7IH130sZk+lXZ9U2UpRjei+a4GXqGhMMc9IMzMkgIDLbmlHj0N0nMSI9TMo4z5CKT4okwkd1gkpoJ98r//fD7kKG+O0v6X7LJGK2BQC+3s5gBj2lSsro8UaDW99uGAXd1ozPUFOiI9DO+P2Bl903Ke20T6b0d5clKKvtf117o8GnseNRO4/xB45jEK/kL0Lh1BpbM5fw2CGGhptw9dxII5eCmdAW0Z5+cezPvZMFJ8nbgz74Vmqmq200/ZbP9dpj0TkMn1OpfPzyjJKbgDZanZegHmCzBrqxet3owzY13XOPuxvfGk4WZpOx2TETYXWeqyT/P80HFWNfk1HOQ++c49qpprsIA90ZBhiRREl8HbQ/K6XICUdwtdXdM7KRas3Wj9soqbq349u9lxRFPWf8m6FRasDkxSXCzU6G2p/OqHECesZvbqRJV/PRayg6VzWfRSWMHXi6GJ03BOC+fFJPHKjhQxtZZfE7GyoBWJLq9y7YHRw4g4OORHHMWf9ThF3Lv+6bSLd/QPBlD7zvWffgHe1xU/IO6P0koC3vBEyd60oIG8d/7f3F069mSWSi9NlqrvKgzS5zTYIT5PZ273hG3y0iU/41HfBTRTnnZ5bq++BlEy6/ftUw3YcHK1Hsgc6YLNKGG49jKaBxQoxWETmTvj/+Bv5zs7ru2/d0pNUry6GLQPHI3l69HYOa9reqLep5civR3O3m+2dbFvum8/nwxYK+BDQ6RrQd/n4uYF74Ns4lvF0CW5PL+PS60gKxKEmaqY5IRFGnK1whnnzl/DaLJ4SdtNMg98bWFONjv49ZcksS/VLqmPdXfD+DbSk7zhZqjPYkNVyBIAzBwrOISOsUTaUEjnEudOuZ1x6+OvlBA6zLVJ3PVfqSNqnWga29bFBxnXpcKkPwkXby/1/V+0v9twBK6l64TPY2O96NgZY/M58OjSK7CZsRA2UrvP7Fhawle"
`endif