// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module dll_bhv #(
        parameter num_phases = 16,
        parameter mdll = 1,
        parameter gen_clk = 1,
        parameter dll_lock = 150
    )(
        input lock_in,                                 
        input clk_in,                                  
        output logic lock_out,                         
        output logic [num_phases-1:0]  clk_out ,       
        input shortreal ph_step_in,                    
        output shortreal ph_step                       
    );

timeunit 1ns;
`ifdef VIP
   timeprecision 1ps;
`else
   timeprecision 1fs;
`endif

    shortreal ph_step_used;
    int lock_cnt;
    genvar ph;


    if(mdll == 1)
    begin : mdll_blk

        shortreal clk_period;
        shortreal t0;
        logic meas_en, meas_en_q;
        logic [2:0] lock_in_q;
        always @(posedge clk_in)
        begin
            if(meas_en == 1'b1)
                t0 <= $realtime;
            if(meas_en_q == 1'b1)
                clk_period <= $realtime - t0;
            meas_en_q <= meas_en;
            meas_en <= (lock_in_q[1] === 1'b1 && lock_in_q[2] !== 1'b1 ) ? 1'b1 : 1'b0;
            lock_in_q <= { lock_in_q[1:0], lock_in };
        end
        assign ph_step = clk_period / num_phases;
        
    end
            
    initial
    begin
        lock_cnt <= 0; 
    end
    
    always @(negedge lock_in or posedge clk_in)
    begin
        if(lock_in == 1'b0)
           lock_cnt <= 0;
        else
           lock_cnt <= (lock_cnt < dll_lock) ? lock_cnt + 1 : lock_cnt;
    end

    assign lock_out = (lock_cnt == dll_lock) ? 1'b1 : 1'b0;
    
    assign ph_step_used = ph_step_in > 0 ? ph_step_in : ph_step;
    if(gen_clk==1)
    begin
        assign clk_out[0] = clk_in;
        for(ph =1; ph<num_phases; ph++)
        begin
            assign #ph_step_used clk_out[ph] = clk_out[ph-1];
        end
    end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61RGlu+1ToxMvtbccaZ1fOHDldaz4g+LFMfgC5VJMgJfL/42wUgJO0WlrBaCBjsaNnjGJeUdpdjG4ASETtiiKry6F/vYcMVL1klhnAtOlzqINa6VSRz0U6FiBuEiT6sRltrnJv/jLF0IBGTC7KakXFW2bp6xpwy+4mDj4Wm4s0mUpsADTUN0KGQB6xtG8yHcZoOKkRG/yJRfjPoQUDoGYcmghDG2BLHjFpeJL7Yjw58iJmhX+LESJ3vSZ5ATdrQ+EEpAEvSYntEl42ZRkjC3PCzkTKldFOQWa9nYjgH05wt3KfHEFR76kAE9Zd/XQGIxiaXn8IlpbvuJjFLkyRR7Hw51H3iDTXXH1BUNhNcwEPw9LSqAaqTBeugyuLH61r5SsnuAOHLeYm9K+YxQG0pU29NYyo9bshjrNWsucc/BUXjFMJZPG9bSEzWYYUUcjEYSbGZ7Re8Nl+jpSV/R/w+AWXSopTstUcwodDl6K1F9pv4hkHjxsjI5ymsHqyUGfG/4JxxKDL9glX9KCKQ0j+o/tJ9cbmghxy9BtH81YutJFwfwgNdrvL7gpnmJ6RvL4Q9GaE1KwuvhCw+lABipdotptyzXGl1me6JvOiSGjG7bvFud9Jhon5nP3Wsl/KP4tdr7gNRyh9BqMuzHLxTnhIL2LoCEvu+X7SvFIOt+64Os/FsWtI5bv3W86i5crsKtUJuthZnBL3S14C7erVW4AI6qt1pFCs5xpjKUjx5ZKHvojg391TvRm7D+KOJWyj6gepq5SOyvX5nF2ia46ut8VeG5M1IR"
`endif