// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



import dphy_pkg::*;

module dphy_cpa_bhv #(
    parameter base_address = 9'h000,
    parameter feedback_dly_sel = "DLY_PHY",
    parameter feedback_dly_steps = 7'h00,
    parameter internal_base_address = 9'h000,
    parameter phy_clk_div = 2'h1,
    parameter protocol_mode = "UNUSED",
    parameter vco_clk_div_exponent = 3'h2,
    parameter vco_clk_div_mantissa = 5'h00,
    parameter vco_clk_freq = 31'h00000000
) ( 
    input  wire            i_core_clk_in,                  
    input  wire            i_phyclk,                       
    input  wire            i_phyclk_sync,                  
    output logic           o_core_clk_out,                 
    input  wire  [7:0]     i_vco8ph,                       
    output logic           o_lock,                         
    input  wire            i_avl_clk,                      
    input  wire            i_avl_rst_n,                    
    input  wire            i_avl_write,                    
    input  wire            i_avl_read,                     
    input  wire  [21:0]    i_avl_address,                  
    input  wire  [31:0]    i_avl_writedata,                
    output logic [31:0]    o_avl_readdata,                 
    input  wire            i_pll_lock                      
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif
    localparam phy_clk_div_int = phy_clk_div == 0 ? 1 : 
                                 phy_clk_div == 1 ? 2 :
                                 phy_clk_div == 2 ? 4 :
                                 phy_clk_div == 3 ? 8 : 0;



    localparam LOCKTIME = 250;
    logic [1:0] clk_div;
    logic core_clk;
    logic lock;
    logic [2:0] sync_q;
    logic sync_p;
    
    always @(i_pll_lock)
    begin
        if(i_pll_lock == 1'b0)              lock <= 1'b0;
        else                    #LOCKTIME   lock <= 1'b1;
    end
    
    always @(posedge i_phyclk or negedge i_pll_lock)
    begin
        if(i_pll_lock == 1'b0 || sync_p == 1'b1)
            clk_div <= 2'h0;
        else
            clk_div <= clk_div + 1'b1;
    end

    always @(negedge i_phyclk or negedge i_pll_lock)
    begin
        if(i_pll_lock == 1'b0)
        begin
            sync_q <= 'h0;
            sync_p <= 1'b0;
        end
        else
        begin
            sync_q <= { sync_q [1:0] , i_phyclk_sync };
            sync_p <= ~sync_q[2] & sync_q[1];
        end
    end

    assign core_clk = phy_clk_div_int == 2 ? ~clk_div[0] : ~clk_div[1];
    assign o_core_clk_out = core_clk;
    assign o_lock = lock;

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61Q0ohzXIWmAzt5Wc+m2V1W9ZSf0hn9jlPk87A3be8vJVba+qBp3PGPVLQwXgi+2z0MIIslMHAXQICS58pOZxcgbvWTYEuK4FKhfPcjWJbKFr8Q18vx8Io8izAn9AVAPzxNc0YFMX5JdaUtbnorn6U+4KbuecKnoPMHKHiYmcsiFMq++5t2WkmkczgX8B1VnqvVfkqWxSYVRCnCcxCpqqVW5c5pvtZZyfubT08oAjE7drAZvsZ4wWKA8PmEbZdc7IwXjaifWvdTcR3VpoLWXx82ElwU9+V5tWbJv6wjwIIqA5m5pj9omUT00xFjHj6Hx2Q7GvN6cQ+irfKCDVnz37A59PPZzwT6poPM3T8wTh9hQTDhDLRt5HUmmHo4oEJ7h/bFEVCuhIjKjiosY2Z78ZfJ7JPqNToYjihctin592PEdL1brY9JYydfhyy5pmnVfGAqbjxduO2G689opnufFn3RrO/mZ3vifpYnxZr5Prkbn3OEjUNqf3tbA4AWhww114EYvwEqSGREiGMEQfp0JC2BE9mGNxbwQvpDUFdW+P4FWPfumswKU7jC6rNccRe+reba5GxzxMDShRIgqlqVFaUyU9/R4Z2xCZtPBpPLBlRjwaTz4PURL3SS5mENt1lItOJc7BM6JYyznzfpphh0AWj01EVZItg0N87L6CnW6J2I3o/TlVbfN0sLkNKNBI0YTYR1LVT+WT/CnZmubHnk5mrkmLm2iAKpo+pyHcfucGAkpz7MiDt7JSPI1s26QralIfAh/PihF9aNeherWM3gZdzuW"
`endif