// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




module byte_rxfifo (
        input push_even_rst_n,
        input push_odd_rst_n,
        input pop_rst_n,
        input push_clk,         
        input din[1:0],         
        input pop_en,
        input pop_clk,          
        output logic [3:0] dout 
    );

    `ifdef def_READ_TH
        localparam READ_TH = `def_READ_TH;   
    `else
        localparam READ_TH = 0; 
    `endif
    `ifdef def_WRITE_TH
        localparam WRITE_TH = `def_WRITE_TH;   
    `else
        localparam WRITE_TH = 16;         
    `endif

    logic [1:0] ram_even [0:15];
    logic [1:0] ram_odd [0:15];
    logic [1:0] dq_pair_even;
    logic [1:0] dq_pair_odd;
    logic din_div_even;
    logic din_div_odd;
    logic write_en_even;
    logic write_en_odd;
    logic [4:0] wr_ptr_even;
    logic [4:0] wr_ptr_odd;
    logic [4:0] wr_ptr_sync [2:0];
    logic [4:0] rd_ptr;
    logic [4:0] rd_ptr_sync [2:0];
    logic [4:0] full_cnt;
    logic [4:0] empty_cnt;
    logic [3:0] full_cnt_sub;
    logic [3:0] empty_cnt_sub;
    logic full_cnt_msb;
    logic empty_cnt_msb;
    logic [1:0] dout_even;
    logic [1:0] dout_odd;    
    logic full;
    logic empty;

    assign push_clk_n = ~push_clk;

    always @(posedge push_clk or negedge push_even_rst_n)
    begin
        if(push_even_rst_n == 1'b0)
            din_div_even <= 1'b0;
        else
            din_div_even <= ~din_div_even;
    end

    always @(posedge push_clk_n or negedge push_odd_rst_n)
    begin
        if(push_odd_rst_n == 1'b0)
            din_div_odd <= 1'b0;
        else
            din_div_odd <= din_div_even;
    end

    always @(posedge push_clk)
    begin
        dq_pair_even[0] <= din_div_even == 1'b0 ? din[0] : dq_pair_even[0];
        dq_pair_even[1] <= din_div_even == 1'b1 ? din[0] : dq_pair_even[1];
    end

    always @(posedge push_clk_n)
    begin
        write_en_odd <= write_en_even;
        dq_pair_odd[0] <= din_div_odd == 1'b0 ? din[1] : dq_pair_odd[0];
        dq_pair_odd[1] <= din_div_odd == 1'b1 ? din[1] : dq_pair_odd[1];
    end

    assign write_en_even = ~din_div_even & ~full;
    assign full = full_cnt == WRITE_TH ? 1'b1 : 1'b0;

    always @(posedge push_clk or negedge push_even_rst_n)
    begin
        if(push_even_rst_n == 1'b0)
            wr_ptr_even <= 'h0;
        else if(write_en_even == 1'b1)
        begin
            ram_even[wr_ptr_even[3:0]] <= dq_pair_even;
            wr_ptr_even <= wr_ptr_even + 1'b1;
        end
    end

    always @(posedge push_clk_n or negedge push_odd_rst_n)
    begin
        if(push_odd_rst_n == 1'b0)
            wr_ptr_odd <= 'h0;
        else if(write_en_odd == 1'b1)
        begin 
            ram_odd[wr_ptr_odd[3:0]] <= dq_pair_odd;
            wr_ptr_odd <= wr_ptr_even;
        end
    end


    assign full_cnt_sub = wr_ptr_even - rd_ptr_sync[2];
    assign full_cnt_msb = (wr_ptr_even[3:0] == rd_ptr_sync[2][3:0]) ? ( wr_ptr_even[4] ^ rd_ptr_sync[2][4] ) : 1'b0;
    assign full_cnt = {full_cnt_msb, full_cnt_sub};


    always @(posedge push_clk)
        if(push_even_rst_n == 1'b0)
            rd_ptr_sync = { 'h0, 'h0, 'h0 };
        else
            rd_ptr_sync = {rd_ptr_sync[1:0] , rd_ptr };

    always @(posedge pop_clk)
        if(pop_rst_n == 1'b0)
            wr_ptr_sync = { 'h0, 'h0, 'h0 };
        else
            wr_ptr_sync = {wr_ptr_sync[1:0] , wr_ptr_even };

    assign empty_cnt_sub = wr_ptr_sync[2] - rd_ptr;
    assign empty_cnt_msb = (wr_ptr_sync[2][3:0] == rd_ptr[3:0]) ? ( wr_ptr_sync[2][4] ^ rd_ptr[4] ) : 1'b0;
    assign empty_cnt = {empty_cnt_msb, empty_cnt_sub};


    assign empty = empty_cnt == READ_TH ? 1'b1 : 1'b0;
    
    always @(posedge pop_clk or negedge pop_rst_n)
    begin
        if(pop_rst_n == 1'b0)
            rd_ptr <= 'h0;
        else if(empty == 1'b0 && pop_en == 1'b1)
        begin
            rd_ptr <= rd_ptr + 1'b1;
        end        
    end

    assign dout[3] = ram_odd[rd_ptr[3:0]][1];
    assign dout[2] = ram_even[rd_ptr[3:0]][1];
    assign dout[1] = ram_odd[rd_ptr[3:0]][0];
    assign dout[0] = ram_even[rd_ptr[3:0]][0];

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61RO8eLyRnRv1FlP/pv3Eem3/nmFOvkBEL+SbNSGodK9y4XablDembxi7cPXEcmfdd5GFN/hvEaizKA39++Fa+svievO1mXa7QvGqUhXWHfN1Syx+wu5uD2r2Q2tpJerUiIKo13ya1TKqVbBV6AmBXqStOgL0XjolNvkCRw+/8jE+cHd8x2U2BY4L0QkGRAJmMcuuAIzS0N6dqW5bXBhCmvrwM5piHBi7laZpCHVwaGR/hx7Obo8e+URns9DynU6HZgjSQUI2NqClsa1RrHiBTKI27bk206oz9edwDTL+f5F07/m8dWXqrmgM9FZcff75Qo31RDqSIfoboLdqEz6tEaYo2ijL5S+HPIBZJTypCSvkwDcNX3zU9gdg75+aD/+nMQNDR3fQpry+STcqquXZgAHSqXV1xa8sYs8PIlj7ESpFVo6v7VPvHGso50ap+nrlSODv1TbxU4azOXjg9AeLA+QloLlrkJAwC/FZVhoQmbzQcTKU7m0GSG2VGV9HCtx/pjJ76yIhoOsWEPIW7lD9FkLx1TiTXckeEMtbVf2F2YddjejeeFc+WNZsfYX/r+cVVwsJMLYhhmaV5E3gpMIsB4+AoNzrY5MRo5dgWG462o4dppWdr2AFwTYeakHw5cFTSmX1WjLwbvc7B92kBhO8AA39zJmpX4XYzYxVvmCTbQAmOuDtih3wJ9JJ3bjwb57ToH0yMHGEukDE4KyFvh2uRkeADUlrMyQbDOTrGYYpdjwgTe3Qbhs5PoMBHFt7zwTByxdIeEVPdnwpjvrVzIOxt/i"
`endif