// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


import dphy_pkg::*;

module dphy_byte_control_bhv #(
    parameter base_address = 16'h000,
    parameter internal_base_address = 16'h000,
    parameter lfifo_value = 7'b0000000,
    parameter reset_auto_release = "DISABLED",
    parameter rx_burst_length = 2,
    parameter rx_clock_source = "OFF",
    parameter rx_self_calibration = "DISABLED",
    parameter rx_serializer_rate = "BYPASS",
    parameter rx_usage_mode = "DISABLED",
    parameter rx_io_standard = "RX_IO_STANDARD_IOSTD_OFF",
    parameter rx_sampler_mode = "DISABLED",
    parameter sim_mdelay_value_ps = 0,
    parameter tx_usage_mode = "DISABLED",
    parameter tx_io_standard = "TX_IO_STANDARD_IOSTD_OFF",
    parameter tx_preamble = "OFF",
    parameter tx_serializer_rate = "BYPASS",
    parameter vccn_voltage = "VCCN_VOLTAGE_UNSET",
    parameter vco_freq = 36'h000000000,
    parameter vfifo_value = 7'b0000000,
    parameter pin0_rx_coarse_delay = 0,
    parameter pin0_rx_fine_delay = 7'b0000000,
    parameter pin0_tx_coarse_delay = 0,
    parameter pin0_tx_fine_delay = 7'b0000000,
    parameter pin1_rx_coarse_delay = 0,
    parameter pin1_rx_fine_delay = 7'b0000000,
    parameter pin1_tx_coarse_delay = 0,
    parameter pin1_tx_fine_delay = 7'b0000000,
    parameter pin2_rx_coarse_delay = 0,
    parameter pin2_rx_fine_delay = 7'b0000000,
    parameter pin2_tx_coarse_delay = 0,
    parameter pin2_tx_fine_delay = 7'b0000000,
    parameter pin3_rx_coarse_delay = 0,
    parameter pin3_rx_fine_delay = 7'b0000000,
    parameter pin3_tx_coarse_delay = 0,
    parameter pin3_tx_fine_delay = 7'b0000000,
    parameter pin4_rx_coarse_delay = 0,
    parameter pin4_rx_fine_delay = 7'b0000000,
    parameter pin4_tx_coarse_delay = 0,
    parameter pin4_tx_fine_delay = 7'b0000000,
    parameter pin5_rx_coarse_delay = 0,
    parameter pin5_rx_fine_delay = 7'b0000000,
    parameter pin5_tx_coarse_delay = 0,
    parameter pin5_tx_fine_delay = 7'b0000000,
    parameter pin6_rx_coarse_delay = 0,
    parameter pin6_rx_fine_delay = 7'b0000000,
    parameter pin6_tx_coarse_delay = 0,
    parameter pin6_tx_fine_delay = 7'b0000000,
    parameter pin7_rx_coarse_delay = 0,
    parameter pin7_rx_fine_delay = 7'b0000000,
    parameter pin7_tx_coarse_delay = 0,
    parameter pin7_tx_fine_delay = 7'b0000000,
    parameter pin8_rx_coarse_delay = 0,
    parameter pin8_rx_fine_delay = 7'b0000000,
    parameter pin8_tx_coarse_delay = 0,
    parameter pin8_tx_fine_delay = 7'b0000000,
    parameter pin9_rx_coarse_delay = 0,
    parameter pin9_rx_fine_delay = 7'b0000000,
    parameter pin9_tx_coarse_delay = 0,
    parameter pin9_tx_fine_delay = 7'b0000000,
    parameter pin10_rx_coarse_delay = 0,
    parameter pin10_rx_fine_delay = 7'b0000000,
    parameter pin10_tx_coarse_delay = 0,
    parameter pin10_tx_fine_delay = 7'b0000000,
    parameter pin11_rx_coarse_delay = 0,
    parameter pin11_rx_fine_delay = 7'b0000000,
    parameter pin11_tx_coarse_delay = 0,
    parameter pin11_tx_fine_delay = 7'b0000000,
    parameter pin0_rx_io_standard = "PIN0_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin1_rx_io_standard = "PIN1_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin2_rx_io_standard = "PIN2_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin3_rx_io_standard = "PIN3_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin4_rx_io_standard = "PIN4_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin5_rx_io_standard = "PIN5_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin6_rx_io_standard = "PIN6_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin7_rx_io_standard = "PIN7_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin8_rx_io_standard = "PIN8_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin9_rx_io_standard = "PIN9_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin10_rx_io_standard = "PIN10_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin11_rx_io_standard = "PIN11_RX_IO_STANDARD_IOSTD_OFF", 
    parameter pin0_rx_usage_mode = "PIN0_RX_USAGE_MODE_UNUSED", 
    parameter pin1_rx_usage_mode = "PIN1_RX_USAGE_MODE_UNUSED", 
    parameter pin2_rx_usage_mode = "PIN2_RX_USAGE_MODE_UNUSED", 
    parameter pin3_rx_usage_mode = "PIN3_RX_USAGE_MODE_UNUSED", 
    parameter pin4_rx_usage_mode = "PIN4_RX_USAGE_MODE_UNUSED", 
    parameter pin5_rx_usage_mode = "PIN5_RX_USAGE_MODE_UNUSED", 
    parameter pin6_rx_usage_mode = "PIN6_RX_USAGE_MODE_UNUSED", 
    parameter pin7_rx_usage_mode = "PIN7_RX_USAGE_MODE_UNUSED", 
    parameter pin8_rx_usage_mode = "PIN8_RX_USAGE_MODE_UNUSED", 
    parameter pin9_rx_usage_mode = "PIN9_RX_USAGE_MODE_UNUSED", 
    parameter pin10_rx_usage_mode = "PIN10_RX_USAGE_MODE_UNUSED", 
    parameter pin11_rx_usage_mode = "PIN11_RX_USAGE_MODE_UNUSED", 
    parameter pin0_rx_usage = "PIN0_RX_USAGE_DATA", 
    parameter pin1_rx_usage = "PIN1_RX_USAGE_DATA", 
    parameter pin2_rx_usage = "PIN2_RX_USAGE_DATA", 
    parameter pin3_rx_usage = "PIN3_RX_USAGE_DATA", 
    parameter pin4_rx_usage = "PIN4_RX_USAGE_DATA", 
    parameter pin5_rx_usage = "PIN5_RX_USAGE_DATA", 
    parameter pin6_rx_usage = "PIN6_RX_USAGE_DATA", 
    parameter pin7_rx_usage = "PIN7_RX_USAGE_DATA", 
    parameter pin8_rx_usage = "PIN8_RX_USAGE_DATA", 
    parameter pin9_rx_usage = "PIN9_RX_USAGE_DATA", 
    parameter pin10_rx_usage = "PIN10_RX_USAGE_DATA", 
    parameter pin11_rx_usage = "PIN11_RX_USAGE_DATA", 
    parameter rcven_coarse_delay = "RCVEN_COARSE_DELAY_0",
    parameter rcven_fine_delay = 0,
    parameter rcven_to_read_valid_offset = 0, 
    parameter outputenable_to_wrfifo_offset = 0,
    
    parameter pin0_tx_usage = "PIN0_TX_USAGE_DATA", 
    parameter pin1_tx_usage = "PIN1_TX_USAGE_DATA", 
    parameter pin2_tx_usage = "PIN2_TX_USAGE_DATA", 
    parameter pin3_tx_usage = "PIN3_TX_USAGE_DATA", 
    parameter pin4_tx_usage = "PIN4_TX_USAGE_DATA", 
    parameter pin5_tx_usage = "PIN5_TX_USAGE_DATA", 
    parameter pin6_tx_usage = "PIN6_TX_USAGE_DATA", 
    parameter pin7_tx_usage = "PIN7_TX_USAGE_DATA", 
    parameter pin8_tx_usage = "PIN8_TX_USAGE_DATA", 
    parameter pin9_tx_usage = "PIN9_TX_USAGE_DATA", 
    parameter pin10_tx_usage = "PIN10_TX_USAGE_DATA", 
    parameter pin11_tx_usage = "PIN11_TX_USAGE_DATA"
) ( 
    output logic [1:0] 	o_phyctrl_rddata_valid_lower, 
    output logic [1:0] 	o_phyctrl_rddata_valid_upper, 
    output logic [1:0] 	o_phyctrl_wr_dqs_en4_del, 
    output logic [1:0] 	o_phyctrl_wr_dqs_en5_del, 
    output logic [1:0] 	o_phyctrl_wr_dqs_en6_del, 
    output logic [1:0] 	o_phyctrl_wr_dqs_en7_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en0_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en1_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en2_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en3_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en8_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en9_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en10_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en11_del, 
    output logic [3:0] 	o_phyctrl_tx_picode0, 
    output logic [3:0] 	o_phyctrl_tx_picode1, 
    output logic [3:0] 	o_phyctrl_tx_picode2, 
    output logic [3:0] 	o_phyctrl_tx_picode3, 
    output logic [3:0] 	o_phyctrl_tx_picode4, 
    output logic [3:0] 	o_phyctrl_tx_picode5, 
    output logic [3:0] 	o_phyctrl_tx_picode6, 
    output logic [3:0] 	o_phyctrl_tx_picode7, 
    output logic [3:0] 	o_phyctrl_tx_picode8, 
    output logic [3:0] 	o_phyctrl_tx_picode9, 
    output logic [3:0] 	o_phyctrl_tx_picode10, 
    output logic [3:0] 	o_phyctrl_tx_picode11, 
    output logic [31:0] o_phyctrl_byte_tx_ctrl, 
    output logic 	o_phyctrl_fifo_pack_select, 
    output logic [1:0] 	o_phyctrl_fifo_read_enable_upper, 
    output logic [1:0] 	o_phyctrl_fifo_read_enable_lower, 
    output logic 	o_phyctrl_trainreset, 
    output logic [31:0] o_phyctrl_byte_rx_ctrl, 
    input wire 		i_phyctrl_pll_lock, 
    input wire 		i_phyctrl_avbb_avl_in_clk, 
    input wire 		i_phyctrl_avbb_avl_in_rst_n, 
    input wire 		i_phyctrl_avbb_avl_in_avm_write, 
    input wire 		i_phyctrl_avbb_avl_in_avm_read, 
    input wire [21:0] 	i_phyctrl_avbb_avl_in_avm_address, 
    input wire [31:0] 	i_phyctrl_avbb_avl_in_avm_writedata, 
    input wire [31:0] 	i_phyctrl_avbb_avl_in_avm_readdata, 
    output logic [31:0] o_phyctrl_avbb_avl_out_avm_readdata, 
    input wire [3:0] 	i_phyctrl_rd_rank, 
    input wire [1:0] 	i_phyctrl_rddata_en, 
    input wire [1:0] 	i_phyctrl_wr_dqs0_en, 
    input wire [1:0] 	i_phyctrl_wr_dqs1_en, 
    input wire [3:0] 	i_phyctrl_wr_rank, 
    input wire [1:0] 	i_phyctrl_wrdata_en, 
    input wire 		i_phyctrl_pllvcoclk, 
    input wire 		i_phyctrl_phyclk_sync, 
    input wire 		i_phyctrl_phy_clk, 
    output logic 	o_phyctrl_gated_tx_phy_clk, 
    output logic 	o_phyctrl_gated_rx_phy_clk, 
    output logic 	o_phyctrl_tx_clkrefdivby2, 
    output logic [11:0] o_phyctrl_tx_clkpi, 
    output logic [5:0] 	o_phyctrl_sdll0_dqsp, 
    output logic [5:0] 	o_phyctrl_sdll0_dqsn, 
    output logic [5:0] 	o_phyctrl_sdll1_dqsp, 
    output logic [5:0] 	o_phyctrl_sdll1_dqsn, 
    input wire 		i_phyctrl_rx_dqs_p4, 
    input wire 		i_phyctrl_rx_dqs_n4, 
    input wire 		i_phyctrl_rx_dqs_amp_p5, 
    input wire 		i_phyctrl_rx_dqs_p6, 
    input wire 		i_phyctrl_rx_dqs_n6, 
    input wire 		i_phyctrl_rx_dqs_amp_p7, 
    input wire [11:0] 	i_phyctrl_pa_sideband, 
    input wire 		i_phyctrl_sdll1_dqspin_x16_clk,
    input wire 		i_phyctrl_sdll1_dqsnin_x16_clk,

    input wire 		i_phyctrl_sdll0_dqspin_x16_clk,
    input wire 		i_phyctrl_sdll0_dqsnin_x16_clk,
    output logic 	o_phyctrl_phyclk_notgated,
    output logic 	o_phyctrl_ckx16dqsn_to_bottom,
    output logic 	o_phyctrl_ckx16dqsp_to_bottom,
    output logic 	o_phyctrl_ckx16dqsn_to_top,
    output logic 	o_phyctrl_ckx16dqsp_to_top,


    output logic [11:0] o_phyctrl_rx_senseampen, 
    output logic [5:0] 	o_phyctrl_sdll0_rx_d0pienable, 
    output logic 	o_phyctrl_sdll0_rx_d0rcvenpre, 
    output logic 	o_phyctrl_sdll0_rx_d0reset, 
    output logic 	o_phyctrl_sdll0_rx_d0sdlparkvalue, 
    output logic [5:0] 	o_phyctrl_sdll1_rx_d0pienable, 
    output logic 	o_phyctrl_sdll1_rx_d0rcvenpre, 
    output logic 	o_phyctrl_sdll1_rx_d0reset, 
    output logic 	o_phyctrl_sdll1_rx_d0sdlparkvalue, 
    input wire [4:0] 	i_DCCXtalkControl_DCCSamples,
    input wire 		i_DCCXtalkControl_RunDCC,
    input wire [1:0] 	i_DCCXtalkControl_SelMeasPoint,
    input wire [4:0] 	i_DDRCrRxEQRank01_RxDFETap0Rank0,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap1Rank0,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap2Rank0,
    input wire [2:0] 	i_DDRCrRxEQRank01_RxDFETap3Rank0,
    input wire [4:0] 	i_DDRCrRxEQRank01_RxDFETap0Rank1,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap1Rank1,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap2Rank1,
    input wire [2:0] 	i_DDRCrRxEQRank01_RxDFETap3Rank1,
    input wire [4:0] 	i_DDRCrRxEQRank23_RxDFETap0Rank2,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap1Rank2,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap2Rank2,
    input wire [2:0] 	i_DDRCrRxEQRank23_RxDFETap3Rank2,
    input wire [4:0] 	i_DDRCrRxEQRank23_RxDFETap0Rank3,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap1Rank3,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap2Rank3,
    input wire [2:0] 	i_DDRCrRxEQRank23_RxDFETap3Rank3, 
    input wire [4:0] 	i_mipi_rb_rxdly_direct_ctrl,
    input wire [4:0] 	i_mipi_rx_diff_en,
    input wire [4:0] 	i_mipi_rx_dphylprxen,
    input wire 		i_phyctrl_io_pad_doe_0,
    input wire 		i_phyctrl_io_pad_doe_1,
    input wire 		i_phyctrl_io_pad_doe_2,
    input wire 		i_phyctrl_io_pad_doe_3,
    input wire 		i_phyctrl_io_pad_doe_4,
    input wire 		i_phyctrl_io_pad_doe_5,
    input wire 		i_phyctrl_io_pad_doe_6,
    input wire 		i_phyctrl_io_pad_doe_7,
    input wire 		i_phyctrl_io_pad_doe_8,
    input wire 		i_phyctrl_io_pad_doe_9,
    input wire 		i_phyctrl_io_pad_doe_10,
    input wire 		i_phyctrl_io_pad_doe_11,
    input wire [47:0] 	i_phyctrl_tx_wr_data_pl,
    input wire [11:0] 	i_rx_rxdqsampresult, 
    input wire 		i_rx_x16dqsn_p4,
    input wire 		i_rx_x16dqsp_p4,
    input wire 		i_rxdphylprxen_0,
    input wire 		i_rxdphylprxen_1,
    input wire 		i_rxdphylprxen_2,
    input wire 		i_rxdphylprxen_3,
    input wire 		i_rxdphylprxen_4,
    input wire 		i_rxdphylprxen_5,
    input wire 		i_rxdphylprxen_6,
    input wire 		i_rxdphylprxen_7,
    input wire 		i_rxdphylprxen_8,
    input wire 		i_rxdphylprxen_9,
    input wire 		i_rxdphylprxen_10,
    input wire 		i_rxdphylprxen_11,
    input wire 		i_rxlvdien_0,
    input wire 		i_rxlvdien_1,
    input wire 		i_rxlvdien_2,
    input wire 		i_rxlvdien_3,
    input wire 		i_rxlvdien_4,
    input wire 		i_rxlvdien_5,
    input wire 		i_rxlvdien_6,
    input wire 		i_rxlvdien_7,
    input wire 		i_rxlvdien_8,
    input wire 		i_rxlvdien_9,
    input wire 		i_rxlvdien_10,
    input wire 		i_rxlvdien_11,
    input wire 		i_rzq_en,
    input wire [2:0] 	i_tx_modectrl_4,
    output logic 	o_dcd_ter_en,
    output logic 	o_from_sdll0_o_dcdsawl_clk,
    output logic 	o_from_sdll1_o_dcdsawl_clk,
    output logic [1:0] 	o_io12phyctrl_dqsmode,
    output logic [1:0] 	o_n0_odt_seg_rotate_en,
    output logic [1:0] 	o_n1_odt_seg_rotate_en,
    output logic [11:0] o_odt_en,
    output logic [11:0] o_odt_parken,
    output logic [11:0] o_odt_parken_dqsn,
    output logic 	o_phyctrl_ddrcrdatacontrol0_enodtrotation,
    output logic 	o_phyctrl_ddrcrdatacontrol4_unmatchedrx,
    output logic [11:0] o_phyctrl_dfemuxout_0,
    output logic [11:0] o_phyctrl_dfemuxout_1,
    output logic 	o_phyctrl_o_occ_phy_clk,
    output logic [11:0] o_phyctrl_rcvenmuxout_0,
    output logic [11:0] o_phyctrl_rcvenmuxout_1,
    output logic [1:0] 	o_phyctrl_rddata_en_dly,
    output logic 	o_phyctrl_rx_d0cben,
    output logic 	o_phyctrl_rx_d0drvsel,
    output logic 	o_phyctrl_rxfifo_rb_avm_wr_pipestage,
    output logic 	o_phyctrl_u_io12phyctrl_logic_o_phy_clk_gated,
    output logic        o_phyctrl_u_io12phyctrl_logic_o_phy_reset_n,
    output logic [1:0] 	o_phyctrl_wrdata_en0,
    output logic [1:0] 	o_phyctrl_wrdata_en1,
    output logic [1:0] 	o_phyctrl_wrdata_en2,
    output logic [1:0] 	o_phyctrl_wrdata_en3,
    output logic [1:0] 	o_phyctrl_wr_dqs_en4,
    output logic [1:0] 	o_phyctrl_wr_dqs_en5,
    output logic [1:0] 	o_phyctrl_wr_dqs_en6,
    output logic [1:0] 	o_phyctrl_wr_dqs_en7,
    output logic [1:0] 	o_phyctrl_wrdata_en8,
    output logic [1:0] 	o_phyctrl_wrdata_en9,
    output logic [1:0] 	o_phyctrl_wrdata_en10,
    output logic [1:0] 	o_phyctrl_wrdata_en11,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_00_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_01_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_02_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_03_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_04_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_05_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_06_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_07_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_08_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_09_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_10_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_11_DCCCount,
    output logic 	o_rxfifo_skew,
    output logic [13:0] o_rxfifo_spare,
    input wire 		rxnpathenable_0,
    input wire 		rxnpathenable_1,
    input wire 		rxnpathenable_2,
    input wire 		rxnpathenable_3,
    input wire 		rxnpathenable_4,
    input wire 		rxnpathenable_5,
    input wire 		rxnpathenable_6,
    input wire 		rxnpathenable_7,
    input wire 		rxnpathenable_8,
    input wire 		rxnpathenable_9,
    input wire 		rxnpathenable_10,
    input wire 		rxnpathenable_11,

    input wire 		rxppathenable_0,
    input wire 		rxppathenable_1,
    input wire 		rxppathenable_2,
    input wire 		rxppathenable_3,
    input wire 		rxppathenable_4,
    input wire 		rxppathenable_5,
    input wire 		rxppathenable_6,
    input wire 		rxppathenable_7,
    input wire 		rxppathenable_8,
    input wire 		rxppathenable_9,
    input wire 		rxppathenable_10,
    input wire 		rxppathenable_11,
    input wire 		i_pa_2_phytop_rx_analog_en,
    input wire 		i_pa_2_phytop_tx_analog_en,
    output logic [3:0] 	o_phyctrl_datatrainfeedback_dqsnparklovohcode,
    output logic 	o_phyctrl_datatrainfeedback_dqsnparklowvoh,
    output logic [11:0] o_phyctrl_ddrcrcmdbustrain_ddrdqovrddata,
    output logic [11:0] o_phyctrl_ddrcrcmdbustrain_ddrdqovrdmodeen,
    input wire 		i_phyctrl_cr_iamca_00,
    input wire 		i_phyctrl_cr_iamca_01,
    input wire 		i_phyctrl_cr_iamca_02,
    input wire 		i_phyctrl_cr_iamca_03,
    input wire 		i_phyctrl_cr_iamca_04,
    input wire 		i_phyctrl_cr_iamca_05,
    input wire 		i_phyctrl_cr_iamca_06,
    input wire 		i_phyctrl_cr_iamca_07,
    input wire 		i_phyctrl_cr_iamca_08,
    input wire 		i_phyctrl_cr_iamca_09,
    input wire 		i_phyctrl_cr_iamca_10,
    input wire 		i_phyctrl_cr_iamca_11
);
    timeunit 1ns;
    `ifdef VIP
        timeprecision 1ps;
    `else
        timeprecision 1fs;
   `endif


    localparam DPHY_RX_EN = pin0_rx_usage_mode == "PIN0_RX_USAGE_MODE_UNUSED" ? 1'b0 : 1'b1;
    localparam DPHY_TX_EN = pin0_rx_usage_mode == "PIN0_RX_USAGE_MODE_UNUSED" ? 1'b1 : 1'b0;

    assign o_phyctrl_sdll0_rx_d0reset = 1'b0;
    assign o_phyctrl_sdll0_rx_d0pienable = 1'b1;
    assign o_phyctrl_sdll0_rx_d0rcvenpre = 1'b1;
    assign o_phyctrl_sdll1_rx_d0reset = 1'b0;
    assign o_phyctrl_sdll1_rx_d0pienable = 1'b0;
    assign o_phyctrl_sdll1_rx_d0rcvenpre = 1'b0;


    `define int_COARSE(x,y,z) ( x == `"PIN``y``_``z``_COARSE_DELAY_0`" ? 0 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_1`" ? 1 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_2`" ? 2 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_3`" ? 3 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_4`" ? 4 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_5`" ? 5 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_6`" ? 6 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_7`" ? 7 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_8`" ? 8 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_9`" ? 9 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_10`" ? 10 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_11`" ? 11 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_11`" ? 12 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_11`" ? 13 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_11`" ? 14 : \
                                x == `"PIN``y``_``z``_COARSE_DELAY_11`" ? 15 : "") 


    localparam int PIN_RX_COARSE_DELAY [11:0] = { 
        `int_COARSE(pin11_rx_coarse_delay, 11, RX), `int_COARSE(pin10_rx_coarse_delay, 10, RX),
        `int_COARSE(pin9_rx_coarse_delay, 9, RX), `int_COARSE(pin8_rx_coarse_delay, 8, RX),
        `int_COARSE(pin7_rx_coarse_delay, 7, RX), `int_COARSE(pin6_rx_coarse_delay, 6, RX),
        `int_COARSE(pin5_rx_coarse_delay, 5, RX), `int_COARSE(pin4_rx_coarse_delay, 4, RX),
        `int_COARSE(pin3_rx_coarse_delay, 3, RX), `int_COARSE(pin2_rx_coarse_delay, 2, RX),
        `int_COARSE(pin1_rx_coarse_delay, 1, RX), `int_COARSE(pin0_rx_coarse_delay, 0, RX)} ;
    localparam [6:0] PIN_RX_FINE_DELAY [11:0] = { 
        pin11_rx_fine_delay, pin10_rx_fine_delay,
        pin9_rx_fine_delay, pin8_rx_fine_delay,
        pin7_rx_fine_delay, pin6_rx_fine_delay,
        pin5_rx_fine_delay, pin4_rx_fine_delay,
        pin3_rx_fine_delay, pin2_rx_fine_delay,
        pin1_rx_fine_delay, pin0_rx_fine_delay} ;
    localparam int PIN_TX_COARSE_DELAY [11:0] = { 
        `int_COARSE(pin11_rx_coarse_delay, 11, TX), `int_COARSE(pin10_rx_coarse_delay, 10, TX),
        `int_COARSE(pin9_rx_coarse_delay, 9, TX), `int_COARSE(pin8_rx_coarse_delay, 8, TX),
        `int_COARSE(pin7_rx_coarse_delay, 7, TX), `int_COARSE(pin6_rx_coarse_delay, 6, TX),
        `int_COARSE(pin5_rx_coarse_delay, 5, TX), `int_COARSE(pin4_rx_coarse_delay, 4, TX),
        `int_COARSE(pin3_rx_coarse_delay, 3, TX), `int_COARSE(pin2_rx_coarse_delay, 2, TX),
        `int_COARSE(pin1_rx_coarse_delay, 1, TX), `int_COARSE(pin0_rx_coarse_delay, 0, TX)} ;
    localparam [6:0] PIN_TX_FINE_DELAY [11:0] = { 
        pin11_tx_fine_delay, pin10_tx_fine_delay,
        pin9_tx_fine_delay, pin8_tx_fine_delay,
        pin7_tx_fine_delay, pin6_tx_fine_delay,
        pin5_tx_fine_delay, pin4_tx_fine_delay,
        pin3_tx_fine_delay, pin2_tx_fine_delay,
        pin1_tx_fine_delay, pin0_tx_fine_delay} ;




    `ifdef def_GLITCH_PER
        localparam GLITCH_PER = `def_GLITCH_PER;
    `else
        localparam GLITCH_PER = 0;
    `endif
    
    `ifdef def_CLK_IDLE_CNT
        localparam CLK_IDLE_CNT = `def_CLK_IDLE_CNT;
    `else
        localparam CLK_IDLE_CNT = 8;
    `endif

    `ifdef def_FIFO_RESET_CNT
        localparam FIFO_RESET_CNT = `def_FIFO_RESET_CNT;
    `else
        localparam FIFO_RESET_CNT = 64;
    `endif
    
    logic fwd_clk_en;

   logic [1:0] o_phyctrl_dqs0_en_dfi;   
   logic [1:0] o_phyctrl_dqs1_en_dfi;   
   logic [1:0] o_phyctrl_wrdata_en_dfi;
   
   
    assign o_phyctrl_byte_tx_ctrl = 'h0;    
    assign o_phyctrl_byte_rx_ctrl = 'h0;                 
    assign o_phyctrl_avbb_avl_out_avm_readdata = 'h0;    
    assign o_phyctrl_gated_tx_phy_clk = i_phyctrl_phy_clk;
    assign o_phyctrl_gated_rx_phy_clk = i_phyctrl_phy_clk;
    assign o_phyctrl_tx_clkrefdivby2 = i_phyctrl_phy_clk;


    logic [11:0][3:0] tx_picodes ;
    logic [11:0][1:0] wrdata_en_dels ;  
    logic [1:0] wrdata_en_q [15:0];
    logic [1:0] rddata_en_q [7:0];
    logic rx_dqs_en;
    logic [2:0] rx_dqs_en_sync;
    
    assign {    o_phyctrl_tx_picode11, o_phyctrl_tx_picode10, o_phyctrl_tx_picode9, o_phyctrl_tx_picode8,
                o_phyctrl_tx_picode7, o_phyctrl_tx_picode6, o_phyctrl_tx_picode5, o_phyctrl_tx_picode4,
                o_phyctrl_tx_picode3, o_phyctrl_tx_picode2, o_phyctrl_tx_picode1, o_phyctrl_tx_picode0 } = tx_picodes;
                
    assign {    o_phyctrl_wrdata_en11_del, o_phyctrl_wrdata_en10_del, o_phyctrl_wrdata_en9_del, o_phyctrl_wrdata_en8_del,
                o_phyctrl_wr_dqs_en7_del, o_phyctrl_wr_dqs_en6_del, o_phyctrl_wr_dqs_en5_del, o_phyctrl_wr_dqs_en4_del,
                o_phyctrl_wrdata_en3_del, o_phyctrl_wrdata_en2_del, o_phyctrl_wrdata_en1_del, o_phyctrl_wrdata_en0_del } = wrdata_en_dels ;   

    
    logic vco_dll_lock;
    logic dq_dll_lock;
    logic [15:0] vco_clk_ph;
    shortreal vco_by_16;
    shortreal ui_by_64;

    dll_bhv #( .num_phases(16), .dll_lock(0)
    ) vco_ph_mdll (
        .lock_in( i_phyctrl_pll_lock),                 
        .clk_in(i_phyctrl_pllvcoclk),                  
        .lock_out(vco_dll_lock),                       
        .clk_out(vco_clk_ph),                          
        .ph_step_in(0),                                
        .ph_step(vco_by_16)                            
    );
    assign ui_by_64 = vco_by_16 / 8;

    logic dqs_in;
    assign dqs_in = ( rx_clock_source == "RX_CLOCK_SOURCE_NEIGHBOR_X8_MIPI") ? i_phyctrl_sdll1_dqspin_x16_clk : i_phyctrl_rx_dqs_p4;
    assign o_phyctrl_ckx16dqsn_to_bottom = i_phyctrl_rx_dqs_n4;
    assign o_phyctrl_ckx16dqsp_to_bottom = i_phyctrl_rx_dqs_p4;
    assign o_phyctrl_ckx16dqsn_to_top = i_phyctrl_rx_dqs_n4;
    assign o_phyctrl_ckx16dqsp_to_top = i_phyctrl_rx_dqs_p4;



    logic dqs_in_q;
    logic dqs_started;
    logic clk_idle;
    int clk_idle_cnter;
    logic dqs_clk_en;
    logic [3:0] fwd_clk_tog;
    logic [2:0] dqs_cntr;
    logic [2:0] dqs_cntr_q;

    initial
    begin
        clk_idle_cnter <= 0;
        dqs_started <= 1'b0;
        dqs_cntr <= 0;
        dqs_cntr_q <= 0;
    end
    

    always @(negedge dqs_clk_en or posedge dqs_in)
    begin
        if (dqs_clk_en == 1'b0) 
            dqs_cntr <= 0;
        else
            dqs_cntr <= dqs_cntr + 1;
    end
    
    always @(posedge i_phyctrl_pllvcoclk)
    begin
        dqs_cntr_q <= dqs_cntr;
        dqs_started <= dqs_clk_en & ( &fwd_clk_tog | dqs_started ) ;
    end

    always @(posedge i_phyctrl_pllvcoclk)
    begin
        if(i_phyctrl_rddata_en[0] == 1'b0 || ( clk_idle == 1'b0 && (dqs_cntr_q != dqs_cntr)) )
            clk_idle_cnter <= 0;
        else
            clk_idle_cnter <= ( dqs_started == 1'b1 && clk_idle_cnter < CLK_IDLE_CNT ) ? clk_idle_cnter + 1'b1 : clk_idle_cnter;
    end

    assign clk_idle = clk_idle_cnter == CLK_IDLE_CNT ? 1'b1 : 1'b0;
    assign dqs_clk_en = ~clk_idle;
    assign o_phyctrl_fifo_pack_select = 1'b0;
    assign o_phyctrl_fifo_read_enable_upper = {|rddata_en_q[6], |rddata_en_q[2]};    
    assign o_phyctrl_fifo_read_enable_lower = {|rddata_en_q[6], |rddata_en_q[2]};     
    assign o_phyctrl_trainreset = ~i_phyctrl_pll_lock;

    logic [127:0] dqs_del;
    assign dqs_clk_in = dqs_clk_en & dqs_in;
    dll_bhv #( .num_phases(128), .mdll(0)
    ) dqs_del_sdll (
        .lock_in(vco_dll_lock),                        
        .clk_in(dqs_clk_in),                          
        .lock_out(dq_dll_lock),                         
        .clk_out(dqs_del),                              
        .ph_step_in(ui_by_64),                         
        .ph_step()                                     
    );


    logic fwd_clk_div;
    initial fwd_clk_div <= 1'b0;

    
    always @(posedge dqs_del[10] or negedge dqs_clk_en)
        if(dqs_clk_en==1'b0)
            rx_dqs_en_sync <= 3'h0;
        else
            rx_dqs_en_sync <= { rx_dqs_en_sync[1:0], 1'b1};
    assign rx_dqs_en = rx_dqs_en_sync[2];

    always @(posedge dqs_del[10])
    begin
        fwd_clk_div <= rx_dqs_en == 1'b1 ? ~fwd_clk_div : fwd_clk_div === 1'bx ? 1'b0 : fwd_clk_div;
    end

    always @(posedge fwd_clk_div)
        fwd_clk_tog <= rx_dqs_en === 1'b1 ? {fwd_clk_tog[2:0], 1'b1} :  4'h0;


    
    always @(posedge i_phyctrl_phy_clk)
    begin
        wrdata_en_q <= { wrdata_en_q[14:0], DPHY_TX_EN == 1 && i_phyctrl_pll_lock == 1'b1 ? 2'h3 : 2'h0 };
        rddata_en_q <= { rddata_en_q[6:0], i_phyctrl_rddata_en };
    end
   
    assign o_phyctrl_dqs0_en_dfi = DPHY_TX_EN == 1 && i_phyctrl_pll_lock == 1'b1 ? 2'h3 : 2'h0;
    assign o_phyctrl_dqs1_en_dfi = DPHY_TX_EN == 1 && i_phyctrl_pll_lock == 1'b1 ? 2'h3 : 2'h0;
    assign o_phyctrl_wrdata_en0 = DPHY_TX_EN == 1 && i_phyctrl_pll_lock == 1'b1 ? 2'h3 : 2'h0;

    assign o_phyctrl_rddata_valid_upper = rddata_en_q[2];
    assign o_phyctrl_rddata_valid_lower = rddata_en_q[2];

    genvar p;
    for (p =0; p<12; p++)
    begin : per_pin
        localparam LPIN_RX_FINE_DELAY = PIN_RX_FINE_DELAY[p];
        localparam LPIN_RX_COARSE_DELAY = PIN_RX_COARSE_DELAY[p];
        localparam LPIN_TX_FINE_DELAY = PIN_TX_FINE_DELAY[p];
        localparam LPIN_TX_COARSE_DELAY = PIN_TX_COARSE_DELAY[p];
        localparam pp = (p >> 1);
    
        logic [11:0] deskew_ctrl_dec;
        logic [8:0] deskew_pi_code;
        logic dqs_clk;
        logic dqs_glitch_en ;
        logic dqs_glitch_sig;
        int glitch_cnt;

        initial 
        begin
            dqs_glitch_en <= 'b0;
            deskew_pi_code <= LPIN_RX_FINE_DELAY;
        end

        always @(posedge i_phyctrl_phy_clk)
        begin
            deskew_ctrl_dec[11:0] <= { i_phyctrl_tx_wr_data_pl[p*4 +: 4] , deskew_ctrl_dec[11:4] };
        end
        always @(posedge i_phyctrl_phy_clk)
        begin
            deskew_pi_code <= i_phyctrl_tx_wr_data_pl[p*4+3] === 1'b1 ? { deskew_ctrl_dec[8], deskew_ctrl_dec[6:4], deskew_ctrl_dec[2:0] } : deskew_pi_code;
            dqs_glitch_en <= GLITCH_PER == 0 ? 1'b0 : ( i_phyctrl_tx_wr_data_pl[p*4+3] | dqs_glitch_en );
        end
       
        always @(posedge dqs_glitch_en)
        begin
            for (glitch_cnt = 0; glitch_cnt < GLITCH_PER; glitch_cnt++)
            begin
                 #(glitch_cnt * ui_by_64) dqs_glitch_sig <= $random;
            end
            @(dqs_del) dqs_glitch_en <= 1'b0;
        end
       
        assign dqs_clk = dqs_glitch_en == 1'b1 ? dqs_glitch_sig : dqs_del[deskew_pi_code[6:0]];

        if(p>5)
        begin
            assign o_phyctrl_sdll1_dqsp[p-6] = rx_dqs_en & dqs_clk;
            assign o_phyctrl_sdll1_dqsn[p-6] = ~(rx_dqs_en & dqs_clk);
        end
        else
        begin
            assign o_phyctrl_sdll0_dqsp[p] = rx_dqs_en & dqs_clk;
            assign o_phyctrl_sdll0_dqsn[p] =  rx_dqs_en & dqs_clk;
        end
        
        assign wrdata_en_dels[p] = wrdata_en_q[LPIN_TX_COARSE_DELAY];

        assign o_phyctrl_tx_clkpi[p] = vco_clk_ph[LPIN_TX_FINE_DELAY[6:3]];
        assign tx_picodes[p] = { 1'b0 , LPIN_TX_FINE_DELAY[2:0] };
        
    end

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5DJczsF9atg9xY2Lu7vRbCWS7BK6nHHaGGZ8cHYYeb24jL9K/PiP9WW+/NTg7OmI+XGUIAyfJ187cb4mrRdDLjM3i8jJlsHt6WcPPEqP/JosRrnp8vxcRnF3wcWIWvyBiKf/nY4xaqnXB6ep7ANhdky3mbGdUeS/nMCt5E+ZFilhZTBRsM7aIbfLQ5dAC0Hd6cSRBSn/E1ZputlRNk7lFRTlNyckl0tcWlIjp7UX61T7lJxbiSjHZRPxj98+An5LyJp1DgLRsF2W8dsQ+9SmNQf4q6nqWVLi0XM3qJ/tbb/f4V4J5LIyt+9mnkwZ7XG8a6YKNBSIQJ5WeA6UcVplF9G12x2e3UXMeN2iA4782QH61FMHSdAqhbqcdNcegkAB4FbTHhwGG5ku1UAqg5ar0eI8KBJuA9IypyRbGe0ToeyzOcx+G8LWpeIzXRKxrf9wl3P8V5i7yWqGbz0dU1gxsYpfuz6rzBrItcY6+LaUvQ8CLOqDRe6E1d8zS7QvY2ayjm+RZfyDCeBVok9zqKH0wJPWMyjcB9K3WFIgWNqEQZileJ9HHO9WdMvtqmj3Yp3JMzHcWG8vE6RlHvrsEEk5cTfMXlUlJeN8jC7ynPTIRJcKbd1Hdh4Wnsb1kYS83gnqVTSI5Ir1ugbzQ9MatOvSZ0NB3EOrth3jnseexia6TLhLeTk9BMda141vamsU2KD1YIrbTI67cVWJ5Z63rBV2cewjnA5PSdVvbMvEf5ztcQKG1V98io24X1GkdAtjoAnjLSKRMuhSwaB5RhHsHsFwfjj042DW5Hc5+exJr7B+hMde9zFL4aD7K8xfvXcsbTtPumb28lkcwPmqk0BHLSgP22lFq+Hu4rbt9RHRQWakddlQCpu6VJQGt9sywO+mrsYaIVTbEwLm39AybpDBH/dB6oWI8Q3ktyty8YILWWEhqclvIiEdztjoWKjeX+lN2fPq7OVW8XwJBXUm7J0z00fw9lg4n11ldwy3+A0LwDQmLIbBy3z31qFl9FttIK0Chn7T"
`endif