// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Apr 23 19:05:55 2025
// ============================================================================

//`define ENABLE_DDR4
//`define ENABLE_HPS
`define ENABLE_HDMI
//`define ENABLE_HSMC
`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input              CPU_RESET_n,
      input    [ 3: 0]   KEY,

      ///////// SW /////////
      input    [ 9: 0]   SW,

      ///////// LED /////////
//    output   [ 9: 0]   LEDR,
		output   [ 8: 0]   LEDR,

      ///////// Seg7 /////////
      output   [ 6: 0]   HEX0,
      output   [ 6: 0]   HEX1,
      output   [ 6: 0]   HEX2,
      output   [ 6: 0]   HEX3,
      output   [ 6: 0]   HEX4,
      output   [ 6: 0]   HEX5,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_DDR4
      ///////// DDR4 /////////
      input              DDR4_REFCLK_p,
      output   [16: 0]   DDR4_A,
      output   [ 1: 0]   DDR4_BA,
      output   [ 0: 0]   DDR4_BG,
      output             DDR4_CK,
      output             DDR4_CK_n,
      output             DDR4_CKE,
      inout    [ 3: 0]   DDR4_DQS,
      inout    [ 3: 0]   DDR4_DQS_n,
      inout    [31: 0]   DDR4_DQ,
      inout    [ 3: 0]   DDR4_DBI_n,
      output             DDR4_CS_n,
      output             DDR4_RESET_n,
      output             DDR4_ODT,
      output             DDR4_PAR,
      input              DDR4_ALERT_n,
      output             DDR4_ACT_n,
      input              DDR4_RZQ,
`endif /*ENABLE_DDR4*/

      ///////// Video-In /////////
      input              TD_CLK27,
      input              TD_HS,
      input              TD_VS,
      input    [ 7: 0]   TD_DATA,
      output             TD_RESET_n,

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,
`endif /*ENABLE_HDMI*/

   //  ///////// Audio /////////
   //  inout              AUD_BCLK,
   //  output             AUD_XCK,
   //  inout              AUD_ADCLRCK,
   //  input              AUD_ADCDAT,
   //  inout              AUD_DACLRCK,
   //  output             AUD_DACDAT,

      ///////// ADC /////////
      output             ADC_SCK,
      output             ADC_SDO,
      input              ADC_SDI,
      output             ADC_CS_n,

      ///////// I2C for Camera, Audio and Video-In /////////
      output             FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_HSMC
      ///////// HSMC /////////
      output   [ 3: 0]   HSMC_GTS_TX_p,
      output   [ 3: 0]   HSMC_GTS_TX_n,
      input    [ 3: 0]   HSMC_GTS_RX_p,
      input    [ 3: 0]   HSMC_GTS_RX_n,
      input              HSMC_GTS_RX_REFCLK_p,
      output             HSMC_I2C_SCL,
      inout              HSMC_I2C_SDA,
      input    [ 2: 0]   HSMC_CLK_IN,
      input              HSMC_GTS_REFCLK_p,
      inout    [ 1: 0]   HSMC_B5B_D,
      inout    [76: 0]   HSMC_D,
`endif /*ENABLE_HSMC*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LCM_BK,
      inout              HPS_LCM_D_C,
      inout              HPS_LCM_RST_n,
      output             HPS_LCM_SPIM_CLK,
      output             HPS_LCM_SPIM_MOSI,
      output             HPS_LCM_SPIM_SS,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IR /////////
      output             IRDA_TXD,
      input              IRDA_RXD,

		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d0_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_d1_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotHS,                  //                       csi2_rx_o_ck_ppi_rx_err.ErrSotHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS,              //                                              .ErrSotSyncHS
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrEsc,                    //                                              .ErrEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc,                //                                              .ErrSyncEsc
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrControl,                //                                              .ErrControl
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0,          //                                              .ErrContentionLP0
		output wire        csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1,          //                                              .ErrContentionLP1

		output wire [63:0] csi2_rx_video_streaming_interface_0_tdata,         //           csi2_rx_video_streaming_interface_0.tdata
		output wire        csi2_rx_video_streaming_interface_0_tvalid,        //                                              .tvalid
//		input  wire        csi2_rx_video_streaming_interface_0_tready,        //                                              .tready
		output wire        csi2_rx_video_streaming_interface_0_tlast,         //                                              .tlast
		output wire [7:0]  csi2_rx_video_streaming_interface_0_tuser,         //                                              .tuser
		
		input  wire        csi2_rx_avalon_mm_control_interface_write,         //           csi2_rx_avalon_mm_control_interface.write
		input  wire        csi2_rx_avalon_mm_control_interface_read,          //                                              .read
		input  wire [9:0]  csi2_rx_avalon_mm_control_interface_address,       //                                              .address
		input  wire [31:0] csi2_rx_avalon_mm_control_interface_writedata,     //                                              .writedata
		output wire [31:0] csi2_rx_avalon_mm_control_interface_readdata,      //                                              .readdata
		output wire        csi2_rx_avalon_mm_control_interface_readdatavalid, //                                              .readdatavalid
		output wire        csi2_rx_avalon_mm_control_interface_waitrequest,   //                                              .waitrequest
		input  wire [3:0]  csi2_rx_avalon_mm_control_interface_byteenable,    //                                              .byteenable
		output wire        csi2_rx_avalon_mm_control_interface_interrupt_irq, // csi2_rx_avalon_mm_control_interface_interrupt.irq
//		input  wire        mipi_dphy_rzq_rzq,                                 //                                 mipi_dphy_rzq.rzq
//		input  wire        mipi_dphy_ref_clk_0_clk,                           //                           mipi_dphy_ref_clk_0.clk
		output wire        mipi_dphy_LINK0_link_core_srst_reset_n,            //                mipi_dphy_LINK0_link_core_srst.reset_n
		output wire        mipi_dphy_LINK0_link_core_arst_reset_n,            //                mipi_dphy_LINK0_link_core_arst.reset_n
		input  wire [11:0] mipi_dphy_axi_lite_awaddr,                         //                            mipi_dphy_axi_lite.awaddr
		input  wire        mipi_dphy_axi_lite_awvalid,                        //                                              .awvalid
		output wire        mipi_dphy_axi_lite_awready,                        //                                              .awready
		input  wire [31:0] mipi_dphy_axi_lite_wdata,                          //                                              .wdata
		input  wire [3:0]  mipi_dphy_axi_lite_wstrb,                          //                                              .wstrb
		input  wire        mipi_dphy_axi_lite_wvalid,                         //                                              .wvalid
		output wire        mipi_dphy_axi_lite_wready,                         //                                              .wready
		output wire [1:0]  mipi_dphy_axi_lite_bresp,                          //                                              .bresp
		output wire        mipi_dphy_axi_lite_bvalid,                         //                                              .bvalid
		input  wire        mipi_dphy_axi_lite_bready,                         //                                              .bready
		input  wire [11:0] mipi_dphy_axi_lite_araddr,                         //                                              .araddr
		input  wire        mipi_dphy_axi_lite_arvalid,                        //                                              .arvalid
		output wire        mipi_dphy_axi_lite_arready,                        //                                              .arready
		output wire [31:0] mipi_dphy_axi_lite_rdata,                          //                                              .rdata
		output wire [1:0]  mipi_dphy_axi_lite_rresp,                          //                                              .rresp
		output wire        mipi_dphy_axi_lite_rvalid,                         //                                              .rvalid
		input  wire        mipi_dphy_axi_lite_rready,                         //                                              .rready
		input  wire [2:0]  mipi_dphy_axi_lite_arprot,                         //                                              .arprot
		input  wire [2:0]  mipi_dphy_axi_lite_awprot,                         //                                              .awprot
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dp,              //                       mipi_dphy_LINK0_dphy_io.dphy_link_dp
//		input  wire [1:0]  mipi_dphy_LINK0_dphy_io_dphy_link_dn,              //                                              .dphy_link_dn
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cp,              //                                              .dphy_link_cp
//		input  wire        mipi_dphy_LINK0_dphy_io_dphy_link_cn,              //                                              .dphy_link_cn
		output wire        mipi_dphy_reg_bus_reg_wr_en_o,                     //                             mipi_dphy_reg_bus.reg_wr_en_o
		output wire        mipi_dphy_reg_bus_reg_rd_en_o,                     //                                              .reg_rd_en_o
		output wire [10:0] mipi_dphy_reg_bus_reg_raddr_o,                     //                                              .reg_raddr_o
		output wire [10:0] mipi_dphy_reg_bus_reg_waddr_o,                     //                                              .reg_waddr_o
		output wire [3:0]  mipi_dphy_reg_bus_reg_be_o,                        //                                              .reg_be_o
		output wire [31:0] mipi_dphy_reg_bus_reg_din_o,                       //                                              .reg_din_o
		input  wire [31:0] mipi_dphy_reg_bus_reg_dout_i ,                     //                                              .reg_dout_i
		output wire        axi_clock                     //                    rx_axi4s_clk_bridge_in_clk.clk
				
		

);
//------TV decoder reset release
assign TD_RESET_n  =1 ;
 
//======================================================
// default
//=======================================================

//=======================================================
//  Structural coding
//=======================================================
//---AV PLL 
wire  AV_locked ;
wire  pll_12M288; 

AV_PLL u_AV_PLL(
    .refclk       (CLOCK1_50     ),
    .outclk_0     (vpg_pclk      ),//25.5MHZ
    .outclk_1     (pll_12M288    ),//12.288136Mhz
    .locked       (AV_locked     ),
	 .rst          (~reset_n      )
);
assign SYSTEM_50MHZ =CLOCK1_50;//

//--csi2/phy/i2c clock generater
wire pll_locked;
wire axi_clock;
wire dphy_clock;
wire mipi_dphy_ref_clk;
wire SYSTEM_50MHZ;

iopll iopll_inst (
		.refclk   (CLOCK0_50  ),   
		.locked   (pll_locked),  
		.rst      (~reset_n  ), 
		.outclk_0 (axi_clock ) 
	);

	
//---INIT RESET 
wire ninit_done;
	ResetRelease ResetRelease_inst (
		.ninit_done (ninit_done)  
	);
	
//--RESET 	
wire reset_n;
assign reset_n = ~ninit_done;	


//---IMX519_AK7375 RESET ----  
wire        RESET_N_DELAY ; 
RESET_DELY  u_RESET_DELY(
           .BUTTON_N     ( HDMI_READY   ),
           .OSC          ( SYSTEM_50MHZ ) , 
           .RESET_n      ( RESET_N_DELAY)  
);

//----- IMX519 i2c set -----------
`define CMD_CCD_INIT        4'd01  // init. cmd_param0=0 for 1080p; other values are reserved.
`define CMD_CCD_EXPOSRE     4'd02  // exposure value = cmd_param0,  range:0x0020~0xffbc, defualt:0x3e8
`define CMD_CCD_ANALOG_GAIN 4'd03  // analog gain value = cmd_param0, range:0x0100~0xffff, defualt:0x0100
`define CMD_CCD_COLOR_BAL   4'd04  // color balance. blue gain = cmd_param0, red gain = cmd_param1

`define CMD_VCM_ACTIVE      4'd10  // vcm power on
`define CMD_VCM_STANDBY     4'd11  // vcm power off
`define CMD_VCM_POS         4'd12  // set vcm pos = param0, range:0~65535

wire [3:0] cmd         ;    
wire [15:0]cmd_param0  ;  
wire [15:0]cmd_param1  ; 
wire       cmd_start   ;  
wire       cmd_done    ;  
wire       cmd_done_err;


wire [3:0] cmd         ;    
wire [15:0]cmd_param0  ;  
wire [15:0]cmd_param1  ; 
wire       cmd_start   ;  
wire       cmd_done    ;  
wire       cmd_done_err;
wire [3:0] rcmd  ; 
wire [3:0] rcmd         ;    
wire [15:0]rcmd_param0  ;  
wire [15:0]rcmd_param1  ; 
wire       rcmd_start   ;  
wire       rcmd_done    ;  
wire       rcmd_done_err;


ffio u_fifo( //<-----timing for different clock domain  //40bit wigth
		/*input  wire [39:0] */.data     ( { cmd_param1 , cmd_param0, cmd, cmd_start}),     
		/*output wire [39:0] */.q        ( { rcmd_param1,rcmd_param0,rcmd,rcmd_start}),        
		/*input  wire [0:0]  */.wraddress(0), 
		/*input  wire [0:0]  */.rdaddress(0), 
		/*input  wire        */.wren     (1), 
		/*input  wire        */.wrclock  (HDMI_TX_CLK),  
		/*input  wire        */.rdclock  (CLK_400K   )  
	);
	
ffio2 u_fifo2( //<-----timing for different clock domain  //40bit wigth
		/*input  wire [1:0] */.data     ( {  rcmd_done, rcmd_done_err} ),     
		/*output wire [1:0] */.q        ( {  cmd_done, cmd_done_err  } ),        
		/*input  wire [0:0] */.wraddress(0), 
		/*input  wire [0:0] */.rdaddress(0), 
		/*input  wire       */.wren     (1), 
		/*input  wire       */.wrclock  (CLK_400K   ), 
		/*input  wire       */.rdclock  (HDMI_TX_CLK)
	);	
wire CLK_400K;
wire CAM_I2C_SCLK ; 
IMX519_AK7375  IMX519_AK7375_inst (
    .clk50       (SYSTEM_50MHZ  ),
	 .CLK_400K    (CLK_400K      ),
    .reset_n     (RESET_N_DELAY ),
    .i2c_clk     (CAM_I2C_SCLK   ),
    .i2c_dat     (FPGA_I2C_SDAT ),
    //
    .cmd         (rcmd         ),//input    
    .cmd_param0  (rcmd_param0  ),//input
    .cmd_param1  (rcmd_param1  ),//input
    .cmd_start   (rcmd_start   ),//input
    .cmd_done    (rcmd_done    ), //out  
    .cmd_done_err(rcmd_done_err)  //out 

);
assign LEDR[4]  = ~cmd_done ;

assign FPGA_I2C_SCLK = (~HDMI_READY)?HDMI_I2C_SCLK:CAM_I2C_SCLK ; 

//---set IMX519_AK7375 ip controller       
//KEY0: White Balance
//KEY1: Auto Focus 
//KEY2: Reset to Initial
//SW3 : Color Bar

IMX519_AK7375_ctl IMX519_AK7375_ctl_int (
.iCLK         (HDMI_TX_CLK  ),
.iRST_N       (IMX519_AK7375_ctl_RESET_N),
.iKEY         (KEY[2:0]  ),
.iVS          (VS_NS        ),  
.oCMD         (cmd          ),   
.oCMD_PARAM0  (cmd_param0   ),   
.oCMD_PARAM1  (cmd_param1   ),   
.oCMD_START   (cmd_start    ),   
.iCMD_DONE    (cmd_done     ),    
.iCMD_DONE_ERR(cmd_done_err ),
// Auto color blance parameter input
.iBLUE_GAIN   (B_gain),//16'h0213),//default
.iRED_GAIN    (R_gain),//16'h01bc),//default

// Auto foucus parameter input
.oAUTO_FOC    (AUTO_FOC),
.iVCM_DATA    (VCM_DATA),
.iVCM_END     (VCM_END ),
.oAUTO_OPEN   (AUTO_OPEN)
);//


//--sync reset
wire IMX519_AK7375_ctl_RESET_N;
altera_std_synchronizer #(
    .depth      (3)
) IMX519_AK7375_ctl_sync (
    .clk        (HDMI_TX_CLK), 
    .reset_n    (1'b1),
    .din        (RESET_N_DELAY), 
    .dout       (IMX519_AK7375_ctl_RESET_N)
);

//------AOTO FOCUS ADJ  --
wire [7:0]RR;
wire [7:0]GG;
wire [7:0]BB;

wire       AUTO_FOC;
wire       AUTO_OPEN ; 
wire [15:0]VCM_DATA;
wire       VCM_END ;
wire  [9:0]STEP    ;
FOCUS_ADJ FOCUS_ADJ_inst(
          .RESET_N       ( RESET_N_DELAY),
          .RESET_SUB_N   ( RESET_N_DELAY),
          .AUTO_FOC      (AUTO_FOC),
			 .AUTO_OPEN     (AUTO_OPEN),
          .VCM_DATA      (VCM_DATA),
          .VCM_END       (VCM_END ),
          .STEP          (STEP    ),
          .SW_Y          ( 0 ),
          .SW_H_FREQ     ( 0 ),   
          .SW_FUC_LINE   ( 0),    
          .SW_FUC_ALL_CEN( 0),
          .VS_NS         ( VS_NS ),
          .HS_NS         ( HS_NS ),
          .VIDEO_CLK     ( HDMI_TX_CLK ),
			 .VIDEO_DE      ( HDMI_TX_DE ) ,
						 
          .iR            ( RED  ), 
          .iG            ( GREEN), 
          .iB            ( BLUE ), 
			 
          .oR            ( RR), 
          .oG            ( GG), 
          .oB            ( BB)
  
 );  
 assign LEDR[3]  = ~VCM_END ;


 

                  
wire [63:0] csi2_rx_video_streaming_interface_0_tdata  /*synthesis keep*/;                   
wire        csi2_rx_video_streaming_interface_0_tvalid /*synthesis keep*/;                  
wire        csi2_rx_video_streaming_interface_0_tready /*synthesis keep*/;                  
wire        csi2_rx_video_streaming_interface_0_tlast /*synthesis keep*/;                   
wire [3:0]  csi2_rx_video_streaming_interface_0_tuser /*synthesis keep*/;              
	
//---MIPI PHY REFCLOCK--
assign mipi_dphy_ref_clk =CLOCK2_50;// ;

//--CSI2 IP , DPHY--
csi2_dphy_sys csi2_dphy_sys_cam (
      .rx_axi4s_clk_bridge_in_clk_clk		               (axi_clock),
		.csi2_rx_o_d0_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d0_ppi_rx_err_ErrSotHS),                 
		.csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d0_ppi_rx_err_ErrSotSyncHS),             
		.csi2_rx_o_d0_ppi_rx_err_ErrEsc                    (csi2_rx_o_d0_ppi_rx_err_ErrEsc),                   
		.csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d0_ppi_rx_err_ErrSyncEsc),               
		.csi2_rx_o_d0_ppi_rx_err_ErrControl                (csi2_rx_o_d0_ppi_rx_err_ErrControl),               
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP0),         
		.csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d0_ppi_rx_err_ErrContentionLP1),         
		.csi2_rx_o_d1_ppi_rx_err_ErrSotHS                  (csi2_rx_o_d1_ppi_rx_err_ErrSotHS),                 
		.csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_d1_ppi_rx_err_ErrSotSyncHS),             
		.csi2_rx_o_d1_ppi_rx_err_ErrEsc                    (csi2_rx_o_d1_ppi_rx_err_ErrEsc),                   
		.csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_d1_ppi_rx_err_ErrSyncEsc),               
		.csi2_rx_o_d1_ppi_rx_err_ErrControl                (csi2_rx_o_d1_ppi_rx_err_ErrControl),               
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP0),         
		.csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_d1_ppi_rx_err_ErrContentionLP1),         
		.csi2_rx_o_ck_ppi_rx_err_ErrSotHS                  (csi2_rx_o_ck_ppi_rx_err_ErrSotHS),                 
		.csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS              (csi2_rx_o_ck_ppi_rx_err_ErrSotSyncHS),             
		.csi2_rx_o_ck_ppi_rx_err_ErrEsc                    (csi2_rx_o_ck_ppi_rx_err_ErrEsc),                   
		.csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc                (csi2_rx_o_ck_ppi_rx_err_ErrSyncEsc),               
		.csi2_rx_o_ck_ppi_rx_err_ErrControl                (csi2_rx_o_ck_ppi_rx_err_ErrControl),               
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP0),         
		.csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1          (csi2_rx_o_ck_ppi_rx_err_ErrContentionLP1), 
		
		.csi2_rx_video_streaming_interface_0_tdata         (csi2_rx_video_streaming_interface_0_tdata),        
		.csi2_rx_video_streaming_interface_0_tvalid        (csi2_rx_video_streaming_interface_0_tvalid),       
		.csi2_rx_video_streaming_interface_0_tready        (csi2_rx_video_streaming_interface_0_tready),       
		.csi2_rx_video_streaming_interface_0_tlast         (csi2_rx_video_streaming_interface_0_tlast),        
		.csi2_rx_video_streaming_interface_0_tuser         (csi2_rx_video_streaming_interface_0_tuser),        
		
		.csi2_rx_avalon_mm_control_interface_write         (csi2_rx_avalon_mm_control_interface_write),        
		.csi2_rx_avalon_mm_control_interface_read          (csi2_rx_avalon_mm_control_interface_read),         
		.csi2_rx_avalon_mm_control_interface_address       (csi2_rx_avalon_mm_control_interface_address),      
		.csi2_rx_avalon_mm_control_interface_writedata     (csi2_rx_avalon_mm_control_interface_writedata),    
		.csi2_rx_avalon_mm_control_interface_readdata      (csi2_rx_avalon_mm_control_interface_readdata),     
		.csi2_rx_avalon_mm_control_interface_readdatavalid (csi2_rx_avalon_mm_control_interface_readdatavalid),
		.csi2_rx_avalon_mm_control_interface_waitrequest   (csi2_rx_avalon_mm_control_interface_waitrequest),  
		.csi2_rx_avalon_mm_control_interface_byteenable    (csi2_rx_avalon_mm_control_interface_byteenable),   
		.csi2_rx_avalon_mm_control_interface_interrupt_irq (csi2_rx_avalon_mm_control_interface_interrupt_irq),
		.mipi_dphy_rzq_rzq                                 (CAM_RZQ1  ),                                
		.mipi_dphy_ref_clk_0_clk                           (mipi_dphy_ref_clk),                          
		.mipi_dphy_LINK0_link_core_srst_reset_n            (mipi_dphy_LINK0_link_core_srst_reset_n),           
		.mipi_dphy_LINK0_link_core_arst_reset_n            (mipi_dphy_LINK0_link_core_arst_reset_n),           

		.mipi_dphy_axi_lite_awaddr                         (mipi_dphy_axi_lite_awaddr),                        
		.mipi_dphy_axi_lite_awvalid                        (mipi_dphy_axi_lite_awvalid),                       
		.mipi_dphy_axi_lite_awready                        (mipi_dphy_axi_lite_awready),                       
		.mipi_dphy_axi_lite_wdata                          (mipi_dphy_axi_lite_wdata),                         
		.mipi_dphy_axi_lite_wstrb                          (mipi_dphy_axi_lite_wstrb),                         
		.mipi_dphy_axi_lite_wvalid                         (mipi_dphy_axi_lite_wvalid),                        
		.mipi_dphy_axi_lite_wready                         (mipi_dphy_axi_lite_wready),                        
		.mipi_dphy_axi_lite_bresp                          (mipi_dphy_axi_lite_bresp),                         
		.mipi_dphy_axi_lite_bvalid                         (mipi_dphy_axi_lite_bvalid),                        
		.mipi_dphy_axi_lite_bready                         (mipi_dphy_axi_lite_bready),                        
		.mipi_dphy_axi_lite_araddr                         (mipi_dphy_axi_lite_araddr),                        
		.mipi_dphy_axi_lite_arvalid                        (mipi_dphy_axi_lite_arvalid),                       
		.mipi_dphy_axi_lite_arready                        (mipi_dphy_axi_lite_arready),                       
		.mipi_dphy_axi_lite_rdata                          (mipi_dphy_axi_lite_rdata),                         
		.mipi_dphy_axi_lite_rresp                          (mipi_dphy_axi_lite_rresp),                         
		.mipi_dphy_axi_lite_rvalid                         (mipi_dphy_axi_lite_rvalid),                        
		.mipi_dphy_axi_lite_rready                         (mipi_dphy_axi_lite_rready),                        
		.mipi_dphy_axi_lite_arprot                         (mipi_dphy_axi_lite_arprot),                        
		.mipi_dphy_axi_lite_awprot                         (mipi_dphy_axi_lite_awprot),   
		
		.mipi_dphy_LINK0_dphy_io_dphy_link_dp              (CAM_D_p),               
		.mipi_dphy_LINK0_dphy_io_dphy_link_dn              (CAM_D_n),               
		.mipi_dphy_LINK0_dphy_io_dphy_link_cp              (CAM_CLK_p),             
		.mipi_dphy_LINK0_dphy_io_dphy_link_cn              (CAM_CLK_n),             
		.mipi_dphy_reg_bus_reg_wr_en_o                     (mipi_dphy_reg_bus_reg_wr_en_o),                   
		.mipi_dphy_reg_bus_reg_rd_en_o                     (mipi_dphy_reg_bus_reg_rd_en_o),                   
		.mipi_dphy_reg_bus_reg_raddr_o                     (mipi_dphy_reg_bus_reg_raddr_o),                   
		.mipi_dphy_reg_bus_reg_waddr_o                     (mipi_dphy_reg_bus_reg_waddr_o),                   
		.mipi_dphy_reg_bus_reg_be_o                        (mipi_dphy_reg_bus_reg_be_o),                      
		.mipi_dphy_reg_bus_reg_din_o                       (mipi_dphy_reg_bus_reg_din_o),                                                                 
		.mipi_dphy_reg_bus_reg_dout_i                      (mipi_dphy_reg_bus_reg_dout_i)                                                                 
	);

//-----Freq measure----	
wire  M50_1HZ ; 
CLOCKMEM    ck0            ( .RESET_n(1),.CLK     (CLK_50_B6A )  ,  .CLK_FREQ (50_000_000),.CK_1HZ( M50_1HZ ) ) ;
FRE_MEASURE f_axi_clock    ( .RESET_n(1),.MES_CLK (axi_clock  )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 	
FRE_MEASURE f_dphy_clock   ( .RESET_n(1),.MES_CLK (dphy_clock )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 	
	
	
//-----heart ----
CLOCKMEM  ckK0( .RESET_n(1), .CLK(HDMI_TX_CLK    ) ,.CLK_FREQ ( 74_250_000 )  ,.CK_1HZ  (LEDR[0] ) ) ;
CLOCKMEM  ckK1( .RESET_n(1), .CLK(AUD_DACLRCK    ) ,.CLK_FREQ ( 48_000     )  ,.CK_1HZ  (LEDR[1] ) ) ;
CLOCKMEM  ckK2( .RESET_n(1), .CLK(SYSTEM_50MHZ   ) ,.CLK_FREQ ( 50_000_000 )  ,.CK_1HZ  (LEDR[7] ) ) ;
CLOCKMEM  ckK3( .RESET_n(1), .CLK(AUD_CTRL_CLk   ) ,.CLK_FREQ ( 12_288_000 )  ,.CK_1HZ  (LEDR[8] ) ) ;



//-----AXI stream analyzer
wire [31:0]fr_line_cnt ;
wire [31:0]fr_line_pixel_cnt ; 


AXI_Stream_Analyze #(
 .PIXEL_PER_BEAT ( PIXEL_PER_BEAT )
) 
AXI_Stream_Analyze_inst(
	.reset_n    (reset_n  ),
	.axi_clock  (axi_clock),
	.axi_tdata  (csi2_rx_video_streaming_interface_0_tdata),
	.axi_tvalid (csi2_rx_video_streaming_interface_0_tvalid),
	.axi_tready (csi2_rx_video_streaming_interface_0_tready),
	.axi_tlast  (csi2_rx_video_streaming_interface_0_tlast),
	.axi_tuser  (csi2_rx_video_streaming_interface_0_tuser),
	
	// video out
	.o_video_clk        (fr_wrclock    ),
	.o_video_pix3       (fr_data[39:30]),
	.o_video_pix2       (fr_data[29:20]),
	.o_video_pix1       (fr_data[19:10]),
	.o_video_pix0       (fr_data[ 9: 0]),	
	.o_video_valid      (fr_video_valid       ),
	.o_video_frame_start(fr_video_frame_start ),
	.o_video_pix_cnt    (fr_wraddress  ),
	.o_line_cnt         (fr_line_cnt),
	.o_line_pixel_cnt   (fr_line_pixel_cnt)
	
	
);

//---on-chip memeory 
wire [39:0] fr_data/*synthesis keep*/;
wire [39:0] wr_data/*synthesis keep*/;
       
wire [39:0] fr_q_out     /*synthesis keep*/;         
wire [23:0] fr_wraddress /*synthesis keep*/;
wire [23:0] fr_rdaddress /*synthesis keep*/;      
wire        fr_wrclock   /*synthesis keep*/;

wire        fr_video_frame_start /*synthesis keep*/; 
wire        fr_video_valid /*synthesis keep*/;	
 

//---on-chip memeory 
wire [39:0] fr_data/*synthesis keep*/;
wire [39:0] wr_data/*synthesis keep*/;
reg  [39:0] fr_q         /*synthesis keep*/;         
wire [39:0] fr_q_out     /*synthesis keep*/;         
wire [23:0] fr_wraddress /*synthesis keep*/;
wire [23:0] fr_rdaddress /*synthesis keep*/;      
wire        fr_wrclock   /*synthesis keep*/;
wire        fr_rdclock   /*synthesis keep*/; 
wire        fr_video_frame_start /*synthesis keep*/; 
wire        fr_video_valid /*synthesis keep*/;	
wire        fr_wren /*synthesis keep*/;
//---Write Frame Counter 
reg  [23:0] wr_cnt; 

//---640X480 VEDIO TO RAM
assign fr_wren =fr_video_valid & (
             (fr_line_pixel_cnt>=320) & (fr_line_pixel_cnt<960) &
             (fr_line_cnt>=120) & (fr_line_cnt<600) 
             ) ;
				 
always @(posedge fr_video_frame_start or posedge  fr_wrclock)
		if (fr_video_frame_start) wr_cnt<=0;
		else if (fr_wren ) wr_cnt<= wr_cnt+1;
				 
//---Frame Buffer 
FRAME_RAM u_FRAME_RAM (
		  .wren      (fr_wren     ),
		  .wrclock   (fr_wrclock  ),
		  .wraddress (wr_cnt      ),
        .data      (fr_data     ),

		  .q         (fr_q_out    ),
		  .rdaddress (fr_rdaddress),
		  .rdclock   (fr_rdclock  )
	);
	
	
	
//--frame read 
always @(negedge fr_rdclock	) fr_q <= fr_q_out  ; 
assign fr_rdaddress  = rd_cnt[23:2];  
assign fr_rdclock    = rd_cnt[1];

// fram buffer read-counter 
reg [23:0]rd_cnt; 
always@ (negedge VS_NS or posedge HDMI_TX_CLK ) 
     if (!VS_NS)     rd_cnt <= 0;
else if (HDMI_TX_DE) rd_cnt <= rd_cnt+1; 

//--- frame out data
wire  [9:0] RD_DATA; 
assign RD_DATA = (
(rd_cnt[1:0]==0)?fr_q[ 9:0]  : ( 
(rd_cnt[1:0]==1)?fr_q[19:10] : ( 
(rd_cnt[1:0]==2)?fr_q[29:20] : ( 
(rd_cnt[1:0]==3)?fr_q[39:30] : fr_q[39:30]
)))
);

//---- H/V sync polarity processing	
wire VS_NS;//negative polarity
wire HS_NS;//negative polarity

AUTO_SYNC_MODIFY  RE(
       .pout0(fr_q_out[9+00:0+00]),
       .pout1(fr_q_out[9+10:0+10]),
       .pout2(fr_q_out[9+20:0+20]),
       .pout3(fr_q_out[9+30:0+30]),
       .PCLK     ( HDMI_TX_CLK ),
       .VS       ( HDMI_TX_VS),
       .HS       ( HDMI_TX_HS),
       .M_VS     ( VS_NS),
       .M_HS     ( HS_NS)
) ;
parameter PIXEL_PER_BEAT = 4;
parameter H_res = 640 ;//H_resolution 
parameter V_res = 480 ;//V_resolution 
parameter VEDIO_DATA = H_res*V_res/PIXEL_PER_BEAT;
//-- RAW10 to RGB 
wire [7:0]  RED  ; 
wire [7:0]  GREEN;
wire [7:0]  BLUE ;	
wire [15:0] R_gain	;
wire [15:0] B_gain	;
wire [9:0] RAW_DATA ; 
assign RAW_DATA = (fr_rdaddress<VEDIO_DATA)? RD_DATA[9:0]:0 ;

RAW2RGB_J #(
  .VAL_LINE_MAX (H_res), 
  .VAL_HIGH_MAX (V_res)
)u_RAW2RGB_J	(	
	.iDATA        ( RAW_DATA ),
   .VGA_CLK      ( HDMI_TX_CLK ),
   .READ_Request ( HDMI_TX_DE),
   .VGA_VS       ( VS_NS ),	
	.VGA_HS       ( HS_NS ) , 	                  			
	.oRed         ( RED   ),
	.oGreen       ( GREEN ),
	.oBlue        ( BLUE  ),
	.R_gain       ( R_gain),
   .B_gain       ( B_gain)
	);
						
//--HDMI DATA output SW[3]=1 color par out, SW[3]=0 video out
assign HDMI_TX_D[23:16]	=	SW[3]?vpg_r:RR;
assign HDMI_TX_D[15:8] 	=	SW[3]?vpg_g:GG;
assign HDMI_TX_D[7:0]  	=	SW[3]?vpg_b:BB;

//--HDMI timing generater & //pattern generator
wire [7:0] vpg_r;
wire [7:0] vpg_g;
wire [7:0] vpg_b;				
vpg	u_vpg (
	.vpg_pclk    (vpg_pclk   ),//vedio clock input
	.reset_n     (reset_n    ),    
	.vpg_de      (HDMI_TX_DE ),
	.vpg_hs      (HDMI_TX_HS ),
	.vpg_vs      (HDMI_TX_VS ),
	.vpg_pclk_out(HDMI_TX_CLK),
	.vpg_r       (vpg_r),
	.vpg_g       (vpg_g),
	.vpg_b       (vpg_b)
	);
								
//--  HDMI I2C	SETTING
wire HDMI_READY ;
wire HDMI_I2C_SCLK ; 
I2C_HDMI_Config u_I2C_HDMI_Config (
	              .iCLK       (SYSTEM_50MHZ  ),
	              .iRST_N     (reset_n & KEY[3]),
	              .I2C_SCLK   (HDMI_I2C_SCLK ),
	              .I2C_SDAT   (FPGA_I2C_SDAT ),
	              .HDMI_TX_INT(HDMI_TX_INT   ),
	              .READY      (HDMI_READY    ) 	
	            );
			
					
//-- HDMI SET READY	
assign LEDR[2] = ~HDMI_READY	 ;


//---Audio Master L/RCLK , BCK ,DATA  generater 
wire AUD_BCLK   ;
wire DAC_DACDAT ;
wire AUD_DACLRCK;
wire AUD_CTRL_CLK ; 
assign AUD_CTRL_CLK =pll_12M288;

AUDIO_DAC 	u13	(	//	Audio Side
					.oAUD_BCK       (AUD_BCLK        ),
					.oAUD_DATA      (DAC_DACDAT      ),
					.oAUD_LRCK      (AUD_DACLRCK     ),
					//	Control Signals
					.iSrc_Select    (2'b00           ),
			      .iCLK_18_4      (AUD_CTRL_CLK    ),//12.288000MHz --12.288136Mhz
					.iRST_N         (HDMI_READY      )
					);
										
// HDMI  SOUND MCLK
assign HDMI_MCLK   =	AUD_CTRL_CLK;
							
// 1Khz sine-tone output to HDMI
assign HDMI_I2S   = DAC_DACDAT;					
assign HDMI_SCLK  = AUD_BCLK     ;
assign HDMI_LRCLK = AUD_DACLRCK  ;	


//--led
assign LEDR[5]    = ~reset_n;
assign LEDR[6]    = ~RESET_N_DELAY;



endmodule
