// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



// synopsys translate_off
`timescale 1 ps / 1 ps
// synopsys translate_on
module  Sdram_WR_FIFO_fifo_1927_otmk5oy  (
    aclr,
    data,
    rdclk,
    rdreq,
    wrclk,
    wrreq,
    q,
    rdempty,
    rdusedw,
    wrfull,
    wrusedw);

    input    aclr;
    input  [15:0]  data;
    input    rdclk;
    input    rdreq;
    input    wrclk;
    input    wrreq;
    output [15:0]  q;
    output   rdempty;
    output [8:0]  rdusedw;
    output   wrfull;
    output [8:0]  wrusedw;
`ifndef ALTERA_RESERVED_QIS
// synopsys translate_off
`endif
    tri0     aclr;
`ifndef ALTERA_RESERVED_QIS
// synopsys translate_on
`endif

    wire [15:0] sub_wire0;
    wire  sub_wire1;
    wire [8:0] sub_wire2;
    wire  sub_wire3;
    wire [8:0] sub_wire4;
    wire [15:0] q = sub_wire0[15:0];
    wire  rdempty = sub_wire1;
    wire [8:0] rdusedw = sub_wire2[8:0];
    wire  wrfull = sub_wire3;
    wire [8:0] wrusedw = sub_wire4[8:0];

    dcfifo  dcfifo_component (
                .aclr (aclr),
                .data (data),
                .rdclk (rdclk),
                .rdreq (rdreq),
                .wrclk (wrclk),
                .wrreq (wrreq),
                .q (sub_wire0),
                .rdempty (sub_wire1),
                .rdusedw (sub_wire2),
                .wrfull (sub_wire3),
                .wrusedw (sub_wire4),
                .eccstatus (),
                .rdfull (),
                .wrempty ());
    defparam
        dcfifo_component.enable_ecc  = "FALSE",
        dcfifo_component.intended_device_family  = "Agilex 5",
        dcfifo_component.lpm_hint  = "RAM_BLOCK_TYPE=M20K,DISABLE_DCFIFO_EMBEDDED_TIMING_CONSTRAINT=TRUE",
        dcfifo_component.lpm_numwords  = 512,
        dcfifo_component.lpm_showahead  = "OFF",
        dcfifo_component.lpm_type  = "dcfifo",
        dcfifo_component.lpm_width  = 16,
        dcfifo_component.lpm_widthu  = 9,
        dcfifo_component.overflow_checking  = "ON",
        dcfifo_component.rdsync_delaypipe  = 4,
        dcfifo_component.read_aclr_synch  = "OFF",
        dcfifo_component.underflow_checking  = "ON",
        dcfifo_component.use_eab  = "ON",
        dcfifo_component.write_aclr_synch  = "OFF",
        dcfifo_component.wrsync_delaypipe  = 4;


endmodule


