// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Apr 16 01:52:48 2025
// ============================================================================

`define ENABLE_DDR4
//`define ENABLE_HPS
//`define ENABLE_HDMI
//`define ENABLE_HSMC
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input              CPU_RESET_n,
      input    [ 3: 0]   KEY,

      ///////// SW /////////
      input    [ 9: 0]   SW,

      ///////// LED /////////
      output   [ 9: 0]   LEDR,

      ///////// Seg7 /////////
      output   [ 6: 0]   HEX0,
      output   [ 6: 0]   HEX1,
      output   [ 6: 0]   HEX2,
      output   [ 6: 0]   HEX3,
      output   [ 6: 0]   HEX4,
      output   [ 6: 0]   HEX5,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_DDR4
      ///////// DDR4 /////////
      input              DDR4_REFCLK_p,
      output   [16: 0]   DDR4_A,
      output   [ 1: 0]   DDR4_BA,
      output   [ 0: 0]   DDR4_BG,
      output             DDR4_CK,
      output             DDR4_CK_n,
      output             DDR4_CKE,
      inout    [ 3: 0]   DDR4_DQS,
      inout    [ 3: 0]   DDR4_DQS_n,
      inout    [31: 0]   DDR4_DQ,
      inout    [ 3: 0]   DDR4_DBI_n,
      output             DDR4_CS_n,
      output             DDR4_RESET_n,
      output             DDR4_ODT,
      output             DDR4_PAR,
      input              DDR4_ALERT_n,
      output             DDR4_ACT_n,
      input              DDR4_RZQ,
`endif /*ENABLE_DDR4*/

      ///////// Video-In /////////
      input              TD_CLK27,
      input              TD_HS,
      input              TD_VS,
      input    [ 7: 0]   TD_DATA,
      output             TD_RESET_n,

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,
`endif /*ENABLE_HDMI*/

      ///////// Audio /////////
      inout              AUD_BCLK,
      output             AUD_XCK,
      inout              AUD_ADCLRCK,
      input              AUD_ADCDAT,
      inout              AUD_DACLRCK,
      output             AUD_DACDAT,

      ///////// ADC /////////
      output             ADC_SCK,
      output             ADC_SDO,
      input              ADC_SDI,
      output             ADC_CS_n,

      ///////// I2C for Camera, Audio, Video-In, Temerature Sensor and Fan Control /////////
      inout              FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_HSMC
      ///////// HSMC /////////
      output   [ 3: 0]   HSMC_GTS_TX_p,
      output   [ 3: 0]   HSMC_GTS_TX_n,
      input    [ 3: 0]   HSMC_GTS_RX_p,
      input    [ 3: 0]   HSMC_GTS_RX_n,
      input              HSMC_GTS_RX_REFCLK_p,
      output             HSMC_I2C_SCL,
      inout              HSMC_I2C_SDA,
      input    [ 2: 0]   HSMC_CLK_IN,
      input              HSMC_GTS_REFCLK_p,
      inout    [ 1: 0]   HSMC_B5B_D,
      inout    [76: 0]   HSMC_D,
`endif /*ENABLE_HSMC*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LCM_BK,
      inout              HPS_LCM_D_C,
      inout              HPS_LCM_RST_n,
      output             HPS_LCM_SPIM_CLK,
      output             HPS_LCM_SPIM_MOSI,
      output             HPS_LCM_SPIM_SS,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IR /////////
      output             IRDA_TXD,
      input              IRDA_RXD

		
);


//=======================================================
//  REG/WIRE declarations
//=======================================================


//=======================================================
//  Structural coding
//=======================================================
wire emif_rst_n_ddr4;
wire DDR4_IOPLL_Lock;
wire reset_handle;

// test status ..
//DDR4 Verify 
wire ddr4_test_pass/*synthesis keep*/;
wire ddr4_test_fail/*synthesis keep*/;
wire ddr4_test_complete/*synthesis keep*/;
wire ddr4_local_cal_success/*synthesis keep*/;
wire ddr4_local_cal_fail/*synthesis keep*/;
wire ddr4_reset_done/*synthesis keep*/;

wire AXI_LITE_CLK;
parameter AXIL_DRIVER_ADDRESS_WIDTH = 27;  
assign reset_handle = DDR4_IOPLL_Lock & !ninit_done;
	 
	 
wire global_reset;
wire	ninit_done;

debouncer debouncer_Inst(
    .clk(CLOCK0_50),         // clock signal
    .reset(ninit_done),       // reset signal
    .button_in(KEY[1]),   // raw button input
    .button_out(global_reset)   // debounced button output
);


wire ninit_done;
    reset_release reset_release_inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );
	 
wire	aclk;	 
wire	aresetn;
wire	pipe_aresetn;
assign pipe_aresetn = global_reset & emif_rst_n_ddr4 & DDR4_cal_done_rst_n;
		
localparam PIPEDEPTH = 15;
hyper_pipe #(.WIDTH(1), .NUM_PIPES(PIPEDEPTH)) read_data_pipe
			(.din(pipe_aresetn), .dout (aresetn), .clk (aclk));


    EMIF_Qsys EMIF_Qsys_Inst (
        
		  .clock_310m_out_clk_clk               (aclk),               //  output,    width = 1,           clock_310m_out_clk.clk
        .emif_ddr4_s0_axi4_ctrl_ready_reset_n (emif_rst_n_ddr4), //  output,    width = 1, emif_ddr4_s0_axi4_ctrl_ready.reset_n
        .emif_ddr4_s0_axi4_awaddr             (DDR4_awaddr),             //   input,   width = 30,            emif_ddr4_s0_axi4.awaddr
        .emif_ddr4_s0_axi4_awburst            (DDR4_awburst),            //   input,    width = 2,                             .awburst
        .emif_ddr4_s0_axi4_awid               (DDR4_awid),               //   input,    width = 7,                             .awid
        .emif_ddr4_s0_axi4_awlen              (DDR4_awlen),              //   input,    width = 8,                             .awlen
        .emif_ddr4_s0_axi4_awlock             (DDR4_awlock),             //   input,    width = 1,                             .awlock
        .emif_ddr4_s0_axi4_awqos              (DDR4_awqos),              //   input,    width = 4,                             .awqos
        .emif_ddr4_s0_axi4_awsize             (DDR4_awsize),             //   input,    width = 3,                             .awsize
        .emif_ddr4_s0_axi4_awvalid            (DDR4_awvalid),            //   input,    width = 1,                             .awvalid
        .emif_ddr4_s0_axi4_awuser             (DDR4_awuser),             //   input,   width = 14,                             .awuser
        .emif_ddr4_s0_axi4_awprot             (DDR4_awprot),             //   input,    width = 3,                             .awprot
        .emif_ddr4_s0_axi4_awready            (DDR4_awready),            //  output,    width = 1,                             .awready
        .emif_ddr4_s0_axi4_araddr             (DDR4_araddr),             //   input,   width = 30,                             .araddr
        .emif_ddr4_s0_axi4_arburst            (DDR4_arburst),            //   input,    width = 2,                             .arburst
        .emif_ddr4_s0_axi4_arid               (DDR4_arid),               //   input,    width = 7,                             .arid
        .emif_ddr4_s0_axi4_arlen              (DDR4_arlen),              //   input,    width = 8,                             .arlen
        .emif_ddr4_s0_axi4_arlock             (DDR4_arlock),             //   input,    width = 1,                             .arlock
        .emif_ddr4_s0_axi4_arqos              (DDR4_arqos),              //   input,    width = 4,                             .arqos
        .emif_ddr4_s0_axi4_arsize             (DDR4_arsize),             //   input,    width = 3,                             .arsize
        .emif_ddr4_s0_axi4_arvalid            (DDR4_arvalid),            //   input,    width = 1,                             .arvalid
        .emif_ddr4_s0_axi4_aruser             (DDR4_aruser),             //   input,   width = 14,                             .aruser
        .emif_ddr4_s0_axi4_arprot             (DDR4_arprot),             //   input,    width = 3,                             .arprot
        .emif_ddr4_s0_axi4_arready            (DDR4_arready),            //  output,    width = 1,                             .arready
        .emif_ddr4_s0_axi4_wdata              (DDR4_wdata),              //   input,  width = 256,                             .wdata
        .emif_ddr4_s0_axi4_wstrb              (DDR4_wstrb),              //   input,   width = 32,                             .wstrb
        .emif_ddr4_s0_axi4_wlast              (DDR4_wlast),              //   input,    width = 1,                             .wlast
        .emif_ddr4_s0_axi4_wvalid             (DDR4_wvalid),             //   input,    width = 1,                             .wvalid
        .emif_ddr4_s0_axi4_wready             (DDR4_wready),             //  output,    width = 1,                             .wready
        .emif_ddr4_s0_axi4_bready             (DDR4_bready),             //   input,    width = 1,                             .bready
        .emif_ddr4_s0_axi4_bid                (DDR4_bid),                //  output,    width = 7,                             .bid
        .emif_ddr4_s0_axi4_bresp              (DDR4_bresp),              //  output,    width = 2,                             .bresp
        .emif_ddr4_s0_axi4_bvalid             (DDR4_bvalid),             //  output,    width = 1,                             .bvalid
        .emif_ddr4_s0_axi4_rready             (DDR4_rready),             //   input,    width = 1,                             .rready
        .emif_ddr4_s0_axi4_rdata              (DDR4_rdata),              //  output,  width = 256,                             .rdata
        .emif_ddr4_s0_axi4_rid                (DDR4_rid),                //  output,    width = 7,                             .rid
        .emif_ddr4_s0_axi4_rlast              (DDR4_rlast),              //  output,    width = 1,                             .rlast
        .emif_ddr4_s0_axi4_rresp              (DDR4_rresp),              //  output,    width = 2,                             .rresp
        .emif_ddr4_s0_axi4_rvalid             (DDR4_rvalid),             //  output,    width = 1,                             .rvalid
       
		
        .emif_ddr4_s0_axi4lite_clock_clk       (AXI_LITE_CLK),       //   input,    width = 1,   emif_ddr4_s0_axi4lite_clock.clk
        .emif_ddr4_s0_axi4lite_reset_n_reset_n (reset_handle), //   input,    width = 1, emif_ddr4_s0_axi4lite_reset_n.reset_n
 		
		  .emif_ddr4_s0_axi4lite_awaddr         (DDR4_axil_driver_awaddr),         //   input,   width = 27,        emif_ddr4_s0_axi4lite.awaddr
        .emif_ddr4_s0_axi4lite_awprot         (DDR4_axil_driver_awprot),         //   input,    width = 3,                             .awprot
        .emif_ddr4_s0_axi4lite_awvalid        (DDR4_axil_driver_awvalid),        //   input,    width = 1,                             .awvalid
        .emif_ddr4_s0_axi4lite_awready        (DDR4_axil_driver_awready),        //  output,    width = 1,                             .awready
        .emif_ddr4_s0_axi4lite_araddr         (DDR4_axil_driver_araddr),         //   input,   width = 27,                             .araddr
        .emif_ddr4_s0_axi4lite_arprot         (DDR4_axil_driver_arprot),         //   input,    width = 3,                             .arprot
        .emif_ddr4_s0_axi4lite_arvalid        (DDR4_axil_driver_arvalid),        //   input,    width = 1,                             .arvalid
        .emif_ddr4_s0_axi4lite_arready        (DDR4_axil_driver_arready),        //  output,    width = 1,                             .arready
        .emif_ddr4_s0_axi4lite_wdata          (DDR4_axil_driver_wdata),          //   input,   width = 32,                             .wdata
        .emif_ddr4_s0_axi4lite_wstrb          (DDR4_axil_driver_wstrb),          //   input,    width = 4,                             .wstrb
        .emif_ddr4_s0_axi4lite_wvalid         (DDR4_axil_driver_wvalid),         //   input,    width = 1,                             .wvalid
        .emif_ddr4_s0_axi4lite_wready         (DDR4_axil_driver_wready),         //  output,    width = 1,                             .wready
        .emif_ddr4_s0_axi4lite_bready         (DDR4_axil_driver_bready),         //   input,    width = 1,                             .bready
        .emif_ddr4_s0_axi4lite_bresp          (DDR4_axil_driver_bresp),          //  output,    width = 2,                             .bresp
        .emif_ddr4_s0_axi4lite_bvalid         (DDR4_axil_driver_bvalid),         //  output,    width = 1,                             .bvalid
        .emif_ddr4_s0_axi4lite_rready         (DDR4_axil_driver_rready),         //   input,    width = 1,                             .rready
        .emif_ddr4_s0_axi4lite_rdata          (DDR4_axil_driver_rdata),          //  output,   width = 32,                             .rdata
        .emif_ddr4_s0_axi4lite_rresp          (DDR4_axil_driver_rresp),          //  output,    width = 2,                             .rresp
        .emif_ddr4_s0_axi4lite_rvalid         (DDR4_axil_driver_rvalid),         //  output,    width = 1,                             .rvalidite_rvalid         (_connected_to_emif_ddr4_s0_axi4lite_rvalid_),         //  output,    width = 1,                             .rvalid
              

		  .emif_ddr4_mem_mem_cke                (DDR4_CKE),                //  output,    width = 1,                emif_ddr4_mem.mem_cke
        .emif_ddr4_mem_mem_odt                (DDR4_ODT),                //  output,    width = 1,                             .mem_odt
        .emif_ddr4_mem_mem_cs_n               (DDR4_CS_n),               //  output,    width = 1,                             .mem_cs_n
        .emif_ddr4_mem_mem_a                  (DDR4_A),                  //  output,   width = 17,                             .mem_a
        .emif_ddr4_mem_mem_ba                 (DDR4_BA),                 //  output,    width = 2,                             .mem_ba
        .emif_ddr4_mem_mem_bg                 (DDR4_BG),                 //  output,    width = 1,                             .mem_bg
        .emif_ddr4_mem_mem_act_n              (DDR4_ACT_n),              //  output,    width = 1,                             .mem_act_n
        .emif_ddr4_mem_mem_par                (DDR4_PAR),                //  output,    width = 1,                             .mem_par
        .emif_ddr4_mem_mem_dq                 (DDR4_DQ),                 //   inout,   width = 32,                             .mem_dq
        .emif_ddr4_mem_mem_dqs_t              (DDR4_DQS),              //   inout,    width = 4,                             .mem_dqs_t
        .emif_ddr4_mem_mem_dqs_c              (DDR4_DQS_n),              //   inout,    width = 4,                             .mem_dqs_c
        .emif_ddr4_mem_mem_alert_n            (DDR4_ALERT_n),            //   input,    width = 1,                             .mem_alert_n
        .emif_ddr4_mem_mem_dbi_n              (DDR4_DBI_n),              //   inout,    width = 4,                             .mem_dbi_n
        .emif_ddr4_mem_ck_mem_ck_t            (DDR4_CK),            //  output,    width = 1,             emif_ddr4_mem_ck.mem_ck_t
        .emif_ddr4_mem_ck_mem_ck_c            (DDR4_CK_n),            //  output,    width = 1,                             .mem_ck_c
        .emif_ddr4_mem_reset_n_mem_reset_n    (DDR4_RESET_n),    //  output,    width = 1,        emif_ddr4_mem_reset_n.mem_reset_n
        .emif_ddr4_oct_oct_rzqin              (DDR4_RZQ),              //   input,    width = 1,                emif_ddr4_oct.oct_rzqin
        .emif_ddr4_ref_clk_clk                (DDR4_REFCLK_p),                //   input,    width = 1,            emif_ddr4_ref_clk.clk
        
		  
		  .iopll_refclk_clk                     (CLOCK0_50),                     //   input,    width = 1,                 iopll_refclk.clk
        .iopll_locked_export                  (DDR4_IOPLL_Lock),                  //  output,    width = 1,                 iopll_locked.export
        .iopll_reset_reset                    (ninit_done),                    //   input,    width = 1,                  iopll_reset.reset
        .iopll_outclk_axi4_lite_clk           (AXI_LITE_CLK),           //  output,    width = 1,       iopll_outclk_axi4_lite.clk
        .reset_reset_n                        (reset_handle)                         //   input,    width = 1,                        reset.reset_n
    );
	 

/////////////////// DDR4 Test ///////////////////	 

//DDR4 Calibration (AXI-Lite)
wire  												DDR4_axil_driver_clk;
wire  												DDR4_axil_driver_rst_n;
wire  [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]	DDR4_axil_driver_araddr;
wire  [2:0]											DDR4_axil_driver_arprot;
wire  												DDR4_axil_driver_arvalid;
wire  												DDR4_axil_driver_arready;
wire  [31:0]										DDR4_axil_driver_rdata;
wire  [1:0]											DDR4_axil_driver_rresp;
wire  												DDR4_axil_driver_rvalid;
wire                                      DDR4_axil_driver_rready;
wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]  DDR4_axil_driver_awaddr;
wire   [2:0]                              DDR4_axil_driver_awprot;
wire                                      DDR4_axil_driver_awvalid;
wire                                      DDR4_axil_driver_awready;
wire   [31:0]                             DDR4_axil_driver_wdata;
wire   [3:0]                              DDR4_axil_driver_wstrb;
wire                                      DDR4_axil_driver_wvalid;
wire                                      DDR4_axil_driver_wready;
wire   [1:0]                              DDR4_axil_driver_bresp;
wire                                      DDR4_axil_driver_bvalid;
wire                                      DDR4_axil_driver_bready;
wire													DDR4_cal_done_rst_n;
 
axil_driver_calibration DDR4_axil_driver_calibration_Inst(

   /*input    wire                                         */    .axil_driver_clk(AXI_LITE_CLK),
   /*input    wire                                         */    .axil_driver_rst_n(DDR4_IOPLL_Lock),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_araddr(DDR4_axil_driver_araddr),
   /*output   wire     [2:0]                               */    .axil_driver_arprot(DDR4_axil_driver_arprot),
   /*output   wire                                         */    .axil_driver_arvalid(DDR4_axil_driver_arvalid),
   /*input    wire                                         */    .axil_driver_arready(DDR4_axil_driver_arready),
   /*input    wire     [31:0]                              */    .axil_driver_rdata(DDR4_axil_driver_rdata),
   /*input    wire     [1:0]                               */    .axil_driver_rresp(DDR4_axil_driver_rresp),
   /*input    wire                                         */    .axil_driver_rvalid(DDR4_axil_driver_rvalid),
	
   /*output   wire                                         */    .axil_driver_rready(DDR4_axil_driver_rready),
   /*output   wire     [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_awaddr(DDR4_axil_driver_awaddr),
   /*output   wire     [2:0]                               */    .axil_driver_awprot(DDR4_axil_driver_awprot),
   /*output   wire                                         */    .axil_driver_awvalid(DDR4_axil_driver_awvalid),
   /*input    wire                                         */    .axil_driver_awready(DDR4_axil_driver_awready),
   /*output   wire     [31:0]                              */    .axil_driver_wdata(DDR4_axil_driver_wdata),
   /*output   wire     [3:0]                               */    .axil_driver_wstrb(DDR4_axil_driver_wstrb),
   /*output   wire                                         */    .axil_driver_wvalid(DDR4_axil_driver_wvalid),
   /*input    wire                                         */    .axil_driver_wready(DDR4_axil_driver_wready),
   /*input    wire     [1:0]                               */    .axil_driver_bresp(DDR4_axil_driver_bresp),
   /*input    wire                                         */    .axil_driver_bvalid(DDR4_axil_driver_bvalid),
   /*output   wire                                         */    .axil_driver_bready(DDR4_axil_driver_bready),
   /*output   wire                                         */    .cal_done_rst_n(DDR4_cal_done_rst_n)
	
);
defparam DDR4_axil_driver_calibration_Inst.AXIL_DRIVER_ADDRESS_WIDTH = AXIL_DRIVER_ADDRESS_WIDTH; 
  
  
// DDR4 RW Test 
parameter DDR4_AXI_ADDR_W 			= 30;
parameter DDR4_AXI_ADDR_W_COUNT	= 30'h2000;
parameter DDR4_AXI_ADDR_W_START	= 30'h00_0000;
parameter DDR4_AXI_ADDR_W_END 	= 30'h3fff_e000;
parameter DDR4_AXI_DATA_W 			= 256;
parameter DDR4_AXI_BURST_LENGHT 	= 8'hff;
parameter DDR4_AXI_ID_W			 	= 4;

wire 											DDR4_awvalid;	
wire 											DDR4_awready;  
wire	[3:0]									DDR4_awid;  
wire 	[DDR4_AXI_ADDR_W-1:0]  			DDR4_awaddr;
wire 	[7:0]        						DDR4_awlen;
wire 	[2:0]        						DDR4_awsize;
wire 	[1:0]        						DDR4_awburst;
wire             							DDR4_awlock;
wire 	[3:0]        						DDR4_awcache;
wire 	[2:0]        						DDR4_awprot;
wire            							DDR4_wvalid;
wire             							DDR4_wready;
wire 	[DDR4_AXI_DATA_W-1:0] 			DDR4_wdata;
wire 	[(DDR4_AXI_DATA_W>>3)-1:0] 	DDR4_wstrb;
wire             							DDR4_wlast;
  wire             						DDR4_bvalid;
  wire            						DDR4_bready;
  wire 	[3:0]  							DDR4_bid;
  wire 	[1:0]      						DDR4_bresp;
  wire            						DDR4_arvalid;
  wire             						DDR4_arready;
  wire 	[3:0]  							DDR4_arid;
  wire 	[DDR4_AXI_ADDR_W-1:0]  		DDR4_araddr;
  wire 	[7:0]        					DDR4_arlen;
  wire 	[2:0]        					DDR4_arsize;
  wire 	[1:0]        					DDR4_arburst;
  wire             						DDR4_arlock;
  wire 	[3:0]        					DDR4_arcache;
  wire 	[2:0]        					DDR4_arprot;
  wire             						DDR4_rvalid;
  wire            						DDR4_rready;
  wire 	[3:0]  							DDR4_rid;
  wire 	[DDR4_AXI_DATA_W-1:0]  		DDR4_rdata;
  wire 	[1:0]        					DDR4_rresp;
  wire             						DDR4_rlast;
//  wire           							DDR4_test_pass;
  


 Axi4_master_RW DDR4_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(KEY[0]),

  // AXI4 Master 
  /* output */            				.awvalid(DDR4_awvalid),
  /* input */             				.awready(DDR4_awready),
  /* output [ID_WIDTH-1:0]*/    		.awid(DDR4_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(DDR4_awaddr),
  /* output [7:0]*/        			.awlen(DDR4_awlen),
  /* output [2:0]*/        			.awsize(DDR4_awsize),
  /* output [1:0]*/        			.awburst(DDR4_awburst),
  /* output */             			.awlock(DDR4_awlock),
  /* output [3:0]*/        			.awcache(DDR4_awcache),
  /* output [2:0]*/        			.awprot(DDR4_awprot),

  /* output */            				.wvalid(DDR4_wvalid),
  /* input */             				.wready(DDR4_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(DDR4_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(DDR4_wstrb),
  /* output */             			.wlast(DDR4_wlast),

  /* input */             				.bvalid(DDR4_bvalid),
  /* output */            				.bready(DDR4_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(DDR4_bid),
  /* input [1:0]*/        				.bresp(DDR4_bresp),

  /* output */            				.arvalid(DDR4_arvalid),
  /* input */             				.arready(DDR4_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(DDR4_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(DDR4_araddr),
  /* output [7:0]*/        			.arlen(DDR4_arlen),
  /* output [2:0]*/        			.arsize(DDR4_arsize),
  /* output [1:0]*/        			.arburst(DDR4_arburst),
  /* output */             			.arlock(DDR4_arlock),
  /* output [3:0]*/        			.arcache(DDR4_arcache),
  /* output [2:0]*/        			.arprot(DDR4_arprot),

  /* input */             				.rvalid(DDR4_rvalid),
  /* output */            				.rready(DDR4_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(DDR4_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(DDR4_rdata),
  /* input [1:0]*/        				.rresp(DDR4_rresp),
  /* input */             				.rlast(DDR4_rlast),

  // 
  /* output */            				.test_pass(ddr4_test_pass),
  /* output */            				.test_complete(ddr4_test_complete)
  
  );
defparam DDR4_axi4_master_Inst.DDR4_AXI_ADDR_W 			= DDR4_AXI_ADDR_W; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_ADDR_W_COUNT 	= DDR4_AXI_ADDR_W_COUNT; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_ADDR_W_START 	= DDR4_AXI_ADDR_W_START; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_ADDR_W_END 	= DDR4_AXI_ADDR_W_END; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_DATA_W 			= DDR4_AXI_DATA_W; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_BURST_LENGHT 	= DDR4_AXI_BURST_LENGHT; 
defparam DDR4_axi4_master_Inst.DDR4_AXI_ID_W 			= DDR4_AXI_ID_W; 



wire heart_led;
heart_beat  heart_beat_0 ( .CLK(CLOCK2_50 ),     .CLK_FREQ  (50_000_000) , . CK_1HZ (heart_led) );

assign LEDR[0] = DDR4_cal_done_rst_n ? ~(ddr4_test_pass & ddr4_test_complete) : heart_led;




			
endmodule
