source [file join [file dirname [info script]] ./../../../ip/system/system_reset_bridge_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_intel_niosv_g_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/jtag_uart/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_1/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_pio_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/sysid_qsys/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_intel_onchip_memory_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/timer/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/clock_in/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_mm_ccb_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_emif_io96b_ddr4comp_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_iopll_0/sim/common/riviera_files.tcl]

namespace eval system {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_reset_bridge_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_intel_niosv_g_0::get_design_libraries]]
    set libraries [dict merge $libraries [jtag_uart::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_1::get_design_libraries]]
    set libraries [dict merge $libraries [system_pio_0::get_design_libraries]]
    set libraries [dict merge $libraries [sysid_qsys::get_design_libraries]]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_design_libraries]]
    set libraries [dict merge $libraries [timer::get_design_libraries]]
    set libraries [dict merge $libraries [clock_in::get_design_libraries]]
    set libraries [dict merge $libraries [system_mm_ccb_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_emif_io96b_ddr4comp_0::get_design_libraries]]
    set libraries [dict merge $libraries [system_iopll_0::get_design_libraries]]
    dict set libraries altera_merlin_axi_translator_1981    1
    dict set libraries altera_merlin_slave_translator_191   1
    dict set libraries altera_merlin_axi_master_ni_19112    1
    dict set libraries altera_merlin_slave_agent_1930       1
    dict set libraries altera_avalon_sc_fifo_1932           1
    dict set libraries altera_merlin_axi_slave_ni_19122     1
    dict set libraries altera_avalon_st_pipeline_stage_1930 1
    dict set libraries altera_merlin_router_1921            1
    dict set libraries altera_merlin_traffic_limiter_1921   1
    dict set libraries altera_merlin_burst_adapter_1940     1
    dict set libraries altera_merlin_demultiplexer_1921     1
    dict set libraries altera_merlin_multiplexer_1922       1
    dict set libraries altera_merlin_width_adapter_1961     1
    dict set libraries altera_mm_interconnect_1920          1
    dict set libraries altera_merlin_master_translator_193  1
    dict set libraries altera_merlin_master_agent_1940      1
    dict set libraries altera_irq_mapper_2001               1
    dict set libraries altera_irq_clock_crosser_2000        1
    dict set libraries altera_reset_controller_1924         1
    dict set libraries system                               1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [system_reset_bridge_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_reset_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_intel_niosv_g_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [jtag_uart::get_memory_files "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_1::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_pio_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [sysid_qsys::get_memory_files "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_intel_onchip_memory_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [timer::get_memory_files "$QSYS_SIMDIR/../../ip/system/timer/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [clock_in::get_memory_files "$QSYS_SIMDIR/../../ip/system/clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_mm_ccb_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_mm_ccb_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_emif_io96b_ddr4comp_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_emif_io96b_ddr4comp_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [system_iopll_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [system_reset_bridge_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_reset_bridge_0/sim/"]]
    set design_files [dict merge $design_files [system_intel_niosv_g_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/"]]
    set design_files [dict merge $design_files [jtag_uart::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    set design_files [dict merge $design_files [system_pio_1::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/"]]
    set design_files [dict merge $design_files [system_pio_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/"]]
    set design_files [dict merge $design_files [sysid_qsys::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set design_files [dict merge $design_files [system_intel_onchip_memory_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set design_files [dict merge $design_files [timer::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set design_files [dict merge $design_files [clock_in::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set design_files [dict merge $design_files [system_mm_ccb_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_mm_ccb_0/sim/"]]
    set design_files [dict merge $design_files [system_emif_io96b_ddr4comp_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_emif_io96b_ddr4comp_0/sim/"]]
    set design_files [dict merge $design_files [system_iopll_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/"]]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    set design_files [concat $design_files [system_reset_bridge_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_reset_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_intel_niosv_g_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [jtag_uart::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_1::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_pio_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [sysid_qsys::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_intel_onchip_memory_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [timer::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/timer/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [clock_in::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_mm_ccb_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_mm_ccb_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_emif_io96b_ddr4comp_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_emif_io96b_ddr4comp_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [system_iopll_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_translator_1981/sim/system_altera_merlin_axi_translator_1981_d6vgxmy.sv"]\"  -work altera_merlin_axi_translator_1981"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/system_altera_merlin_slave_translator_191_xg7rzxi.sv"]\"  -work altera_merlin_slave_translator_191"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19112/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_axi_master_ni_19112"                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19112/sim/system_altera_merlin_axi_master_ni_19112_2jrcixq.sv"]\"  -work altera_merlin_axi_master_ni_19112"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/system_altera_merlin_slave_agent_1930_jxauz3i.sv"]\"  -work altera_merlin_slave_agent_1930"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_slave_agent_1930"                                                       
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/system_altera_avalon_sc_fifo_1932_22gxxgi.v"]\"  -work altera_avalon_sc_fifo_1932"                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/system_altera_merlin_axi_slave_ni_altera_avalon_sc_fifo_19122_flnh5da.v"]\"  -work altera_merlin_axi_slave_ni_19122"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/system_altera_avalon_st_pipeline_stage_1930_oiupeiq.sv"]\"  -work altera_avalon_st_pipeline_stage_1930"                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_avalon_st_pipeline_stage_1930"                                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/system_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19122_ywrtanq.v"]\"  -work altera_merlin_axi_slave_ni_19122"
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/system_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19122_rjx2lky.v"]\"  -work altera_merlin_axi_slave_ni_19122"
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/system_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19122_jfjtpsa.v"]\"  -work altera_merlin_axi_slave_ni_19122"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/compare_eq.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/rd_response_mem_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/rd_comp_sel_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/rd_pri_mux_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/rd_sipo_plus_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/wr_response_mem_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/wr_comp_sel_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/wr_pri_mux_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/wr_sipo_plus_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19122/sim/system_altera_merlin_axi_slave_ni_19122_e3kro7q.sv"]\"  -work altera_merlin_axi_slave_ni_19122"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_zgahrai.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_xdet5ay.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_2a3bfui.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_2o43vvq.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_drjqgyq.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_szllori.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_7ol62eq.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_te3kfhq.v"]\"  -work altera_merlin_traffic_limiter_1921"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"  -work altera_merlin_traffic_limiter_1921"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_merlin_traffic_limiter_1921"                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_1921_5pm4apa.sv"]\"  -work altera_merlin_traffic_limiter_1921"                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/system_altera_merlin_burst_adapter_altera_avalon_st_pipeline_stage_1940_xmhajay.v"]\"  -work altera_merlin_burst_adapter_1940"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/system_altera_merlin_burst_adapter_1940_peqmhla.sv"]\"  -work altera_merlin_burst_adapter_1940"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_uncmpr.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_13_1.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_burst_adapter_new.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_incr_burst_converter.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_wrap_burst_converter.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_default_burst_converter.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_burst_adapter_1940/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_burst_adapter_1940"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_vsluw7y.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_qnhaqeq.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_i7sbfaq.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_rr76jvi.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_2gd2loi.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_tw2fc3y.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_hn7a2dy.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_nansgpy.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_nypnn3i.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_3u7v3za.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/system_altera_merlin_width_adapter_1961_jnangaa.sv"]\"  -work altera_merlin_width_adapter_1961"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_width_adapter_1961"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_width_adapter_1961"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/system_altera_merlin_width_adapter_1961_uxtb7ji.sv"]\"  -work altera_merlin_width_adapter_1961"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_width_adapter_1961"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_width_adapter_1961/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_width_adapter_1961"                                                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/system_altera_mm_interconnect_1920_hnc4o4q.v"]\"  -work altera_mm_interconnect_1920"                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_master_translator_193/sim/system_altera_merlin_master_translator_193_lgcew2q.sv"]\"  -work altera_merlin_master_translator_193"                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_master_agent_1940/sim/system_altera_merlin_master_agent_1940_r3ep6da.sv"]\"  -work altera_merlin_master_agent_1940"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_lzw66mi.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_wyh36sy.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_a53nykq.v"]\"  -work altera_merlin_traffic_limiter_1921"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"  -work altera_merlin_traffic_limiter_1921"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_merlin_traffic_limiter_1921"                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_1921_p3fvlba.sv"]\"  -work altera_merlin_traffic_limiter_1921"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_tif3vpy.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_276vlkq.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_jdcugza.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_6rrr3uy.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/system_altera_mm_interconnect_1920_k36ogsy.v"]\"  -work altera_mm_interconnect_1920"                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/system_altera_irq_mapper_2001_qylhc4a.sv"]\"  -work altera_irq_mapper_2001"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_irq_clock_crosser_2000/sim/system_altera_irq_clock_crosser_2000_nl7nlqq.sv"]\"  -work altera_irq_clock_crosser_2000"                                             
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1924"                                                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1924"                                                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/system.v"]\"  -work system"                                                                                                                                           
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_reset_bridge_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_niosv_g_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [jtag_uart::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_1::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_pio_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [sysid_qsys::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_onchip_memory_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [timer::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [clock_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_mm_ccb_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_emif_io96b_ddr4comp_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_iopll_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [system_reset_bridge_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_intel_niosv_g_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [jtag_uart::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_1::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_pio_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [sysid_qsys::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_intel_onchip_memory_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [timer::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [clock_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_mm_ccb_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_emif_io96b_ddr4comp_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_iopll_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_reset_bridge_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_niosv_g_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [jtag_uart::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_1::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_pio_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [sysid_qsys::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_onchip_memory_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [timer::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [clock_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_mm_ccb_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_emif_io96b_ddr4comp_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_iopll_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_reset_bridge_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_reset_bridge_0/sim/"]]
    set libraries [dict merge $libraries [system_intel_niosv_g_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_g_0/sim/"]]
    set libraries [dict merge $libraries [jtag_uart::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    set libraries [dict merge $libraries [system_pio_1::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_1/sim/"]]
    set libraries [dict merge $libraries [system_pio_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_pio_0/sim/"]]
    set libraries [dict merge $libraries [sysid_qsys::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set libraries [dict merge $libraries [timer::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set libraries [dict merge $libraries [clock_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set libraries [dict merge $libraries [system_mm_ccb_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_mm_ccb_0/sim/"]]
    set libraries [dict merge $libraries [system_emif_io96b_ddr4comp_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_emif_io96b_ddr4comp_0/sim/"]]
    set libraries [dict merge $libraries [system_iopll_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_iopll_0/sim/"]]
    
    return $libraries
  }
  
}
