
namespace eval system_hydra_0 {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries altera_common_sv_packages 1
    dict set libraries hydra_software_100        1
    dict set libraries hydra_rtl_library_100     1
    dict set libraries hydra_global_csr_100      1
    dict set libraries hydra_driver_mem_axi4_100 1
    dict set libraries hydra_301                 1
    dict set libraries system_hydra_0            1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    return $memory_files
  }
  
  proc get_common_design_files {QSYS_SIMDIR} {
    set design_files [dict create]
    dict set design_files "altera_common_sv_packages::hydra_rtl_library_pkg"     "-makelib altera_common_sv_packages \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_rtl_library_pkg.sv"]\"   -end"        
    dict set design_files "altera_common_sv_packages::hydra_mem_axi4_driver_pkg" "-makelib altera_common_sv_packages \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_pkg.sv"]\"   -end"
    return $design_files
  }
  
  proc get_design_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    lappend design_files "-makelib hydra_software_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_software_100/sim/hydra_software_dummy_top.sv"]\"   -L altera_common_sv_packages -end"                                            
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_id_checker.sv"]\"   -L altera_common_sv_packages -end"                                              
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_local_reset_tree.sv"]\"   -L altera_common_sv_packages -end"                                        
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_orchestrator.sv"]\"   -L altera_common_sv_packages -end"                                            
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_rtl_library_dummy_top.sv"]\"   -L altera_common_sv_packages -end"                                   
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_alu_generator.sv"]\"   -L altera_common_sv_packages -end"                                           
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_mem_addr_alu.sv"]\"   -L altera_common_sv_packages -end"                                            
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_mem_dq_alu.sv"]\"   -L altera_common_sv_packages -end"                                              
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_main_control.sv"]\"   -L altera_common_sv_packages -end"                                            
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_ooo_worker_head_control.sv"]\"   -L altera_common_sv_packages -end"                                 
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_ooo_worker_list_control.sv"]\"   -L altera_common_sv_packages -end"                                 
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_worker_control.sv"]\"   -L altera_common_sv_packages -end"                                          
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_binary_to_gray.sv"]\"   -L altera_common_sv_packages -end"                                          
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_dcfifo_s.sv"]\"   -L altera_common_sv_packages -end"                                                
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_dcfifo_s_normal.sv"]\"   -L altera_common_sv_packages -end"                                         
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_dcfifo_s_showahead.sv"]\"   -L altera_common_sv_packages -end"                                      
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_generic_mlab_dc.sv"]\"   -L altera_common_sv_packages -end"                                         
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_gray_to_binary.sv"]\"   -L altera_common_sv_packages -end"                                          
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_synchronizer_ff_r2.sv"]\"   -L altera_common_sv_packages -end"                                      
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_synchronizer_mlab.sv"]\"   -L altera_common_sv_packages -end"                                       
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_add_a_b_s0_s1.sv"]\"   -L altera_common_sv_packages -end"                                           
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_generic_mlab_sc.sv"]\"   -L altera_common_sv_packages -end"                                         
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_scfifo_s.sv"]\"   -L altera_common_sv_packages -end"                                                
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_scfifo_s_normal.sv"]\"   -L altera_common_sv_packages -end"                                         
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_scfifo_s_showahead.sv"]\"   -L altera_common_sv_packages -end"                                      
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_contxt_ram.sv"]\"   -L altera_common_sv_packages -end"                                              
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_instr_ram.sv"]\"   -L altera_common_sv_packages -end"                                               
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_log_ram.sv"]\"   -L altera_common_sv_packages -end"                                                 
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_user_to_ram_adapter.sv"]\"   -L altera_common_sv_packages -end"                                     
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_skid_buffer.sv"]\"   -L altera_common_sv_packages -end"                                             
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_ready_valid_fork_merge.sv"]\"   -L altera_common_sv_packages -end"                                  
    lappend design_files "-makelib hydra_rtl_library_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_rtl_library_100/sim/hydra_stream_multiplier.sv"]\"   -L altera_common_sv_packages -end"                                       
    lappend design_files "-makelib hydra_global_csr_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_global_csr_100/sim/system_hydra_0_hydra_global_csr_100_ixxrsea_hydra_global_csr_top.sv"]\"   -L altera_common_sv_packages -end"
    lappend design_files "-makelib hydra_global_csr_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_global_csr_100/sim/hydra_global_csr_impl.sv"]\"   -L altera_common_sv_packages -end"                                           
    lappend design_files "-makelib hydra_global_csr_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_global_csr_100/sim/hydra_global_csr_sync.sv"]\"   -L altera_common_sv_packages -end"                                           
    lappend design_files "-makelib hydra_global_csr_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_global_csr_100/sim/hydra_global_csr_registers.sv"]\"   -L altera_common_sv_packages -end"                                      
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_csr_interface.sv"]\"   -L altera_common_sv_packages -end"                   
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_csr_bank.sv"]\"   -L altera_common_sv_packages -end"                        
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_top.sv"]\"   -L altera_common_sv_packages -end"                             
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_channel_path.sv"]\"   -L altera_common_sv_packages -end"                    
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_gen_path.sv"]\"   -L altera_common_sv_packages -end"                        
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/hydra_mem_axi4_driver_narrow_xstrb.sv"]\"   -L altera_common_sv_packages -end"                    
    lappend design_files "-makelib hydra_driver_mem_axi4_100 \"[normalize_path "$QSYS_SIMDIR/../hydra_driver_mem_axi4_100/sim/altera_std_synchronizer_nocut.v"]\"   -end"                                                       
    lappend design_files "-makelib hydra_301 \"[normalize_path "$QSYS_SIMDIR/../hydra_301/sim/system_hydra_0_hydra_301_4ddyhvi.v"]\"   -end"                                                                                    
    lappend design_files "-makelib system_hydra_0 \"[normalize_path "$QSYS_SIMDIR/system_hydra_0.v"]\"   -end"                                                                                                                  
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
