// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



package hydra_rtl_library_pkg;

   function automatic string get_param_from_str;
      input string str;
      input string param;

      integer str_len;
      integer param_len;
      integer val_start;
      integer val_end;
      string  sub;
   begin
      str_len   = str.len();
      param_len = param.len();
      val_start = 0;
      val_end   = 0;

      get_param_from_str = "0";

      for (int i = 0; i < str_len; i++) begin
         sub = str.substr(i, i + param_len - 1);
         if(sub.compare(param) == 0) begin
            val_start = i + param_len;
            for (int j = val_start; j < str_len; j++) begin
               if (val_start >= val_end && (str[j] == " " || str[j] == "="))
                  val_start = val_start + 1;
               val_end = j;
               if (str[j] == "," || (val_start < val_end && str[j] == " ")) begin
                  val_end = val_end - 1;
                  break;
               end
            end

            if (val_start <= val_end)
               get_param_from_str = str.substr(val_start, val_end);
         end
      end
   end
   endfunction

   function automatic integer str_to_int;
      input string str;

      integer str_len;
      integer val;
   begin
      str_len = str.len();
      val = 0;
      for (int i = 0; i < str_len; i++) begin
         case (str.getc(i))
            "0":     val = val*10 + 0;
            "1":     val = val*10 + 1;
            "2":     val = val*10 + 2;
            "3":     val = val*10 + 3;
            "4":     val = val*10 + 4;
            "5":     val = val*10 + 5;
            "6":     val = val*10 + 6;
            "7":     val = val*10 + 7;
            "8":     val = val*10 + 8;
            "9":     val = val*10 + 9;
            default: $fatal(1, "Found non-digit character %s in string %s", str[i], str);
         endcase
      end
      str_to_int = val;
   end
   endfunction

   localparam CTRL_INSTR_OP_EOL = 0;


endpackage

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "1m/2vrF2xfQiMJ/OSW7W9wpH0GrYLWLcOgQangOK10lxUOL7anvDqiC01KALN5h7j34pXoKQPkPaacyqwkNfLGj5ci7Q9Dnhw6GC3G5rPvlYh4pQi1tUmmRytxxBSUr06z5JOLeAHp2coKbvq/aAB4AQAbTlzWeWrxob+H0f6G2zuBanr6kL6emL/21E1sfKj4Nxp4I2ZBKwzHCM/qOb1G0PdrVUA7gceAgkGwMABuELG8IUfKYwOmnfYyTzeEA05sKTlxKSVdnF19AduyiRcS49AY09zPXjbg7G/6nk3GVV4mE31WS/mcs54dzA8XLpKH9tReScWl60aYeXXzLES8hZDnoXqIoF+934PWyIDkcZVfQKbuNAjijf+jJIFa0xS6cf3o4IStLy5jmeLRvwHU/Y6hSRiQhBi2Gug8KzqAU/Uf/DHO/xlDpvZ3ItymX6QhwlvqAlMYG1sH4ZR9XtfadTGnJ9/kgHlvb/DZsXy6UzmaqmQTde7cW5CG4lT+XL9t+n6PK238qKeA1tRRDStz7E+x3TgkZNHVaz9gvYUDSLQ+06erger2Jb6uNJgFmZAZyBiaPlNRhKVZpcNL6ZZToskKx9/YGNyhU5ixUxumS63IWjSbKfNmt2bAzFua8/Db7IeuIgOs9pPl+mHw245ToGdRjTDy+aF3PsCT8l529WQs8Fl9VJ6XLVA8LlI6D83imQYPt5ZzQk9v1P2K8cJcGV6wFrz8d5SkW3xMYwMsWwq8N+wjs+m2JIZPqyXkUsd9ifvqHAwpgF6UQ5L6ZkiIpVEviXBmKSWUgEwfCUUBls1cqzgi0kHIiLUKw7D6WT9NRF0WKlhPJS/ynA8OJmvouMhejNQTHKlP5pNrlIxnOfYv+iip8qIuyupKx+blg0Drc0wu9Xp0ph7O3tGj7b+MKo0oNV3hGcdjOjex9s5Hg09WEouGowPhRzG5+JGpXik5Fd+tA1ZSugWtqMMyRPhW0/6EO2XQXLJxPlEnfNd4Hvg3rE0geCWtHPuBY7HPXm"
`endif