// nios_system.v

// Generated using ACDS version 25.1.1 125

`timescale 1 ps / 1 ps
module nios_system (
		output wire        audio_conduit_end_XCK,                          //                      audio_conduit_end.XCK
		input  wire        audio_conduit_end_ADCDAT,                       //                                       .ADCDAT
		input  wire        audio_conduit_end_ADCLRC,                       //                                       .ADCLRC
		output wire        audio_conduit_end_DACDAT,                       //                                       .DACDAT
		input  wire        audio_conduit_end_DACLRC,                       //                                       .DACLRC
		input  wire        audio_conduit_end_BCLK,                         //                                       .BCLK
		inout  wire        audio_i2c_export_scl_pad_io,                    //                       audio_i2c_export.scl_pad_io
		inout  wire        audio_i2c_export_sda_pad_io,                    //                                       .sda_pad_io
		input  wire        clk_clk,                                        //                                    clk.clk
		output wire        emif_io96b_ddr4comp_s0_axi4_ctrl_ready_reset_n, // emif_io96b_ddr4comp_s0_axi4_ctrl_ready.reset_n
		output wire [0:0]  emif_io96b_ddr4comp_mem_0_mem_cke,              //              emif_io96b_ddr4comp_mem_0.mem_cke
		output wire [0:0]  emif_io96b_ddr4comp_mem_0_mem_odt,              //                                       .mem_odt
		output wire [0:0]  emif_io96b_ddr4comp_mem_0_mem_cs_n,             //                                       .mem_cs_n
		output wire [16:0] emif_io96b_ddr4comp_mem_0_mem_a,                //                                       .mem_a
		output wire [1:0]  emif_io96b_ddr4comp_mem_0_mem_ba,               //                                       .mem_ba
		output wire [0:0]  emif_io96b_ddr4comp_mem_0_mem_bg,               //                                       .mem_bg
		output wire        emif_io96b_ddr4comp_mem_0_mem_act_n,            //                                       .mem_act_n
		output wire        emif_io96b_ddr4comp_mem_0_mem_par,              //                                       .mem_par
		inout  wire [31:0] emif_io96b_ddr4comp_mem_0_mem_dq,               //                                       .mem_dq
		inout  wire [3:0]  emif_io96b_ddr4comp_mem_0_mem_dqs_t,            //                                       .mem_dqs_t
		inout  wire [3:0]  emif_io96b_ddr4comp_mem_0_mem_dqs_c,            //                                       .mem_dqs_c
		input  wire        emif_io96b_ddr4comp_mem_0_mem_alert_n,          //                                       .mem_alert_n
		inout  wire [3:0]  emif_io96b_ddr4comp_mem_0_mem_dbi_n,            //                                       .mem_dbi_n
		output wire [0:0]  emif_io96b_ddr4comp_mem_ck_0_mem_ck_t,          //           emif_io96b_ddr4comp_mem_ck_0.mem_ck_t
		output wire [0:0]  emif_io96b_ddr4comp_mem_ck_0_mem_ck_c,          //                                       .mem_ck_c
		output wire        emif_io96b_ddr4comp_mem_reset_n_mem_reset_n,    //        emif_io96b_ddr4comp_mem_reset_n.mem_reset_n
		input  wire        emif_io96b_ddr4comp_oct_0_oct_rzqin,            //              emif_io96b_ddr4comp_oct_0.oct_rzqin
		input  wire        emif_io96b_ddr4comp_ref_clk_clk,                //            emif_io96b_ddr4comp_ref_clk.clk
		input  wire        pio_ddr4_cal_done_external_connection_export,   //  pio_ddr4_cal_done_external_connection.export
		input  wire [3:0]  key_external_connection_export,                 //                key_external_connection.export
		output wire [9:0]  led_external_connection_export,                 //                led_external_connection.export
		input  wire [9:0]  sw_external_connection_export,                  //                 sw_external_connection.export
		input  wire        reset_reset_n,                                  //                                  reset.reset_n
		output wire [47:0] seg7_conduit_end_export                         //                       seg7_conduit_end.export
	);

	wire          clock_in_out_clk_clk;                                      // clock_in:out_clk -> [iopll:refclk, pll_audio:refclk, reset_bridge:clk, reset_in:clk, rst_controller_003:clk]
	wire          iopll_outclk0_clk;                                         // iopll:outclk_0 -> [audio_i2c:wb_clk_i, emif_io96b_ddr4comp:s0_axi4_clock_in, emif_io96b_ddr4comp:s0_axi4lite_clock, irq_mapper:clk, jtag_uart:clk, mm_bridge_peripheral:clk, mm_interconnect_0:iopll_outclk0_clk, mm_interconnect_1:iopll_outclk0_clk, niosv_g:clk, onchip_memory:clk, pio_ddr4_cal_done:clk, pio_key:clk, pio_led:clk, pio_sw:clk, rst_controller_001:clk, rst_controller_002:clk, rst_controller_004:clk, seg7:s_clk, sysid_qsys:clock]
	wire          pll_audio_outclk0_clk;                                     // pll_audio:outclk_0 -> [audio:avs_s1_clk, mm_interconnect_1:pll_audio_outclk0_clk, rst_controller:clk, rst_controller_005:clk]
	wire          reset_release_ninit_done_reset;                            // reset_release:ninit_done -> [emif_io96b_ddr4comp:core_init_n, rst_controller_003:reset_in0]
	wire          reset_bridge_out_reset_reset;                              // reset_bridge:out_reset_n -> [iopll:rst, pll_audio:rst, rst_controller:reset_in0, rst_controller_001:reset_in0, rst_controller_002:reset_in0, rst_controller_005:reset_in0]
	wire    [7:0] niosv_g_data_manager_arlen;                                // niosv_g:data_manager_arlen -> mm_interconnect_0:niosv_g_data_manager_arlen
	wire    [3:0] niosv_g_data_manager_wstrb;                                // niosv_g:data_manager_wstrb -> mm_interconnect_0:niosv_g_data_manager_wstrb
	wire          niosv_g_data_manager_wready;                               // mm_interconnect_0:niosv_g_data_manager_wready -> niosv_g:data_manager_wready
	wire          niosv_g_data_manager_rready;                               // niosv_g:data_manager_rready -> mm_interconnect_0:niosv_g_data_manager_rready
	wire    [7:0] niosv_g_data_manager_awlen;                                // niosv_g:data_manager_awlen -> mm_interconnect_0:niosv_g_data_manager_awlen
	wire          niosv_g_data_manager_wvalid;                               // niosv_g:data_manager_wvalid -> mm_interconnect_0:niosv_g_data_manager_wvalid
	wire   [31:0] niosv_g_data_manager_araddr;                               // niosv_g:data_manager_araddr -> mm_interconnect_0:niosv_g_data_manager_araddr
	wire    [2:0] niosv_g_data_manager_arprot;                               // niosv_g:data_manager_arprot -> mm_interconnect_0:niosv_g_data_manager_arprot
	wire    [2:0] niosv_g_data_manager_awprot;                               // niosv_g:data_manager_awprot -> mm_interconnect_0:niosv_g_data_manager_awprot
	wire   [31:0] niosv_g_data_manager_wdata;                                // niosv_g:data_manager_wdata -> mm_interconnect_0:niosv_g_data_manager_wdata
	wire          niosv_g_data_manager_arvalid;                              // niosv_g:data_manager_arvalid -> mm_interconnect_0:niosv_g_data_manager_arvalid
	wire   [31:0] niosv_g_data_manager_awaddr;                               // niosv_g:data_manager_awaddr -> mm_interconnect_0:niosv_g_data_manager_awaddr
	wire    [1:0] niosv_g_data_manager_bresp;                                // mm_interconnect_0:niosv_g_data_manager_bresp -> niosv_g:data_manager_bresp
	wire          niosv_g_data_manager_arready;                              // mm_interconnect_0:niosv_g_data_manager_arready -> niosv_g:data_manager_arready
	wire   [31:0] niosv_g_data_manager_rdata;                                // mm_interconnect_0:niosv_g_data_manager_rdata -> niosv_g:data_manager_rdata
	wire          niosv_g_data_manager_awready;                              // mm_interconnect_0:niosv_g_data_manager_awready -> niosv_g:data_manager_awready
	wire    [2:0] niosv_g_data_manager_arsize;                               // niosv_g:data_manager_arsize -> mm_interconnect_0:niosv_g_data_manager_arsize
	wire          niosv_g_data_manager_bready;                               // niosv_g:data_manager_bready -> mm_interconnect_0:niosv_g_data_manager_bready
	wire          niosv_g_data_manager_rlast;                                // mm_interconnect_0:niosv_g_data_manager_rlast -> niosv_g:data_manager_rlast
	wire          niosv_g_data_manager_wlast;                                // niosv_g:data_manager_wlast -> mm_interconnect_0:niosv_g_data_manager_wlast
	wire    [1:0] niosv_g_data_manager_rresp;                                // mm_interconnect_0:niosv_g_data_manager_rresp -> niosv_g:data_manager_rresp
	wire          niosv_g_data_manager_bvalid;                               // mm_interconnect_0:niosv_g_data_manager_bvalid -> niosv_g:data_manager_bvalid
	wire    [2:0] niosv_g_data_manager_awsize;                               // niosv_g:data_manager_awsize -> mm_interconnect_0:niosv_g_data_manager_awsize
	wire          niosv_g_data_manager_awvalid;                              // niosv_g:data_manager_awvalid -> mm_interconnect_0:niosv_g_data_manager_awvalid
	wire          niosv_g_data_manager_rvalid;                               // mm_interconnect_0:niosv_g_data_manager_rvalid -> niosv_g:data_manager_rvalid
	wire    [1:0] niosv_g_instruction_manager_awburst;                       // niosv_g:instruction_manager_awburst -> mm_interconnect_0:niosv_g_instruction_manager_awburst
	wire    [7:0] niosv_g_instruction_manager_arlen;                         // niosv_g:instruction_manager_arlen -> mm_interconnect_0:niosv_g_instruction_manager_arlen
	wire    [3:0] niosv_g_instruction_manager_wstrb;                         // niosv_g:instruction_manager_wstrb -> mm_interconnect_0:niosv_g_instruction_manager_wstrb
	wire          niosv_g_instruction_manager_wready;                        // mm_interconnect_0:niosv_g_instruction_manager_wready -> niosv_g:instruction_manager_wready
	wire          niosv_g_instruction_manager_rready;                        // niosv_g:instruction_manager_rready -> mm_interconnect_0:niosv_g_instruction_manager_rready
	wire    [7:0] niosv_g_instruction_manager_awlen;                         // niosv_g:instruction_manager_awlen -> mm_interconnect_0:niosv_g_instruction_manager_awlen
	wire          niosv_g_instruction_manager_wvalid;                        // niosv_g:instruction_manager_wvalid -> mm_interconnect_0:niosv_g_instruction_manager_wvalid
	wire   [31:0] niosv_g_instruction_manager_araddr;                        // niosv_g:instruction_manager_araddr -> mm_interconnect_0:niosv_g_instruction_manager_araddr
	wire    [2:0] niosv_g_instruction_manager_arprot;                        // niosv_g:instruction_manager_arprot -> mm_interconnect_0:niosv_g_instruction_manager_arprot
	wire    [2:0] niosv_g_instruction_manager_awprot;                        // niosv_g:instruction_manager_awprot -> mm_interconnect_0:niosv_g_instruction_manager_awprot
	wire   [31:0] niosv_g_instruction_manager_wdata;                         // niosv_g:instruction_manager_wdata -> mm_interconnect_0:niosv_g_instruction_manager_wdata
	wire          niosv_g_instruction_manager_arvalid;                       // niosv_g:instruction_manager_arvalid -> mm_interconnect_0:niosv_g_instruction_manager_arvalid
	wire   [31:0] niosv_g_instruction_manager_awaddr;                        // niosv_g:instruction_manager_awaddr -> mm_interconnect_0:niosv_g_instruction_manager_awaddr
	wire    [1:0] niosv_g_instruction_manager_bresp;                         // mm_interconnect_0:niosv_g_instruction_manager_bresp -> niosv_g:instruction_manager_bresp
	wire          niosv_g_instruction_manager_arready;                       // mm_interconnect_0:niosv_g_instruction_manager_arready -> niosv_g:instruction_manager_arready
	wire   [31:0] niosv_g_instruction_manager_rdata;                         // mm_interconnect_0:niosv_g_instruction_manager_rdata -> niosv_g:instruction_manager_rdata
	wire          niosv_g_instruction_manager_awready;                       // mm_interconnect_0:niosv_g_instruction_manager_awready -> niosv_g:instruction_manager_awready
	wire    [1:0] niosv_g_instruction_manager_arburst;                       // niosv_g:instruction_manager_arburst -> mm_interconnect_0:niosv_g_instruction_manager_arburst
	wire    [2:0] niosv_g_instruction_manager_arsize;                        // niosv_g:instruction_manager_arsize -> mm_interconnect_0:niosv_g_instruction_manager_arsize
	wire          niosv_g_instruction_manager_bready;                        // niosv_g:instruction_manager_bready -> mm_interconnect_0:niosv_g_instruction_manager_bready
	wire          niosv_g_instruction_manager_rlast;                         // mm_interconnect_0:niosv_g_instruction_manager_rlast -> niosv_g:instruction_manager_rlast
	wire          niosv_g_instruction_manager_wlast;                         // niosv_g:instruction_manager_wlast -> mm_interconnect_0:niosv_g_instruction_manager_wlast
	wire    [1:0] niosv_g_instruction_manager_rresp;                         // mm_interconnect_0:niosv_g_instruction_manager_rresp -> niosv_g:instruction_manager_rresp
	wire          niosv_g_instruction_manager_bvalid;                        // mm_interconnect_0:niosv_g_instruction_manager_bvalid -> niosv_g:instruction_manager_bvalid
	wire    [2:0] niosv_g_instruction_manager_awsize;                        // niosv_g:instruction_manager_awsize -> mm_interconnect_0:niosv_g_instruction_manager_awsize
	wire          niosv_g_instruction_manager_awvalid;                       // niosv_g:instruction_manager_awvalid -> mm_interconnect_0:niosv_g_instruction_manager_awvalid
	wire          niosv_g_instruction_manager_rvalid;                        // mm_interconnect_0:niosv_g_instruction_manager_rvalid -> niosv_g:instruction_manager_rvalid
	wire   [31:0] mm_interconnect_0_niosv_g_dm_agent_readdata;               // niosv_g:dm_agent_readdata -> mm_interconnect_0:niosv_g_dm_agent_readdata
	wire          mm_interconnect_0_niosv_g_dm_agent_waitrequest;            // niosv_g:dm_agent_waitrequest -> mm_interconnect_0:niosv_g_dm_agent_waitrequest
	wire   [15:0] mm_interconnect_0_niosv_g_dm_agent_address;                // mm_interconnect_0:niosv_g_dm_agent_address -> niosv_g:dm_agent_address
	wire          mm_interconnect_0_niosv_g_dm_agent_read;                   // mm_interconnect_0:niosv_g_dm_agent_read -> niosv_g:dm_agent_read
	wire          mm_interconnect_0_niosv_g_dm_agent_readdatavalid;          // niosv_g:dm_agent_readdatavalid -> mm_interconnect_0:niosv_g_dm_agent_readdatavalid
	wire          mm_interconnect_0_niosv_g_dm_agent_write;                  // mm_interconnect_0:niosv_g_dm_agent_write -> niosv_g:dm_agent_write
	wire   [31:0] mm_interconnect_0_niosv_g_dm_agent_writedata;              // mm_interconnect_0:niosv_g_dm_agent_writedata -> niosv_g:dm_agent_writedata
	wire   [31:0] mm_interconnect_0_mm_bridge_peripheral_s0_readdata;        // mm_bridge_peripheral:s0_readdata -> mm_interconnect_0:mm_bridge_peripheral_s0_readdata
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest;     // mm_bridge_peripheral:s0_waitrequest -> mm_interconnect_0:mm_bridge_peripheral_s0_waitrequest
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess;     // mm_interconnect_0:mm_bridge_peripheral_s0_debugaccess -> mm_bridge_peripheral:s0_debugaccess
	wire   [17:0] mm_interconnect_0_mm_bridge_peripheral_s0_address;         // mm_interconnect_0:mm_bridge_peripheral_s0_address -> mm_bridge_peripheral:s0_address
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_read;            // mm_interconnect_0:mm_bridge_peripheral_s0_read -> mm_bridge_peripheral:s0_read
	wire    [3:0] mm_interconnect_0_mm_bridge_peripheral_s0_byteenable;      // mm_interconnect_0:mm_bridge_peripheral_s0_byteenable -> mm_bridge_peripheral:s0_byteenable
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid;   // mm_bridge_peripheral:s0_readdatavalid -> mm_interconnect_0:mm_bridge_peripheral_s0_readdatavalid
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_write;           // mm_interconnect_0:mm_bridge_peripheral_s0_write -> mm_bridge_peripheral:s0_write
	wire   [31:0] mm_interconnect_0_mm_bridge_peripheral_s0_writedata;       // mm_interconnect_0:mm_bridge_peripheral_s0_writedata -> mm_bridge_peripheral:s0_writedata
	wire    [0:0] mm_interconnect_0_mm_bridge_peripheral_s0_burstcount;      // mm_interconnect_0:mm_bridge_peripheral_s0_burstcount -> mm_bridge_peripheral:s0_burstcount
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awburst;     // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awburst -> emif_io96b_ddr4comp:s0_axi4_awburst
	wire   [13:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awuser;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awuser -> emif_io96b_ddr4comp:s0_axi4_awuser
	wire    [7:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlen;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arlen -> emif_io96b_ddr4comp:s0_axi4_arlen
	wire    [3:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arqos;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arqos -> emif_io96b_ddr4comp:s0_axi4_arqos
	wire   [31:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wstrb;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_wstrb -> emif_io96b_ddr4comp:s0_axi4_wstrb
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wready;      // emif_io96b_ddr4comp:s0_axi4_wready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_wready
	wire    [6:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rid;         // emif_io96b_ddr4comp:s0_axi4_rid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rid
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rready;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rready -> emif_io96b_ddr4comp:s0_axi4_rready
	wire    [7:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlen;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awlen -> emif_io96b_ddr4comp:s0_axi4_awlen
	wire    [3:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awqos;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awqos -> emif_io96b_ddr4comp:s0_axi4_awqos
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wvalid;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_wvalid -> emif_io96b_ddr4comp:s0_axi4_wvalid
	wire   [29:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_araddr;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_araddr -> emif_io96b_ddr4comp:s0_axi4_araddr
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arprot;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arprot -> emif_io96b_ddr4comp:s0_axi4_arprot
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awprot;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awprot -> emif_io96b_ddr4comp:s0_axi4_awprot
	wire  [255:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wdata;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_wdata -> emif_io96b_ddr4comp:s0_axi4_wdata
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arvalid;     // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arvalid -> emif_io96b_ddr4comp:s0_axi4_arvalid
	wire    [6:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arid;        // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arid -> emif_io96b_ddr4comp:s0_axi4_arid
	wire    [0:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlock;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arlock -> emif_io96b_ddr4comp:s0_axi4_arlock
	wire    [0:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlock;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awlock -> emif_io96b_ddr4comp:s0_axi4_awlock
	wire   [29:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awaddr;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awaddr -> emif_io96b_ddr4comp:s0_axi4_awaddr
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bresp;       // emif_io96b_ddr4comp:s0_axi4_bresp -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_bresp
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arready;     // emif_io96b_ddr4comp:s0_axi4_arready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arready
	wire  [255:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rdata;       // emif_io96b_ddr4comp:s0_axi4_rdata -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rdata
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awready;     // emif_io96b_ddr4comp:s0_axi4_awready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awready
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arburst;     // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arburst -> emif_io96b_ddr4comp:s0_axi4_arburst
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arsize;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_arsize -> emif_io96b_ddr4comp:s0_axi4_arsize
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bready;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_bready -> emif_io96b_ddr4comp:s0_axi4_bready
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rlast;       // emif_io96b_ddr4comp:s0_axi4_rlast -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rlast
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wlast;       // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_wlast -> emif_io96b_ddr4comp:s0_axi4_wlast
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rresp;       // emif_io96b_ddr4comp:s0_axi4_rresp -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rresp
	wire    [6:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awid;        // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awid -> emif_io96b_ddr4comp:s0_axi4_awid
	wire    [6:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bid;         // emif_io96b_ddr4comp:s0_axi4_bid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_bid
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bvalid;      // emif_io96b_ddr4comp:s0_axi4_bvalid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_bvalid
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awsize;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awsize -> emif_io96b_ddr4comp:s0_axi4_awsize
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awvalid;     // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_awvalid -> emif_io96b_ddr4comp:s0_axi4_awvalid
	wire   [13:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_aruser;      // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_aruser -> emif_io96b_ddr4comp:s0_axi4_aruser
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rvalid;      // emif_io96b_ddr4comp:s0_axi4_rvalid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_rvalid
	wire   [26:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awaddr;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_awaddr -> emif_io96b_ddr4comp:s0_axi4lite_awaddr
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bresp;   // emif_io96b_ddr4comp:s0_axi4lite_bresp -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_bresp
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arready; // emif_io96b_ddr4comp:s0_axi4lite_arready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_arready
	wire   [31:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rdata;   // emif_io96b_ddr4comp:s0_axi4lite_rdata -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_rdata
	wire    [3:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wstrb;   // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_wstrb -> emif_io96b_ddr4comp:s0_axi4lite_wstrb
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wready;  // emif_io96b_ddr4comp:s0_axi4lite_wready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_wready
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awready; // emif_io96b_ddr4comp:s0_axi4lite_awready -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_awready
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rready;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_rready -> emif_io96b_ddr4comp:s0_axi4lite_rready
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bready;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_bready -> emif_io96b_ddr4comp:s0_axi4lite_bready
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wvalid;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_wvalid -> emif_io96b_ddr4comp:s0_axi4lite_wvalid
	wire   [26:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_araddr;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_araddr -> emif_io96b_ddr4comp:s0_axi4lite_araddr
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arprot;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_arprot -> emif_io96b_ddr4comp:s0_axi4lite_arprot
	wire    [1:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rresp;   // emif_io96b_ddr4comp:s0_axi4lite_rresp -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_rresp
	wire    [2:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awprot;  // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_awprot -> emif_io96b_ddr4comp:s0_axi4lite_awprot
	wire   [31:0] mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wdata;   // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_wdata -> emif_io96b_ddr4comp:s0_axi4lite_wdata
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arvalid; // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_arvalid -> emif_io96b_ddr4comp:s0_axi4lite_arvalid
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bvalid;  // emif_io96b_ddr4comp:s0_axi4lite_bvalid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_bvalid
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awvalid; // mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_awvalid -> emif_io96b_ddr4comp:s0_axi4lite_awvalid
	wire          mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rvalid;  // emif_io96b_ddr4comp:s0_axi4lite_rvalid -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4lite_rvalid
	wire   [31:0] mm_interconnect_0_onchip_memory_s1_readdata;               // onchip_memory:readdata -> mm_interconnect_0:onchip_memory_s1_readdata
	wire   [16:0] mm_interconnect_0_onchip_memory_s1_address;                // mm_interconnect_0:onchip_memory_s1_address -> onchip_memory:address
	wire          mm_interconnect_0_onchip_memory_s1_read;                   // mm_interconnect_0:onchip_memory_s1_read -> onchip_memory:read
	wire    [3:0] mm_interconnect_0_onchip_memory_s1_byteenable;             // mm_interconnect_0:onchip_memory_s1_byteenable -> onchip_memory:byteenable
	wire          mm_interconnect_0_onchip_memory_s1_write;                  // mm_interconnect_0:onchip_memory_s1_write -> onchip_memory:write
	wire   [31:0] mm_interconnect_0_onchip_memory_s1_writedata;              // mm_interconnect_0:onchip_memory_s1_writedata -> onchip_memory:writedata
	wire   [31:0] mm_interconnect_0_niosv_g_timer_sw_agent_readdata;         // niosv_g:timer_sw_agent_readdata -> mm_interconnect_0:niosv_g_timer_sw_agent_readdata
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest;      // niosv_g:timer_sw_agent_waitrequest -> mm_interconnect_0:niosv_g_timer_sw_agent_waitrequest
	wire    [5:0] mm_interconnect_0_niosv_g_timer_sw_agent_address;          // mm_interconnect_0:niosv_g_timer_sw_agent_address -> niosv_g:timer_sw_agent_address
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_read;             // mm_interconnect_0:niosv_g_timer_sw_agent_read -> niosv_g:timer_sw_agent_read
	wire    [3:0] mm_interconnect_0_niosv_g_timer_sw_agent_byteenable;       // mm_interconnect_0:niosv_g_timer_sw_agent_byteenable -> niosv_g:timer_sw_agent_byteenable
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid;    // niosv_g:timer_sw_agent_readdatavalid -> mm_interconnect_0:niosv_g_timer_sw_agent_readdatavalid
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_write;            // mm_interconnect_0:niosv_g_timer_sw_agent_write -> niosv_g:timer_sw_agent_write
	wire   [31:0] mm_interconnect_0_niosv_g_timer_sw_agent_writedata;        // mm_interconnect_0:niosv_g_timer_sw_agent_writedata -> niosv_g:timer_sw_agent_writedata
	wire          mm_bridge_peripheral_m0_waitrequest;                       // mm_interconnect_1:mm_bridge_peripheral_m0_waitrequest -> mm_bridge_peripheral:m0_waitrequest
	wire   [31:0] mm_bridge_peripheral_m0_readdata;                          // mm_interconnect_1:mm_bridge_peripheral_m0_readdata -> mm_bridge_peripheral:m0_readdata
	wire          mm_bridge_peripheral_m0_debugaccess;                       // mm_bridge_peripheral:m0_debugaccess -> mm_interconnect_1:mm_bridge_peripheral_m0_debugaccess
	wire   [17:0] mm_bridge_peripheral_m0_address;                           // mm_bridge_peripheral:m0_address -> mm_interconnect_1:mm_bridge_peripheral_m0_address
	wire          mm_bridge_peripheral_m0_read;                              // mm_bridge_peripheral:m0_read -> mm_interconnect_1:mm_bridge_peripheral_m0_read
	wire    [3:0] mm_bridge_peripheral_m0_byteenable;                        // mm_bridge_peripheral:m0_byteenable -> mm_interconnect_1:mm_bridge_peripheral_m0_byteenable
	wire          mm_bridge_peripheral_m0_readdatavalid;                     // mm_interconnect_1:mm_bridge_peripheral_m0_readdatavalid -> mm_bridge_peripheral:m0_readdatavalid
	wire   [31:0] mm_bridge_peripheral_m0_writedata;                         // mm_bridge_peripheral:m0_writedata -> mm_interconnect_1:mm_bridge_peripheral_m0_writedata
	wire          mm_bridge_peripheral_m0_write;                             // mm_bridge_peripheral:m0_write -> mm_interconnect_1:mm_bridge_peripheral_m0_write
	wire    [0:0] mm_bridge_peripheral_m0_burstcount;                        // mm_bridge_peripheral:m0_burstcount -> mm_interconnect_1:mm_bridge_peripheral_m0_burstcount
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect;  // mm_interconnect_1:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire   [31:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata;    // jtag_uart:av_readdata -> mm_interconnect_1:jtag_uart_avalon_jtag_slave_readdata
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest; // jtag_uart:av_waitrequest -> mm_interconnect_1:jtag_uart_avalon_jtag_slave_waitrequest
	wire    [0:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_address;     // mm_interconnect_1:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_read;        // mm_interconnect_1:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_write;       // mm_interconnect_1:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire   [31:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata;   // mm_interconnect_1:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire    [7:0] mm_interconnect_1_seg7_avalon_slave_readdata;              // seg7:s_readdata -> mm_interconnect_1:seg7_avalon_slave_readdata
	wire    [2:0] mm_interconnect_1_seg7_avalon_slave_address;               // mm_interconnect_1:seg7_avalon_slave_address -> seg7:s_address
	wire          mm_interconnect_1_seg7_avalon_slave_read;                  // mm_interconnect_1:seg7_avalon_slave_read -> seg7:s_read
	wire          mm_interconnect_1_seg7_avalon_slave_write;                 // mm_interconnect_1:seg7_avalon_slave_write -> seg7:s_write
	wire    [7:0] mm_interconnect_1_seg7_avalon_slave_writedata;             // mm_interconnect_1:seg7_avalon_slave_writedata -> seg7:s_writedata
	wire   [15:0] mm_interconnect_1_audio_avalon_slave_readdata;             // audio:avs_s1_readdata -> mm_interconnect_1:audio_avalon_slave_readdata
	wire    [2:0] mm_interconnect_1_audio_avalon_slave_address;              // mm_interconnect_1:audio_avalon_slave_address -> audio:avs_s1_address
	wire          mm_interconnect_1_audio_avalon_slave_read;                 // mm_interconnect_1:audio_avalon_slave_read -> audio:avs_s1_read
	wire          mm_interconnect_1_audio_avalon_slave_write;                // mm_interconnect_1:audio_avalon_slave_write -> audio:avs_s1_write
	wire   [15:0] mm_interconnect_1_audio_avalon_slave_writedata;            // mm_interconnect_1:audio_avalon_slave_writedata -> audio:avs_s1_writedata
	wire          mm_interconnect_1_audio_i2c_avalon_slave_0_chipselect;     // mm_interconnect_1:audio_i2c_avalon_slave_0_chipselect -> audio_i2c:wb_stb_i
	wire    [7:0] mm_interconnect_1_audio_i2c_avalon_slave_0_readdata;       // audio_i2c:wb_dat_o -> mm_interconnect_1:audio_i2c_avalon_slave_0_readdata
	wire          mm_interconnect_1_audio_i2c_avalon_slave_0_waitrequest;    // audio_i2c:wb_ack_o -> mm_interconnect_1:audio_i2c_avalon_slave_0_waitrequest
	wire    [2:0] mm_interconnect_1_audio_i2c_avalon_slave_0_address;        // mm_interconnect_1:audio_i2c_avalon_slave_0_address -> audio_i2c:wb_adr_i
	wire          mm_interconnect_1_audio_i2c_avalon_slave_0_write;          // mm_interconnect_1:audio_i2c_avalon_slave_0_write -> audio_i2c:wb_we_i
	wire    [7:0] mm_interconnect_1_audio_i2c_avalon_slave_0_writedata;      // mm_interconnect_1:audio_i2c_avalon_slave_0_writedata -> audio_i2c:wb_dat_i
	wire   [31:0] mm_interconnect_1_sysid_qsys_control_slave_readdata;       // sysid_qsys:readdata -> mm_interconnect_1:sysid_qsys_control_slave_readdata
	wire    [0:0] mm_interconnect_1_sysid_qsys_control_slave_address;        // mm_interconnect_1:sysid_qsys_control_slave_address -> sysid_qsys:address
	wire          mm_interconnect_1_pio_sw_s1_chipselect;                    // mm_interconnect_1:pio_sw_s1_chipselect -> pio_sw:chipselect
	wire   [31:0] mm_interconnect_1_pio_sw_s1_readdata;                      // pio_sw:readdata -> mm_interconnect_1:pio_sw_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_sw_s1_address;                       // mm_interconnect_1:pio_sw_s1_address -> pio_sw:address
	wire          mm_interconnect_1_pio_sw_s1_write;                         // mm_interconnect_1:pio_sw_s1_write -> pio_sw:write_n
	wire   [31:0] mm_interconnect_1_pio_sw_s1_writedata;                     // mm_interconnect_1:pio_sw_s1_writedata -> pio_sw:writedata
	wire          mm_interconnect_1_pio_led_s1_chipselect;                   // mm_interconnect_1:pio_led_s1_chipselect -> pio_led:chipselect
	wire   [31:0] mm_interconnect_1_pio_led_s1_readdata;                     // pio_led:readdata -> mm_interconnect_1:pio_led_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_led_s1_address;                      // mm_interconnect_1:pio_led_s1_address -> pio_led:address
	wire          mm_interconnect_1_pio_led_s1_write;                        // mm_interconnect_1:pio_led_s1_write -> pio_led:write_n
	wire   [31:0] mm_interconnect_1_pio_led_s1_writedata;                    // mm_interconnect_1:pio_led_s1_writedata -> pio_led:writedata
	wire          mm_interconnect_1_pio_key_s1_chipselect;                   // mm_interconnect_1:pio_key_s1_chipselect -> pio_key:chipselect
	wire   [31:0] mm_interconnect_1_pio_key_s1_readdata;                     // pio_key:readdata -> mm_interconnect_1:pio_key_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_key_s1_address;                      // mm_interconnect_1:pio_key_s1_address -> pio_key:address
	wire          mm_interconnect_1_pio_key_s1_write;                        // mm_interconnect_1:pio_key_s1_write -> pio_key:write_n
	wire   [31:0] mm_interconnect_1_pio_key_s1_writedata;                    // mm_interconnect_1:pio_key_s1_writedata -> pio_key:writedata
	wire   [31:0] mm_interconnect_1_pio_ddr4_cal_done_s1_readdata;           // pio_ddr4_cal_done:readdata -> mm_interconnect_1:pio_ddr4_cal_done_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_ddr4_cal_done_s1_address;            // mm_interconnect_1:pio_ddr4_cal_done_s1_address -> pio_ddr4_cal_done:address
	wire          irq_mapper_receiver0_irq;                                  // audio_i2c:wb_inta_o -> irq_mapper:receiver0_irq
	wire          irq_mapper_receiver1_irq;                                  // pio_sw:irq -> irq_mapper:receiver1_irq
	wire          irq_mapper_receiver2_irq;                                  // jtag_uart:av_irq -> irq_mapper:receiver2_irq
	wire          irq_mapper_receiver3_irq;                                  // pio_key:irq -> irq_mapper:receiver3_irq
	wire   [15:0] niosv_g_platform_irq_rx_irq;                               // irq_mapper:sender_irq -> niosv_g:platform_irq_rx_irq
	wire          rst_controller_reset_out_reset;                            // rst_controller:reset_out -> audio:avs_s1_reset
	wire          rst_controller_001_reset_out_reset;                        // rst_controller_001:reset_out -> [audio_i2c:wb_rst_i, emif_io96b_ddr4comp:s0_axi4lite_reset_n, irq_mapper:reset, jtag_uart:rst_n, niosv_g:reset_reset, onchip_memory:reset, pio_ddr4_cal_done:reset_n, pio_key:reset_n, pio_led:reset_n, pio_sw:reset_n, rst_translator:in_reset, seg7:s_reset, sysid_qsys:reset_n]
	wire          rst_controller_001_reset_out_reset_req;                    // rst_controller_001:reset_req -> [onchip_memory:reset_req, rst_translator:reset_req_in]
	wire          rst_controller_002_reset_out_reset;                        // rst_controller_002:reset_out -> [mm_bridge_peripheral:reset, mm_interconnect_0:mm_bridge_peripheral_reset_reset_bridge_in_reset_reset, mm_interconnect_0:niosv_g_reset_reset_bridge_in_reset_reset, mm_interconnect_1:jtag_uart_reset_reset_bridge_in_reset_reset, mm_interconnect_1:mm_bridge_peripheral_reset_reset_bridge_in_reset_reset]
	wire          rst_controller_003_reset_out_reset;                        // rst_controller_003:reset_out -> reset_bridge:in_reset_n
	wire          reset_in_out_reset_reset;                                  // reset_in:out_reset_n -> rst_controller_003:reset_in1
	wire          rst_controller_004_reset_out_reset;                        // rst_controller_004:reset_out -> mm_interconnect_0:emif_io96b_ddr4comp_s0_axi4_translator_clk_reset_reset_bridge_in_reset_reset
	wire          rst_controller_005_reset_out_reset;                        // rst_controller_005:reset_out -> [mm_interconnect_1:audio_avalon_slave_translator_reset_reset_bridge_in_reset_reset, mm_interconnect_1:audio_clock_sink_reset_reset_bridge_in_reset_reset]

	audio audio (
		.avs_s1_address       (mm_interconnect_1_audio_avalon_slave_address),   //   input,   width = 3,     avalon_slave.address
		.avs_s1_read          (mm_interconnect_1_audio_avalon_slave_read),      //   input,   width = 1,                 .read
		.avs_s1_readdata      (mm_interconnect_1_audio_avalon_slave_readdata),  //  output,  width = 16,                 .readdata
		.avs_s1_write         (mm_interconnect_1_audio_avalon_slave_write),     //   input,   width = 1,                 .write
		.avs_s1_writedata     (mm_interconnect_1_audio_avalon_slave_writedata), //   input,  width = 16,                 .writedata
		.avs_s1_clk           (pll_audio_outclk0_clk),                          //   input,   width = 1,       clock_sink.clk
		.avs_s1_reset         (rst_controller_reset_out_reset),                 //   input,   width = 1, clock_sink_reset.reset
		.avs_s1_export_XCK    (audio_conduit_end_XCK),                          //  output,   width = 1,      conduit_end.XCK
		.avs_s1_export_ADCDAT (audio_conduit_end_ADCDAT),                       //   input,   width = 1,                 .ADCDAT
		.avs_s1_export_ADCLRC (audio_conduit_end_ADCLRC),                       //   input,   width = 1,                 .ADCLRC
		.avs_s1_export_DACDAT (audio_conduit_end_DACDAT),                       //  output,   width = 1,                 .DACDAT
		.avs_s1_export_DACLRC (audio_conduit_end_DACLRC),                       //   input,   width = 1,                 .DACLRC
		.avs_s1_export_BCLK   (audio_conduit_end_BCLK)                          //   input,   width = 1,                 .BCLK
	);

	audio_i2c audio_i2c (
		.wb_clk_i   (iopll_outclk0_clk),                                      //   input,  width = 1,            clock.clk
		.wb_rst_i   (rst_controller_001_reset_out_reset),                     //   input,  width = 1,      clock_reset.reset
		.scl_pad_io (audio_i2c_export_scl_pad_io),                            //   inout,  width = 1,           export.scl_pad_io
		.sda_pad_io (audio_i2c_export_sda_pad_io),                            //   inout,  width = 1,                 .sda_pad_io
		.wb_adr_i   (mm_interconnect_1_audio_i2c_avalon_slave_0_address),     //   input,  width = 3,   avalon_slave_0.address
		.wb_dat_i   (mm_interconnect_1_audio_i2c_avalon_slave_0_writedata),   //   input,  width = 8,                 .writedata
		.wb_dat_o   (mm_interconnect_1_audio_i2c_avalon_slave_0_readdata),    //  output,  width = 8,                 .readdata
		.wb_we_i    (mm_interconnect_1_audio_i2c_avalon_slave_0_write),       //   input,  width = 1,                 .write
		.wb_stb_i   (mm_interconnect_1_audio_i2c_avalon_slave_0_chipselect),  //   input,  width = 1,                 .chipselect
		.wb_ack_o   (mm_interconnect_1_audio_i2c_avalon_slave_0_waitrequest), //  output,  width = 1,                 .waitrequest_n
		.wb_inta_o  (irq_mapper_receiver0_irq)                                //  output,  width = 1, interrupt_sender.irq
	);

	clock_in clock_in (
		.in_clk  (clk_clk),              //   input,  width = 1,  in_clk.clk
		.out_clk (clock_in_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	nios_system_emif_io96b_ddr4comp_0 emif_io96b_ddr4comp (
		.s0_axi4_clock_in    (iopll_outclk0_clk),                                         //   input,    width = 1,    s0_axi4_clock_in.clk
		.s0_axi4_reset_n     (emif_io96b_ddr4comp_s0_axi4_ctrl_ready_reset_n),            //  output,    width = 1,  s0_axi4_ctrl_ready.reset_n
		.core_init_n         (~reset_release_ninit_done_reset),                           //   input,    width = 1,         core_init_n.reset_n
		.s0_axi4_awaddr      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awaddr),      //   input,   width = 30,             s0_axi4.awaddr
		.s0_axi4_awburst     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awburst),     //   input,    width = 2,                    .awburst
		.s0_axi4_awid        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awid),        //   input,    width = 7,                    .awid
		.s0_axi4_awlen       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlen),       //   input,    width = 8,                    .awlen
		.s0_axi4_awlock      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlock),      //   input,    width = 1,                    .awlock
		.s0_axi4_awqos       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awqos),       //   input,    width = 4,                    .awqos
		.s0_axi4_awsize      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awsize),      //   input,    width = 3,                    .awsize
		.s0_axi4_awvalid     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awvalid),     //   input,    width = 1,                    .awvalid
		.s0_axi4_awuser      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awuser),      //   input,   width = 14,                    .awuser
		.s0_axi4_awprot      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awprot),      //   input,    width = 3,                    .awprot
		.s0_axi4_awready     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awready),     //  output,    width = 1,                    .awready
		.s0_axi4_araddr      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_araddr),      //   input,   width = 30,                    .araddr
		.s0_axi4_arburst     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arburst),     //   input,    width = 2,                    .arburst
		.s0_axi4_arid        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arid),        //   input,    width = 7,                    .arid
		.s0_axi4_arlen       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlen),       //   input,    width = 8,                    .arlen
		.s0_axi4_arlock      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlock),      //   input,    width = 1,                    .arlock
		.s0_axi4_arqos       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arqos),       //   input,    width = 4,                    .arqos
		.s0_axi4_arsize      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arsize),      //   input,    width = 3,                    .arsize
		.s0_axi4_arvalid     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arvalid),     //   input,    width = 1,                    .arvalid
		.s0_axi4_aruser      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_aruser),      //   input,   width = 14,                    .aruser
		.s0_axi4_arprot      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arprot),      //   input,    width = 3,                    .arprot
		.s0_axi4_arready     (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arready),     //  output,    width = 1,                    .arready
		.s0_axi4_wdata       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wdata),       //   input,  width = 256,                    .wdata
		.s0_axi4_wstrb       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wstrb),       //   input,   width = 32,                    .wstrb
		.s0_axi4_wlast       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wlast),       //   input,    width = 1,                    .wlast
		.s0_axi4_wvalid      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wvalid),      //   input,    width = 1,                    .wvalid
		.s0_axi4_wready      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wready),      //  output,    width = 1,                    .wready
		.s0_axi4_bready      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bready),      //   input,    width = 1,                    .bready
		.s0_axi4_bid         (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bid),         //  output,    width = 7,                    .bid
		.s0_axi4_bresp       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bresp),       //  output,    width = 2,                    .bresp
		.s0_axi4_bvalid      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bvalid),      //  output,    width = 1,                    .bvalid
		.s0_axi4_rready      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rready),      //   input,    width = 1,                    .rready
		.s0_axi4_rdata       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rdata),       //  output,  width = 256,                    .rdata
		.s0_axi4_rid         (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rid),         //  output,    width = 7,                    .rid
		.s0_axi4_rlast       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rlast),       //  output,    width = 1,                    .rlast
		.s0_axi4_rresp       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rresp),       //  output,    width = 2,                    .rresp
		.s0_axi4_rvalid      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rvalid),      //  output,    width = 1,                    .rvalid
		.s0_axi4lite_clock   (iopll_outclk0_clk),                                         //   input,    width = 1,   s0_axi4lite_clock.clk
		.s0_axi4lite_reset_n (~rst_controller_001_reset_out_reset),                       //   input,    width = 1, s0_axi4lite_reset_n.reset_n
		.s0_axi4lite_awaddr  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awaddr),  //   input,   width = 27,         s0_axi4lite.awaddr
		.s0_axi4lite_awprot  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awprot),  //   input,    width = 3,                    .awprot
		.s0_axi4lite_awvalid (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awvalid), //   input,    width = 1,                    .awvalid
		.s0_axi4lite_awready (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awready), //  output,    width = 1,                    .awready
		.s0_axi4lite_araddr  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_araddr),  //   input,   width = 27,                    .araddr
		.s0_axi4lite_arprot  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arprot),  //   input,    width = 3,                    .arprot
		.s0_axi4lite_arvalid (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arvalid), //   input,    width = 1,                    .arvalid
		.s0_axi4lite_arready (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arready), //  output,    width = 1,                    .arready
		.s0_axi4lite_wdata   (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wdata),   //   input,   width = 32,                    .wdata
		.s0_axi4lite_wstrb   (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wstrb),   //   input,    width = 4,                    .wstrb
		.s0_axi4lite_wvalid  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wvalid),  //   input,    width = 1,                    .wvalid
		.s0_axi4lite_wready  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wready),  //  output,    width = 1,                    .wready
		.s0_axi4lite_bready  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bready),  //   input,    width = 1,                    .bready
		.s0_axi4lite_bresp   (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bresp),   //  output,    width = 2,                    .bresp
		.s0_axi4lite_bvalid  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bvalid),  //  output,    width = 1,                    .bvalid
		.s0_axi4lite_rready  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rready),  //   input,    width = 1,                    .rready
		.s0_axi4lite_rdata   (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rdata),   //  output,   width = 32,                    .rdata
		.s0_axi4lite_rresp   (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rresp),   //  output,    width = 2,                    .rresp
		.s0_axi4lite_rvalid  (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rvalid),  //  output,    width = 1,                    .rvalid
		.mem_0_cke           (emif_io96b_ddr4comp_mem_0_mem_cke),                         //  output,    width = 1,               mem_0.mem_cke
		.mem_0_odt           (emif_io96b_ddr4comp_mem_0_mem_odt),                         //  output,    width = 1,                    .mem_odt
		.mem_0_cs_n          (emif_io96b_ddr4comp_mem_0_mem_cs_n),                        //  output,    width = 1,                    .mem_cs_n
		.mem_0_a             (emif_io96b_ddr4comp_mem_0_mem_a),                           //  output,   width = 17,                    .mem_a
		.mem_0_ba            (emif_io96b_ddr4comp_mem_0_mem_ba),                          //  output,    width = 2,                    .mem_ba
		.mem_0_bg            (emif_io96b_ddr4comp_mem_0_mem_bg),                          //  output,    width = 1,                    .mem_bg
		.mem_0_act_n         (emif_io96b_ddr4comp_mem_0_mem_act_n),                       //  output,    width = 1,                    .mem_act_n
		.mem_0_par           (emif_io96b_ddr4comp_mem_0_mem_par),                         //  output,    width = 1,                    .mem_par
		.mem_0_dq            (emif_io96b_ddr4comp_mem_0_mem_dq),                          //   inout,   width = 32,                    .mem_dq
		.mem_0_dqs_t         (emif_io96b_ddr4comp_mem_0_mem_dqs_t),                       //   inout,    width = 4,                    .mem_dqs_t
		.mem_0_dqs_c         (emif_io96b_ddr4comp_mem_0_mem_dqs_c),                       //   inout,    width = 4,                    .mem_dqs_c
		.mem_0_alert_n       (emif_io96b_ddr4comp_mem_0_mem_alert_n),                     //   input,    width = 1,                    .mem_alert_n
		.mem_0_dbi_n         (emif_io96b_ddr4comp_mem_0_mem_dbi_n),                       //   inout,    width = 4,                    .mem_dbi_n
		.mem_0_ck_t          (emif_io96b_ddr4comp_mem_ck_0_mem_ck_t),                     //  output,    width = 1,            mem_ck_0.mem_ck_t
		.mem_0_ck_c          (emif_io96b_ddr4comp_mem_ck_0_mem_ck_c),                     //  output,    width = 1,                    .mem_ck_c
		.mem_0_reset_n       (emif_io96b_ddr4comp_mem_reset_n_mem_reset_n),               //  output,    width = 1,         mem_reset_n.mem_reset_n
		.oct_rzqin_0         (emif_io96b_ddr4comp_oct_0_oct_rzqin),                       //   input,    width = 1,               oct_0.oct_rzqin
		.ref_clk             (emif_io96b_ddr4comp_ref_clk_clk)                            //   input,    width = 1,             ref_clk.clk
	);

	iopll iopll (
		.refclk   (clock_in_out_clk_clk),          //   input,  width = 1,  refclk.clk
		.rst      (~reset_bridge_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (iopll_outclk0_clk)              //  output,  width = 1, outclk0.clk
	);

	jtag_uart jtag_uart (
		.clk            (iopll_outclk0_clk),                                         //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_001_reset_out_reset),                       //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_1_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_1_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_1_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver2_irq)                                   //  output,   width = 1,               irq.irq
	);

	mm_bridge_peripheral mm_bridge_peripheral (
		.clk              (iopll_outclk0_clk),                                       //   input,   width = 1,   clk.clk
		.reset            (rst_controller_002_reset_out_reset),                      //   input,   width = 1, reset.reset
		.s0_waitrequest   (mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest),   //  output,   width = 1,    s0.waitrequest
		.s0_readdata      (mm_interconnect_0_mm_bridge_peripheral_s0_readdata),      //  output,  width = 32,      .readdata
		.s0_readdatavalid (mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid), //  output,   width = 1,      .readdatavalid
		.s0_burstcount    (mm_interconnect_0_mm_bridge_peripheral_s0_burstcount),    //   input,   width = 1,      .burstcount
		.s0_writedata     (mm_interconnect_0_mm_bridge_peripheral_s0_writedata),     //   input,  width = 32,      .writedata
		.s0_address       (mm_interconnect_0_mm_bridge_peripheral_s0_address),       //   input,  width = 18,      .address
		.s0_write         (mm_interconnect_0_mm_bridge_peripheral_s0_write),         //   input,   width = 1,      .write
		.s0_read          (mm_interconnect_0_mm_bridge_peripheral_s0_read),          //   input,   width = 1,      .read
		.s0_byteenable    (mm_interconnect_0_mm_bridge_peripheral_s0_byteenable),    //   input,   width = 4,      .byteenable
		.s0_debugaccess   (mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess),   //   input,   width = 1,      .debugaccess
		.m0_waitrequest   (mm_bridge_peripheral_m0_waitrequest),                     //   input,   width = 1,    m0.waitrequest
		.m0_readdata      (mm_bridge_peripheral_m0_readdata),                        //   input,  width = 32,      .readdata
		.m0_readdatavalid (mm_bridge_peripheral_m0_readdatavalid),                   //   input,   width = 1,      .readdatavalid
		.m0_burstcount    (mm_bridge_peripheral_m0_burstcount),                      //  output,   width = 1,      .burstcount
		.m0_writedata     (mm_bridge_peripheral_m0_writedata),                       //  output,  width = 32,      .writedata
		.m0_address       (mm_bridge_peripheral_m0_address),                         //  output,  width = 18,      .address
		.m0_write         (mm_bridge_peripheral_m0_write),                           //  output,   width = 1,      .write
		.m0_read          (mm_bridge_peripheral_m0_read),                            //  output,   width = 1,      .read
		.m0_byteenable    (mm_bridge_peripheral_m0_byteenable),                      //  output,   width = 4,      .byteenable
		.m0_debugaccess   (mm_bridge_peripheral_m0_debugaccess)                      //  output,   width = 1,      .debugaccess
	);

	niosv_g niosv_g (
		.clk                          (iopll_outclk0_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_001_reset_out_reset),                     //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (niosv_g_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awaddr   (niosv_g_instruction_manager_awaddr),                     //  output,  width = 32, instruction_manager.awaddr
		.instruction_manager_awlen    (niosv_g_instruction_manager_awlen),                      //  output,   width = 8,                    .awlen
		.instruction_manager_awsize   (niosv_g_instruction_manager_awsize),                     //  output,   width = 3,                    .awsize
		.instruction_manager_awburst  (niosv_g_instruction_manager_awburst),                    //  output,   width = 2,                    .awburst
		.instruction_manager_awprot   (niosv_g_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (niosv_g_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awready  (niosv_g_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (niosv_g_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (niosv_g_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wlast    (niosv_g_instruction_manager_wlast),                      //  output,   width = 1,                    .wlast
		.instruction_manager_wvalid   (niosv_g_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (niosv_g_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (niosv_g_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (niosv_g_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (niosv_g_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (niosv_g_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arlen    (niosv_g_instruction_manager_arlen),                      //  output,   width = 8,                    .arlen
		.instruction_manager_arsize   (niosv_g_instruction_manager_arsize),                     //  output,   width = 3,                    .arsize
		.instruction_manager_arburst  (niosv_g_instruction_manager_arburst),                    //  output,   width = 2,                    .arburst
		.instruction_manager_arprot   (niosv_g_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (niosv_g_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arready  (niosv_g_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (niosv_g_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (niosv_g_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rlast    (niosv_g_instruction_manager_rlast),                      //   input,   width = 1,                    .rlast
		.instruction_manager_rvalid   (niosv_g_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (niosv_g_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.data_manager_awaddr          (niosv_g_data_manager_awaddr),                            //  output,  width = 32,        data_manager.awaddr
		.data_manager_awlen           (niosv_g_data_manager_awlen),                             //  output,   width = 8,                    .awlen
		.data_manager_awsize          (niosv_g_data_manager_awsize),                            //  output,   width = 3,                    .awsize
		.data_manager_awprot          (niosv_g_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (niosv_g_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (niosv_g_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (niosv_g_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (niosv_g_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wlast           (niosv_g_data_manager_wlast),                             //  output,   width = 1,                    .wlast
		.data_manager_wvalid          (niosv_g_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (niosv_g_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (niosv_g_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (niosv_g_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (niosv_g_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (niosv_g_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arlen           (niosv_g_data_manager_arlen),                             //  output,   width = 8,                    .arlen
		.data_manager_arsize          (niosv_g_data_manager_arsize),                            //  output,   width = 3,                    .arsize
		.data_manager_arprot          (niosv_g_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (niosv_g_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (niosv_g_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (niosv_g_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (niosv_g_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rlast           (niosv_g_data_manager_rlast),                             //   input,   width = 1,                    .rlast
		.data_manager_rvalid          (niosv_g_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rready          (niosv_g_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_address       (mm_interconnect_0_niosv_g_timer_sw_agent_address),       //   input,   width = 6,      timer_sw_agent.address
		.timer_sw_agent_byteenable    (mm_interconnect_0_niosv_g_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_read          (mm_interconnect_0_niosv_g_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_niosv_g_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_write         (mm_interconnect_0_niosv_g_timer_sw_agent_write),         //   input,   width = 1,                    .write
		.timer_sw_agent_writedata     (mm_interconnect_0_niosv_g_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_waitrequest   (mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.timer_sw_agent_readdatavalid (mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.dm_agent_address             (mm_interconnect_0_niosv_g_dm_agent_address),             //   input,  width = 16,            dm_agent.address
		.dm_agent_read                (mm_interconnect_0_niosv_g_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_niosv_g_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_write               (mm_interconnect_0_niosv_g_dm_agent_write),               //   input,   width = 1,                    .write
		.dm_agent_writedata           (mm_interconnect_0_niosv_g_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_waitrequest         (mm_interconnect_0_niosv_g_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dm_agent_readdatavalid       (mm_interconnect_0_niosv_g_dm_agent_readdatavalid)        //  output,   width = 1,                    .readdatavalid
	);

	onchip_memory onchip_memory (
		.clk        (iopll_outclk0_clk),                             //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_onchip_memory_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_onchip_memory_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_onchip_memory_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_onchip_memory_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_onchip_memory_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_onchip_memory_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_001_reset_out_reset),            //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_001_reset_out_reset_req)         //   input,   width = 1,       .reset_req
	);

	nios_system_pio_0 pio_ddr4_cal_done (
		.clk      (iopll_outclk0_clk),                               //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_001_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_1_pio_ddr4_cal_done_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_1_pio_ddr4_cal_done_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pio_ddr4_cal_done_external_connection_export)     //   input,   width = 1, external_connection.export
	);

	pio_key pio_key (
		.clk        (iopll_outclk0_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_001_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_key_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_key_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_key_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_key_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_key_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (key_external_connection_export),          //   input,   width = 4, external_connection.export
		.irq        (irq_mapper_receiver3_irq)                 //  output,   width = 1,                 irq.irq
	);

	pio_led pio_led (
		.clk        (iopll_outclk0_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_001_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_led_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_led_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_led_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_led_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_led_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (led_external_connection_export)           //  output,  width = 10, external_connection.export
	);

	pio_sw pio_sw (
		.clk        (iopll_outclk0_clk),                      //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_001_reset_out_reset),    //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_sw_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_sw_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_sw_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_sw_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_sw_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (sw_external_connection_export),          //   input,  width = 10, external_connection.export
		.irq        (irq_mapper_receiver1_irq)                //  output,   width = 1,                 irq.irq
	);

	pll_audio pll_audio (
		.refclk   (clock_in_out_clk_clk),          //   input,  width = 1,  refclk.clk
		.rst      (~reset_bridge_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (pll_audio_outclk0_clk)          //  output,  width = 1, outclk0.clk
	);

	reset_bridge reset_bridge (
		.clk         (clock_in_out_clk_clk),                //   input,  width = 1,       clk.clk
		.in_reset_n  (~rst_controller_003_reset_out_reset), //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_bridge_out_reset_reset)         //  output,  width = 1, out_reset.reset_n
	);

	reset_in reset_in (
		.clk         (clock_in_out_clk_clk),     //   input,  width = 1,       clk.clk
		.in_reset_n  (reset_reset_n),            //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_in_out_reset_reset)  //  output,  width = 1, out_reset.reset_n
	);

	reset_release reset_release (
		.ninit_done (reset_release_ninit_done_reset)  //  output,  width = 1, ninit_done.reset
	);

	seg7 seg7 (
		.s_address   (mm_interconnect_1_seg7_avalon_slave_address),   //   input,   width = 3,     avalon_slave.address
		.s_read      (mm_interconnect_1_seg7_avalon_slave_read),      //   input,   width = 1,                 .read
		.s_readdata  (mm_interconnect_1_seg7_avalon_slave_readdata),  //  output,   width = 8,                 .readdata
		.s_write     (mm_interconnect_1_seg7_avalon_slave_write),     //   input,   width = 1,                 .write
		.s_writedata (mm_interconnect_1_seg7_avalon_slave_writedata), //   input,   width = 8,                 .writedata
		.SEG7        (seg7_conduit_end_export),                       //  output,  width = 48,      conduit_end.export
		.s_clk       (iopll_outclk0_clk),                             //   input,   width = 1,       clock_sink.clk
		.s_reset     (rst_controller_001_reset_out_reset)             //   input,   width = 1, clock_sink_reset.reset
	);

	sysid_qsys sysid_qsys (
		.clock    (iopll_outclk0_clk),                                   //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_001_reset_out_reset),                 //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_1_sysid_qsys_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_1_sysid_qsys_control_slave_address)   //   input,   width = 1,              .address
	);

	nios_system_altera_mm_interconnect_1920_rvke4ui mm_interconnect_0 (
		.niosv_g_data_manager_awaddr                                                  (niosv_g_data_manager_awaddr),                               //   input,   width = 32,                                                   niosv_g_data_manager.awaddr
		.niosv_g_data_manager_awlen                                                   (niosv_g_data_manager_awlen),                                //   input,    width = 8,                                                                       .awlen
		.niosv_g_data_manager_awsize                                                  (niosv_g_data_manager_awsize),                               //   input,    width = 3,                                                                       .awsize
		.niosv_g_data_manager_awprot                                                  (niosv_g_data_manager_awprot),                               //   input,    width = 3,                                                                       .awprot
		.niosv_g_data_manager_awvalid                                                 (niosv_g_data_manager_awvalid),                              //   input,    width = 1,                                                                       .awvalid
		.niosv_g_data_manager_awready                                                 (niosv_g_data_manager_awready),                              //  output,    width = 1,                                                                       .awready
		.niosv_g_data_manager_wdata                                                   (niosv_g_data_manager_wdata),                                //   input,   width = 32,                                                                       .wdata
		.niosv_g_data_manager_wstrb                                                   (niosv_g_data_manager_wstrb),                                //   input,    width = 4,                                                                       .wstrb
		.niosv_g_data_manager_wlast                                                   (niosv_g_data_manager_wlast),                                //   input,    width = 1,                                                                       .wlast
		.niosv_g_data_manager_wvalid                                                  (niosv_g_data_manager_wvalid),                               //   input,    width = 1,                                                                       .wvalid
		.niosv_g_data_manager_wready                                                  (niosv_g_data_manager_wready),                               //  output,    width = 1,                                                                       .wready
		.niosv_g_data_manager_bresp                                                   (niosv_g_data_manager_bresp),                                //  output,    width = 2,                                                                       .bresp
		.niosv_g_data_manager_bvalid                                                  (niosv_g_data_manager_bvalid),                               //  output,    width = 1,                                                                       .bvalid
		.niosv_g_data_manager_bready                                                  (niosv_g_data_manager_bready),                               //   input,    width = 1,                                                                       .bready
		.niosv_g_data_manager_araddr                                                  (niosv_g_data_manager_araddr),                               //   input,   width = 32,                                                                       .araddr
		.niosv_g_data_manager_arlen                                                   (niosv_g_data_manager_arlen),                                //   input,    width = 8,                                                                       .arlen
		.niosv_g_data_manager_arsize                                                  (niosv_g_data_manager_arsize),                               //   input,    width = 3,                                                                       .arsize
		.niosv_g_data_manager_arprot                                                  (niosv_g_data_manager_arprot),                               //   input,    width = 3,                                                                       .arprot
		.niosv_g_data_manager_arvalid                                                 (niosv_g_data_manager_arvalid),                              //   input,    width = 1,                                                                       .arvalid
		.niosv_g_data_manager_arready                                                 (niosv_g_data_manager_arready),                              //  output,    width = 1,                                                                       .arready
		.niosv_g_data_manager_rdata                                                   (niosv_g_data_manager_rdata),                                //  output,   width = 32,                                                                       .rdata
		.niosv_g_data_manager_rresp                                                   (niosv_g_data_manager_rresp),                                //  output,    width = 2,                                                                       .rresp
		.niosv_g_data_manager_rlast                                                   (niosv_g_data_manager_rlast),                                //  output,    width = 1,                                                                       .rlast
		.niosv_g_data_manager_rvalid                                                  (niosv_g_data_manager_rvalid),                               //  output,    width = 1,                                                                       .rvalid
		.niosv_g_data_manager_rready                                                  (niosv_g_data_manager_rready),                               //   input,    width = 1,                                                                       .rready
		.niosv_g_instruction_manager_awaddr                                           (niosv_g_instruction_manager_awaddr),                        //   input,   width = 32,                                            niosv_g_instruction_manager.awaddr
		.niosv_g_instruction_manager_awlen                                            (niosv_g_instruction_manager_awlen),                         //   input,    width = 8,                                                                       .awlen
		.niosv_g_instruction_manager_awsize                                           (niosv_g_instruction_manager_awsize),                        //   input,    width = 3,                                                                       .awsize
		.niosv_g_instruction_manager_awburst                                          (niosv_g_instruction_manager_awburst),                       //   input,    width = 2,                                                                       .awburst
		.niosv_g_instruction_manager_awprot                                           (niosv_g_instruction_manager_awprot),                        //   input,    width = 3,                                                                       .awprot
		.niosv_g_instruction_manager_awvalid                                          (niosv_g_instruction_manager_awvalid),                       //   input,    width = 1,                                                                       .awvalid
		.niosv_g_instruction_manager_awready                                          (niosv_g_instruction_manager_awready),                       //  output,    width = 1,                                                                       .awready
		.niosv_g_instruction_manager_wdata                                            (niosv_g_instruction_manager_wdata),                         //   input,   width = 32,                                                                       .wdata
		.niosv_g_instruction_manager_wstrb                                            (niosv_g_instruction_manager_wstrb),                         //   input,    width = 4,                                                                       .wstrb
		.niosv_g_instruction_manager_wlast                                            (niosv_g_instruction_manager_wlast),                         //   input,    width = 1,                                                                       .wlast
		.niosv_g_instruction_manager_wvalid                                           (niosv_g_instruction_manager_wvalid),                        //   input,    width = 1,                                                                       .wvalid
		.niosv_g_instruction_manager_wready                                           (niosv_g_instruction_manager_wready),                        //  output,    width = 1,                                                                       .wready
		.niosv_g_instruction_manager_bresp                                            (niosv_g_instruction_manager_bresp),                         //  output,    width = 2,                                                                       .bresp
		.niosv_g_instruction_manager_bvalid                                           (niosv_g_instruction_manager_bvalid),                        //  output,    width = 1,                                                                       .bvalid
		.niosv_g_instruction_manager_bready                                           (niosv_g_instruction_manager_bready),                        //   input,    width = 1,                                                                       .bready
		.niosv_g_instruction_manager_araddr                                           (niosv_g_instruction_manager_araddr),                        //   input,   width = 32,                                                                       .araddr
		.niosv_g_instruction_manager_arlen                                            (niosv_g_instruction_manager_arlen),                         //   input,    width = 8,                                                                       .arlen
		.niosv_g_instruction_manager_arsize                                           (niosv_g_instruction_manager_arsize),                        //   input,    width = 3,                                                                       .arsize
		.niosv_g_instruction_manager_arburst                                          (niosv_g_instruction_manager_arburst),                       //   input,    width = 2,                                                                       .arburst
		.niosv_g_instruction_manager_arprot                                           (niosv_g_instruction_manager_arprot),                        //   input,    width = 3,                                                                       .arprot
		.niosv_g_instruction_manager_arvalid                                          (niosv_g_instruction_manager_arvalid),                       //   input,    width = 1,                                                                       .arvalid
		.niosv_g_instruction_manager_arready                                          (niosv_g_instruction_manager_arready),                       //  output,    width = 1,                                                                       .arready
		.niosv_g_instruction_manager_rdata                                            (niosv_g_instruction_manager_rdata),                         //  output,   width = 32,                                                                       .rdata
		.niosv_g_instruction_manager_rresp                                            (niosv_g_instruction_manager_rresp),                         //  output,    width = 2,                                                                       .rresp
		.niosv_g_instruction_manager_rlast                                            (niosv_g_instruction_manager_rlast),                         //  output,    width = 1,                                                                       .rlast
		.niosv_g_instruction_manager_rvalid                                           (niosv_g_instruction_manager_rvalid),                        //  output,    width = 1,                                                                       .rvalid
		.niosv_g_instruction_manager_rready                                           (niosv_g_instruction_manager_rready),                        //   input,    width = 1,                                                                       .rready
		.niosv_g_dm_agent_address                                                     (mm_interconnect_0_niosv_g_dm_agent_address),                //  output,   width = 16,                                                       niosv_g_dm_agent.address
		.niosv_g_dm_agent_write                                                       (mm_interconnect_0_niosv_g_dm_agent_write),                  //  output,    width = 1,                                                                       .write
		.niosv_g_dm_agent_read                                                        (mm_interconnect_0_niosv_g_dm_agent_read),                   //  output,    width = 1,                                                                       .read
		.niosv_g_dm_agent_readdata                                                    (mm_interconnect_0_niosv_g_dm_agent_readdata),               //   input,   width = 32,                                                                       .readdata
		.niosv_g_dm_agent_writedata                                                   (mm_interconnect_0_niosv_g_dm_agent_writedata),              //  output,   width = 32,                                                                       .writedata
		.niosv_g_dm_agent_readdatavalid                                               (mm_interconnect_0_niosv_g_dm_agent_readdatavalid),          //   input,    width = 1,                                                                       .readdatavalid
		.niosv_g_dm_agent_waitrequest                                                 (mm_interconnect_0_niosv_g_dm_agent_waitrequest),            //   input,    width = 1,                                                                       .waitrequest
		.mm_bridge_peripheral_s0_address                                              (mm_interconnect_0_mm_bridge_peripheral_s0_address),         //  output,   width = 18,                                                mm_bridge_peripheral_s0.address
		.mm_bridge_peripheral_s0_write                                                (mm_interconnect_0_mm_bridge_peripheral_s0_write),           //  output,    width = 1,                                                                       .write
		.mm_bridge_peripheral_s0_read                                                 (mm_interconnect_0_mm_bridge_peripheral_s0_read),            //  output,    width = 1,                                                                       .read
		.mm_bridge_peripheral_s0_readdata                                             (mm_interconnect_0_mm_bridge_peripheral_s0_readdata),        //   input,   width = 32,                                                                       .readdata
		.mm_bridge_peripheral_s0_writedata                                            (mm_interconnect_0_mm_bridge_peripheral_s0_writedata),       //  output,   width = 32,                                                                       .writedata
		.mm_bridge_peripheral_s0_burstcount                                           (mm_interconnect_0_mm_bridge_peripheral_s0_burstcount),      //  output,    width = 1,                                                                       .burstcount
		.mm_bridge_peripheral_s0_byteenable                                           (mm_interconnect_0_mm_bridge_peripheral_s0_byteenable),      //  output,    width = 4,                                                                       .byteenable
		.mm_bridge_peripheral_s0_readdatavalid                                        (mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid),   //   input,    width = 1,                                                                       .readdatavalid
		.mm_bridge_peripheral_s0_waitrequest                                          (mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest),     //   input,    width = 1,                                                                       .waitrequest
		.mm_bridge_peripheral_s0_debugaccess                                          (mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess),     //  output,    width = 1,                                                                       .debugaccess
		.emif_io96b_ddr4comp_s0_axi4_awid                                             (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awid),        //  output,    width = 7,                                            emif_io96b_ddr4comp_s0_axi4.awid
		.emif_io96b_ddr4comp_s0_axi4_awaddr                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awaddr),      //  output,   width = 30,                                                                       .awaddr
		.emif_io96b_ddr4comp_s0_axi4_awlen                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlen),       //  output,    width = 8,                                                                       .awlen
		.emif_io96b_ddr4comp_s0_axi4_awsize                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awsize),      //  output,    width = 3,                                                                       .awsize
		.emif_io96b_ddr4comp_s0_axi4_awburst                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awburst),     //  output,    width = 2,                                                                       .awburst
		.emif_io96b_ddr4comp_s0_axi4_awlock                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awlock),      //  output,    width = 1,                                                                       .awlock
		.emif_io96b_ddr4comp_s0_axi4_awprot                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awprot),      //  output,    width = 3,                                                                       .awprot
		.emif_io96b_ddr4comp_s0_axi4_awuser                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awuser),      //  output,   width = 14,                                                                       .awuser
		.emif_io96b_ddr4comp_s0_axi4_awqos                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awqos),       //  output,    width = 4,                                                                       .awqos
		.emif_io96b_ddr4comp_s0_axi4_awvalid                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awvalid),     //  output,    width = 1,                                                                       .awvalid
		.emif_io96b_ddr4comp_s0_axi4_awready                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_awready),     //   input,    width = 1,                                                                       .awready
		.emif_io96b_ddr4comp_s0_axi4_wdata                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wdata),       //  output,  width = 256,                                                                       .wdata
		.emif_io96b_ddr4comp_s0_axi4_wstrb                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wstrb),       //  output,   width = 32,                                                                       .wstrb
		.emif_io96b_ddr4comp_s0_axi4_wlast                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wlast),       //  output,    width = 1,                                                                       .wlast
		.emif_io96b_ddr4comp_s0_axi4_wvalid                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wvalid),      //  output,    width = 1,                                                                       .wvalid
		.emif_io96b_ddr4comp_s0_axi4_wready                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_wready),      //   input,    width = 1,                                                                       .wready
		.emif_io96b_ddr4comp_s0_axi4_bid                                              (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bid),         //   input,    width = 7,                                                                       .bid
		.emif_io96b_ddr4comp_s0_axi4_bresp                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bresp),       //   input,    width = 2,                                                                       .bresp
		.emif_io96b_ddr4comp_s0_axi4_bvalid                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bvalid),      //   input,    width = 1,                                                                       .bvalid
		.emif_io96b_ddr4comp_s0_axi4_bready                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_bready),      //  output,    width = 1,                                                                       .bready
		.emif_io96b_ddr4comp_s0_axi4_arid                                             (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arid),        //  output,    width = 7,                                                                       .arid
		.emif_io96b_ddr4comp_s0_axi4_araddr                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_araddr),      //  output,   width = 30,                                                                       .araddr
		.emif_io96b_ddr4comp_s0_axi4_arlen                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlen),       //  output,    width = 8,                                                                       .arlen
		.emif_io96b_ddr4comp_s0_axi4_arsize                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arsize),      //  output,    width = 3,                                                                       .arsize
		.emif_io96b_ddr4comp_s0_axi4_arburst                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arburst),     //  output,    width = 2,                                                                       .arburst
		.emif_io96b_ddr4comp_s0_axi4_arlock                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arlock),      //  output,    width = 1,                                                                       .arlock
		.emif_io96b_ddr4comp_s0_axi4_arprot                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arprot),      //  output,    width = 3,                                                                       .arprot
		.emif_io96b_ddr4comp_s0_axi4_aruser                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_aruser),      //  output,   width = 14,                                                                       .aruser
		.emif_io96b_ddr4comp_s0_axi4_arqos                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arqos),       //  output,    width = 4,                                                                       .arqos
		.emif_io96b_ddr4comp_s0_axi4_arvalid                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arvalid),     //  output,    width = 1,                                                                       .arvalid
		.emif_io96b_ddr4comp_s0_axi4_arready                                          (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_arready),     //   input,    width = 1,                                                                       .arready
		.emif_io96b_ddr4comp_s0_axi4_rid                                              (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rid),         //   input,    width = 7,                                                                       .rid
		.emif_io96b_ddr4comp_s0_axi4_rdata                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rdata),       //   input,  width = 256,                                                                       .rdata
		.emif_io96b_ddr4comp_s0_axi4_rresp                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rresp),       //   input,    width = 2,                                                                       .rresp
		.emif_io96b_ddr4comp_s0_axi4_rlast                                            (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rlast),       //   input,    width = 1,                                                                       .rlast
		.emif_io96b_ddr4comp_s0_axi4_rvalid                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rvalid),      //   input,    width = 1,                                                                       .rvalid
		.emif_io96b_ddr4comp_s0_axi4_rready                                           (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4_rready),      //  output,    width = 1,                                                                       .rready
		.onchip_memory_s1_address                                                     (mm_interconnect_0_onchip_memory_s1_address),                //  output,   width = 17,                                                       onchip_memory_s1.address
		.onchip_memory_s1_write                                                       (mm_interconnect_0_onchip_memory_s1_write),                  //  output,    width = 1,                                                                       .write
		.onchip_memory_s1_read                                                        (mm_interconnect_0_onchip_memory_s1_read),                   //  output,    width = 1,                                                                       .read
		.onchip_memory_s1_readdata                                                    (mm_interconnect_0_onchip_memory_s1_readdata),               //   input,   width = 32,                                                                       .readdata
		.onchip_memory_s1_writedata                                                   (mm_interconnect_0_onchip_memory_s1_writedata),              //  output,   width = 32,                                                                       .writedata
		.onchip_memory_s1_byteenable                                                  (mm_interconnect_0_onchip_memory_s1_byteenable),             //  output,    width = 4,                                                                       .byteenable
		.niosv_g_timer_sw_agent_address                                               (mm_interconnect_0_niosv_g_timer_sw_agent_address),          //  output,    width = 6,                                                 niosv_g_timer_sw_agent.address
		.niosv_g_timer_sw_agent_write                                                 (mm_interconnect_0_niosv_g_timer_sw_agent_write),            //  output,    width = 1,                                                                       .write
		.niosv_g_timer_sw_agent_read                                                  (mm_interconnect_0_niosv_g_timer_sw_agent_read),             //  output,    width = 1,                                                                       .read
		.niosv_g_timer_sw_agent_readdata                                              (mm_interconnect_0_niosv_g_timer_sw_agent_readdata),         //   input,   width = 32,                                                                       .readdata
		.niosv_g_timer_sw_agent_writedata                                             (mm_interconnect_0_niosv_g_timer_sw_agent_writedata),        //  output,   width = 32,                                                                       .writedata
		.niosv_g_timer_sw_agent_byteenable                                            (mm_interconnect_0_niosv_g_timer_sw_agent_byteenable),       //  output,    width = 4,                                                                       .byteenable
		.niosv_g_timer_sw_agent_readdatavalid                                         (mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid),    //   input,    width = 1,                                                                       .readdatavalid
		.niosv_g_timer_sw_agent_waitrequest                                           (mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest),      //   input,    width = 1,                                                                       .waitrequest
		.emif_io96b_ddr4comp_s0_axi4lite_awaddr                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awaddr),  //  output,   width = 27,                                        emif_io96b_ddr4comp_s0_axi4lite.awaddr
		.emif_io96b_ddr4comp_s0_axi4lite_awprot                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awprot),  //  output,    width = 3,                                                                       .awprot
		.emif_io96b_ddr4comp_s0_axi4lite_awvalid                                      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awvalid), //  output,    width = 1,                                                                       .awvalid
		.emif_io96b_ddr4comp_s0_axi4lite_awready                                      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_awready), //   input,    width = 1,                                                                       .awready
		.emif_io96b_ddr4comp_s0_axi4lite_wdata                                        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wdata),   //  output,   width = 32,                                                                       .wdata
		.emif_io96b_ddr4comp_s0_axi4lite_wstrb                                        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wstrb),   //  output,    width = 4,                                                                       .wstrb
		.emif_io96b_ddr4comp_s0_axi4lite_wvalid                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wvalid),  //  output,    width = 1,                                                                       .wvalid
		.emif_io96b_ddr4comp_s0_axi4lite_wready                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_wready),  //   input,    width = 1,                                                                       .wready
		.emif_io96b_ddr4comp_s0_axi4lite_bresp                                        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bresp),   //   input,    width = 2,                                                                       .bresp
		.emif_io96b_ddr4comp_s0_axi4lite_bvalid                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bvalid),  //   input,    width = 1,                                                                       .bvalid
		.emif_io96b_ddr4comp_s0_axi4lite_bready                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_bready),  //  output,    width = 1,                                                                       .bready
		.emif_io96b_ddr4comp_s0_axi4lite_araddr                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_araddr),  //  output,   width = 27,                                                                       .araddr
		.emif_io96b_ddr4comp_s0_axi4lite_arprot                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arprot),  //  output,    width = 3,                                                                       .arprot
		.emif_io96b_ddr4comp_s0_axi4lite_arvalid                                      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arvalid), //  output,    width = 1,                                                                       .arvalid
		.emif_io96b_ddr4comp_s0_axi4lite_arready                                      (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_arready), //   input,    width = 1,                                                                       .arready
		.emif_io96b_ddr4comp_s0_axi4lite_rdata                                        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rdata),   //   input,   width = 32,                                                                       .rdata
		.emif_io96b_ddr4comp_s0_axi4lite_rresp                                        (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rresp),   //   input,    width = 2,                                                                       .rresp
		.emif_io96b_ddr4comp_s0_axi4lite_rvalid                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rvalid),  //   input,    width = 1,                                                                       .rvalid
		.emif_io96b_ddr4comp_s0_axi4lite_rready                                       (mm_interconnect_0_emif_io96b_ddr4comp_s0_axi4lite_rready),  //  output,    width = 1,                                                                       .rready
		.niosv_g_reset_reset_bridge_in_reset_reset                                    (rst_controller_002_reset_out_reset),                        //   input,    width = 1,                                    niosv_g_reset_reset_bridge_in_reset.reset
		.mm_bridge_peripheral_reset_reset_bridge_in_reset_reset                       (rst_controller_002_reset_out_reset),                        //   input,    width = 1,                       mm_bridge_peripheral_reset_reset_bridge_in_reset.reset
		.emif_io96b_ddr4comp_s0_axi4_translator_clk_reset_reset_bridge_in_reset_reset (rst_controller_004_reset_out_reset),                        //   input,    width = 1, emif_io96b_ddr4comp_s0_axi4_translator_clk_reset_reset_bridge_in_reset.reset
		.iopll_outclk0_clk                                                            (iopll_outclk0_clk)                                          //   input,    width = 1,                                                          iopll_outclk0.clk
	);

	nios_system_altera_mm_interconnect_1920_5tgnb3y mm_interconnect_1 (
		.mm_bridge_peripheral_m0_address                                 (mm_bridge_peripheral_m0_address),                           //   input,  width = 18,                                   mm_bridge_peripheral_m0.address
		.mm_bridge_peripheral_m0_waitrequest                             (mm_bridge_peripheral_m0_waitrequest),                       //  output,   width = 1,                                                          .waitrequest
		.mm_bridge_peripheral_m0_burstcount                              (mm_bridge_peripheral_m0_burstcount),                        //   input,   width = 1,                                                          .burstcount
		.mm_bridge_peripheral_m0_byteenable                              (mm_bridge_peripheral_m0_byteenable),                        //   input,   width = 4,                                                          .byteenable
		.mm_bridge_peripheral_m0_read                                    (mm_bridge_peripheral_m0_read),                              //   input,   width = 1,                                                          .read
		.mm_bridge_peripheral_m0_readdata                                (mm_bridge_peripheral_m0_readdata),                          //  output,  width = 32,                                                          .readdata
		.mm_bridge_peripheral_m0_readdatavalid                           (mm_bridge_peripheral_m0_readdatavalid),                     //  output,   width = 1,                                                          .readdatavalid
		.mm_bridge_peripheral_m0_write                                   (mm_bridge_peripheral_m0_write),                             //   input,   width = 1,                                                          .write
		.mm_bridge_peripheral_m0_writedata                               (mm_bridge_peripheral_m0_writedata),                         //   input,  width = 32,                                                          .writedata
		.mm_bridge_peripheral_m0_debugaccess                             (mm_bridge_peripheral_m0_debugaccess),                       //   input,   width = 1,                                                          .debugaccess
		.jtag_uart_avalon_jtag_slave_address                             (mm_interconnect_1_jtag_uart_avalon_jtag_slave_address),     //  output,   width = 1,                               jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                               (mm_interconnect_1_jtag_uart_avalon_jtag_slave_write),       //  output,   width = 1,                                                          .write
		.jtag_uart_avalon_jtag_slave_read                                (mm_interconnect_1_jtag_uart_avalon_jtag_slave_read),        //  output,   width = 1,                                                          .read
		.jtag_uart_avalon_jtag_slave_readdata                            (mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata),    //   input,  width = 32,                                                          .readdata
		.jtag_uart_avalon_jtag_slave_writedata                           (mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata),   //  output,  width = 32,                                                          .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                         (mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest), //   input,   width = 1,                                                          .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                          (mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect),  //  output,   width = 1,                                                          .chipselect
		.seg7_avalon_slave_address                                       (mm_interconnect_1_seg7_avalon_slave_address),               //  output,   width = 3,                                         seg7_avalon_slave.address
		.seg7_avalon_slave_write                                         (mm_interconnect_1_seg7_avalon_slave_write),                 //  output,   width = 1,                                                          .write
		.seg7_avalon_slave_read                                          (mm_interconnect_1_seg7_avalon_slave_read),                  //  output,   width = 1,                                                          .read
		.seg7_avalon_slave_readdata                                      (mm_interconnect_1_seg7_avalon_slave_readdata),              //   input,   width = 8,                                                          .readdata
		.seg7_avalon_slave_writedata                                     (mm_interconnect_1_seg7_avalon_slave_writedata),             //  output,   width = 8,                                                          .writedata
		.audio_avalon_slave_address                                      (mm_interconnect_1_audio_avalon_slave_address),              //  output,   width = 3,                                        audio_avalon_slave.address
		.audio_avalon_slave_write                                        (mm_interconnect_1_audio_avalon_slave_write),                //  output,   width = 1,                                                          .write
		.audio_avalon_slave_read                                         (mm_interconnect_1_audio_avalon_slave_read),                 //  output,   width = 1,                                                          .read
		.audio_avalon_slave_readdata                                     (mm_interconnect_1_audio_avalon_slave_readdata),             //   input,  width = 16,                                                          .readdata
		.audio_avalon_slave_writedata                                    (mm_interconnect_1_audio_avalon_slave_writedata),            //  output,  width = 16,                                                          .writedata
		.audio_i2c_avalon_slave_0_address                                (mm_interconnect_1_audio_i2c_avalon_slave_0_address),        //  output,   width = 3,                                  audio_i2c_avalon_slave_0.address
		.audio_i2c_avalon_slave_0_write                                  (mm_interconnect_1_audio_i2c_avalon_slave_0_write),          //  output,   width = 1,                                                          .write
		.audio_i2c_avalon_slave_0_readdata                               (mm_interconnect_1_audio_i2c_avalon_slave_0_readdata),       //   input,   width = 8,                                                          .readdata
		.audio_i2c_avalon_slave_0_writedata                              (mm_interconnect_1_audio_i2c_avalon_slave_0_writedata),      //  output,   width = 8,                                                          .writedata
		.audio_i2c_avalon_slave_0_waitrequest                            (~mm_interconnect_1_audio_i2c_avalon_slave_0_waitrequest),   //   input,   width = 1,                                                          .waitrequest
		.audio_i2c_avalon_slave_0_chipselect                             (mm_interconnect_1_audio_i2c_avalon_slave_0_chipselect),     //  output,   width = 1,                                                          .chipselect
		.sysid_qsys_control_slave_address                                (mm_interconnect_1_sysid_qsys_control_slave_address),        //  output,   width = 1,                                  sysid_qsys_control_slave.address
		.sysid_qsys_control_slave_readdata                               (mm_interconnect_1_sysid_qsys_control_slave_readdata),       //   input,  width = 32,                                                          .readdata
		.pio_sw_s1_address                                               (mm_interconnect_1_pio_sw_s1_address),                       //  output,   width = 2,                                                 pio_sw_s1.address
		.pio_sw_s1_write                                                 (mm_interconnect_1_pio_sw_s1_write),                         //  output,   width = 1,                                                          .write
		.pio_sw_s1_readdata                                              (mm_interconnect_1_pio_sw_s1_readdata),                      //   input,  width = 32,                                                          .readdata
		.pio_sw_s1_writedata                                             (mm_interconnect_1_pio_sw_s1_writedata),                     //  output,  width = 32,                                                          .writedata
		.pio_sw_s1_chipselect                                            (mm_interconnect_1_pio_sw_s1_chipselect),                    //  output,   width = 1,                                                          .chipselect
		.pio_led_s1_address                                              (mm_interconnect_1_pio_led_s1_address),                      //  output,   width = 2,                                                pio_led_s1.address
		.pio_led_s1_write                                                (mm_interconnect_1_pio_led_s1_write),                        //  output,   width = 1,                                                          .write
		.pio_led_s1_readdata                                             (mm_interconnect_1_pio_led_s1_readdata),                     //   input,  width = 32,                                                          .readdata
		.pio_led_s1_writedata                                            (mm_interconnect_1_pio_led_s1_writedata),                    //  output,  width = 32,                                                          .writedata
		.pio_led_s1_chipselect                                           (mm_interconnect_1_pio_led_s1_chipselect),                   //  output,   width = 1,                                                          .chipselect
		.pio_key_s1_address                                              (mm_interconnect_1_pio_key_s1_address),                      //  output,   width = 2,                                                pio_key_s1.address
		.pio_key_s1_write                                                (mm_interconnect_1_pio_key_s1_write),                        //  output,   width = 1,                                                          .write
		.pio_key_s1_readdata                                             (mm_interconnect_1_pio_key_s1_readdata),                     //   input,  width = 32,                                                          .readdata
		.pio_key_s1_writedata                                            (mm_interconnect_1_pio_key_s1_writedata),                    //  output,  width = 32,                                                          .writedata
		.pio_key_s1_chipselect                                           (mm_interconnect_1_pio_key_s1_chipselect),                   //  output,   width = 1,                                                          .chipselect
		.pio_ddr4_cal_done_s1_address                                    (mm_interconnect_1_pio_ddr4_cal_done_s1_address),            //  output,   width = 2,                                      pio_ddr4_cal_done_s1.address
		.pio_ddr4_cal_done_s1_readdata                                   (mm_interconnect_1_pio_ddr4_cal_done_s1_readdata),           //   input,  width = 32,                                                          .readdata
		.mm_bridge_peripheral_reset_reset_bridge_in_reset_reset          (rst_controller_002_reset_out_reset),                        //   input,   width = 1,          mm_bridge_peripheral_reset_reset_bridge_in_reset.reset
		.jtag_uart_reset_reset_bridge_in_reset_reset                     (rst_controller_002_reset_out_reset),                        //   input,   width = 1,                     jtag_uart_reset_reset_bridge_in_reset.reset
		.audio_clock_sink_reset_reset_bridge_in_reset_reset              (rst_controller_005_reset_out_reset),                        //   input,   width = 1,              audio_clock_sink_reset_reset_bridge_in_reset.reset
		.audio_avalon_slave_translator_reset_reset_bridge_in_reset_reset (rst_controller_005_reset_out_reset),                        //   input,   width = 1, audio_avalon_slave_translator_reset_reset_bridge_in_reset.reset
		.iopll_outclk0_clk                                               (iopll_outclk0_clk),                                         //   input,   width = 1,                                             iopll_outclk0.clk
		.pll_audio_outclk0_clk                                           (pll_audio_outclk0_clk)                                      //   input,   width = 1,                                         pll_audio_outclk0.clk
	);

	nios_system_altera_irq_mapper_2001_a6ix3bi irq_mapper (
		.clk           (iopll_outclk0_clk),                  //   input,   width = 1,       clk.clk
		.reset         (rst_controller_001_reset_out_reset), //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),           //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),           //   input,   width = 1, receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),           //   input,   width = 1, receiver2.irq
		.receiver3_irq (irq_mapper_receiver3_irq),           //   input,   width = 1, receiver3.irq
		.sender_irq    (niosv_g_platform_irq_rx_irq)         //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~reset_bridge_out_reset_reset),  //   input,  width = 1, reset_in0.reset
		.clk            (pll_audio_outclk0_clk),          //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                               // (terminated),                       
		.reset_req_in0  (1'b0),                           // (terminated),                       
		.reset_in1      (1'b0),                           // (terminated),                       
		.reset_req_in1  (1'b0),                           // (terminated),                       
		.reset_in2      (1'b0),                           // (terminated),                       
		.reset_req_in2  (1'b0),                           // (terminated),                       
		.reset_in3      (1'b0),                           // (terminated),                       
		.reset_req_in3  (1'b0),                           // (terminated),                       
		.reset_in4      (1'b0),                           // (terminated),                       
		.reset_req_in4  (1'b0),                           // (terminated),                       
		.reset_in5      (1'b0),                           // (terminated),                       
		.reset_req_in5  (1'b0),                           // (terminated),                       
		.reset_in6      (1'b0),                           // (terminated),                       
		.reset_req_in6  (1'b0),                           // (terminated),                       
		.reset_in7      (1'b0),                           // (terminated),                       
		.reset_req_in7  (1'b0),                           // (terminated),                       
		.reset_in8      (1'b0),                           // (terminated),                       
		.reset_req_in8  (1'b0),                           // (terminated),                       
		.reset_in9      (1'b0),                           // (terminated),                       
		.reset_req_in9  (1'b0),                           // (terminated),                       
		.reset_in10     (1'b0),                           // (terminated),                       
		.reset_req_in10 (1'b0),                           // (terminated),                       
		.reset_in11     (1'b0),                           // (terminated),                       
		.reset_req_in11 (1'b0),                           // (terminated),                       
		.reset_in12     (1'b0),                           // (terminated),                       
		.reset_req_in12 (1'b0),                           // (terminated),                       
		.reset_in13     (1'b0),                           // (terminated),                       
		.reset_req_in13 (1'b0),                           // (terminated),                       
		.reset_in14     (1'b0),                           // (terminated),                       
		.reset_req_in14 (1'b0),                           // (terminated),                       
		.reset_in15     (1'b0),                           // (terminated),                       
		.reset_req_in15 (1'b0)                            // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (~reset_bridge_out_reset_reset),          //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk0_clk),                      //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_001_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                                   // (terminated),                       
		.reset_in1      (1'b0),                                   // (terminated),                       
		.reset_req_in1  (1'b0),                                   // (terminated),                       
		.reset_in2      (1'b0),                                   // (terminated),                       
		.reset_req_in2  (1'b0),                                   // (terminated),                       
		.reset_in3      (1'b0),                                   // (terminated),                       
		.reset_req_in3  (1'b0),                                   // (terminated),                       
		.reset_in4      (1'b0),                                   // (terminated),                       
		.reset_req_in4  (1'b0),                                   // (terminated),                       
		.reset_in5      (1'b0),                                   // (terminated),                       
		.reset_req_in5  (1'b0),                                   // (terminated),                       
		.reset_in6      (1'b0),                                   // (terminated),                       
		.reset_req_in6  (1'b0),                                   // (terminated),                       
		.reset_in7      (1'b0),                                   // (terminated),                       
		.reset_req_in7  (1'b0),                                   // (terminated),                       
		.reset_in8      (1'b0),                                   // (terminated),                       
		.reset_req_in8  (1'b0),                                   // (terminated),                       
		.reset_in9      (1'b0),                                   // (terminated),                       
		.reset_req_in9  (1'b0),                                   // (terminated),                       
		.reset_in10     (1'b0),                                   // (terminated),                       
		.reset_req_in10 (1'b0),                                   // (terminated),                       
		.reset_in11     (1'b0),                                   // (terminated),                       
		.reset_req_in11 (1'b0),                                   // (terminated),                       
		.reset_in12     (1'b0),                                   // (terminated),                       
		.reset_req_in12 (1'b0),                                   // (terminated),                       
		.reset_in13     (1'b0),                                   // (terminated),                       
		.reset_req_in13 (1'b0),                                   // (terminated),                       
		.reset_in14     (1'b0),                                   // (terminated),                       
		.reset_req_in14 (1'b0),                                   // (terminated),                       
		.reset_in15     (1'b0),                                   // (terminated),                       
		.reset_req_in15 (1'b0)                                    // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_002 (
		.reset_in0      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk0_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_002_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_003 (
		.reset_in0      (reset_release_ninit_done_reset),     //   input,  width = 1, reset_in0.reset
		.reset_in1      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in1.reset
		.clk            (clock_in_out_clk_clk),               //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_003_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_004 (
		.reset_in0      (~emif_io96b_ddr4comp_s0_axi4_ctrl_ready_reset_n), //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk0_clk),                               //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_004_reset_out_reset),              //  output,  width = 1, reset_out.reset
		.reset_req      (),                                                // (terminated),                       
		.reset_req_in0  (1'b0),                                            // (terminated),                       
		.reset_in1      (1'b0),                                            // (terminated),                       
		.reset_req_in1  (1'b0),                                            // (terminated),                       
		.reset_in2      (1'b0),                                            // (terminated),                       
		.reset_req_in2  (1'b0),                                            // (terminated),                       
		.reset_in3      (1'b0),                                            // (terminated),                       
		.reset_req_in3  (1'b0),                                            // (terminated),                       
		.reset_in4      (1'b0),                                            // (terminated),                       
		.reset_req_in4  (1'b0),                                            // (terminated),                       
		.reset_in5      (1'b0),                                            // (terminated),                       
		.reset_req_in5  (1'b0),                                            // (terminated),                       
		.reset_in6      (1'b0),                                            // (terminated),                       
		.reset_req_in6  (1'b0),                                            // (terminated),                       
		.reset_in7      (1'b0),                                            // (terminated),                       
		.reset_req_in7  (1'b0),                                            // (terminated),                       
		.reset_in8      (1'b0),                                            // (terminated),                       
		.reset_req_in8  (1'b0),                                            // (terminated),                       
		.reset_in9      (1'b0),                                            // (terminated),                       
		.reset_req_in9  (1'b0),                                            // (terminated),                       
		.reset_in10     (1'b0),                                            // (terminated),                       
		.reset_req_in10 (1'b0),                                            // (terminated),                       
		.reset_in11     (1'b0),                                            // (terminated),                       
		.reset_req_in11 (1'b0),                                            // (terminated),                       
		.reset_in12     (1'b0),                                            // (terminated),                       
		.reset_req_in12 (1'b0),                                            // (terminated),                       
		.reset_in13     (1'b0),                                            // (terminated),                       
		.reset_req_in13 (1'b0),                                            // (terminated),                       
		.reset_in14     (1'b0),                                            // (terminated),                       
		.reset_req_in14 (1'b0),                                            // (terminated),                       
		.reset_in15     (1'b0),                                            // (terminated),                       
		.reset_req_in15 (1'b0)                                             // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_005 (
		.reset_in0      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (pll_audio_outclk0_clk),              //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_005_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

endmodule
