// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Wed Apr 23 19:05:55 2025
// ============================================================================

//`define ENABLE_DDR4
//`define ENABLE_HPS
//`define ENABLE_HDMI
//`define ENABLE_HSMC
//`define ENABLE_CAM

module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,

      ///////// KEY /////////
      input              CPU_RESET_n,
      input    [ 3: 0]   KEY,

      ///////// SW /////////
      input    [ 9: 0]   SW,

      ///////// LED /////////
      output   [ 9: 0]   LEDR,

      ///////// Seg7 /////////
      output   [ 6: 0]   HEX0,
      output   [ 6: 0]   HEX1,
      output   [ 6: 0]   HEX2,
      output   [ 6: 0]   HEX3,
      output   [ 6: 0]   HEX4,
      output   [ 6: 0]   HEX5,

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [15: 0]   DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_UDQM,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,

`ifdef ENABLE_DDR4
      ///////// DDR4 /////////
      input              DDR4_REFCLK_p,
      output   [16: 0]   DDR4_A,
      output   [ 1: 0]   DDR4_BA,
      output   [ 0: 0]   DDR4_BG,
      output             DDR4_CK,
      output             DDR4_CK_n,
      output             DDR4_CKE,
      inout    [ 3: 0]   DDR4_DQS,
      inout    [ 3: 0]   DDR4_DQS_n,
      inout    [31: 0]   DDR4_DQ,
      inout    [ 3: 0]   DDR4_DBI_n,
      output             DDR4_CS_n,
      output             DDR4_RESET_n,
      output             DDR4_ODT,
      output             DDR4_PAR,
      input              DDR4_ALERT_n,
      output             DDR4_ACT_n,
      input              DDR4_RZQ,
`endif /*ENABLE_DDR4*/

      ///////// Video-In /////////
      input              TD_CLK27,
      input              TD_HS,
      input              TD_VS,
      input    [ 7: 0]   TD_DATA,
      output             TD_RESET_n,

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              HDMI_LRCLK,
      inout              HDMI_MCLK,
      inout              HDMI_SCLK,
      output             HDMI_TX_CLK,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      input              HDMI_TX_INT,
      inout              HDMI_I2S,
`endif /*ENABLE_HDMI*/

      ///////// Audio /////////
      inout              AUD_BCLK,
      output             AUD_XCK,
      inout              AUD_ADCLRCK,
      input              AUD_ADCDAT,
      inout              AUD_DACLRCK,
      output             AUD_DACDAT,

      ///////// ADC /////////
      output             ADC_SCK,
      input              ADC_SDO,
      output             ADC_SDI,
      output             ADC_CS_n,

      ///////// I2C for Camera, Audio and Video-In /////////
      output             FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

`ifdef ENABLE_HSMC
      ///////// HSMC /////////
      output   [ 3: 0]   HSMC_GTS_TX_p,
      output   [ 3: 0]   HSMC_GTS_TX_n,
      input    [ 3: 0]   HSMC_GTS_RX_p,
      input    [ 3: 0]   HSMC_GTS_RX_n,
      input              HSMC_GTS_RX_REFCLK_p,
      output             HSMC_I2C_SCL,
      inout              HSMC_I2C_SDA,
      input    [ 2: 0]   HSMC_CLK_IN,
      input              HSMC_GTS_REFCLK_p,
      inout    [ 1: 0]   HSMC_B5B_D,
      inout    [76: 0]   HSMC_D,
`endif /*ENABLE_HSMC*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 1: 0]   CAM_D_p,
      input    [ 1: 0]   CAM_D_n,
      inout              CAM_GPIO,
      input              CAM_RZQ1,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      input              HPS_CLK_25,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      inout              HPS_KEY,
      inout              HPS_LCM_BK,
      inout              HPS_LCM_D_C,
      inout              HPS_LCM_RST_n,
      output             HPS_LCM_SPIM_CLK,
      output             HPS_LCM_SPIM_MOSI,
      output             HPS_LCM_SPIM_SS,
      inout              HPS_LED,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IR /////////
      output             IRDA_TXD,
      input              IRDA_RXD

);




//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================

	wire ninit_done;
	reset_release reset_release_inst (
		.ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
	);
	
wire reset_n;
assign reset_n = ~ninit_done;	



nios_system u0 (
    .clk_clk                        (CLOCK0_50),     //                     clk.clk
    .reset_reset_n                  (reset_n),         //                   reset.reset_n
    .sw_external_connection_export  (SW),           //  sw_external_connection.export
	 

    .spi_master_external_MISO      (ADC_SDO),      //   input,   width = 1,    spi_master_external.MISO
    .spi_master_external_MOSI      (ADC_SDI),      //  output,   width = 1,                       .MOSI
    .spi_master_external_SCLK      (ADC_SCK),      //  output,   width = 1,                       .SCLK
    .spi_master_external_SS_n      (ADC_CS_n)       //  output,   width = 1,                       .SS_n
	 
);



endmodule
