// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ff_macro_p2c # (
 parameter DATA_WIDTH = 256,
 parameter NUM_FLOPS = 1 // based on number of flops you need in 1 dir 
 ) (
 input logic clk,

 input [DATA_WIDTH -1:0] in_data ,

 output [DATA_WIDTH -1:0] out_data

);


 (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_PERIPHERY_CORE_TRANSFER ON"} *)
    reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS:0];    

    assign in_data_reg[0] = in_data;


    genvar i;
    
    generate 
    for (i=0 ; i<NUM_FLOPS ; i=i+1 ) begin : hps_p2c_ff
      always @(posedge clk) begin
          in_data_reg[i+1] <= in_data_reg[i];
      end
    end
    endgenerate

    assign out_data = in_data_reg[NUM_FLOPS];



    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "7MBsfGNfLBj+3Zi0T+jPOOUG+uBbozaZWVDc4xAFLKvkE7uHMcMX/Sb/YzYLVWEO4dPcV49X5MnL3Ek9SCr5TxAoL3kAbmnHB0r2kq59JrxDdeZquVD0c1SUF14wlg3eyf66c5j3gg8NQDtmre7iyEUOtx0c6jRrIT9v7LBW/+u5RCTAfPF6zxCuM2/BFtpOIcKwM+ejcvpE3I08RyJgOSecDgBO8M6JsXsm1V3AwfKHFASjAd/Eior1FZbedurM8fuXdAp04iXzRpN7vbVtTPcVHjxRIIpVestESl8mLCubF1FntVtfNib9f0FrzcSydCO6GDSoI0ORjOJu/PZnKbH+SuBPhZQcdZsLdNy0HQoS5G0pAtr+vZx78i7JEJtXjScozmJGGrQ433ZB/GDmNtIF0KZUUq87tNDu6Bi23psPsrK321HbkAVWbihxodpBwp9Yh5EQkEqnEJDEqHQaQydCB686gcqxxYHgv32Hirf1gz0bHlrOQ001Sdne7mBySlSlB0hjQRRkb6S3a/igWu0SKdpiGed3dtSjV5DMT9LfNsFmv1yyjSDt573rBWzvENpxvaNwSN9dUZM6N2wLGocWG7VlDXL4WeslOHw4cUNBibVzxS2DWzh/TEeUQr4Kq0cE5gknz7WMZ8Ot1Dq37ka2JqiAgKNYCFPvG0M1ghORGI3BUmXeonATCPUrfjvHZ0Z6x77idYfqj4cvVoGSAU3KrVqjJnr/4nJV1q1rvUWr7EaWKXczNSGwXRXPraSOvRzhxAu3iigFiDCa9ofnKUUxQTYS79D+dUoXCgur+rIbeIgiKzxjO2cwFmi6UZN2rA+ptaf6D28FibzS3IMJUigV+zlVk8MArpLdGaD8MScGRCVH17nOhqK7pOeLitaxQey/otHK/gb6HSQfq0ZgiM1Hgk6X77pApy5aLaVJ/IAVfEExoyK7pNsGoEIYLJgEqVANq/CvwaA9FKEdRWbjAKqd5QHUdFKozX8JQjL8GkPSmO8BDTOKTJq5ITMcmL0V"
`endif