// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ns / 100ps

// this module has zero ready latency input and non zero latency output


module ready_latency_adapter # (
 parameter READY_LATENCY_OUT = 2,
 parameter PAYLOAD_WIDTH = 256,
 parameter LOG_DEPTH = 3


) (  
 output logic         in_ready,
 input  logic            in_valid,
 input  logic   [PAYLOAD_WIDTH-1: 0]  in_data,
 // Interface: out
 input  logic             out_ready,
 output logic          out_valid,
 output logic [PAYLOAD_WIDTH-1: 0] out_data,
  // Interface: clk
 input logic          clk,
 // Interface: reset
 input logic           reset

 /*AUTOARG*/);

   // ---------------------------------------------------------------------
   //| Signal Declarations
   // ---------------------------------------------------------------------
   
   logic [PAYLOAD_WIDTH-1:0]   in_payload;
   logic [PAYLOAD_WIDTH-1:0]   out_payload;
   logic            in_ready_wire;
   logic            out_valid_wire;
   logic [2:0]      fifo_fill;
   logic    rdreq;
   logic empty;   

   logic [READY_LATENCY_OUT-1:0] in_ready_dly_reg;
   logic in_ready_dly;
   assign in_ready_dly = (READY_LATENCY_OUT > 0) ? in_ready_dly_reg[0] : in_ready;
 
   localparam DEPTH = 2 ** LOG_DEPTH -1 ;

   // ---------------------------------------------------------------------
   //| Payload Mapping
   // ---------------------------------------------------------------------
   always @* begin
     in_payload = {in_data};
     {out_data} = out_payload;
   end

   // ---------------------------------------------------------------------
   //| FIFO
   // ---------------------------------------------------------------------                           
    scfifo_s # (
      .LOG_DEPTH (LOG_DEPTH),
      .WIDTH (PAYLOAD_WIDTH),
      .ALMOST_FULL_VALUE (DEPTH-1),
      .SHOW_AHEAD (1),
      .FAMILY ("Agilex")
    ) fifo_inst ( 
       .clock        (clk),
       .aclr       (reset),
       .sclr (1'b0),
       //.in_ready   (),
       .wrreq  (in_valid && in_ready_dly),      
       .data    (in_payload),
      //.out_ready  (out_ready),
       .rdreq      (rdreq),
       .q (out_payload),
       .usedw (fifo_fill),
       .empty (empty),
       .full (full),
       .almost_empty (),
       .almost_full ()
       );

   // ---------------------------------------------------------------------
   //| Ready & valid signals.
   // ---------------------------------------------------------------------
   always @* begin
      in_ready = ( DEPTH- fifo_fill > READY_LATENCY_OUT);
   end

    always @(posedge clk) begin
        in_ready_dly_reg[READY_LATENCY_OUT-1] <= in_ready;
        for (int i = 0; i < READY_LATENCY_OUT - 1; i++) begin
            in_ready_dly_reg[i] <= in_ready_dly_reg[i+1];
        end
    end

assign rdreq = out_ready && !empty;

assign out_valid = !empty;


endmodule


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "Sm3xu4Vnrp6yvCibqMxZxciGdFl4hB05KLCzWsL23fkXrYsOViiWhrC7pYzdPlFHbP5eAI2/bPPsZEH15jhL9aBrgucU7ZbPs/WRkAdaXiE9tW5+6yG2OjRiQgyF8xJhLTyG0luT7uIvvRXDhDLALGziFcg6hgqGBvdQq/SRMuny4wnj/BdEIQAYcLwSFYzovAcjBVOA38sd1vBC5bMWczRpuAM82D5Qd7noeVxjUA7kgh66rObexUWBQGaimHKlJE2MwUGg1paMHec4aJFV657dXewU7kHvLXqhEA9q4rXCt19NQ8J/B0oRBh+bxd0gOItwrcE6t/TpxR6yuBA/zOh+fbX03Yg91DTo/OtYC+qt91oKMZzF0WopBhHVZde3ryUzJ7fe3e919rJoVJOvtQL0PZUJeeeF/MWrloXGR2impL+semFQ/i+ytNFX8o6cM3U2H/XJjZDHiPtWJyuBLaP8a6J2bGGT0PdsQ2o9rlhTIjvByyCMqbdj5qhVKK4cpQGVdtb/SrbalKzLcZsl8UuivzljC3482obh4y9EywjbjvX9y2Qq5HDVnvzgoIgevbvxIO2T7vlKDikE9EMT3VDJ9ZBNGlmY+Ks3zXl3rdB61SiRl3o0o6VX4wCioCTnFMlIrUTHIhsAcvLHJtbWTFWsZg1Ixd9GxprrwT2zdIR3Icm72HjSBLJ178Mly8mV9iIcOf0oVaSBbYQFP0ad4oMT/AnXe4bo/5tSP5c0ZqzfK+ceBmix7l8Sng0IWAtsw1H9ohuTz/fbWExHYmD9h7fapDzH3qHjpteVvnD1gS7VXa0C0+pCrSpxwXlx1ZVmLQdptQsXVUvGyp3Z9h0t7TbvZAD2JR72ajN6ArAMrbmGIkOVbqcHyMmEsZIZ7fZQJbahY22sqXfi8lmLXFm+F3Sl+TfMzhBDbYhD0WON6yKAhrwfIwF1rbek8G+eAsIZ/TcnaHzyWdBvfieavVnqld8zgasXPrJSS/M4FcAHyeIhWpXN4f3Nan2tkeXtC0ON"
`endif