// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ff_macro_c2p # (
 parameter DATA_WIDTH = 256,
 parameter NUM_FLOPS = 1 // based on number of flops you need in 1 dir 
 ) (
 input logic clk,

 input [DATA_WIDTH -1:0] in_data ,

 output [DATA_WIDTH -1:0] out_data

);


 (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 350"} *)
    reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS:0];    

    assign in_data_reg[0] = in_data;


    genvar i;
    
    generate 
    for (i=0 ; i<NUM_FLOPS ; i=i+1 ) begin : hps_c2p_ff
      always @(posedge clk) begin
          in_data_reg[i+1] <= in_data_reg[i];
      end
    end
    endgenerate

    assign out_data = in_data_reg[NUM_FLOPS];



    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "7MBsfGNfLBj+3Zi0T+jPOOUG+uBbozaZWVDc4xAFLKvkE7uHMcMX/Sb/YzYLVWEO4dPcV49X5MnL3Ek9SCr5TxAoL3kAbmnHB0r2kq59JrxDdeZquVD0c1SUF14wlg3eyf66c5j3gg8NQDtmre7iyEUOtx0c6jRrIT9v7LBW/+u5RCTAfPF6zxCuM2/BFtpOIcKwM+ejcvpE3I08RyJgOSecDgBO8M6JsXsm1V3AwfJFB5dCwXrl2iyiFIFC5eW+LKl7yejZYmH3lW0vDTSBMDSGonH32emRwLn1244eVWO0daS6VAkfWIgmEKxt+lOZIt2z1N66r9lQ4DJcsQKjhe1sqSCnln6Yzfpi3ycI3KtuqIsVcQjdyaDIjh9bPpo72tzLM0CpvH7yjovZx8Va3s2iaWZzRisKsYYs/ReBAHyAtjInpJvYNhuLBH0LYc+MVxnUERuQGEsIOw4YjsrKQfT2zWtOlh6AtlmMMEpnbquycwGUCbuRuahw189WJAJyJtW9hw9XtLk23+AFkmwiurJyZ6bbS0kpXUb7PSG/gN3bU+0Cd727QfN6wU9CgssDzveiajjkQwbNxC1o1ng7QUPsI+ERhU2v+tHbfTjnxQo6ehj8pXiZpcq1jwIeaZXfloI4E21wwntXOXeYatS1TeRdylzzMnGAzgcTVqP347CIp/YiNBzn4aBqH3IxMOx0Dcn3DXCDbQYcmtMzo1oLDn04/XsvdVadoxvp+9RohEeqhsQ454DwiPCyofglRInbf0C0niynx5D+xYlf5Wt/lDY+lq5Ar6zRipfEOyGmdQcTqKkJDYxzXqZ4UVyEktz9xgqG3hjojDBSdXx3Hk951TblvV+UQq6a1Wpql89zsJOSbhBkjb9uMk/C+e01jLcQU8c65rTXVHcY+dA9veSr7/TP7KmPBPXb82JEA53Tn3BZZgzztZbtybaRZz+OMYwPoz7UXsLMHcXbrG/txtFEjmWaIjKVQaiTfUQ0JxPPYeeXxIN+LynFmiPm22Vgi29n"
`endif