
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "gpio_lib.h"
#include "led_lib.h"



/****************************************************************
 * Main
 ****************************************************************/
 
 int main(int argc, char **argv)
{	
	GPIO_HANDLE *line_key;
	unsigned int io_led=0;
	int loop;
	int fd_led;
	unsigned int key_value;
	bool bLedLight = true;

	
	line_key = gpio_open_line("/dev/gpiochip0", 16/*line 16 for KEY*/, 0 /*input*/);
	
	fd_led = led_fd_open(io_led);

	loop = 20;
	while (loop >= 0) {
		//gpio_get_value(io_key, &value);
		gpio_get_line_value(line_key, &key_value); // key_value is low active
		if (!key_value || bLedLight)
			led_fd_write(fd_led, "1", 2); // light led
		else
			led_fd_write(fd_led, "0", 2); // unlight led
		printf("key: %x\n", key_value);
		bLedLight = bLedLight?false:true;
		usleep(500*1000); // 0.5 second
		loop--;
	}
	
	led_fd_close(fd_led);
	gpio_close_line(line_key);
	
	return 0;
}


