#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include "led_lib.h"

 /****************************************************************
 * Constants
 ****************************************************************/
#define SYSFS_LED_DIR "/sys/class/leds"
#define MAX_BUF 64



/****************************************************************
 * led_fd_open
 ****************************************************************/
int led_fd_open(unsigned int led)
{
	int fd;//, len;
	char buf[MAX_BUF];

	//len = 
	snprintf(buf, sizeof(buf), SYSFS_LED_DIR "/hps_led%d/brightness", led);
	printf("%s\n", buf);

	fd = open(buf, O_WRONLY);
	if (fd < 0) {
		perror("led/fd_open");
	}
	return fd;
}

/****************************************************************
 * led_fd_write
 ****************************************************************/
int led_fd_write(int fd, const void *buf, size_t count)
{
	return write(fd, buf, count);
}

/****************************************************************
 * led_fd_close
 ****************************************************************/
int led_fd_close(int fd)
{
	return close(fd);
}


