// ============================================================================
// Copyright (c) 2024 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdbool.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <string.h>
#include <linux/gpio.h>
#include "gpio_lib.h"
 

GPIO_HANDLE* gpio_open_line(const char *dev_name, int line, int direction){
	struct gpiohandle_request req;
	int fd, ret;
	GPIO_HANDLE *pHandle = NULL;

	fd = open(dev_name, 0);
	if (fd < 0){
    	printf("Unable to open file %s\r\n", dev_name);
	}else{		
		// get key status
		req.lineoffsets[0] = line;
		req.lines = 1;
		req.flags = (direction==0)?GPIOHANDLE_REQUEST_INPUT:GPIOHANDLE_REQUEST_OUTPUT;
		ret = ioctl(fd, GPIO_GET_LINEHANDLE_IOCTL, &req);	
		if (ret == -1) {
			printf("Failed to issue %s for line %d (%d)\n","GPIO_GET_LINEHANDLE_IOCTL", line, ret );
		}else{
			pHandle = (GPIO_HANDLE *)malloc(sizeof(GPIO_HANDLE));
			if (pHandle){
				pHandle->fd = fd;
				pHandle->req = req;
				//memcpy((void *)&pHandle->req, &req, sizeof(struct gpiohandle_request));
			}else{
				printf("failed to allocate memory\r\n");
			}
		}		
	}
	return pHandle;

}
 
void gpio_close_line(GPIO_HANDLE *pHandle){
	if (pHandle){
		if (pHandle->fd)
			close(pHandle->fd);
		free(pHandle);
	}
 
 }
 
 bool gpio_get_line_value(GPIO_HANDLE *pHandle, unsigned int *pValue){
	bool bSuccess = false;
	struct gpiohandle_data data;
	int ret;

	if (pHandle){
		ret = ioctl(pHandle->req.fd, GPIOHANDLE_GET_LINE_VALUES_IOCTL, &data);
		if (ret == -1) {
			printf("Failed to issue %s for line %d (%d)\n","GPIOHANDLE_GET_LINE_VALUES_IOCTL", pHandle->req.lineoffsets[0], ret );
		}else{
			*pValue = data.values[0];
			bSuccess = true;
		}
	}
	return bSuccess;
 }
 
 bool gpio_set_line_value(GPIO_HANDLE *pHandle, unsigned int nValue){
	bool bSuccess = false;
	struct gpiohandle_data data;
	int ret;

	if (pHandle){
		data.values[0] = nValue;
		ret = ioctl(pHandle->req.fd, GPIOHANDLE_SET_LINE_VALUES_IOCTL, &data);
		if (ret == -1) {
			printf("Failed to issue %s for line %d (%d)\n","GPIOHANDLE_SET_LINE_VALUES_IOCTL", pHandle->req.lineoffsets[0], ret );
		}else{
			bSuccess = true;
		}
	}
	return bSuccess;
 }
 
 