// --------------------------------------------------------------------
// Copyright (c) 2007 by Terasic Technologies Inc. 
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// --------------------------------------------------------------------
//           
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------



module VGA_Ctrl (
//	Host Side
input		   [9:0]	iRed,
input		   [9:0]	iGreen,
input		   [9:0]	iBlue,
output		[21:0]oAddress,
output		[10:0]oCurrent_X,
output		[10:0]oCurrent_Y,
output reg [10:0]	VS_Cont ,
output				oRequest,
//	VGA Side
output		[9:0]	oVGA_R,
output		[9:0]	oVGA_G,
output		[9:0]	oVGA_B,
output	         oVGA_HS,
output	         oVGA_VS,
output				oVGA_DE,
output				oVGA_CLOCK,
//	Control Signal
input				   iCLK,
input				   iRST_N
);//
//--parameter
parameter H_ACT=  640 ; 

//	Internal Registers
reg			oVGA_HS_;
reg			oVGA_VS_;

reg			[10:0]	H_Cont;
reg			[10:0]	V_Cont;

assign	oAddress	=	 oCurrent_Y*H_ACT+oCurrent_X;
assign	oRequest	=	 H_Request & V_Request  ; 
						            
assign	oCurrent_X	=H_Cont; 
assign	oCurrent_Y	=V_Cont; 


wire  H_Request,V_Request ; 

assign  H_Request =vpg_de & (H_Cont < 640 );
assign  V_Request =((VS_Cont>= 34) && (VS_Cont <  (34+480)));

always@(posedge iCLK or negedge vpg_de)
	if(!vpg_de) begin
		H_Cont		<=	0;
   end 		
	else begin 
	if (H_Cont < 640 )  begin 
		H_Cont	<=	H_Cont+1'b1;
	end 
	end	
//	Vertical Generator: Refer to the horizontal sync

always@(posedge vpg_hs or negedge vpg_vs)
if(!vpg_vs)begin 
		VS_Cont		<=	0;
		V_Cont<=0;
   end 		
	else begin 
	VS_Cont <=VS_Cont+1; 
	if ((VS_Cont>= 34) && (VS_Cont <  (34+480)))   begin 
			V_Cont<= V_Cont+1 ;
	end 
	end

//=======================================================
//  Signal WIRE
//=======================================================
wire          vpg_pclk ; 
wire	  		  reset_n;
wire			  vpg_de;
wire			  vpg_hs;
wire			  vpg_vs;
wire	[7:0]   vpg_r;
wire	[7:0]   vpg_g;
wire	[7:0]   vpg_b;


assign	oVGA_R		=	iRed;
assign	oVGA_G		=	iGreen;
assign	oVGA_B		=	iBlue;


assign  oVGA_DE      = vpg_de;
assign  oVGA_HS      = vpg_hs;
assign  oVGA_VS      = vpg_vs;
assign  oVGA_CLOCK   = vpg_pclk;

assign  reset_n      = iRST_N; 
assign  vpg_pclk     = iCLK ;


//=======================================================
//  Signal declarations
//=======================================================
//============= assign timing constant  
wire  [11:0] h_total, h_sync, h_start, h_end; 
wire  [11:0] v_total, v_sync, v_start, v_end; 
wire  [11:0] v_active_14, v_active_24, v_active_34; 


//=============== pattern generator according to vga timing
vga_generator u_vga_generator (                                    
  .clk     ( vpg_pclk  ),                
  .reset_n ( reset_n   ),
  .h_total ( h_total),           
  .h_sync  ( h_sync),           
  .h_start ( h_start),             
  .h_end   ( h_end),                                                    
  .v_total ( v_total),           
  .v_sync  ( v_sync),            
  .v_start ( v_start),           
  .v_end   ( v_end), 
  .v_active_14(v_active_14), 
  .v_active_24(v_active_24), 
  .v_active_34(v_active_34), 
  .vga_hs     (vpg_hs),
  .vga_vs     (vpg_vs),           
  .vga_de     (vpg_de),
  .vga_r      (vpg_r),
  .vga_g      (vpg_g),
  .vga_b      (vpg_b) );


//=======================================================
//  Structural coding
//=======================================================
//============= assign timing constant  
//h_total : total - 1
//h_sync : sync - 1
//h_start : sync + back porch - 1 - 2(delay)
//h_end : h_start + avtive
//v_total : total - 1
//v_sync : sync - 1
//v_start : sync + back porch - 1
//v_end : v_start + avtive
//v_active_14 : v_start + 1/4 avtive
//v_active_24 : v_start + 2/4 avtive
//v_active_34 : v_start + 3/4 avtive

//640x480@60 25.175 MHZ
assign {h_total, h_sync, h_start, h_end} = {12'd799, 12'd95, 12'd141, 12'd781}; 
assign {v_total, v_sync, v_start, v_end} = {12'd524, 12'd1, 12'd34, 12'd514}; 
assign {v_active_14, v_active_24, v_active_34} = {12'd154, 12'd274, 12'd394};
	
		
//720x480@60 27MHZ (VIC=3, 480P)
//assign {h_total, h_sync, h_start, h_end} = {12'd857, 12'd61, 12'd119, 12'd839}; 
//assign {v_total, v_sync, v_start, v_end} = {12'd524, 12'd5, 12'd35, 12'd515}; 
//assign {v_active_14, v_active_24, v_active_34} = {12'd155, 12'd275, 12'd395};
			
//1024x768@60 65MHZ (XGA)
//assign {h_total, h_sync, h_start, h_end} = {12'd1343, 12'd135, 12'd293, 12'd1317}; 
//assign {v_total, v_sync, v_start, v_end} = {12'd805, 12'd5, 12'd34, 12'd802}; 
//assign {v_active_14, v_active_24, v_active_34} = {12'd226, 12'd418, 12'd610};

//1280x1024@60   108MHZ (SXGA)
//assign {h_total, h_sync, h_start, h_end} = {12'd1687, 12'd111, 12'd357, 12'd1637}; 
//assign {v_total, v_sync, v_start, v_end} = {12'd1065, 12'd2, 12'd40, 12'd1064}; 
//assign {v_active_14, v_active_24, v_active_34} = {12'd296, 12'd552, 12'd808};

//1920x1080p60 148.5MHZ 	
//assign {h_total, h_sync, h_start, h_end} = {12'd2199, 12'd43, 12'd189, 12'd2109}; 
//assign {v_total, v_sync, v_start, v_end} = {12'd1124, 12'd4, 12'd40, 12'd1120}; 
//assign {v_active_14, v_active_24, v_active_34} = {12'd310, 12'd580, 12'd850};
		
//1600x1200p60 162MHZ (VESA)
//assign {h_total, h_sync, h_start, h_end} = {12'd2159, 12'd191, 12'd493, 12'd2093}; 
//assign {v_total, v_sync, v_start, v_end} = {12'd1249, 12'd2, 12'd48, 12'd1248}; 
//assign {v_active_14, v_active_24, v_active_34} = {12'd348, 12'd648, 12'd948};

endmodule 