// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



package hydra_rtl_library_pkg;

   function automatic string get_param_from_str;
      input string str;
      input string param;

      integer str_len;
      integer param_len;
      integer val_start;
      integer val_end;
      string  sub;
   begin
      str_len   = str.len();
      param_len = param.len();
      val_start = 0;
      val_end   = 0;

      get_param_from_str = "0";

      for (int i = 0; i < str_len; i++) begin
         sub = str.substr(i, i + param_len - 1);
         if(sub.compare(param) == 0) begin
            val_start = i + param_len;
            for (int j = val_start; j < str_len; j++) begin
               if (val_start >= val_end && (str[j] == " " || str[j] == "="))
                  val_start = val_start + 1;
               val_end = j;
               if (str[j] == "," || (val_start < val_end && str[j] == " ")) begin
                  val_end = val_end - 1;
                  break;
               end
            end

            if (val_start <= val_end)
               get_param_from_str = str.substr(val_start, val_end);
         end
      end
   end
   endfunction

   function automatic integer str_to_int;
      input string str;

      integer str_len;
      integer val;
   begin
      str_len = str.len();
      val = 0;
      for (int i = 0; i < str_len; i++) begin
         case (str.getc(i))
            "0":     val = val*10 + 0;
            "1":     val = val*10 + 1;
            "2":     val = val*10 + 2;
            "3":     val = val*10 + 3;
            "4":     val = val*10 + 4;
            "5":     val = val*10 + 5;
            "6":     val = val*10 + 6;
            "7":     val = val*10 + 7;
            "8":     val = val*10 + 8;
            "9":     val = val*10 + 9;
            default: $fatal(1, "Found non-digit character %s in string %s", str[i], str);
         endcase
      end
      str_to_int = val;
   end
   endfunction

   localparam CTRL_INSTR_OP_EOL = 0;


endpackage

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "FXSRKOAKBLPA886OFzf7z9ske4ySKJSsErbyEmoApfVmAfyIoA1yGDkAU9G+2VpYKCLpOfnDV9Q6rGOzd2Xltl4WT/Q93M4BwRgsnRFNqW0YAarhezZ8nvZYJ2RlZh4HO5i818Bzt0CgTQ3O7fD/eLNzlMGc37uMc2jvocZpEPZpD34nPMDa8zICcNHV7niQnbhXiboQD1qVAMpc2B+R+yR7YOwvGx7RE0AbZ/CEuvT8Fqm5A6C61ipCuT2nccnbYTR0CQmB6m0xGMyPVKKpot38h6zvh6WMp581RLq5yuYCpCN2bFjhV9fjtHcH43W0Xk+kl3xDCeFHmD0Yu1K2V9cx/JQOkCcpSQXREi5iwvSZMWSR/h8+WsqbTUb+VJibiPqhsbACJfrZwVCRszkZqQCHSXwan7ubXl4g4AadrTI2YW+VW/pftBYxAOY+nMWo2dPjewy/w8fOsZkSDTeQIhDfZt6okMEsCRQhLYPhxdJjpXKy7EBB5eOpMl+3lq6p85WkLfnFDfvqqvYzgnI6icuPubJrHH+FJTp9WXtI0IBefyYK9vOpBrvsc09UiUrGqb4PvbpO8AS+PvAWo0ybQ7Z7DK1T+jkJ3WNxeZsTYq/mApmlAVD+Ikrtbe6PRfsvoRrROOTcozTA0El3xs8lEWgjpCCqnRuEFuoksJdhRIX0MUcFXmPI6lW/oy40P9MNmqGKnlN781H9gmYlnqMbk2Z5jF2PS3L9hs/Iu/bOHbd9CkzgRokkDjkbtRfZkU5XUh9fxCVd6bYq2r4pn0JBML/wE1vg5nzlQa0C+t9rzQswSkbMa8oGWJuUTihw/wRXsZUGc4n5e/dFq00moQQszg31DaEMnUK7dGPzc7RRT8uHJUbnfrGV97cZqIHgOjBnOTuC/igT+YXUK7lzpTvvVJUf24J0VR8MOMGDupbkoIGtjkED+d+IEsbB7OWJgLbeK2DFbyoC8kX64E/qNu+FQYERRi15T1/x3UbJkR0kCIyJHxeku63mN7Gy+WcGeGR7"
`endif