// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`ifndef PHY_ARCH_FP_INTERFACE

`define PHY_ARCH_FP_INTERFACE 1

// altera message_off 18455
interface AXI_BUS #(
  parameter int signed PORT_AXI_AXADDR_WIDTH  = 0,
  parameter int signed PORT_AXI_AXID_WIDTH    = 0,
  parameter int signed PORT_AXI_AXBURST_WIDTH = 0,
  parameter int signed PORT_AXI_AXLEN_WIDTH   = 0,
  parameter int signed PORT_AXI_AXSIZE_WIDTH  = 0,
  parameter int signed PORT_AXI_AXUSER_WIDTH  = 0,
  parameter int signed PORT_AXI_DATA_WIDTH    = 0,
  parameter int signed PORT_AXI_STRB_WIDTH    = 0,
  parameter int signed PORT_AXI_RESP_WIDTH    = 0,
  parameter int signed PORT_AXI_ID_WIDTH      = 0,
  parameter int signed PORT_AXI_USER_WIDTH    = 0,
  parameter int signed PORT_AXI_AXQOS_WIDTH   = 0,
  parameter int signed PORT_AXI_AXCACHE_WIDTH = 0,
  parameter int signed PORT_AXI_AXPROT_WIDTH  = 0
);

typedef logic [PORT_AXI_AXADDR_WIDTH-1:0]  addr_t;
typedef logic [PORT_AXI_AXID_WIDTH-1:0]    id_t;
typedef logic [PORT_AXI_AXBURST_WIDTH-1:0] burst_t;
typedef logic [PORT_AXI_AXLEN_WIDTH-1:0]   len_t;
typedef logic [PORT_AXI_AXSIZE_WIDTH-1:0]  size_t;
typedef logic [PORT_AXI_AXUSER_WIDTH-1:0]  user_t;
typedef logic [PORT_AXI_DATA_WIDTH-1:0]    data_t;
typedef logic [PORT_AXI_STRB_WIDTH-1:0]    strb_t;
typedef logic [PORT_AXI_RESP_WIDTH-1:0]    resp_t;
typedef logic [PORT_AXI_ID_WIDTH-1:0]      respid_t;
typedef logic [PORT_AXI_USER_WIDTH-1:0]    respuser_t;
typedef logic [PORT_AXI_AXQOS_WIDTH-1:0]   qos_t;
typedef logic [PORT_AXI_AXCACHE_WIDTH-1:0] cache_t;
typedef logic [PORT_AXI_AXPROT_WIDTH-1:0]  prot_t;

id_t              awid;
addr_t            awaddr;
len_t             awlen;
size_t            awsize;
burst_t           awburst;
logic             awlock;
cache_t           awcache;
prot_t            awprot;
qos_t             awqos;
user_t            awuser;
logic             awvalid;
logic             awready;

data_t            wdata;
strb_t            wstrb;
logic             wlast;
respuser_t        wuser;
logic             wvalid;
logic             wready;

respid_t          bid;
resp_t            bresp;
respuser_t        buser;
logic             bvalid;
logic             bready;

id_t              arid;
addr_t            araddr;
len_t             arlen;
size_t            arsize;
burst_t           arburst;
logic             arlock;
cache_t           arcache;
prot_t            arprot;
qos_t             arqos;
user_t            aruser;
logic             arvalid;
logic             arready;

respid_t          rid;
data_t            rdata;
resp_t            rresp;
logic             rlast;
respuser_t        ruser;
logic             rvalid;
logic             rready;

modport Manager (
   output awid, awaddr, awlen, awsize, awburst, awlock, awcache, awprot, awqos, awuser, awvalid, input awready,
   output wdata, wstrb, wlast, wuser, wvalid, input wready,
   input bid, bresp, buser, bvalid, output bready,
   output arid, araddr, arlen, arsize, arburst, arlock, arcache, arprot, arqos, aruser, arvalid, input arready,
   input rid, rdata, rresp, rlast, ruser, rvalid, output rready
);

modport Subordinate (
   input awid, awaddr, awlen, awsize, awburst, awlock, awcache, awprot, awqos, awuser, awvalid, output awready,
   input wdata, wstrb, wlast, wuser, wvalid, output wready,
   output bid, bresp, buser, bvalid, input bready,
   input arid, araddr, arlen, arsize, arburst, arlock, arcache, arprot, arqos, aruser, arvalid, output arready,
   output rid, rdata, rresp, rlast, ruser, rvalid, input rready
);

endinterface

`endif 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "ERcVHNiT6fAr6LTzP7H99FwvKS4gXNYfBKJ8K95MKu8+jpMfTh3oq5dzkKLzunL48XXvwqc3An6HNSQj8RBsCamCeZcBBaNFWlbr8711C5C73LrSHOBbSgj9Y0e9AInTPDcSifUKXK5mIPdc616kyL3U7dwFAgd86N7JJ6dKOl/8br7aRXsNEYnUfxTXtMHIiwkVZkUMNHtnG07O3KhW9xl9PcDSXgOnyhS+e2DdhunhOuNLTtx3IQGDE/vcr80RoGI7j/WbTG3dNExB/tzciPR9o99NTlHxtlkZKzzELEs9Fu5oeVWwLWIiML3e7Vgq4IdXlRbi3WUo5p0prRMzVk50i9sknCV2CTifQWC/qx+LplcAq07KCsqQIP5URZu/U5iTG4gJ4niugegvA+iReCnkJoRHRaAsHaRKaJIIpy4uRtU6JMiMW8xN6aaJtJ9TzLSxrpaUdJZ/HJ//OkxP0g2c8jRw9ZQZRUBoYOdDzTIDoKpjctiafPkITjJ8jeQ76OOWeO/7KNVeXs4rby3WFd/82O38bgkfAM1PDFjZsBBOUDIV+TPLK7vrdhQY/2ClHkYGnCihHwy9YSZTpgcM1HG9DdITni8zX8zQ5xzmI1qsxuCVEhVGLBnwONXZGGqUxD9qmqRcNBgocgXcoLkT8OLXIHoqVq4EuUfquGpULzNqx0dBaEZduF3UZOXRyUc1tCQ2RxFTapGshD0pminVw1EWxTCHWWOGhCCD1bGkAAP033DUV467/6mucBF3/fZsptjc4L+TrJ3a/Hr7QY3wcxFrOl5n/g+2BsmRLz92j4C1WJb3GpJCdwNuSQr/u4IECEYUHI3z+3IMu/XNsjRpc46yjuIRGZQN5Ad4tzHWEBj0JyxkmTAhbz3ZCiNPedhUULQYhihdAqFuiNBF29l8++nIKljVivlKJrest9/NmxizdyHTRnUDIzOGm7CTL/PiDrh/vCRoWL/fBqLWOkpmpndt++X+hUG4uoduiZ4PByZ/xqqDwzmi4STUKjQQ8gnb"
`endif