// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



module stdfn_inst_fa_c2p_ssm #(
   parameter IS_USED  = 0,

   parameter SSM_C2P_DATA_MODE                               = "SSM_C2P_DATA_MODE_BYPASS",
   parameter FA_CORE_PERIPH_CLK_SEL_DATA_MODE                = "FA_CORE_PERIPH_CLK_SEL_DATA_MODE_UNUSED",
   parameter SSM_P2C_DATA_MODE                               = "SSM_P2C_DATA_MODE_BYPASS",
   localparam PORT_I_SSM_C2P_WIDTH                            = 40,
   localparam PORT_O_SSM_C2P_WIDTH                            = 40,
   localparam PORT_I_SSM_P2C_WIDTH                            = 20,
   localparam PORT_O_SSM_P2C_WIDTH                            = 20
) (
   input                                                      i_core_clk,
   input [PORT_I_SSM_C2P_WIDTH-1:0]                           i_ssm_c2p,
   output [PORT_O_SSM_C2P_WIDTH-1:0]                           o_ssm_c2p,
   input                                                      i_phy_clk_fr,
   input                                                      i_phy_clk_sync,
   input [PORT_I_SSM_P2C_WIDTH-1:0]                           i_ssm_p2c,
   output [PORT_O_SSM_P2C_WIDTH-1:0]                           o_ssm_p2c
);
   timeunit 1ns;
   timeprecision 1ps;

   tennm_ssm_c2p_fabric_adaptor # (
      .ssm_c2p_data_mode                                    (SSM_C2P_DATA_MODE),
      .fa_core_periph_clk_sel_data_mode                     (FA_CORE_PERIPH_CLK_SEL_DATA_MODE)
   ) fa_c2p_ssm (
      .i_core_clk                                           (i_core_clk),
      .i_phy_clk_fr                                         (i_phy_clk_fr),
      .i_phy_clk_sync                                       (i_phy_clk_sync),
      .i_ssm_c2p                                            (i_ssm_c2p),
      .o_ssm_c2p                                            (o_ssm_c2p)
   );
   tennm_ssm_p2c_fabric_adaptor # (
      .ssm_p2c_data_mode                                    (SSM_P2C_DATA_MODE),
      .fa_core_periph_clk_sel_data_mode                     (FA_CORE_PERIPH_CLK_SEL_DATA_MODE)
   ) fa_p2c_ssm (
      .i_core_clk                                           (i_core_clk),
      .i_phy_clk_fr                                         (i_phy_clk_fr),
      .i_phy_clk_sync                                       (i_phy_clk_sync),
      .i_ssm_p2c                                            (i_ssm_p2c),
      .o_ssm_p2c                                            (o_ssm_p2c)
   );

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "ERcVHNiT6fAr6LTzP7H99FwvKS4gXNYfBKJ8K95MKu8+jpMfTh3oq5dzkKLzunL48XXvwqc3An6HNSQj8RBsCamCeZcBBaNFWlbr8711C5C73LrSHOBbSgj9Y0e9AInTPDcSifUKXK5mIPdc616kyL3U7dwFAgd86N7JJ6dKOl/8br7aRXsNEYnUfxTXtMHIiwkVZkUMNHtnG07O3KhW9xl9PcDSXgOnyhS+e2DdhukRIHE9oUU6/o+b8oi0N8yWE62o3wozxbZc8YwYagrGMssU3+On8O/Wu2vC0RGaj3x9hsBz4caOTFwb080Exha98WmEzQgSXG1KlM6ft3M2l2SfqgPtabrgSWVSEkMo4PHjI7x9LYA6p03i3JVKBzwPEBTweSsJs7q7th4bP4T3kcNpllnKhQUl5L/VOgSfs4ij1q7sFlTKUbYWJcBU/uco353RHzVQR8TAt7DYhauFhKZEcg0EkjVBxf2T3d+Y7JEj/F/epTKXtW2Yy0ELF2l/rxu0rl+02fo0WWY/qCO2JHJ9NPAImRHvZXUXIwSI9MdY5Q64uzGPtzBxcHghvmAXswyvI88251L9Tp4IaNRDnzV7XlnNwemyWz4NMQ1Nnrqu1X4RgR9FDgjEob8LVyMdnWNBHdxaH1Jzzox8QdIbTHoHd3uVBUOIruO1NxU1sf5Dy6bXelL8hKUpal6pswmnf9Rnb1zNx+IWb6aktEBdnqJeOEpd/YKkTzNBs1kkiBpmxru+FNawfI16RUMkvMccujCrWBJCy4/YcCEYoBieif2dqhR+nhDqkQMBqdROs5qCMBkDwU0R9Y4t3QYeV1acef+F3Iv6z5H8s+YPA519lEpgmphI76u8BT+dHR/DrMd7f0sTMf8AkNbgEQ/7vU4Hj3vM+tFzwwFLhqVt2OX2bqwHyItutWmBGWq9pR7wGptNT5EKzPx+huLj1FqPT/X00rclwyxqk/eyhjkzdux9zcq+ewSV6Jmhb1htlJKxaXAoZDdYxVTri/U+zZkRpk+7"
`endif