// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module mem_reset_handler #(
   parameter  SYNC_TO_CLK          = 1,
   parameter  USE_AND_GATE         = 1,
   parameter  NUM_RESETS           = 1,
   parameter  NUM_CONDUITS         = 0,
   parameter  CONDUIT_INVERT_0     = 0,
   parameter  CONDUIT_INVERT_1     = 0,
   parameter  CONDUIT_INVERT_2     = 0,
   parameter  CONDUIT_INVERT_3     = 0,
   parameter  CONDUIT_INVERT_4     = 0,
   parameter  CONDUIT_INVERT_5     = 0,
   parameter  CONDUIT_INVERT_6     = 0,
   parameter  CONDUIT_INVERT_7     = 0,
   parameter  CONDUIT_INVERT_8     = 0,
   parameter  CONDUIT_INVERT_9     = 0,
   parameter  CONDUIT_INVERT_10    = 0,
   parameter  CONDUIT_INVERT_11    = 0,
   parameter  CONDUIT_INVERT_12    = 0,
   parameter  CONDUIT_INVERT_13    = 0,
   parameter  CONDUIT_INVERT_14    = 0,
   parameter  CONDUIT_INVERT_15    = 0
) (
   input logic clk ,
   input logic reset_n_0 ,
   input logic reset_n_1 ,
   input logic reset_n_2 ,
   input logic reset_n_3 ,
   input logic reset_n_4 ,
   input logic reset_n_5 ,
   input logic reset_n_6 ,
   input logic reset_n_7 ,
   input logic reset_n_8 ,
   input logic reset_n_9 ,
   input logic reset_n_10,
   input logic reset_n_11,
   input logic reset_n_12,
   input logic reset_n_13,
   input logic reset_n_14,
   input logic reset_n_15,
   input logic conduit_0 ,
   input logic conduit_1 ,
   input logic conduit_2 ,
   input logic conduit_3 ,
   input logic conduit_4 ,
   input logic conduit_5 ,
   input logic conduit_6 ,
   input logic conduit_7 ,
   input logic conduit_8 ,
   input logic conduit_9 ,
   input logic conduit_10,
   input logic conduit_11,
   input logic conduit_12,
   input logic conduit_13,
   input logic conduit_14,
   input logic conduit_15,
   output logic reset_out_n
);
   timeunit 1ps;
   timeprecision 1ps;

   logic [15:0] resets_n;
   logic [15:0] conduits;
   logic reset_out_n_async;

   assign resets_n[0 ] = NUM_RESETS > 0  ? reset_n_0  : 1'b1;
   assign resets_n[1 ] = NUM_RESETS > 1  ? reset_n_1  : 1'b1;
   assign resets_n[2 ] = NUM_RESETS > 2  ? reset_n_2  : 1'b1;
   assign resets_n[3 ] = NUM_RESETS > 3  ? reset_n_3  : 1'b1;
   assign resets_n[4 ] = NUM_RESETS > 4  ? reset_n_4  : 1'b1;
   assign resets_n[5 ] = NUM_RESETS > 5  ? reset_n_5  : 1'b1;
   assign resets_n[6 ] = NUM_RESETS > 6  ? reset_n_6  : 1'b1;
   assign resets_n[7 ] = NUM_RESETS > 7  ? reset_n_7  : 1'b1;
   assign resets_n[8 ] = NUM_RESETS > 8  ? reset_n_8  : 1'b1;
   assign resets_n[9 ] = NUM_RESETS > 9  ? reset_n_9  : 1'b1;
   assign resets_n[10] = NUM_RESETS > 10 ? reset_n_10 : 1'b1;
   assign resets_n[11] = NUM_RESETS > 11 ? reset_n_11 : 1'b1;
   assign resets_n[12] = NUM_RESETS > 12 ? reset_n_12 : 1'b1;
   assign resets_n[13] = NUM_RESETS > 13 ? reset_n_13 : 1'b1;
   assign resets_n[14] = NUM_RESETS > 14 ? reset_n_14 : 1'b1;
   assign resets_n[15] = NUM_RESETS > 15 ? reset_n_15 : 1'b1;

   assign conduits[0 ] = NUM_CONDUITS > 0  ? (CONDUIT_INVERT_0 ? !conduit_0  : conduit_0 ) : 1'b1;
   assign conduits[1 ] = NUM_CONDUITS > 1  ? (CONDUIT_INVERT_1 ? !conduit_1  : conduit_1 ) : 1'b1;
   assign conduits[2 ] = NUM_CONDUITS > 2  ? (CONDUIT_INVERT_2 ? !conduit_2  : conduit_2 ) : 1'b1;
   assign conduits[3 ] = NUM_CONDUITS > 3  ? (CONDUIT_INVERT_3 ? !conduit_3  : conduit_3 ) : 1'b1;
   assign conduits[4 ] = NUM_CONDUITS > 4  ? (CONDUIT_INVERT_4 ? !conduit_4  : conduit_4 ) : 1'b1;
   assign conduits[5 ] = NUM_CONDUITS > 5  ? (CONDUIT_INVERT_5 ? !conduit_5  : conduit_5 ) : 1'b1;
   assign conduits[6 ] = NUM_CONDUITS > 6  ? (CONDUIT_INVERT_6 ? !conduit_6  : conduit_6 ) : 1'b1;
   assign conduits[7 ] = NUM_CONDUITS > 7  ? (CONDUIT_INVERT_7 ? !conduit_7  : conduit_7 ) : 1'b1;
   assign conduits[8 ] = NUM_CONDUITS > 8  ? (CONDUIT_INVERT_8 ? !conduit_8  : conduit_8 ) : 1'b1;
   assign conduits[9 ] = NUM_CONDUITS > 9  ? (CONDUIT_INVERT_9 ? !conduit_9  : conduit_9 ) : 1'b1;
   assign conduits[10] = NUM_CONDUITS > 10 ? (CONDUIT_INVERT_10? !conduit_10 : conduit_10) : 1'b1;
   assign conduits[11] = NUM_CONDUITS > 11 ? (CONDUIT_INVERT_11? !conduit_11 : conduit_11) : 1'b1;
   assign conduits[12] = NUM_CONDUITS > 12 ? (CONDUIT_INVERT_12? !conduit_12 : conduit_12) : 1'b1;
   assign conduits[13] = NUM_CONDUITS > 13 ? (CONDUIT_INVERT_13? !conduit_13 : conduit_13) : 1'b1;
   assign conduits[14] = NUM_CONDUITS > 14 ? (CONDUIT_INVERT_14? !conduit_14 : conduit_14) : 1'b1;
   assign conduits[15] = NUM_CONDUITS > 15 ? (CONDUIT_INVERT_15? !conduit_15 : conduit_15) : 1'b1;

   assign reset_out_n_async = USE_AND_GATE ? (&resets_n) && (&conduits) : (&resets_n) || (&conduits);

   if (SYNC_TO_CLK) begin : reset_n_sync
      (* altera_attribute = "-name DESIGN_ASSISTANT_EXCLUDE \"CDC-50012\" -to \"reset_n_sync.reset_sync_inst\|*\" " *)
      altera_std_synchronizer_nocut #(
         .depth(3),
         .rst_value (0)
      ) reset_sync_inst (
         .clk(clk),
         .reset_n(1'b1),
         .din(reset_out_n_async),
         .dout(reset_out_n)
      );
   end else begin : reset_n_async
      assign reset_out_n = reset_out_n_async;
   end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "ERcVHNiT6fAr6LTzP7H99FwvKS4gXNYfBKJ8K95MKu8+jpMfTh3oq5dzkKLzunL48XXvwqc3An6HNSQj8RBsCamCeZcBBaNFWlbr8711C5C73LrSHOBbSgj9Y0e9AInTPDcSifUKXK5mIPdc616kyL3U7dwFAgd86N7JJ6dKOl/8br7aRXsNEYnUfxTXtMHIiwkVZkUMNHtnG07O3KhW9xl9PcDSXgOnyhS+e2DdhunRlRi+2MSVMkEe229k4DCzm6wknGR+dkzJRAzvGD3oZMCEpW334dmf9tih8Qc8HVc0hjhugS7aLTnH/SdsEL7195mfiWNVL4l6BY667bq2RfzUbVbLpA+d7GRVRvZjBw2kKmVvszku3ztnkSJ7QRUs2Rb8x49excWgTNpa44dTmyZWsQlcH3u2xNybQEzUAa6JAD52rLrVxQtwWUuJOWmRF06pP42aRQyritSZqqX6djGUZOogNJ33xaWw32xCzQM59tQHgD0eH7sQNLiK1WBiS7jFKAF7mUxmFowkmG8oOR90/pBh7yIEBaIS1i3O3gly+oO6Ju3ByR6/tdhT02g/502LEMFVETjx+SWcORKpEmefMOwbFAct1rtmPWpyUanxIpk1TRSHnEaeyoVy25Q7svXeQ4WHzf5MzczVPmx48W/jMMe1tJ10+jixHxOV9VRDLuxrkovMgqt9Xnln/HBTQ1bPuz/hEUcxDYlZZiihXSL66Wb98uTAlmy/bL6twokT1NX/WU/nZu1sNbESgjIl5iVLdRCkbeeRVbW03vEVNR5gv85qeEEMi0v/ZPBVuy+XTG28E2IrSSeidQ5Rl+lVdsdtSrTUC00ELweF4RwuRZBuqYygKUgadAcViTYtB8ZKwfGZXTCt6gbnrsuJkzBIHnLFIzgcj5iB9IxHsjC1vQZUAcD7MLGuxrooviPjXoMCJg9FVfHckSR88AXdremvUAM22kgR1M/dRrSXgJE0uMeefbURSUIgcXRpr+jPwtnE9PSaENUunXDmEkPw2cdz"
`endif