/*
 * IMX519_reg.h
 *
 *  Created on: Mar 21, 2024
 *      Author: User
 */

//https://github.com/ArduCAM/IMX519_AK7375/blob/main/IMX519/imx519.c

#ifndef IMX519_REG_H_
#define IMX519_REG_H_


#define IMX519_REG_VALUE_08BIT		1
#define IMX519_REG_VALUE_16BIT		2

/* Chip ID */
#define IMX519_REG_CHIP_ID		0x0016
#define IMX519_CHIP_ID			0x0519

#define IMX519_REG_MODE_SELECT		0x0100
#define IMX519_MODE_STANDBY		0x00
#define IMX519_MODE_STREAMING		0x01

#define IMX519_REG_ORIENTATION		0x101

#define IMX519_XCLK_FREQ		24000000

#define IMX519_DEFAULT_LINK_FREQ	493500000


/* Pixel rate is fixed at 686MHz for all the modes */
#define IMX519_PIXEL_RATE		426666667

/* V_TIMING internal */
#define IMX519_REG_FRAME_LENGTH		0x0340
#define IMX519_FRAME_LENGTH_MAX		0xffdc

/* Long exposure multiplier */
#define IMX519_LONG_EXP_SHIFT_MAX	7
#define IMX519_LONG_EXP_SHIFT_REG	0x3100


/* Exposure control */
#define IMX519_REG_EXPOSURE		0x0202
#define IMX519_EXPOSURE_OFFSET		32
#define IMX519_EXPOSURE_MIN		20
#define IMX519_EXPOSURE_STEP		1
#define IMX519_EXPOSURE_DEFAULT		0x3e8
#define IMX519_EXPOSURE_MAX		(IMX519_FRAME_LENGTH_MAX - \
					 IMX519_EXPOSURE_OFFSET)

/* Analog gain control */
#define IMX519_REG_ANALOG_GAIN		0x0204
#define IMX519_ANA_GAIN_MIN		0
#define IMX519_ANA_GAIN_MAX		960
#define IMX519_ANA_GAIN_STEP		1
#define IMX519_ANA_GAIN_DEFAULT		0x0

/* Digital gain control */
#define IMX519_REG_DIGITAL_GAIN		0x020e
#define IMX519_DGTL_GAIN_MIN		0x0100
#define IMX519_DGTL_GAIN_MAX		0xffff
#define IMX519_DGTL_GAIN_DEFAULT	0x0100
#define IMX519_DGTL_GAIN_STEP		1

/* Colour balance controls */
#define IMX708_REG_DIG_GAIN_GR   0x020e
#define IMX708_REG_DIG_GAIN_R    0x0210
#define IMX708_REG_DIG_GAIN_B    0x0212
#define IMX708_REG_DIG_GAIN_GB   0x0214
#define IMX708_REG_DPGA_USE_GLOBAL_GAINB   0x3ff9   //0: by color, 1: all color



/* Test Pattern Control */
#define IMX519_REG_TEST_PATTERN		0x0600
#define IMX519_TEST_PATTERN_DISABLE	0
#define IMX519_TEST_PATTERN_SOLID_COLOR	1
#define IMX519_TEST_PATTERN_COLOR_BARS	2
#define IMX519_TEST_PATTERN_GREY_COLOR	3
#define IMX519_TEST_PATTERN_PN9		4

/* Test pattern colour components */
#define IMX519_REG_TEST_PATTERN_R	0x0602
#define IMX519_REG_TEST_PATTERN_GR	0x0604
#define IMX519_REG_TEST_PATTERN_B	0x0606
#define IMX519_REG_TEST_PATTERN_GB	0x0608
#define IMX519_TEST_PATTERN_COLOUR_MIN	0
#define IMX519_TEST_PATTERN_COLOUR_MAX	0x0fff
#define IMX519_TEST_PATTERN_COLOUR_STEP	1
#define IMX519_TEST_PATTERN_R_DEFAULT	IMX519_TEST_PATTERN_COLOUR_MAX
#define IMX519_TEST_PATTERN_GR_DEFAULT	0
#define IMX519_TEST_PATTERN_B_DEFAULT	0
#define IMX519_TEST_PATTERN_GB_DEFAULT	0



/* Embedded metadata stream structure */
#define IMX519_EMBEDDED_LINE_WIDTH 16384
#define IMX519_NUM_EMBEDDED_LINES 1



/* IMX519 native and active pixel array size. */
#define IMX519_NATIVE_WIDTH		4672U
#define IMX519_NATIVE_HEIGHT		3648U
#define IMX519_PIXEL_ARRAY_LEFT		8U
#define IMX519_PIXEL_ARRAY_TOP		48U
#define IMX519_PIXEL_ARRAY_WIDTH	4656U
#define IMX519_PIXEL_ARRAY_HEIGHT	3496U


#endif /* IMX519_REG_H_ */
