/*
 * IMX708.h
 *
 *  Created on: Mar 21, 2024
 *      Author: User
 */

// SPDX-License-Identifier: GPL-2.0
/*
 * A V4L2 driver for Sony IMX708 cameras.
 * Copyright (C) 2022, Raspberry Pi Ltd
 *
 * Based on Sony imx477 camera driver
 * Copyright (C) 2020 Raspberry Pi Ltd
 */

#ifndef IMX519_H_
#define IMX519_H_

#include "I2C.h"
#include "IMX519_reg.h"
#include "v412.h"

#define IMX519_I2C_ADDRESS 0x1A // IMX 708 7-bit i2c address (8-bit is 0x34)
#define AK7375_I2C_ADDRESS 0x0C // AK7375-VCM 7-bit i2c address (8-bit is 0x18)

// test pattern





/*
 * Metadata buffer holds a variety of data, all sent with the same VC/DT (0x12).
 * It comprises two scanlines (of up to 5760 bytes each, for 4608 pixels)
 * of embedded data, one line of PDAF data, and two lines of AE-HIST data
 * (AE histograms are valid for HDR mode and empty in non-HDR modes).
 */
//#define imx519_EMBEDDED_LINE_WIDTH (5 * 5760)
//#define imx519_NUM_EMBEDDED_LINES 1

//enum pad_types {
	//IMAGE_PAD,
	//METADATA_PAD,
	//NUM_PADS
//};

/* IMX519 native and active pixel array size. */
#define IMX519_NATIVE_WIDTH		4672U
#define IMX519_NATIVE_HEIGHT		3648U
#define IMX519_PIXEL_ARRAY_LEFT		8U
#define IMX519_PIXEL_ARRAY_TOP		48U
#define IMX519_PIXEL_ARRAY_WIDTH	4656U
#define IMX519_PIXEL_ARRAY_HEIGHT	3496U




struct imx519_reg {
	alt_u16 address;
	alt_u8 val;
};


struct imx519_reg_list {
	unsigned int num_of_regs;
	const struct imx519_reg *regs;
};


struct v4l2_fract {
	alt_32   numerator;
 	alt_32   denominator;
 };

struct imx519_mode {
	/* Frame width */
	unsigned int width;

	/* Frame height */
	unsigned int height;

	/* H-timing in pixels */
	unsigned int line_length_pix;

	/* Analog crop rectangle. */
	struct v4l2_rect crop;

	/* Highest possible framerate. */
	struct v4l2_fract timeperframe_min;

	/* Default framerate. */
	struct v4l2_fract timeperframe_default;

	/* Default register values */
	struct imx519_reg_list reg_list;

};


struct imx519 {
#if 0
	struct v4l2_subdev sd;
	struct media_pad pad[NUM_PADS];

	struct v4l2_mbus_framefmt fmt;

	struct clk *inclk;
	u32 inclk_freq;

	struct gpio_desc *reset_gpio;
	struct regulator_bulk_data supplies[ARRAY_SIZE(imx519_supply_name)];

	struct v4l2_ctrl_handler ctrl_handler;
#endif


	/* V4L2 Controls */

	struct v4l2_ctrl *pixel_rate;
	struct v4l2_ctrl *exposure;
	struct v4l2_ctrl *vblank;
	struct v4l2_ctrl *hblank;
	struct v4l2_ctrl *hdr_mode;
	struct v4l2_ctrl *link_freq;
	struct {
		struct v4l2_ctrl *hflip;
		struct v4l2_ctrl *vflip;
	};
	/* Current mode */
	const struct imx519_mode *mode;

#if 0
	/*
	 * Mutex for serialized access:
	 * Protect sensor module set pad format and start/stop streaming safely.
	 */
	struct mutex mutex;
#endif

	/* Streaming on/off */
	bool streaming;

	/* Rewrite common registers on stream on? */
	bool common_regs_written;

	/* Current long exposure factor in use. Set through V4L2_CID_VBLANK */
	unsigned int long_exp_shift;

	unsigned int link_freq_idx;
};

class IMX519 : public I2C {
protected:
	char m_szDevName[64];
	alt_u32 m_nDeviceAddr;

	struct imx519 m_imx519;


	/* Write a list of registers */
	bool imx519_write_regs(const struct imx519_reg *regs, alt_u32 len);
	bool imx519_write_reg8(alt_u16 nRegByteOffset, alt_u8 nValue8);
	bool imx519_read_reg8(alt_u16 nRegByteOffset, alt_u8 *pnRead8);
	bool imx519_write_reg16(alt_u16 nRegByteOffset, alt_u16 nValue16);
	bool imx519_read_reg16(alt_u16 nRegByteOffset, alt_u16 *pnRead16);

	/* Initialize default format */
	bool imx519_set_default_format();

public:
	IMX519(const char *pDevName, alt_u32 nDeviceAddr);
	virtual ~IMX519();

	//bool Open(const char *pDevName);
	//void Close();




	///////////////////////////////////////////
	// refer API define in https://github.com/raspberrypi/linux/blob/rpi-6.1.y/drivers/media/i2c/imx708.c
public:

	///* Verify chip ID */
	bool imx519_identify_module();

	bool imx519_init();

	/* Start streaming */
	bool imx519_start_streaming();

	/* Stop streaming */
	bool imx519_stop_streaming();


	bool imx519_set_exposure(unsigned int val);
	bool imx519_get_exposure(unsigned int *val);

	bool imx519_set_analogue_gain(unsigned int val);
	bool imx519_get_analogue_gain(unsigned int *val);

	bool imx519_set_digital_gain(unsigned int val);
	bool imx519_get_digital_gain(unsigned int *val);

	bool imx519_set_frame_length(unsigned int val);

	bool imx519_set_color_balance_BR(unsigned int blue, unsigned int red);
	bool imx519_get_color_balance_BR(unsigned int *blue, unsigned int *red);



	bool imx519_set_test_patttern_colour(unsigned int R, unsigned int GR, unsigned int B,unsigned int GB);
	bool imx519_set_test_patttern(unsigned int nPatternID);
	bool imx519_dump_setting();
	bool imx519_user_customized_setting();




};

#endif /* IMX519_H_ */

