/*
 * AK7375.cpp
 *
 *  Created on: Jun 27, 2024
 *      Author: User
 *  ref: https://github.com/ArduCAM/IMX519_AK7375/blob/main/AK7375/ak7375.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "AK7375.h"



AK7375::AK7375(const char *pDevName, alt_u32 nDeviceAddr):
m_focus_vol(0)
{
	// TODO Auto-generated constructor stub
	strcpy(m_szDevName, pDevName);
	m_nDeviceAddr = nDeviceAddr;

}

AK7375::~AK7375() {
	// TODO Auto-generated destructor stub
}

bool AK7375::i2c_write16(alt_u8 addr8, alt_u16 data16){
	bool bSuccess;

	alt_u16 SwapData16;
	SwapData16 = (data16 >> 8) & 0x00FF;
	SwapData16 |= (data16 & 0x00FF ) << 8;
	bSuccess = I2C::Addr8_WriteReg16(addr8, SwapData16);

	return bSuccess;
}

bool AK7375::i2c_write8(alt_u8 addr8, alt_u8 data8){
	bool bSuccess;

	bSuccess = I2C::Addr8_WriteReg8(addr8, data8);

	return bSuccess;

}



bool AK7375::active(){
	bool bSuccess;
	int val;

	bSuccess = Open(m_szDevName, m_nDeviceAddr);

	if (bSuccess)
		bSuccess = i2c_write8(AK7375_REG_CONT,  AK7375_MODE_ACTIVE);

	printf("move %d --> %d \r\n", m_focus_vol % AK7375_CTRL_STEPS, m_focus_vol);
	for (val = m_focus_vol % AK7375_CTRL_STEPS; val <= m_focus_vol && bSuccess; val += AK7375_CTRL_STEPS) {
		bSuccess = i2c_write16(AK7375_REG_POSITION, val << 4);
		usleep(AK7375_CTRL_DELAY_US+5);
	}
	if (bSuccess)
		m_focus_vol = val;


	Close();

	if (!bSuccess)
		printf("%s failed\n",__func__);

	return bSuccess;
}

bool AK7375::standby(){
	bool bSuccess;
	int val;

	bSuccess = Open(m_szDevName, m_nDeviceAddr);

	printf("move %d --> %d \r\n", m_focus_vol & ~(AK7375_CTRL_STEPS - 1), 0);
	for (val = m_focus_vol & ~(AK7375_CTRL_STEPS - 1); val >= 0 && bSuccess; val -= AK7375_CTRL_STEPS) {
		bSuccess = i2c_write16(AK7375_REG_POSITION, val << 4);
		if (!bSuccess)
			printf("%s failed\n",__func__);
		usleep(AK7375_CTRL_DELAY_US+5);
	}
	if (bSuccess)
		m_focus_vol = val;


	if (bSuccess)
		bSuccess = i2c_write8(AK7375_REG_CONT,  AK7375_MODE_STANDBY);

	Close();

	if (!bSuccess)
		printf("%s failed\n",__func__);

	return bSuccess;
}

bool AK7375::set_pos(int nPos){
	bool bSuccess;

	bSuccess = Open(m_szDevName, m_nDeviceAddr);

	if (nPos < 0)
		nPos = 0;
	else if (nPos > AK7375_MAX_FOCUS_POS)
		nPos = AK7375_MAX_FOCUS_POS;

	if (bSuccess)
		bSuccess = i2c_write16(AK7375_REG_POSITION, nPos << 4);

	if (bSuccess)
		m_focus_vol = nPos;

	Close();

	if (!bSuccess)
		printf("%s failed\n",__func__);

	return bSuccess;
}


bool AK7375::scan(){
	bool bSuccess;
	int nPos;

	bSuccess = Open(m_szDevName, m_nDeviceAddr);

	printf("move %d --> %d \r\n", 0, AK7375_MAX_FOCUS_POS);
	for(nPos = 0; nPos < AK7375_MAX_FOCUS_POS && bSuccess; nPos+=AK7375_CTRL_STEPS ){
		bSuccess = i2c_write16(AK7375_REG_POSITION, nPos << 4);
		if (bSuccess){
			m_focus_vol = nPos;
			printf("pos=%d\r\n", nPos);
		}
		usleep(500*1000); // wait 0.5 second
	}

	Close();

	if (!bSuccess)
		printf("%s failed\n",__func__);

	return bSuccess;
}


